/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.converters.odg.OdgParser;
import inform.agent.schemes.converters.odg.content.OdgContentParser;
import inform.agent.schemes.converters.odg.content.OdgStyleStyle;
import inform.agent.schemes.converters.odg.content.OdgTextListStyle;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgAutomaticStyles {
    private final List<OdgStyleStyle> styleList = new ArrayList<OdgStyleStyle>();
    private final List<OdgTextListStyle> textListStyles = new ArrayList<OdgTextListStyle>();

    public OdgAutomaticStyles(String value) {
        NodeList list = OdgContentParser.getDocument().getDocumentElement().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            List<Element> elementList = OdgParser.getChildElements(el);
            for (Element elements : elementList) {
                String tagName = elements.getTagName();
                String styleName = elements.getAttribute("style:name");
                if (!styleName.equals(value)) continue;
                if (tagName.equals("style:style")) {
                    OdgStyleStyle styleStyle = new OdgStyleStyle(elements);
                    this.styleList.add(styleStyle);
                    continue;
                }
                if (!tagName.equals("text:list-style")) continue;
                OdgTextListStyle textListStyle = new OdgTextListStyle(elements);
                this.textListStyles.add(textListStyle);
            }
        }
    }

    public OdgStyleStyle getStyleByName(String name) {
        for (OdgStyleStyle style : this.styleList) {
            if (!style.getStyleName().equals(name)) continue;
            return style;
        }
        return null;
    }

    public OdgTextListStyle getTextStyleByName(String name) {
        for (OdgTextListStyle style : this.textListStyles) {
            if (!style.getStyleName().equals(name)) continue;
            return style;
        }
        return null;
    }
}

