/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.converters.odg.OdgParser;
import inform.agent.schemes.converters.odg.content.OdgContent;
import inform.agent.schemes.converters.odg.content.OdgDeepContentPageParser;
import inform.agent.schemes.converters.odg.content.OdgPage;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgContentParser {
    private final List<OdgPage> drawPage;
    private static Document document;

    public OdgContentParser(Document document) {
        OdgContentParser.writeDocument(document);
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        this.drawPage = new ArrayList<OdgPage>();
        int count = nodeList.getLength();
        for (int i = 0; i < count; ++i) {
            Element el;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(el = (Element)node).getNodeName().equals("office:body")) continue;
            this.pageInform(el);
        }
    }

    private static void writeDocument(Document document) {
        OdgContentParser.document = document;
    }

    private void pageInform(Element element) {
        Element elementOfficeDrawing = SchemeUtils.getFirstElement(element.getChildNodes());
        List<Element> listPage = OdgParser.getChildElements(elementOfficeDrawing);
        for (Element page : listPage) {
            OdgDeepContentPageParser deepParser = new OdgDeepContentPageParser();
            deepParser.setPage(page);
            OdgPage odgPage = new OdgPage(page);
            odgPage.setShape(deepParser.getParserShape());
            this.drawPage.add(odgPage);
        }
    }

    public List<OdgPage> getPages() {
        return this.drawPage;
    }

    public OdgContent getContent() {
        OdgContent content = new OdgContent();
        content.drawPage = this.drawPage;
        return content;
    }

    public static Document getDocument() {
        return document;
    }
}

