/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.converters.odg.content.OdgFigure;
import inform.agent.schemes.converters.odg.content.OdgUtils;
import org.w3c.dom.Element;

public class OdgEllipse
extends OdgFigure {
    private String drawKind;
    private double drawStartAngle;
    private double drawEndAngle;

    public OdgEllipse(Element element) {
        super(element);
        if (element.hasAttribute("draw:kind")) {
            this.drawKind = element.getAttribute("draw:kind");
        } else if (element.getTagName().equals("draw:circle")) {
            this.drawKind = "circle";
        } else if (element.getTagName().equals("draw:ellipse")) {
            this.drawKind = "ellipse";
        }
        if (element.hasAttribute("draw:start-angle")) {
            this.drawStartAngle = Double.parseDouble(element.getAttribute("draw:start-angle"));
        }
        if (element.hasAttribute("draw:end-angle")) {
            this.drawEndAngle = Double.parseDouble(element.getAttribute("draw:end-angle"));
        }
        if (element.hasAttribute("svg:x")) {
            String nodeX = element.getAttribute("svg:x");
            this.svgX = OdgUtils.parseSizeValue(nodeX);
        }
        if (element.hasAttribute("svg:y")) {
            String nodeY = element.getAttribute("svg:y");
            this.svgY = OdgUtils.parseSizeValue(nodeY);
        }
        if (element.hasAttribute("svg:height")) {
            String nodeHeight = element.getAttribute("svg:height");
            this.svgHeight = OdgUtils.parseSizeValue(nodeHeight);
        }
        if (element.hasAttribute("svg:width")) {
            String nodeWidth = element.getAttribute("svg:width");
            this.svgWidth = OdgUtils.parseSizeValue(nodeWidth);
        }
    }

    public String getDrawKind() {
        return this.drawKind;
    }

    public double getDrawStartAngle() {
        return this.drawStartAngle;
    }

    public double getDrawEndAngle() {
        return this.drawEndAngle;
    }

    @Override
    public double getSvgX() {
        return this.svgX * 10.0;
    }

    @Override
    public double getSvgY() {
        return this.svgY * 10.0;
    }

    @Override
    public double getSvgHeight() {
        return this.svgHeight * 10.0;
    }

    @Override
    public double getSvgWidth() {
        return this.svgWidth * 10.0;
    }

    @Override
    public boolean hasGeometry() {
        return false;
    }
}

