/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxConnection;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxRowsSectionParser;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VsdxConnectionParser
extends VsdxRowsSectionParser {
    VsdxConnectionParser(VsdxParser vsdxParser, Element connectionNode) {
        super(vsdxParser, connectionNode);
    }

    VsdxConnection parse(VsdxShape shape) {
        Element connectionSection = this.getSectionNode();
        NodeList rows = connectionSection.getChildNodes();
        VsdxConnection result = new VsdxConnection();
        if (shape.connection != null) {
            result.rows.addAll(shape.connection.rows);
        }
        for (int i = 0; i < rows.getLength(); ++i) {
            if (rows.item(i).getNodeType() != 1) continue;
            Element row = (Element)rows.item(i);
            VsdxConnection.VsdxConnectionRow connection = null;
            String connectionId = row.getAttribute("IX");
            String connectionName = row.getAttribute("N");
            if (!"".equals(connectionName)) {
                connection = result.findRowByName(connectionName);
            } else if (!"".equals(connectionId)) {
                connection = result.findRowById(connectionId);
            }
            if (connection == null) {
                connection = new VsdxConnection.VsdxConnectionRow();
                connection.ID = connectionId;
                connection.Name = connectionName;
                result.addRow(connection);
            }
            connection.Del = row.getAttribute("Del");
            NodeList cells = row.getChildNodes();
            block11: for (int j = 0; j < cells.getLength(); ++j) {
                if (cells.item(j).getNodeType() != 1) continue;
                Element cell = (Element)cells.item(j);
                String cellValue = cell.getAttribute("V");
                switch (cell.getAttribute("N")) {
                    case "X": {
                        connection.X = cellValue;
                        continue block11;
                    }
                    case "Y": {
                        connection.Y = cellValue;
                        continue block11;
                    }
                    case "Type": {
                        connection.Type = cellValue;
                    }
                }
            }
        }
        return result;
    }
}

