/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.Vsdx;
import inform.agent.schemes.converters.vsdx.VsdxMaster;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.VsdxShapeParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VsdxMasterParser {
    private final VsdxParser vsdxParser;
    private final Element masterNode;
    private final Map<String, String> rels;
    private Element pageSheet;
    private List<Element> pageLayers;
    private Map<String, Integer> pageLayersIdx;
    private List<Element> shapes;

    VsdxMasterParser(VsdxParser vsdxParser, Element masterNode, Document master, Map<String, String> rels) {
        List<Element> shapesList;
        List<Element> nodes;
        this.vsdxParser = vsdxParser;
        this.masterNode = masterNode;
        this.rels = rels;
        if (masterNode != null && (nodes = VsdxParser.getElementsByLocalName(masterNode, "PageSheet")).size() == 1) {
            this.pageLayers = new ArrayList<Element>();
            this.pageLayersIdx = new HashMap<String, Integer>();
            this.pageSheet = nodes.get(0);
            List<Element> sections = VsdxParser.getElementsByLocalName(this.pageSheet, "Section");
            int cnt = sections.size();
            for (int i = 0; i < cnt; ++i) {
                Element e = sections.get(i);
                if (!"Layer".equals(e.getAttribute("N"))) continue;
                List<Element> rows = VsdxParser.getElementsByLocalName(e, "Row");
                int cntRows = rows.size();
                for (int j = 0; j < cntRows; ++j) {
                    Element layer = rows.get(j);
                    this.pageLayersIdx.put(layer.getAttribute("IX"), this.pageLayers.size());
                    this.pageLayers.add(layer);
                }
                break;
            }
        }
        if (master != null && !(shapesList = VsdxParser.getElementsByLocalName(master.getDocumentElement(), "Shapes")).isEmpty()) {
            assert (shapesList.size() == 1);
            this.shapes = VsdxParser.getElementsByLocalName(shapesList.get(0), "Shape");
        }
    }

    public boolean hasMasterAttribute(String name) {
        assert (this.masterNode != null);
        return this.masterNode.hasAttribute(name);
    }

    public String getMasterAttribute(String name) {
        assert (this.masterNode != null);
        return this.masterNode.getAttribute(name);
    }

    public boolean hasPageSheetAttribute(String name) {
        assert (this.pageSheet != null);
        return this.pageSheet.hasAttribute(name);
    }

    public String getPageSheetAttribute(String name) {
        assert (this.pageSheet != null);
        return this.pageSheet.getAttribute(name);
    }

    public boolean hasPageSheetCell(String name) {
        assert (this.pageSheet != null);
        return this.vsdxParser.hasCellAttribute(this.pageSheet, name);
    }

    public String getPageSheetCellValue(String name) {
        assert (this.pageSheet != null);
        return this.vsdxParser.getCellValue(this.pageSheet, name);
    }

    public double getPageSheetCellNumberValue(String name) {
        assert (this.pageSheet != null);
        return this.vsdxParser.getCellNumberValue(this.pageSheet, name);
    }

    public int countLayers() {
        assert (this.pageLayers != null);
        return this.pageLayers.size();
    }

    public String getLayerCellValue(int layerIndex, String cellName) {
        assert (this.pageLayers != null);
        if (layerIndex < 0 || layerIndex >= this.pageLayers.size()) {
            return "";
        }
        return this.vsdxParser.getCellValue(this.pageLayers.get(layerIndex), cellName);
    }

    public double getLayerCellNumberValue(int layerIndex, String cellName) {
        String s = this.getLayerCellValue(layerIndex, cellName);
        if (s == null || s.isEmpty()) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    public String getLayerCellValue(String layerID, String cellName) {
        assert (this.pageLayers != null);
        assert (this.pageLayersIdx != null);
        assert (this.pageLayers.size() == this.pageLayersIdx.size());
        Integer idx = this.pageLayersIdx.get(layerID);
        return idx == null ? "" : this.getLayerCellValue(idx, cellName);
    }

    public double getLayerCellNumberValue(String layerID, String cellName) {
        assert (this.pageLayers != null);
        assert (this.pageLayersIdx != null);
        assert (this.pageLayers.size() == this.pageLayersIdx.size());
        Integer idx = this.pageLayersIdx.get(layerID);
        return idx == null ? 0.0 : this.getLayerCellNumberValue(idx, cellName);
    }

    public int countShapes() {
        return this.shapes == null ? 0 : this.shapes.size();
    }

    public VsdxShapeParser getShape(int index) {
        if (this.shapes == null || index < 0 || index >= this.shapes.size()) {
            return null;
        }
        return new VsdxShapeParser(this.vsdxParser, this.shapes.get(index), this.rels);
    }

    public VsdxMaster getVsdxMaster(Vsdx vsdx) {
        assert (vsdx != null);
        VsdxMaster vsdxMaster = new VsdxMaster(vsdx);
        vsdxMaster.ID = this.getMasterAttribute("ID");
        vsdxMaster.Name = this.getMasterAttribute("Name");
        if (this.hasPageSheetCell("PageScale")) {
            vsdxMaster.PageScale = this.getPageSheetCellValue("PageScale");
        }
        if (this.hasPageSheetCell("DrawingScale")) {
            vsdxMaster.DrawingScale = this.getPageSheetCellValue("DrawingScale");
        }
        vsdxMaster.isHidden = "1".equals(this.getMasterAttribute("Hidden"));
        vsdxMaster.isPatternFlags = "1".equals(this.getMasterAttribute("PatternFlags"));
        int cnt = this.countShapes();
        for (int j = 0; j < cnt; ++j) {
            VsdxShapeParser shapeParser = this.getShape(j);
            if (shapeParser == null) continue;
            VsdxShape vsdxShape = new VsdxShape(vsdx, null);
            VsdxMasterParser masterParser = shapeParser.getMasterParser();
            shapeParser.parseShape(vsdxShape, true, masterParser);
            vsdxMaster.shapes.add(vsdxShape);
            vsdxShape.master = vsdxMaster;
        }
        return vsdxMaster;
    }
}

