/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.schemes.SchemeImportRequest;
import inform.agent.schemes.converters.vsdx.Vsdx;
import inform.agent.schemes.converters.vsdx.VsdxCommentsParser;
import inform.agent.schemes.converters.vsdx.VsdxDocumentParser;
import inform.agent.schemes.converters.vsdx.VsdxMaster;
import inform.agent.schemes.converters.vsdx.VsdxMasterParser;
import inform.agent.schemes.converters.vsdx.VsdxPageParser;
import inform.agent.schemes.converters.vsdx.VsdxWindowsParser;
import inform.agent.schemes.converters.vsdx.themes.VsdxTheme;
import inform.agent.schemes.converters.vsdx.themes.VsdxThemeParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VsdxParser {
    static final String FILE_DOCUMENT = Paths.get("visio", "document.xml").toString();
    static final String FILE_WINDOWS = Paths.get("visio", "windows.xml").toString();
    static final String FILE_COMMENTS = Paths.get("visio", "comments.xml").toString();
    static final String PATH_PAGES = Paths.get("visio", "pages").toString();
    static final String PATH_THEMES = Paths.get("visio", "theme").toString();
    static final String FILE_PAGES = "pages.xml";
    static final String FILE_REL_PAGES = "pages.xml.rels";
    static final String PATH_MASTERS = Paths.get("visio", "masters").toString();
    static final String FILE_MASTERS = "masters.xml";
    static final String FILE_REL_MASTERS = "masters.xml.rels";
    static final String EXTENSION_RELS = ".rels";
    private final byte[] content;
    private Document pages;
    private Document masters;
    private Map<String, String> relPages;
    private Map<String, String> relMasters;
    private Map<String, VsdxMaster> vsdxMasters;
    private List<Element> pageNodes;
    private List<Element> masterNodes;
    private final Map<Path, Map<String, String>> rels = new HashMap<Path, Map<String, String>>();
    private final Map<Path, Document> docs = new HashMap<Path, Document>();
    private final Map<Path, Document> themeDocuments = new HashMap<Path, Document>();
    private final Map<Path, byte[]> foreignFiles = new HashMap<Path, byte[]>();

    public VsdxParser(byte[] content) throws Exception {
        this.content = content;
        this.parseDocuments();
        this.initPages();
    }

    private void parseDocuments() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setCoalescing(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(this.content));){
            ZipEntry zipEntry;
            byte[] buffer = new byte[100000];
            while ((zipEntry = zis.getNextEntry()) != null) {
                byte[] byteContent;
                if (zipEntry.isDirectory()) continue;
                if (zipEntry.getSize() < 0L) {
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        int len;
                        while ((len = zis.read(buffer)) != -1) {
                            os.write(buffer, 0, len);
                        }
                        byteContent = os.toByteArray();
                    }
                } else {
                    int bytes_read;
                    byte[] blob = new byte[(int)zipEntry.getSize()];
                    int offset = 0;
                    while ((bytes_read = zis.read(blob, offset, blob.length - offset)) > 0) {
                        offset += bytes_read;
                    }
                    byteContent = blob;
                }
                Path pathToFile = Paths.get(zipEntry.getName(), new String[0]);
                if (zipEntry.getName().endsWith(EXTENSION_RELS) || zipEntry.getName().endsWith(".xml")) {
                    try (ByteArrayInputStream inputStream = new ByteArrayInputStream(byteContent);){
                        Document parsedFile = documentBuilder.parse(inputStream);
                        if (zipEntry.getName().endsWith(EXTENSION_RELS)) {
                            this.parseRelationships(pathToFile, parsedFile);
                            continue;
                        }
                        if (pathToFile.startsWith(PATH_THEMES)) {
                            this.themeDocuments.put(pathToFile, parsedFile);
                            continue;
                        }
                        this.docs.put(pathToFile, parsedFile);
                    }
                    catch (Exception e) {
                        SchemeImportRequest currentRequest = (SchemeImportRequest)LogContext.CURRENT.get();
                        if (currentRequest != null) {
                            currentRequest.putRequestStateLog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 " + zipEntry.getName() + ": " + e.getMessage());
                        }
                        Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 {}", zipEntry.getName(), e);
                    }
                    continue;
                }
                this.foreignFiles.put(pathToFile, byteContent);
            }
        }
    }

    public static List<Element> getElementsByLocalName(Element root, String localName) {
        if (root == null) {
            return null;
        }
        NodeList nodes = root.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        int cnt = nodes.getLength();
        for (int i = 0; i < cnt; ++i) {
            Node item = nodes.item(i);
            if (!(item instanceof Element)) continue;
            Element e = (Element)item;
            if (localName != null && !localName.equals(e.getLocalName())) continue;
            result.add(e);
        }
        return result;
    }

    private void initPages() {
        if (this.pages != null) {
            return;
        }
        this.pages = this.docs.get(Paths.get(PATH_PAGES, FILE_PAGES));
        assert (this.pages != null);
        this.relPages = this.getRelationships(PATH_PAGES, FILE_REL_PAGES);
        this.pageNodes = VsdxParser.getElementsByLocalName(this.pages.getDocumentElement(), "Page");
        this.masters = this.docs.get(Paths.get(PATH_MASTERS, FILE_MASTERS));
        if (this.masters != null) {
            this.relMasters = this.getRelationships(PATH_MASTERS, FILE_REL_MASTERS);
            this.masterNodes = VsdxParser.getElementsByLocalName(this.masters.getDocumentElement(), "Master");
        }
    }

    public int countMasters() {
        return this.relMasters == null ? 0 : this.relMasters.size();
    }

    public VsdxMasterParser getMaster(int index) {
        if (this.masterNodes == null || index < 0 || index >= this.masterNodes.size()) {
            return null;
        }
        String masterName = "";
        Element master = this.masterNodes.get(index);
        if (master == null) {
            return null;
        }
        List<Element> rels = VsdxParser.getElementsByLocalName(master, "Rel");
        if (rels != null && !rels.isEmpty()) {
            assert (rels.size() == 1);
            Element rel = rels.get(0);
            assert (rel != null);
            masterName = this.relMasters.get(rel.getAttribute("r:id"));
        }
        assert (!masterName.isEmpty());
        Document masterContent = this.docs.get(Paths.get(PATH_MASTERS, masterName));
        assert (masterContent != null);
        Map<String, String> relMaster = this.getRelationships(PATH_MASTERS, masterName + EXTENSION_RELS);
        return new VsdxMasterParser(this, master, masterContent, relMaster);
    }

    public VsdxMasterParser getMaster(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        try {
            if (this.masters == null || this.relMasters == null) {
                return null;
            }
            assert (this.masterNodes != null);
            for (Element master : this.masterNodes) {
                String masterName = "";
                if (master == null || !id.equals(master.getAttribute("ID"))) continue;
                List<Element> rels = VsdxParser.getElementsByLocalName(master, "Rel");
                if (rels != null && !rels.isEmpty()) {
                    assert (rels.size() == 1);
                    Element rel = rels.get(0);
                    assert (rel != null);
                    masterName = this.relMasters.get(rel.getAttribute("r:id"));
                }
                assert (!masterName.isEmpty());
                Document masterContent = this.docs.get(Paths.get(PATH_MASTERS, masterName));
                assert (masterContent != null);
                Map<String, String> relMaster = this.getRelationships(PATH_MASTERS, masterName + EXTENSION_RELS);
                return new VsdxMasterParser(this, master, masterContent, relMaster);
            }
        }
        catch (Exception ex) {
            Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 \u0441 \u043c\u0430\u0441\u0442\u0435\u0440\u043e\u043c", ex);
        }
        return null;
    }

    public int countPages() {
        List<Element> nodes = VsdxParser.getElementsByLocalName(this.pages.getDocumentElement(), "Page");
        return nodes == null ? 0 : nodes.size();
    }

    public VsdxPageParser getPageParser(int index) {
        Document pageContent;
        if (this.pageNodes == null || index < 0 || index >= this.pageNodes.size()) {
            return null;
        }
        Object pageName = "";
        Element page = this.pageNodes.get(index);
        if (page == null) {
            return null;
        }
        List<Element> rels = VsdxParser.getElementsByLocalName(page, "Rel");
        if (rels != null && !rels.isEmpty()) {
            assert (rels.size() == 1);
            Element rel = rels.get(0);
            assert (rel != null);
            pageName = this.relPages.get(rel.getAttribute("r:id"));
        }
        if (((String)pageName).isEmpty()) {
            pageName = "page" + (index + 1) + ".xml";
        }
        if ((pageContent = this.docs.get(Paths.get(PATH_PAGES, new String[]{pageName}))) == null) {
            return null;
        }
        Map<String, String> relPage = this.getRelationships(PATH_PAGES, (String)pageName + EXTENSION_RELS);
        return new VsdxPageParser(this, page, pageContent, relPage);
    }

    public VsdxDocumentParser getDocumentParser() {
        Document document = this.docs.get(Paths.get(FILE_DOCUMENT, new String[0]));
        assert (document != null);
        return new VsdxDocumentParser(this, document);
    }

    public VsdxWindowsParser getWindowsParser() {
        Document document = this.docs.get(Paths.get(FILE_WINDOWS, new String[0]));
        assert (document != null);
        return new VsdxWindowsParser(this, document);
    }

    public VsdxCommentsParser getCommentsParser() {
        Document document = this.docs.get(Paths.get(FILE_COMMENTS, new String[0]));
        return document == null ? null : new VsdxCommentsParser(this, document);
    }

    byte[] getFileFromPath(Path filePath) {
        return this.foreignFiles.get(filePath);
    }

    private void parseRelationships(Path path, Document doc) {
        if (doc == null) {
            this.rels.put(path, null);
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        NodeList elements = doc.getElementsByTagName("Relationship");
        int cnt = elements.getLength();
        for (int i = 0; i < cnt; ++i) {
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String id = element.getAttribute("Id");
            String target = element.getAttribute("Target");
            if (id.isEmpty() || target.isEmpty()) continue;
            result.put(id, target);
        }
        this.rels.put(path, result);
    }

    public Map<String, String> getRelationships(String path, String file) {
        return this.rels.get(Paths.get(path, "_rels", file));
    }

    String getCellValue(Element element, String name) {
        return this.getCellAttributeValue(element, name, "V");
    }

    String getCellUnit(Element element, String name) {
        return this.getCellAttributeValue(element, name, "U");
    }

    String getCellFunction(Element element, String name) {
        return this.getCellAttributeValue(element, name, "F");
    }

    String getCellAttributeValue(Element element, String name, String attr) {
        if (element != null && name != null) {
            List<Element> cells = VsdxParser.getElementsByLocalName(element, "Cell");
            for (Element e : cells) {
                if (e == null || !name.equals(e.getAttribute("N"))) continue;
                return e.getAttribute(attr);
            }
        }
        return "";
    }

    double getCellNumberValue(Element element, String name) {
        String s = this.getCellValue(element, name);
        if (s == null || s.isEmpty()) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    List<Element> getElements(Element element, String tagName, String attrName, String attrValue) {
        if (element == null || tagName == null || tagName.isEmpty()) {
            return null;
        }
        NodeList nodes = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        boolean hasAttrName = attrName != null && !attrName.isEmpty();
        boolean hasAttrValue = hasAttrName && attrValue != null && !attrValue.isEmpty();
        int cnt = nodes.getLength();
        for (int i = 0; i < cnt; ++i) {
            Element e;
            Node node = nodes.item(i);
            if (!(node instanceof Element) || !tagName.equals((e = (Element)node).getTagName()) || hasAttrName && !e.hasAttribute(attrName) || hasAttrValue && !e.getAttribute(attrName).equals(attrValue)) continue;
            result.add(e);
        }
        return result;
    }

    boolean hasCellAttribute(Element element, String name) {
        if (element != null && name != null) {
            List<Element> cells = VsdxParser.getElementsByLocalName(element, "Cell");
            for (Element e : cells) {
                if (e == null || !name.equals(e.getAttribute("N"))) continue;
                return true;
            }
        }
        return false;
    }

    VsdxMaster parseMasterShapes(Vsdx vsdx, String masterID, VsdxMasterParser masterParser) {
        assert (masterID != null);
        assert (masterParser != null);
        assert (masterID.equals(masterParser.getMasterAttribute("ID")));
        if (this.vsdxMasters == null) {
            this.vsdxMasters = new HashMap<String, VsdxMaster>();
        }
        if (this.vsdxMasters.containsKey(masterID)) {
            return this.vsdxMasters.get(masterID);
        }
        VsdxMaster vsdxMaster = masterParser.getVsdxMaster(vsdx);
        this.vsdxMasters.put(masterID, vsdxMaster);
        return vsdxMaster;
    }

    public int countThemes() {
        return this.themeDocuments.size();
    }

    public VsdxTheme parseTheme(int index) {
        String themeFileName = "theme" + (index + 1) + ".xml";
        Document themeContent = this.themeDocuments.get(Paths.get(PATH_THEMES, themeFileName));
        if (themeContent == null) {
            return null;
        }
        VsdxThemeParser parser = new VsdxThemeParser(themeContent);
        return parser.getTheme();
    }
}

