/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.adt.collections.IntegerList;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.VsdxReader;
import inform.agent.schemes.converters.vsdx.Vsdx;
import inform.agent.schemes.converters.vsdx.VsdxAction;
import inform.agent.schemes.converters.vsdx.VsdxCharacter;
import inform.agent.schemes.converters.vsdx.VsdxChart;
import inform.agent.schemes.converters.vsdx.VsdxComment;
import inform.agent.schemes.converters.vsdx.VsdxConnection;
import inform.agent.schemes.converters.vsdx.VsdxField;
import inform.agent.schemes.converters.vsdx.VsdxForeignData;
import inform.agent.schemes.converters.vsdx.VsdxGeometry;
import inform.agent.schemes.converters.vsdx.VsdxGeometryRow;
import inform.agent.schemes.converters.vsdx.VsdxGradientStops;
import inform.agent.schemes.converters.vsdx.VsdxMaster;
import inform.agent.schemes.converters.vsdx.VsdxPage;
import inform.agent.schemes.converters.vsdx.VsdxParagraph;
import inform.agent.schemes.converters.vsdx.VsdxProperty;
import inform.agent.schemes.converters.vsdx.VsdxShapes;
import inform.agent.schemes.converters.vsdx.VsdxStyle;
import inform.agent.schemes.converters.vsdx.VsdxTabs;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class VsdxShape {
    public double avesID = 0.0;
    public String ID;
    public String Master;
    public String MasterShape;
    public String Del;
    public String Name;
    public String Type;
    public String LineStyle;
    public String FillStyle;
    public String TextStyle;
    public String Width;
    public String Height;
    public String PinX;
    public String PinY;
    public String LocPinX;
    public String LocPinY;
    public String Angle;
    public String LayerMember;
    public String LineColor;
    public String FillBkgnd;
    public String FillForegnd;
    public String LineWeight;
    public String LinePattern;
    public String LineCap;
    public String FillPattern;
    public String FillForegndTrans;
    public String LineColorTrans;
    public String Contrast;
    public String Brightness;
    public String Gamma;
    public String FPinX;
    public String FPinY;
    public String FlipX;
    public String FlipY;
    public String BeginX;
    public String BeginY;
    public String EndX;
    public String EndY;
    String Text;
    public List<VsdxTextInfo> TextInfo;
    public String HideText;
    public String ObjType;
    public boolean hasControlSection = false;
    public List<VsdxField> Fields = new ArrayList<VsdxField>();
    public VsdxCharacter Character;
    public VsdxParagraph Paragraph;
    public List<VsdxCharacter> Characters;
    public List<VsdxParagraph> Paragraphs;
    public VsdxTabs Tabs;
    public String PreferredCharacterIX;
    public String PreferredParagraphIX;
    public List<VsdxProperty> Properties = new ArrayList<VsdxProperty>();
    public List<VsdxAction> Actions = new ArrayList<VsdxAction>();
    public String TxtPinX;
    public String TxtPinY;
    public String TxtWidth;
    public String TxtHeight;
    public String TxtLocPinX;
    public String TxtLocPinY;
    public String TxtAngle;
    public String TextBkgnd;
    public String LeftMargin;
    public String RightMargin;
    public String TopMargin;
    public String BottomMargin;
    public String VerticalAlign;
    public String DefaultTabStop;
    public String TextDirection;
    public String TextBkgndTrans;
    public String ImgWidth;
    public String ImgHeight;
    public String ImgOffsetX;
    public String ImgOffsetY;
    public String Transparency;
    public String BeginArrow;
    public String EndArrow;
    public String BeginArrowSize;
    public String EndArrowSize;
    public String Rounding;
    public String FillGradientDir;
    public String FillGradientEnabled;
    public String FillGradientAngle;
    public String DisplayMode;
    public String QuickStyleLineColor;
    public String QuickStyleFillColor;
    public String QuickStyleShadowColor;
    public String QuickStyleFontColor;
    public String QuickStyleLineMatrix;
    public String QuickStyleFillMatrix;
    public String QuickStyleEffectsMatrix;
    public String QuickStyleFontMatrix;
    public String QuickStyleType;
    public String QuickStyleVariation;
    public String ThemeIndex;
    public String ColorSchemeIndex;
    public String EffectSchemeIndex;
    public String ConnectorSchemeIndex;
    public String FontSchemeIndex;
    public String msvStructureType;
    public String msvSDContainerMargin;
    public String msvSDContainerResize;
    public String msvSDContainerLocked;
    public String msvShapeCategories;
    public String msvSDContainerRequiredCategories;
    public String msvSDContainerExcludedCategories;
    public String msvSDContainerHeadingEdge;
    public String msvSDListAlignment;
    public String msvSDListDirection;
    public String msvSDListRequiredCategories;
    public String msvSDListExcludedCategories;
    public List<String[]> Relationships;
    public Map<String, String> UserVars;
    public String ShapeRouteStyle;
    public String ConFixedCode;
    public String ConLineRouteExt;
    protected String BaseID;
    protected String UniqueID;
    public List<VsdxGeometry> geometries;
    public VsdxShapes shapes;
    private IntegerList visiblePaths;
    private IntegerList fillArr;
    private IntegerList lineArr;
    private IntegerList hiddenPaths;
    private BaseGraphic.RealPoint shapeSize;
    private BaseGraphic.RealPoint locPin;
    private BaseGraphic.RealPoint pin;
    private BaseGraphic.RealPoint shapeSizeMM;
    private BaseGraphic.RealPoint locPinMM;
    private BaseGraphic.RealPoint pinMM;
    public String ShdwForegnd;
    public String ShdwForegndTrans;
    public String ShdwPattern;
    public String ShapeShdwOffsetX;
    public String ShapeShdwOffsetY;
    public String ShapeShdwType;
    public String ShapeShdwObliqueAngle;
    public String ShapeShdwScaleFactor;
    public String ShapeShdwBlur;
    public String ShapeShdwShow;
    public String ReflectionTrans;
    public String ReflectionBlur;
    public String ReflectionSize;
    public String ReflectionDist;
    public String GlowColor;
    public String GlowColorTrans;
    public String GlowSize;
    public String SoftEdgesSize;
    protected VsdxConnection connection;
    public VsdxForeignData foreignData;
    public VsdxGradientStops fillGradient;
    public List<VsdxChart> charts;
    public List<VsdxComment> comments;
    public boolean InvalidConverting = false;
    private Map<String, Boolean> isProtected = new HashMap<String, Boolean>();
    public final Vsdx vsdx;
    public final VsdxPage page;
    final VsdxShape parent;
    public VsdxMaster master;
    private VsdxShape masterShape;
    boolean onlyMaster = false;
    public boolean isMaster = false;
    boolean inheritsConnectorStyleSheet = false;

    public VsdxShape(Vsdx vsdx, VsdxShape parent) {
        this(vsdx, parent, null);
    }

    public VsdxShape(Vsdx vsdx, VsdxShape parent, VsdxPage page) {
        this.vsdx = vsdx;
        this.parent = parent;
        this.page = page;
    }

    public boolean isNotProtected(String attrName) {
        return this.isProtected.get(attrName) == null || this.isProtected.get(attrName) == false;
    }

    public void protectAttr(String attrName) {
        this.isProtected.put(attrName, true);
    }

    void applyMaster(VsdxShape masterShape) {
        if (masterShape == null) {
            return;
        }
        this.applyProperties(masterShape);
        this.masterShape = masterShape;
        this.onlyMaster = true;
        masterShape.isMaster = true;
    }

    void applyProperties(VsdxShape masterShape) {
        boolean isEmpty;
        if (masterShape == null) {
            return;
        }
        if (masterShape.Name != null) {
            this.Name = masterShape.Name;
        }
        if (masterShape.Del != null) {
            this.Del = masterShape.Del;
        }
        if (masterShape.Type != null) {
            this.Type = masterShape.Type;
        }
        if (masterShape.LineStyle != null) {
            this.LineStyle = masterShape.LineStyle;
        }
        if (masterShape.FillStyle != null) {
            this.FillStyle = masterShape.FillStyle;
        }
        if (masterShape.TextStyle != null) {
            this.TextStyle = masterShape.TextStyle;
        }
        if (masterShape.Width != null) {
            this.Width = masterShape.Width;
        }
        if (masterShape.Height != null) {
            this.Height = masterShape.Height;
        }
        if (masterShape.PinX != null) {
            this.PinX = masterShape.PinX;
        }
        if (masterShape.PinY != null) {
            this.PinY = masterShape.PinY;
        }
        if (masterShape.LocPinX != null) {
            this.LocPinX = masterShape.LocPinX;
        }
        if (masterShape.LocPinY != null) {
            this.LocPinY = masterShape.LocPinY;
        }
        if (masterShape.Angle != null) {
            this.Angle = masterShape.Angle;
        }
        if (masterShape.LayerMember != null) {
            this.LayerMember = masterShape.LayerMember;
        }
        if (masterShape.LineColor != null) {
            this.LineColor = masterShape.LineColor;
        }
        if (masterShape.FillBkgnd != null) {
            this.FillBkgnd = masterShape.FillBkgnd;
        }
        if (masterShape.FillForegnd != null) {
            this.FillForegnd = masterShape.FillForegnd;
        }
        if (masterShape.LineWeight != null) {
            this.LineWeight = masterShape.LineWeight;
        }
        if (masterShape.LinePattern != null) {
            this.LinePattern = masterShape.LinePattern;
        }
        if (masterShape.LineCap != null) {
            this.LineCap = masterShape.LineCap;
        }
        if (masterShape.FillPattern != null) {
            this.FillPattern = masterShape.FillPattern;
        }
        if (masterShape.FillForegndTrans != null) {
            this.FillForegndTrans = masterShape.FillForegndTrans;
        }
        if (masterShape.LineColorTrans != null) {
            this.LineColorTrans = masterShape.LineColorTrans;
        }
        if (masterShape.DisplayMode != null) {
            this.DisplayMode = masterShape.DisplayMode;
        }
        if (masterShape.ObjType != null) {
            this.ObjType = masterShape.ObjType;
        }
        if (masterShape.FPinX != null) {
            this.FPinX = masterShape.FPinX;
        }
        if (masterShape.FPinY != null) {
            this.FPinY = masterShape.FPinY;
        }
        if (masterShape.FlipX != null) {
            this.FlipX = masterShape.FlipX;
        }
        if (masterShape.FlipY != null) {
            this.FlipY = masterShape.FlipY;
        }
        if (masterShape.BeginX != null) {
            this.BeginX = masterShape.BeginX;
        }
        if (masterShape.BeginY != null) {
            this.BeginY = masterShape.BeginY;
        }
        if (masterShape.EndX != null) {
            this.EndX = masterShape.EndX;
        }
        if (masterShape.EndY != null) {
            this.EndY = masterShape.EndY;
        }
        if (masterShape.ShapeRouteStyle != null) {
            this.ShapeRouteStyle = masterShape.ShapeRouteStyle;
        }
        if (masterShape.ConLineRouteExt != null) {
            this.ConLineRouteExt = masterShape.ConLineRouteExt;
        }
        if (masterShape.ConFixedCode != null) {
            this.ConFixedCode = masterShape.ConFixedCode;
        }
        if (masterShape.inheritsConnectorStyleSheet) {
            this.inheritsConnectorStyleSheet = true;
        }
        if (masterShape.TxtPinX != null) {
            this.TxtPinX = masterShape.TxtPinX;
        }
        if (masterShape.TxtPinY != null) {
            this.TxtPinY = masterShape.TxtPinY;
        }
        if (masterShape.TxtWidth != null) {
            this.TxtWidth = masterShape.TxtWidth;
        }
        if (masterShape.TxtHeight != null) {
            this.TxtHeight = masterShape.TxtHeight;
        }
        if (masterShape.TxtLocPinX != null) {
            this.TxtLocPinX = masterShape.TxtLocPinX;
        }
        if (masterShape.TxtLocPinY != null) {
            this.TxtLocPinY = masterShape.TxtLocPinY;
        }
        if (masterShape.TxtAngle != null) {
            this.TxtAngle = masterShape.TxtAngle;
        }
        if (masterShape.TextBkgnd != null) {
            this.TextBkgnd = masterShape.TextBkgnd;
        }
        if (masterShape.LeftMargin != null) {
            this.LeftMargin = masterShape.LeftMargin;
        }
        if (masterShape.RightMargin != null) {
            this.RightMargin = masterShape.RightMargin;
        }
        if (masterShape.TopMargin != null) {
            this.TopMargin = masterShape.TopMargin;
        }
        if (masterShape.BottomMargin != null) {
            this.BottomMargin = masterShape.BottomMargin;
        }
        if (masterShape.VerticalAlign != null) {
            this.VerticalAlign = masterShape.VerticalAlign;
        }
        if (masterShape.DefaultTabStop != null) {
            this.DefaultTabStop = masterShape.DefaultTabStop;
        }
        if (masterShape.TextDirection != null) {
            this.TextDirection = masterShape.TextDirection;
        }
        if (masterShape.TextBkgndTrans != null) {
            this.TextBkgndTrans = masterShape.TextBkgndTrans;
        }
        if (masterShape.ImgWidth != null) {
            this.ImgWidth = masterShape.ImgWidth;
        }
        if (masterShape.ImgHeight != null) {
            this.ImgHeight = masterShape.ImgHeight;
        }
        if (masterShape.ImgOffsetX != null) {
            this.ImgOffsetX = masterShape.ImgOffsetX;
        }
        if (masterShape.ImgOffsetY != null) {
            this.ImgOffsetY = masterShape.ImgOffsetY;
        }
        if (masterShape.Transparency != null) {
            this.Transparency = masterShape.Transparency;
        }
        if (masterShape.Contrast != null) {
            this.Contrast = masterShape.Contrast;
        }
        if (masterShape.Brightness != null) {
            this.Brightness = masterShape.Brightness;
        }
        if (masterShape.Gamma != null) {
            this.Gamma = masterShape.Gamma;
        }
        if (masterShape.BeginArrow != null) {
            this.BeginArrow = masterShape.BeginArrow;
        }
        if (masterShape.EndArrow != null) {
            this.EndArrow = masterShape.EndArrow;
        }
        if (masterShape.BeginArrowSize != null) {
            this.BeginArrowSize = masterShape.BeginArrowSize;
        }
        if (masterShape.EndArrowSize != null) {
            this.EndArrowSize = masterShape.EndArrowSize;
        }
        if (masterShape.Rounding != null) {
            this.Rounding = masterShape.Rounding;
        }
        if (masterShape.FillGradientEnabled != null) {
            this.FillGradientEnabled = masterShape.FillGradientEnabled;
        }
        if (masterShape.FillGradientDir != null) {
            this.FillGradientDir = masterShape.FillGradientDir;
        }
        if (masterShape.FillGradientAngle != null) {
            this.FillGradientAngle = masterShape.FillGradientAngle;
        }
        if (masterShape.DisplayMode != null) {
            this.DisplayMode = masterShape.DisplayMode;
        }
        if (masterShape.Character != null) {
            if (this.Character == null) {
                this.Character = new VsdxCharacter();
                this.Character.IX = masterShape.Character.IX;
            }
            this.Character.applyProperties(masterShape.Character);
        }
        if (masterShape.Paragraph != null) {
            if (this.Paragraph == null) {
                this.Paragraph = new VsdxParagraph();
                this.Paragraph.IX = masterShape.Paragraph.IX;
            }
            this.Paragraph.applyProperties(masterShape.Paragraph);
        }
        if (masterShape.Characters != null && !masterShape.Characters.isEmpty()) {
            if (this.Characters == null) {
                this.Characters = new ArrayList<VsdxCharacter>();
            }
            isEmpty = this.Characters.isEmpty();
            for (VsdxCharacter masterCharacter : masterShape.Characters) {
                VsdxCharacter character;
                VsdxCharacter vsdxCharacter = character = isEmpty ? null : this.findCharacterById(masterCharacter.IX);
                if (character == null) {
                    character = new VsdxCharacter();
                    character.IX = masterCharacter.IX;
                    this.Characters.add(character);
                }
                character.applyProperties(masterCharacter);
            }
        }
        if (masterShape.Paragraphs != null && !masterShape.Paragraphs.isEmpty()) {
            if (this.Paragraphs == null) {
                this.Paragraphs = new ArrayList<VsdxParagraph>();
            }
            isEmpty = this.Paragraphs.isEmpty();
            for (VsdxParagraph masterParagraph : masterShape.Paragraphs) {
                VsdxParagraph paragraph;
                VsdxParagraph vsdxParagraph = paragraph = isEmpty ? null : this.findParagraphById(masterParagraph.IX);
                if (paragraph == null) {
                    paragraph = new VsdxParagraph();
                    paragraph.IX = masterParagraph.IX;
                    this.Paragraphs.add(paragraph);
                }
                paragraph.applyProperties(masterParagraph);
            }
        }
        if (masterShape.Tabs != null && masterShape.Tabs.TabList != null && !masterShape.Tabs.TabList.isEmpty()) {
            if (this.Tabs == null) {
                this.Tabs = new VsdxTabs();
                this.Tabs.TabList = new ArrayList();
            }
            this.Tabs.applyProperties(masterShape.Tabs);
        }
        if (masterShape.connection != null) {
            if (this.connection == null) {
                this.connection = new VsdxConnection();
            }
            this.connection.applyProperties(masterShape.connection);
        }
        if (masterShape.foreignData != null) {
            if (this.foreignData == null) {
                this.foreignData = new VsdxForeignData();
            }
            this.foreignData.applyProperties(masterShape.foreignData);
        }
        if (masterShape.fillGradient != null) {
            if (this.fillGradient == null) {
                this.fillGradient = new VsdxGradientStops();
            }
            this.fillGradient.applyProperties(masterShape.fillGradient);
        }
        if (masterShape.Fields != null && !masterShape.Fields.isEmpty()) {
            if (this.Fields == null) {
                this.Fields = new ArrayList<VsdxField>();
            }
            isEmpty = this.Fields.isEmpty();
            for (VsdxField masterField : masterShape.Fields) {
                VsdxField field;
                String id = masterField.getIX();
                VsdxField vsdxField = field = isEmpty ? null : this.findFieldById(id);
                if (field == null) {
                    field = new VsdxField(id);
                    this.Fields.add(field);
                }
                field.applyProperties(masterField);
            }
        }
        if (masterShape.Text != null) {
            this.Text = masterShape.Text;
        }
        if (masterShape.TextInfo != null) {
            this.TextInfo = new ArrayList<VsdxTextInfo>(masterShape.TextInfo);
        }
        if (masterShape.HideText != null) {
            this.HideText = masterShape.HideText;
        }
        if (masterShape.hasControlSection) {
            this.hasControlSection = masterShape.hasControlSection;
        }
        if (masterShape.Properties != null && !masterShape.Properties.isEmpty()) {
            if (this.Properties == null) {
                this.Properties = new ArrayList<VsdxProperty>();
            }
            isEmpty = this.Properties.isEmpty();
            for (VsdxProperty masterProperty : masterShape.Properties) {
                VsdxProperty property;
                VsdxProperty vsdxProperty = property = isEmpty ? null : this.findPropertyByName(masterProperty.getName());
                if (property == null) {
                    property = new VsdxProperty();
                    this.Properties.add(property);
                }
                property.applyProperties(masterProperty);
            }
        }
        if (masterShape.Actions != null && !masterShape.Actions.isEmpty()) {
            if (this.Actions == null) {
                this.Actions = new ArrayList<VsdxAction>();
            }
            isEmpty = this.Actions.isEmpty();
            for (VsdxAction masterAction : masterShape.Actions) {
                VsdxAction action;
                VsdxAction vsdxAction = action = isEmpty ? null : this.findActionByName(masterAction.getName());
                if (action == null) {
                    action = new VsdxAction();
                    this.Actions.add(action);
                }
                action.applyProperties(masterAction);
            }
        }
        if (masterShape.geometries != null && !masterShape.geometries.isEmpty()) {
            if (this.geometries == null) {
                this.geometries = new ArrayList<VsdxGeometry>();
            }
            isEmpty = this.geometries.isEmpty();
            for (VsdxGeometry shapeGeometry : masterShape.geometries) {
                VsdxGeometry geometry;
                VsdxGeometry vsdxGeometry = geometry = isEmpty ? null : this.findGeometryById(shapeGeometry.ID);
                if (geometry == null) {
                    geometry = new VsdxGeometry(this);
                    geometry.ID = shapeGeometry.ID;
                    this.geometries.add(geometry);
                }
                geometry.applyProperties(shapeGeometry);
            }
        }
        if (masterShape.QuickStyleLineColor != null) {
            this.QuickStyleLineColor = masterShape.QuickStyleLineColor;
        }
        if (masterShape.QuickStyleFillColor != null) {
            this.QuickStyleFillColor = masterShape.QuickStyleFillColor;
        }
        if (masterShape.QuickStyleShadowColor != null) {
            this.QuickStyleShadowColor = masterShape.QuickStyleShadowColor;
        }
        if (masterShape.QuickStyleFontColor != null) {
            this.QuickStyleFontColor = masterShape.QuickStyleFontColor;
        }
        if (masterShape.QuickStyleLineMatrix != null) {
            this.QuickStyleLineMatrix = masterShape.QuickStyleLineMatrix;
        }
        if (masterShape.QuickStyleFillMatrix != null) {
            this.QuickStyleFillMatrix = masterShape.QuickStyleFillMatrix;
        }
        if (masterShape.QuickStyleEffectsMatrix != null) {
            this.QuickStyleEffectsMatrix = masterShape.QuickStyleEffectsMatrix;
        }
        if (masterShape.QuickStyleFontMatrix != null) {
            this.QuickStyleFontMatrix = masterShape.QuickStyleFontMatrix;
        }
        if (masterShape.QuickStyleVariation != null) {
            this.QuickStyleVariation = masterShape.QuickStyleVariation;
        }
        if (masterShape.QuickStyleType != null) {
            this.QuickStyleType = masterShape.QuickStyleType;
        }
        if (masterShape.isProtected != null) {
            this.isProtected.putAll(masterShape.isProtected);
        }
        if (masterShape.msvStructureType != null) {
            this.msvStructureType = masterShape.msvStructureType;
        }
        if (masterShape.msvSDContainerMargin != null) {
            this.msvSDContainerMargin = masterShape.msvSDContainerMargin;
        }
        if (masterShape.msvSDContainerResize != null) {
            this.msvSDContainerResize = masterShape.msvSDContainerResize;
        }
        if (masterShape.msvSDContainerLocked != null) {
            this.msvSDContainerLocked = masterShape.msvSDContainerLocked;
        }
        if (masterShape.msvShapeCategories != null) {
            this.msvShapeCategories = masterShape.msvShapeCategories;
        }
        if (masterShape.msvSDContainerRequiredCategories != null) {
            this.msvSDContainerRequiredCategories = masterShape.msvSDContainerRequiredCategories;
        }
        if (masterShape.msvSDContainerExcludedCategories != null) {
            this.msvSDContainerExcludedCategories = masterShape.msvSDContainerExcludedCategories;
        }
        if (masterShape.msvSDContainerHeadingEdge != null) {
            this.msvSDContainerHeadingEdge = masterShape.msvSDContainerHeadingEdge;
        }
        if (masterShape.msvSDListAlignment != null) {
            this.msvSDListAlignment = masterShape.msvSDListAlignment;
        }
        if (masterShape.msvSDListDirection != null) {
            this.msvSDListDirection = masterShape.msvSDListDirection;
        }
        if (masterShape.msvSDListRequiredCategories != null) {
            this.msvSDListRequiredCategories = masterShape.msvSDListRequiredCategories;
        }
        if (masterShape.msvSDListExcludedCategories != null) {
            this.msvSDListExcludedCategories = masterShape.msvSDListExcludedCategories;
        }
        if (masterShape.Relationships != null) {
            this.Relationships = new ArrayList<String[]>(masterShape.Relationships);
        }
        if (masterShape.UserVars != null) {
            this.UserVars = new HashMap<String, String>(masterShape.UserVars);
        }
        if (masterShape.ShdwForegnd != null) {
            this.ShdwForegnd = masterShape.ShdwForegnd;
        }
        if (masterShape.ShdwForegndTrans != null) {
            this.ShdwForegndTrans = masterShape.ShdwForegndTrans;
        }
        if (masterShape.ShdwPattern != null) {
            this.ShdwPattern = masterShape.ShdwPattern;
        }
        if (masterShape.ShapeShdwOffsetX != null) {
            this.ShapeShdwOffsetX = masterShape.ShapeShdwOffsetX;
        }
        if (masterShape.ShapeShdwOffsetY != null) {
            this.ShapeShdwOffsetY = masterShape.ShapeShdwOffsetY;
        }
        if (masterShape.ShapeShdwType != null) {
            this.ShapeShdwType = masterShape.ShapeShdwType;
        }
        if (masterShape.ShapeShdwObliqueAngle != null) {
            this.ShapeShdwObliqueAngle = masterShape.ShapeShdwObliqueAngle;
        }
        if (masterShape.ShapeShdwScaleFactor != null) {
            this.ShapeShdwScaleFactor = masterShape.ShapeShdwScaleFactor;
        }
        if (masterShape.ShapeShdwBlur != null) {
            this.ShapeShdwBlur = masterShape.ShapeShdwBlur;
        }
        if (masterShape.ShapeShdwShow != null) {
            this.ShapeShdwShow = masterShape.ShapeShdwShow;
        }
        if (masterShape.ReflectionTrans != null) {
            this.ReflectionTrans = masterShape.ReflectionTrans;
        }
        if (masterShape.ReflectionBlur != null) {
            this.ReflectionBlur = masterShape.ReflectionBlur;
        }
        if (masterShape.ReflectionSize != null) {
            this.ReflectionSize = masterShape.ReflectionSize;
        }
        if (masterShape.ReflectionDist != null) {
            this.ReflectionDist = masterShape.ReflectionDist;
        }
        if (masterShape.GlowColor != null) {
            this.GlowColor = masterShape.GlowColor;
        }
        if (masterShape.GlowColorTrans != null) {
            this.GlowColorTrans = masterShape.GlowColorTrans;
        }
        if (masterShape.GlowSize != null) {
            this.GlowSize = masterShape.GlowSize;
        }
        if (masterShape.SoftEdgesSize != null) {
            this.SoftEdgesSize = masterShape.SoftEdgesSize;
        }
        if (masterShape.ThemeIndex != null) {
            this.ThemeIndex = masterShape.ThemeIndex;
        }
        if (masterShape.ColorSchemeIndex != null) {
            this.ColorSchemeIndex = masterShape.ColorSchemeIndex;
        }
        if (masterShape.EffectSchemeIndex != null) {
            this.EffectSchemeIndex = masterShape.EffectSchemeIndex;
        }
        if (masterShape.ConnectorSchemeIndex != null) {
            this.ConnectorSchemeIndex = masterShape.ConnectorSchemeIndex;
        }
        if (masterShape.FontSchemeIndex != null) {
            this.FontSchemeIndex = masterShape.FontSchemeIndex;
        }
    }

    public VsdxGeometry findGeometryById(String id) {
        if (id != null && this.geometries != null) {
            for (VsdxGeometry g : this.geometries) {
                if (!id.equals(g.ID)) continue;
                return g;
            }
        }
        return null;
    }

    public VsdxShape findShapeById(String id) {
        if (id == null || this.shapes == null) {
            return null;
        }
        VsdxShape result = this.shapes.get(id);
        if (result == null) {
            assert (this.shapes.shapes != null);
            for (VsdxShape s : this.shapes.shapes) {
                result = s.findShapeById(id);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public VsdxField findFieldById(String id) {
        if (id == null || this.Fields == null) {
            return null;
        }
        for (VsdxField f : this.Fields) {
            if (!id.equals(f.getIX())) continue;
            return f;
        }
        return null;
    }

    public VsdxCharacter findCharacterById(String id) {
        if (id == null || this.Characters == null) {
            return null;
        }
        for (VsdxCharacter c : this.Characters) {
            if (!id.equals(c.IX)) continue;
            return c;
        }
        return null;
    }

    public VsdxParagraph findParagraphById(String id) {
        if (id == null || this.Paragraphs == null) {
            return null;
        }
        for (VsdxParagraph p : this.Paragraphs) {
            if (!id.equals(p.IX)) continue;
            return p;
        }
        return null;
    }

    public VsdxTabs.VsdxTab findTabByIndex(String index) {
        if (this.Tabs == null || index == null || index.isEmpty()) {
            return null;
        }
        return this.Tabs.findVsdxTabByIndex(index);
    }

    public VsdxProperty findPropertyByName(String name) {
        if (name == null || name.isEmpty() || this.Properties == null) {
            return null;
        }
        for (VsdxProperty p : this.Properties) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public VsdxAction findActionByName(String name) {
        if (name == null || name.isEmpty() || this.Actions == null) {
            return null;
        }
        for (VsdxAction a : this.Actions) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    private boolean isInitInfo() {
        return this.visiblePaths != null;
    }

    private void initInfo() {
        if (this.isInitInfo()) {
            return;
        }
        this.visiblePaths = new IntegerList(2);
        this.fillArr = new IntegerList(2);
        this.lineArr = new IntegerList(2);
        if (this.geometries == null) {
            return;
        }
        boolean fillEmpty = this.checkEmptyFill();
        boolean lineEmpty = this.checkEmptyLine();
        int cnt = this.geometries.size();
        for (int i = 0; i < cnt; ++i) {
            boolean closed;
            boolean isLine;
            VsdxGeometry geom = this.geometries.get(i);
            boolean isFill = !geom.isNoFill() && !fillEmpty;
            boolean bl = isLine = !geom.isNoLine() && !lineEmpty;
            if (geom.isNoShow() || !isFill && !isLine) {
                if (this.hiddenPaths == null) {
                    this.hiddenPaths = new IntegerList(0);
                }
                this.hiddenPaths.add(i);
                continue;
            }
            this.visiblePaths.add(i);
            boolean bl2 = closed = geom.getClosed() != 0;
            if (isFill) {
                if (closed) {
                    this.fillArr.add(i);
                    continue;
                }
                this.lineArr.add(i);
                if (this.checkEmptyFill() || geom.rows == null || geom.rows.size() <= 2) continue;
                VsdxGeometry fill = new VsdxGeometry(this);
                fill.applyProperties(geom);
                fill.NoLine = "1";
                assert (fill.rows != null);
                VsdxGeometryRow lastr = new VsdxGeometryRow();
                lastr.applyProperties(fill.rows.get(0));
                fill.rows.add(lastr);
                int cntj = fill.rows.size();
                for (int j = 1; j < cntj; ++j) {
                    VsdxGeometryRow r = fill.rows.get(j);
                    if ("MoveTo".equals(r.T)) {
                        r.T = "LineTo";
                        continue;
                    }
                    if (!"RelMoveTo".equals(r.T)) continue;
                    r.T = "RelLineTo";
                }
                boolean bl3 = closed = fill.getClosed() != 0;
                if (!closed) continue;
                this.fillArr.add(this.geometries.size());
                this.geometries.add(fill);
                continue;
            }
            if (!isLine) continue;
            this.lineArr.add(i);
        }
    }

    public boolean isNoFill() {
        if (this.geometries != null) {
            for (VsdxGeometry g : this.geometries) {
                if (!g.isNoFill()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNoLine() {
        if (this.geometries != null) {
            for (VsdxGeometry g : this.geometries) {
                if (!g.isNoLine()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkEmptyFill() {
        return "1".equals(this.FillForegndTrans) || VsdxUtils.convertFillStyle(this.FillPattern) == 1;
    }

    public boolean checkEmptyLine() {
        return "1".equals(this.LineColorTrans) || VsdxUtils.convertLineStyle(this.LinePattern) == 5;
    }

    public BaseGraphic.RealPoint getShapeSize() {
        if (this.shapeSize == null) {
            this.shapeSize = new BaseGraphic.RealPoint(Math.abs(this.convertDouble(this.Width)), Math.abs(this.convertDouble(this.Height)));
        }
        return this.shapeSize;
    }

    public BaseGraphic.RealPoint getShapeSizeMM() {
        if (this.shapeSizeMM == null) {
            this.shapeSizeMM = new BaseGraphic.RealPoint(25.4 * Math.abs(this.convertDouble(this.Width)), 25.4 * Math.abs(this.convertDouble(this.Height)));
        }
        return this.shapeSizeMM;
    }

    public BaseGraphic.RealPoint getLocPinMM() {
        if (this.locPinMM == null) {
            this.locPinMM = new BaseGraphic.RealPoint(25.4 * this.convertDouble(this.LocPinX), 25.4 * this.convertDouble(this.LocPinY));
        }
        return this.locPinMM;
    }

    public BaseGraphic.RealPoint getLocPin() {
        if (this.locPin == null) {
            this.locPin = new BaseGraphic.RealPoint(this.convertDouble(this.LocPinX), this.convertDouble(this.LocPinY));
        }
        return this.locPin;
    }

    public BaseGraphic.RealPoint getPinMM() {
        if (this.pinMM == null) {
            this.pinMM = new BaseGraphic.RealPoint(25.4 * this.convertDouble(this.PinX), 25.4 * this.convertDouble(this.PinY));
        }
        return this.pinMM;
    }

    public BaseGraphic.RealPoint getPin() {
        if (this.pin == null) {
            this.pin = new BaseGraphic.RealPoint(this.convertDouble(this.PinX), this.convertDouble(this.PinY));
        }
        return this.pin;
    }

    public BaseGraphic.RealPoint getTxtPin() {
        return new BaseGraphic.RealPoint(this.convertDouble(this.TxtPinX), this.convertDouble(this.TxtPinY));
    }

    public BaseGraphic.RealPoint getTxtLocPin() {
        return new BaseGraphic.RealPoint(this.convertDouble(this.TxtLocPinX), this.convertDouble(this.TxtLocPinY));
    }

    public BaseGraphic.RealPoint getTxtSize() {
        return new BaseGraphic.RealPoint(Math.abs(this.convertDouble(this.TxtWidth)), Math.abs(this.convertDouble(this.TxtHeight)));
    }

    public IntegerList getVisiblePaths() {
        this.initInfo();
        return this.visiblePaths;
    }

    public IntegerList getFillArr() {
        this.initInfo();
        return this.fillArr;
    }

    public IntegerList getLineArr() {
        this.initInfo();
        return this.lineArr;
    }

    public IntegerList getHiddenPaths() {
        this.initInfo();
        return this.hiddenPaths;
    }

    public String getName() {
        if (this.Name == null || this.Name.isEmpty()) {
            return "Sheet." + this.ID;
        }
        return this.Name;
    }

    public boolean isFlipX() {
        return "1".equals(this.FlipX);
    }

    public boolean isFlipY() {
        return "1".equals(this.FlipY);
    }

    public boolean isFillGradientEnabled() {
        return "1".equals(this.FillGradientEnabled);
    }

    public double getAngle() {
        return this.convertDouble(this.Angle);
    }

    public boolean isOneD() {
        return this.BeginX != null && !this.BeginX.isEmpty() && this.BeginY != null && !this.BeginY.isEmpty() && this.EndX != null && !this.EndX.isEmpty() && this.EndY != null && !this.EndY.isEmpty();
    }

    public Color getLineColor() {
        return this.vsdx.parseColor(this.LineColor);
    }

    public Color getFillBkgnd() {
        return this.vsdx.parseColor(this.FillBkgnd);
    }

    public Color getFillForegnd() {
        return this.FillForegnd == null || this.FillForegnd.isEmpty() ? Color.WHITE : this.vsdx.parseColor(this.FillForegnd);
    }

    public String getText() {
        return this.Text == null ? "" : this.Text;
    }

    public boolean isHideText() {
        return "1".equals(this.HideText);
    }

    public boolean hasTextTransform() {
        if (!SchemeUtils.isEmpty(this.TxtWidth) && !SchemeUtils.isEqualAsDouble(this.TxtWidth, this.Width)) {
            return true;
        }
        if (!SchemeUtils.isEmpty(this.TxtHeight) && !SchemeUtils.isEqualAsDouble(this.TxtHeight, this.Height)) {
            return true;
        }
        if (!SchemeUtils.isEmpty(this.TxtLocPinX) && !SchemeUtils.isEqualAsDouble(this.TxtLocPinX, this.LocPinX)) {
            return true;
        }
        if (!SchemeUtils.isEmpty(this.TxtLocPinY) && !SchemeUtils.isEqualAsDouble(this.TxtLocPinY, this.LocPinY)) {
            return true;
        }
        if (!(SchemeUtils.isEmpty(this.TxtPinX) || SchemeUtils.isEmpty(this.TxtPinY) || SchemeUtils.isEqualAsDouble(this.TxtPinX, this.PinX) && SchemeUtils.isEqualAsDouble(this.TxtPinY, this.PinY) || SchemeUtils.isEqualAsDouble(this.TxtPinX, this.PinY) && SchemeUtils.isEqualAsDouble(this.TxtPinY, this.PinX))) {
            return true;
        }
        return !SchemeUtils.isEmpty(this.TxtAngle) && !SchemeUtils.isEqual(VsdxUtils.convertDouble(this.TxtAngle, null), 0.0);
    }

    public Color parseColor(String color) {
        return this.vsdx.parseColor(color);
    }

    public boolean isConnector() {
        return "2".equals(this.ObjType) & this.inheritsConnectorStyleSheet;
    }

    public void applyStyles(boolean usesTheme) {
        VsdxStyle textStyle;
        VsdxStyle fillStyle;
        VsdxStyle lineStyle;
        if (this.shapes != null) {
            this.shapes.shapes.forEach(s -> s.applyStyles(usesTheme));
        }
        Predicate<String> Empty2 = v -> v == null || v.isEmpty() || "Themed".equals(v) && !usesTheme;
        Predicate<String> Empty0 = v -> v == null || v.isEmpty() || "Themed".equals(v);
        if (this.vsdx.styles == null) {
            return;
        }
        VsdxStyle vsdxStyle = lineStyle = this.LineStyle == null ? null : this.vsdx.styles.get(this.LineStyle);
        if (lineStyle != null) {
            if (lineStyle.cellValues != null) {
                if (Empty2.test(this.LineColor)) {
                    this.LineColor = lineStyle.cellValues.get("LineColor");
                }
                if (Empty2.test(this.LinePattern)) {
                    this.LinePattern = lineStyle.cellValues.get("LinePattern");
                }
                if (Empty2.test(this.LineWeight)) {
                    this.LineWeight = lineStyle.cellValues.get("LineWeight");
                }
                if (Empty2.test(this.LineColorTrans)) {
                    this.LineColorTrans = lineStyle.cellValues.get("LineColorTrans");
                }
                if (Empty2.test(this.LineCap)) {
                    this.LineCap = lineStyle.cellValues.get("LineCap");
                }
                if (Empty2.test(this.BeginArrow)) {
                    this.BeginArrow = lineStyle.cellValues.get("BeginArrow");
                }
                if (Empty2.test(this.EndArrow)) {
                    this.EndArrow = lineStyle.cellValues.get("EndArrow");
                }
                if (Empty2.test(this.BeginArrowSize)) {
                    this.BeginArrowSize = lineStyle.cellValues.get("BeginArrowSize");
                }
                if (Empty2.test(this.EndArrowSize)) {
                    this.EndArrowSize = lineStyle.cellValues.get("EndArrowSize");
                }
                if (Empty2.test(this.Rounding)) {
                    this.Rounding = lineStyle.cellValues.get("Rounding");
                }
                if (Empty2.test(this.QuickStyleLineColor)) {
                    this.QuickStyleLineColor = lineStyle.cellValues.get("QuickStyleLineColor");
                }
                if (Empty2.test(this.QuickStyleLineMatrix)) {
                    this.QuickStyleLineMatrix = lineStyle.cellValues.get("QuickStyleLineMatrix");
                }
            }
            if (lineStyle.lineGradientValues != null) {
                // empty if block
            }
            if ("Connector".equals(lineStyle.Name)) {
                this.inheritsConnectorStyleSheet = true;
            }
            this.LineStyle = lineStyle.LineStyleID;
        } else {
            this.LineStyle = null;
        }
        VsdxStyle vsdxStyle2 = fillStyle = this.FillStyle == null ? null : this.vsdx.styles.get(this.FillStyle);
        if (fillStyle != null) {
            if (fillStyle.cellValues != null) {
                if (Empty2.test(this.FillForegnd)) {
                    this.FillForegnd = fillStyle.cellValues.get("FillForegnd");
                }
                if (Empty2.test(this.FillForegndTrans)) {
                    this.FillForegndTrans = fillStyle.cellValues.get("FillForegndTrans");
                }
                if (Empty2.test(this.FillBkgnd)) {
                    this.FillBkgnd = fillStyle.cellValues.get("FillBkgnd");
                }
                if (Empty2.test(this.FillPattern) && this.isNotProtected("FillPattern")) {
                    this.FillPattern = fillStyle.cellValues.get("FillPattern");
                }
                if (Empty2.test(this.FillGradientEnabled) && this.isNotProtected("FillGradientEnabled")) {
                    this.FillGradientEnabled = fillStyle.cellValues.get("FillGradientEnabled");
                }
                if (Empty2.test(this.FillGradientDir)) {
                    this.FillGradientDir = fillStyle.cellValues.get("FillGradientDir");
                }
                if (Empty2.test(this.FillGradientAngle)) {
                    this.FillGradientAngle = fillStyle.cellValues.get("FillGradientAngle");
                }
                if (Empty2.test(this.QuickStyleFillColor)) {
                    this.QuickStyleFillColor = fillStyle.cellValues.get("QuickStyleFillColor");
                }
                if (Empty2.test(this.QuickStyleFillMatrix)) {
                    this.QuickStyleFillMatrix = fillStyle.cellValues.get("QuickStyleFillMatrix");
                }
                if (Empty2.test(this.QuickStyleFontColor)) {
                    this.QuickStyleFontColor = fillStyle.cellValues.get("QuickStyleFontColor");
                }
                if (Empty2.test(this.QuickStyleFontMatrix)) {
                    this.QuickStyleFontMatrix = fillStyle.cellValues.get("QuickStyleFontMatrix");
                }
                if (Empty2.test(this.QuickStyleShadowColor)) {
                    this.QuickStyleShadowColor = fillStyle.cellValues.get("QuickStyleShadowColor");
                }
                if (Empty2.test(this.QuickStyleEffectsMatrix)) {
                    this.QuickStyleEffectsMatrix = fillStyle.cellValues.get("QuickStyleEffectsMatrix");
                }
                if (Empty2.test(this.QuickStyleVariation)) {
                    this.QuickStyleVariation = fillStyle.cellValues.get("QuickStyleVariation");
                }
                if (Empty2.test(this.QuickStyleType)) {
                    this.QuickStyleType = fillStyle.cellValues.get("QuickStyleType");
                }
                if (Empty2.test(this.ShdwForegnd)) {
                    this.ShdwForegnd = fillStyle.cellValues.get("ShdwForegnd");
                }
                if (Empty2.test(this.ShdwForegndTrans)) {
                    this.ShdwForegndTrans = fillStyle.cellValues.get("ShdwForegndTrans");
                }
                if (Empty2.test(this.ShdwPattern)) {
                    this.ShdwPattern = fillStyle.cellValues.get("ShdwPattern");
                }
                if (Empty2.test(this.ShapeShdwOffsetX)) {
                    this.ShapeShdwOffsetX = fillStyle.cellValues.get("ShapeShdwOffsetX");
                }
                if (Empty2.test(this.ShapeShdwOffsetY)) {
                    this.ShapeShdwOffsetY = fillStyle.cellValues.get("ShapeShdwOffsetY");
                }
                if (Empty2.test(this.ShapeShdwType)) {
                    this.ShapeShdwType = fillStyle.cellValues.get("ShapeShdwType");
                }
                if (Empty2.test(this.ShapeShdwObliqueAngle)) {
                    this.ShapeShdwObliqueAngle = fillStyle.cellValues.get("ShapeShdwObliqueAngle");
                }
                if (Empty2.test(this.ShapeShdwScaleFactor)) {
                    this.ShapeShdwScaleFactor = fillStyle.cellValues.get("ShapeShdwScaleFactor");
                }
                if (Empty2.test(this.ShapeShdwBlur)) {
                    this.ShapeShdwBlur = fillStyle.cellValues.get("ShapeShdwBlur");
                }
                if (Empty2.test(this.ShapeShdwShow)) {
                    this.ShapeShdwShow = fillStyle.cellValues.get("ShapeShdwShow");
                }
                if (Empty2.test(this.GlowColor)) {
                    this.GlowColor = fillStyle.cellValues.get("GlowColor");
                }
                if (Empty2.test(this.GlowColorTrans)) {
                    this.GlowColorTrans = fillStyle.cellValues.get("GlowColorTrans");
                }
                if (Empty2.test(this.GlowSize)) {
                    this.GlowSize = fillStyle.cellValues.get("GlowSize");
                }
                if (Empty2.test(this.SoftEdgesSize)) {
                    this.SoftEdgesSize = fillStyle.cellValues.get("SoftEdgesSize");
                }
                if (Empty2.test(this.ThemeIndex)) {
                    this.ThemeIndex = fillStyle.cellValues.get("ThemeIndex");
                }
                if (Empty2.test(this.ColorSchemeIndex)) {
                    this.ColorSchemeIndex = fillStyle.cellValues.get("ColorSchemeIndex");
                }
                if (Empty2.test(this.EffectSchemeIndex)) {
                    this.EffectSchemeIndex = fillStyle.cellValues.get("EffectSchemeIndex");
                }
                if (Empty2.test(this.ConnectorSchemeIndex)) {
                    this.ConnectorSchemeIndex = fillStyle.cellValues.get("ConnectorSchemeIndex");
                }
                if (Empty2.test(this.FontSchemeIndex)) {
                    this.FontSchemeIndex = fillStyle.cellValues.get("FontSchemeIndex");
                }
                if (Empty2.test(this.ReflectionTrans)) {
                    this.ReflectionTrans = fillStyle.cellValues.get("ReflectionTrans");
                }
                if (Empty2.test(this.ReflectionBlur)) {
                    this.ReflectionBlur = fillStyle.cellValues.get("ReflectionBlur");
                }
                if (Empty2.test(this.ReflectionSize)) {
                    this.ReflectionSize = fillStyle.cellValues.get("ReflectionSize");
                }
                if (Empty2.test(this.ReflectionDist)) {
                    this.ReflectionDist = fillStyle.cellValues.get("ReflectionDist");
                }
                if (Empty2.test(this.Contrast)) {
                    this.Contrast = fillStyle.cellValues.get("Contrast");
                }
                if (Empty2.test(this.Brightness)) {
                    this.Brightness = fillStyle.cellValues.get("Brightness");
                }
                if (Empty2.test(this.Gamma)) {
                    this.Gamma = fillStyle.cellValues.get("Gamma");
                }
            }
            if (fillStyle.fillGradientValues != null && fillStyle.fillGradientValues.size() > 0) {
                if (this.fillGradient == null) {
                    this.fillGradient = new VsdxGradientStops();
                }
                for (Map<String, String> point : fillStyle.fillGradientValues) {
                    if (point.isEmpty()) continue;
                    String rowId = point.get("IX");
                    VsdxGradientStops.VsdxGradientStopsRow row = this.fillGradient.findRowById(rowId);
                    if (row == null) {
                        row = new VsdxGradientStops.VsdxGradientStopsRow();
                        row.ID = rowId;
                        if (this.fillGradient.rows == null) {
                            this.fillGradient.rows = new ArrayList<VsdxGradientStops.VsdxGradientStopsRow>();
                        }
                        this.fillGradient.rows.add(row);
                    }
                    if (Empty2.test(row.Del)) {
                        row.Del = point.get("Del");
                    }
                    if ("1".equals(row.Del)) continue;
                    if (Empty2.test(row.GradientStopColor)) {
                        row.GradientStopColor = point.get("GradientStopColor");
                    }
                    if (Empty2.test(row.GradientStopPosition)) {
                        row.GradientStopPosition = point.get("GradientStopPosition");
                    }
                    if (!Empty2.test(row.GradientStopColorTrans)) continue;
                    row.GradientStopColorTrans = point.get("GradientStopColorTrans");
                }
            }
            this.FillStyle = fillStyle.FillStyleID;
        } else {
            this.FillStyle = null;
        }
        VsdxStyle vsdxStyle3 = textStyle = this.TextStyle == null ? null : this.vsdx.styles.get(this.TextStyle);
        if (this.TextStyle != null && this.vsdx.styles.containsKey(this.TextStyle)) {
            if (textStyle.cellValues != null) {
                if (Empty2.test(this.TxtPinX)) {
                    this.TxtPinX = textStyle.cellValues.get("TxtPinX");
                }
                if (Empty2.test(this.TxtPinY)) {
                    this.TxtPinY = textStyle.cellValues.get("TxtPinY");
                }
                if (Empty2.test(this.TxtLocPinX)) {
                    this.TxtLocPinX = textStyle.cellValues.get("TxtLocPinX");
                }
                if (Empty2.test(this.TxtLocPinY)) {
                    this.TxtLocPinY = textStyle.cellValues.get("TxtLocPinY");
                }
                if (Empty2.test(this.TxtAngle)) {
                    this.TxtAngle = textStyle.cellValues.get("TxtAngle");
                }
                if (Empty2.test(this.TxtWidth)) {
                    this.TxtWidth = textStyle.cellValues.get("TxtWidth");
                }
                if (Empty2.test(this.TxtHeight)) {
                    this.TxtHeight = textStyle.cellValues.get("TxtHeight");
                }
                if (Empty2.test(this.LeftMargin)) {
                    this.LeftMargin = textStyle.cellValues.get("LeftMargin");
                }
                if (Empty2.test(this.RightMargin)) {
                    this.RightMargin = textStyle.cellValues.get("RightMargin");
                }
                if (Empty2.test(this.TopMargin)) {
                    this.TopMargin = textStyle.cellValues.get("TopMargin");
                }
                if (Empty2.test(this.BottomMargin)) {
                    this.BottomMargin = textStyle.cellValues.get("BottomMargin");
                }
                if (Empty2.test(this.TextDirection)) {
                    this.TextDirection = textStyle.cellValues.get("TextDirection");
                }
                if (Empty2.test(this.VerticalAlign)) {
                    this.VerticalAlign = textStyle.cellValues.get("VerticalAlign");
                }
                if (Empty2.test(this.TextBkgnd)) {
                    this.TextBkgnd = textStyle.cellValues.get("TextBkgnd");
                }
                if (Empty2.test(this.TextBkgndTrans)) {
                    this.TextBkgndTrans = textStyle.cellValues.get("TextBkgndTrans");
                }
                if (Empty2.test(this.DefaultTabStop)) {
                    this.DefaultTabStop = textStyle.cellValues.get("DefaultTabStop");
                }
            }
            if (textStyle.characterValues != null) {
                if (this.Character == null) {
                    this.Character = new VsdxCharacter();
                }
                if (Empty0.test(this.Character.Font)) {
                    this.Character.Font = textStyle.characterValues.get("Font");
                }
                if (Empty0.test(this.Character.Size)) {
                    this.Character.Size = textStyle.characterValues.get("Size");
                }
                if (Empty2.test(this.Character.Style)) {
                    this.Character.Style = textStyle.characterValues.get("Style");
                }
                if (Empty2.test(this.Character.Color)) {
                    this.Character.Color = textStyle.characterValues.get("Color");
                }
                if (Empty0.test(this.Character.Case)) {
                    this.Character.Case = textStyle.characterValues.get("Case");
                }
                if (Empty0.test(this.Character.Strikethru)) {
                    this.Character.Strikethru = textStyle.characterValues.get("Strikethru");
                }
                if (Empty0.test(this.Character.FontScale)) {
                    this.Character.FontScale = textStyle.characterValues.get("FontScale");
                }
                if (Empty0.test(this.Character.ColorTrans)) {
                    this.Character.ColorTrans = textStyle.characterValues.get("ColorTrans");
                }
            }
            if (textStyle.paragraphValues != null) {
                if (this.Paragraph == null) {
                    this.Paragraph = new VsdxParagraph();
                }
                if (Empty0.test(this.Paragraph.IndFirst)) {
                    this.Paragraph.IndFirst = textStyle.paragraphValues.get("IndFirst");
                }
                if (Empty0.test(this.Paragraph.IndLeft)) {
                    this.Paragraph.IndLeft = textStyle.paragraphValues.get("IndLeft");
                }
                if (Empty0.test(this.Paragraph.IndRight)) {
                    this.Paragraph.IndRight = textStyle.paragraphValues.get("IndRight");
                }
                if (Empty0.test(this.Paragraph.SpLine)) {
                    this.Paragraph.SpLine = textStyle.paragraphValues.get("SpLine");
                }
                if (Empty0.test(this.Paragraph.SpBefore)) {
                    this.Paragraph.SpBefore = textStyle.paragraphValues.get("SpBefore");
                }
                if (Empty0.test(this.Paragraph.SpAfter)) {
                    this.Paragraph.SpAfter = textStyle.paragraphValues.get("SpAfter");
                }
                if (Empty0.test(this.Paragraph.HorzAlign)) {
                    this.Paragraph.HorzAlign = textStyle.paragraphValues.get("HorzAlign");
                }
                if (Empty0.test(this.Paragraph.Bullet)) {
                    this.Paragraph.Bullet = textStyle.paragraphValues.get("Bullet");
                }
                if (Empty0.test(this.Paragraph.BulletStr)) {
                    this.Paragraph.BulletStr = textStyle.paragraphValues.get("BulletStr");
                }
                if (Empty0.test(this.Paragraph.BulletFont)) {
                    this.Paragraph.BulletFont = textStyle.paragraphValues.get("BulletFont");
                }
                if (Empty0.test(this.Paragraph.BulletFontSize)) {
                    this.Paragraph.BulletFontSize = textStyle.paragraphValues.get("BulletFontSize");
                }
                if (Empty0.test(this.Paragraph.TextPosAfterBullet)) {
                    this.Paragraph.TextPosAfterBullet = textStyle.paragraphValues.get("TextPosAfterBullet");
                }
                if (Empty0.test(this.Paragraph.Flags)) {
                    this.Paragraph.Flags = textStyle.paragraphValues.get("Flags");
                }
            }
            this.TextStyle = textStyle.TextStyleID;
        } else {
            this.TextStyle = null;
        }
        if (this.LineStyle != null || this.FillStyle != null || this.TextStyle != null) {
            this.applyStyles(usesTheme);
        }
    }

    public List<VsdxShape> getShapes() {
        return this.shapes == null ? null : this.shapes.shapes;
    }

    VsdxShape findMasterShape(String masterShapeId, boolean remove) {
        if (masterShapeId == null || this.parent == null) {
            return null;
        }
        if (this.parent.master != null && this.parent.master.shapes != null) {
            int cnt = this.parent.master.shapes.size();
            for (int i = 0; i < cnt; ++i) {
                VsdxShape result;
                VsdxShape shape = this.parent.master.shapes.get(i);
                if (shape == null) continue;
                VsdxShape vsdxShape = result = masterShapeId.equals(shape.ID) ? shape : shape.findShapeById(masterShapeId);
                if (result == null) continue;
                return result;
            }
        }
        return this.parent.findMasterShape(masterShapeId, remove);
    }

    public boolean hasMaster() {
        return this.Master != null && !this.Master.isEmpty() || this.MasterShape != null && !this.MasterShape.isEmpty();
    }

    public boolean hasFillProperties() {
        return !SchemeUtils.isEmpty(this.FillForegnd) || !SchemeUtils.isEmpty(this.FillPattern) || this.fillGradient != null;
    }

    private double convertDouble(String s) {
        return VsdxUtils.convertDouble(s, this);
    }

    public VsdxShape getMasterShape() {
        return this.masterShape;
    }

    public boolean isPrimitiveInsert(BaseGraphic.RealPoint scale) {
        assert (scale != null);
        if (this.masterShape == null) {
            return false;
        }
        double W = VsdxUtils.convertDouble(this.Width, this);
        double H = VsdxUtils.convertDouble(this.Height, this);
        double mW = VsdxUtils.convertDouble(this.masterShape.Width, this);
        double mH = VsdxUtils.convertDouble(this.masterShape.Height, this);
        double scaleX = mW == 0.0 || W == 0.0 ? 1.0 : W / mW;
        double scaleY = mH == 0.0 || H == 0.0 ? 1.0 : H / mH;
        scale.X = scaleX;
        scale.Y = scaleY;
        return this.onlyMaster;
    }

    public boolean isMasterBase() {
        return this.masterShape != null && this.masterShape.BaseID != null && !this.masterShape.BaseID.isEmpty();
    }

    public String getMasterBaseID() {
        return this.masterShape == null ? null : (this.masterShape.UniqueID == null || this.masterShape.UniqueID.isEmpty() ? this.masterShape.BaseID : this.masterShape.UniqueID);
    }

    public String getBaseID() {
        return this.BaseID == null ? "" : this.BaseID;
    }

    public ContainerType getContainerType() {
        if (this.msvStructureType == null || this.msvStructureType.isEmpty()) {
            return null;
        }
        String s = this.msvStructureType.toLowerCase();
        if ("container".equals(s)) {
            return ContainerType.CONTAINER;
        }
        if ("list".equals(s)) {
            return ContainerType.LIST;
        }
        if ("callout".equals(s)) {
            return ContainerType.CALLOUT;
        }
        if ("heading".equals(s)) {
            return ContainerType.HEADING;
        }
        return null;
    }

    public String getPageMeasureUnits() {
        if (this.page != null && this.page.PageMeasureUnits != null) {
            return this.page.PageMeasureUnits;
        }
        return "";
    }

    public BaseGraphic.RealRect calcGeometriesRect() {
        if (this.geometries == null || this.geometries.isEmpty()) {
            return null;
        }
        if (this.checkEmptyFill() && this.checkEmptyLine()) {
            return null;
        }
        double maxX = BaseGraphic.initMaxX();
        double maxY = BaseGraphic.initMaxY();
        double minX = BaseGraphic.initMinX();
        double minY = BaseGraphic.initMinY();
        boolean result = false;
        for (VsdxGeometry g : this.geometries) {
            if (g.isNoShow() || g.isNoFill() && g.isNoLine()) continue;
            for (BaseGraphic.RealPoint p : g.getPoints(true, false)) {
                if (p.X > maxX) {
                    maxX = p.X;
                }
                if (p.X < minX) {
                    minX = p.X;
                }
                if (p.Y > maxY) {
                    maxY = p.Y;
                }
                if (p.Y < minY) {
                    minY = p.Y;
                }
                result = true;
            }
        }
        if (result) {
            BaseGraphic.RealRect rect = new BaseGraphic.RealRect();
            rect.Left = SchemeUtils.mmToInch(minX);
            rect.Bottom = SchemeUtils.mmToInch(minY);
            rect.Right = SchemeUtils.mmToInch(maxX);
            rect.Top = SchemeUtils.mmToInch(maxY);
            return rect;
        }
        return null;
    }

    public boolean isLineRoute() {
        return "2".equals(this.ObjType);
    }

    public boolean isRepairLineRoute() {
        return "1".equals(this.ConFixedCode) || "2".equals(this.ConFixedCode) || "3".equals(this.ConFixedCode);
    }

    public boolean isCurveLineRoute() {
        return "2".equals(this.ConLineRouteExt);
    }

    public boolean isStraightLineRoute() {
        if (this.ShapeRouteStyle == null || this.ShapeRouteStyle.isEmpty()) {
            return false;
        }
        return "2".equals(this.ShapeRouteStyle) || "7".equals(this.ShapeRouteStyle) || "8".equals(this.ShapeRouteStyle) || "14".equals(this.ShapeRouteStyle) || "15".equals(this.ShapeRouteStyle) || "16".equals(this.ShapeRouteStyle);
    }

    public String getTextContent() {
        String lastPP;
        String lastCP;
        if (this.TextInfo == null || this.TextInfo.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int lastlenCP = 0;
        int maxlenCP = -1;
        this.PreferredCharacterIX = lastCP = "";
        int lastlenPP = 0;
        int maxlenPP = -1;
        this.PreferredParagraphIX = lastPP = "";
        for (VsdxTextInfo info : this.TextInfo) {
            String text;
            VsdxField field;
            String ix;
            if (info.nodeType == 3) {
                sb.append(info.content);
            } else if (info.nodeType != 1) continue;
            if (info.name.equalsIgnoreCase("cp")) {
                int len = sb.toString().trim().length();
                if (len - lastlenCP > maxlenCP) {
                    maxlenCP = len - lastlenCP;
                    this.PreferredCharacterIX = lastCP;
                }
                lastlenCP = sb.length();
                lastCP = info.attributes.get("IX");
                continue;
            }
            if (info.name.equalsIgnoreCase("pp")) {
                int len = sb.toString().trim().length();
                if (len - lastlenPP > maxlenPP) {
                    maxlenPP = len - lastlenPP;
                    this.PreferredParagraphIX = lastPP;
                }
                lastlenPP = sb.length();
                lastPP = info.attributes.get("IX");
                continue;
            }
            if (!info.name.equalsIgnoreCase("fld") || info.attributes == null || (ix = info.attributes.get("IX")) == null || (field = this.findFieldById(ix)) == null || (text = field.getText("")) == null) continue;
            sb.append(text);
        }
        int len = sb.toString().trim().length();
        if (len - lastlenCP > maxlenCP) {
            this.PreferredCharacterIX = lastCP;
        }
        if (len - lastlenPP > maxlenPP) {
            this.PreferredParagraphIX = lastPP;
        }
        return sb.toString();
    }

    private void addTextPart(List<VsdxTextPart> parts, String text, String cp, String pp, String tp, boolean newLine) {
        int idx;
        if (parts == null) {
            return;
        }
        String txt = text == null ? "" : text;
        ArrayList<String> texts = new ArrayList<String>();
        int begIdx = 0;
        while ((idx = txt.indexOf("\t", begIdx)) >= 0) {
            if (idx > begIdx) {
                texts.add(txt.substring(begIdx, idx));
            }
            texts.add("\t");
            begIdx = idx + 1;
        }
        if (begIdx == 0 || begIdx < txt.length()) {
            texts.add(txt.substring(begIdx));
        }
        for (String s : texts) {
            VsdxTextPart part = new VsdxTextPart();
            part.text = s;
            part.cp = cp;
            part.pp = pp;
            part.tp = tp;
            part.newLine = newLine;
            newLine = false;
            parts.add(part);
        }
    }

    public List<VsdxTextPart> getTextParts() {
        if (this.TextInfo == null || this.TextInfo.isEmpty()) {
            return null;
        }
        ArrayList<VsdxTextPart> parts = new ArrayList<VsdxTextPart>();
        String lastCP = "";
        String lastPP = "";
        String lastTP = "";
        boolean nextNewLine = false;
        for (VsdxTextInfo info : this.TextInfo) {
            String text;
            VsdxField field;
            String ix;
            if (info.nodeType == 3) {
                List<String> textStrings = SchemeUtils.getStrings(info.content);
                int cnti = textStrings.size();
                for (int i = 0; i < cnti; ++i) {
                    this.addTextPart(parts, textStrings.get(i), lastCP, lastPP, lastTP, i > 0 || parts.isEmpty() || nextNewLine);
                    nextNewLine = false;
                }
                nextNewLine = info.content != null && info.content.endsWith("\n");
            } else if (info.nodeType != 1) continue;
            if (info.name.equalsIgnoreCase("cp")) {
                lastCP = info.attributes.get("IX");
                continue;
            }
            if (info.name.equalsIgnoreCase("pp")) {
                lastPP = info.attributes.get("IX");
                continue;
            }
            if (info.name.equalsIgnoreCase("tp")) {
                lastTP = info.attributes.get("IX");
                continue;
            }
            if (!info.name.equalsIgnoreCase("fld") || info.attributes == null || (ix = info.attributes.get("IX")) == null || (field = this.findFieldById(ix)) == null || (text = field.getText("")) == null) continue;
            this.addTextPart(parts, text, lastCP, lastPP, lastTP, false);
        }
        return parts;
    }

    public VsdxCharacter getCharacter(String ix) {
        VsdxCharacter c;
        VsdxCharacter result = new VsdxCharacter();
        result.IX = ix;
        if (this.Character != null) {
            result.applyProperties(this.Character);
        }
        if ((c = this.findCharacterById(ix == null || ix.isEmpty() ? "0" : ix)) != null) {
            result.applyProperties(c, true);
        }
        return result;
    }

    public VsdxParagraph getParagraph(String ix) {
        VsdxParagraph p;
        VsdxParagraph result = new VsdxParagraph();
        result.IX = ix;
        if (this.Paragraph != null) {
            result.applyProperties(this.Paragraph);
        }
        if (!((p = this.findParagraphById(ix)) != null || this.Paragraphs == null || this.Paragraphs.isEmpty() || "0".equals(ix) && this.Paragraph != null)) {
            p = this.Paragraphs.get(0);
        }
        if (p != null) {
            result.applyProperties(p, true);
        }
        return result;
    }

    public List<VsdxConnectionPoint> getConnectionPoints(boolean local, boolean checkAngle, BaseGraphic bg) {
        if (this.connection == null || this.connection.rows == null || this.connection.rows.isEmpty()) {
            return null;
        }
        ArrayList<VsdxConnectionPoint> result = new ArrayList<VsdxConnectionPoint>();
        if (local) {
            int rowCount = this.connection.rows.size();
            for (int i = 0; i < rowCount; ++i) {
                VsdxConnection.VsdxConnectionRow row = this.connection.rows.get(i);
                if (row == null || "1".equals(row.Del)) continue;
                VsdxConnectionPoint cp = new VsdxConnectionPoint(VsdxUtils.convertContactNumber(row.Type), VsdxReader.inchToMM(row.X, this), VsdxReader.inchToMM(row.Y, this));
                result.add(cp);
            }
        } else {
            boolean polyline = bg instanceof Polyline;
            boolean flipX = this.isFlipX();
            boolean flipY = this.isFlipY();
            BaseGraphic.RealPoint shapePin = this.getPin();
            BaseGraphic.RealPoint shapeLocPin = this.getLocPin();
            double deltaX = -shapeLocPin.X;
            double deltaY = shapeLocPin.Y;
            double shiftX = 0.0;
            double shiftY = 0.0;
            if (polyline) {
                deltaX = shapePin.X - shapeLocPin.X;
                deltaY = shapeLocPin.Y - shapePin.Y;
                shiftX = -bg.OrgX;
                shiftY = -bg.OrgY;
            } else if (bg.TransProps != null) {
                shiftX -= bg.TransProps.CenterX;
                shiftY -= bg.TransProps.CenterY;
            }
            double angle = this.getAngle();
            boolean hasAngle = checkAngle && Math.abs(angle) > BaseGraphic.FloatTolerance;
            double cos = 1.0;
            double sin = 0.0;
            if (hasAngle) {
                cos = Math.cos(angle);
                sin = Math.sin(angle);
            }
            if (hasAngle || flipX || flipY) {
                int rowCount = this.connection.rows.size();
                for (int i = 0; i < rowCount; ++i) {
                    VsdxConnection.VsdxConnectionRow row = this.connection.rows.get(i);
                    if (row == null || "1".equals(row.Del)) continue;
                    double pX = this.convertDouble(row.X);
                    double pY = this.convertDouble(row.Y);
                    double dx = flipX ? shapeLocPin.X - pX : pX - shapeLocPin.X;
                    double dy = flipY ? shapeLocPin.Y - pY : pY - shapeLocPin.Y;
                    double x = shapeLocPin.X + dx * cos - dy * sin;
                    double y = shapeLocPin.Y + dx * sin + dy * cos;
                    x = deltaX + x;
                    y = deltaY - y;
                    VsdxConnectionPoint cp = new VsdxConnectionPoint(VsdxUtils.convertContactNumber(row.Type), SchemeUtils.inchToMM(x) + shiftX, SchemeUtils.inchToMM(y) + shiftY);
                    result.add(cp);
                }
            } else {
                int rowCount = this.connection.rows.size();
                for (int i = 0; i < rowCount; ++i) {
                    VsdxConnection.VsdxConnectionRow row = this.connection.rows.get(i);
                    if (row == null || "1".equals(row.Del)) continue;
                    double x = deltaX + this.convertDouble(row.X);
                    double y = deltaY - this.convertDouble(row.Y);
                    VsdxConnectionPoint cp = new VsdxConnectionPoint(VsdxUtils.convertContactNumber(row.Type), SchemeUtils.inchToMM(x) + shiftX, SchemeUtils.inchToMM(y) + shiftY);
                    result.add(cp);
                }
            }
        }
        return result;
    }

    public int getConnectionPointIndexByName(String name) {
        if (this.connection == null || this.connection.rows == null || this.connection.rows.isEmpty()) {
            return -1;
        }
        return this.connection.getRowIndexByName(name);
    }

    public boolean onlyText() {
        String text = this.getText();
        if (text == null || text.replaceAll("\\s+", "").isEmpty()) {
            return false;
        }
        if (this.geometries != null) {
            boolean fillEmpty = this.checkEmptyFill();
            boolean lineEmpty = this.checkEmptyLine();
            for (VsdxGeometry g : this.geometries) {
                if (g.isNoShow()) continue;
                boolean noFill = g.isNoFill();
                boolean noLine = g.isNoLine();
                if (noFill && noLine) continue;
                if (!fillEmpty && !noFill && g.getClosed() != 0) {
                    return false;
                }
                if (lineEmpty || noLine) continue;
                return false;
            }
        }
        return true;
    }

    public static class VsdxConnectionPoint {
        public int ContactNumber;
        public double X;
        public double Y;

        public VsdxConnectionPoint(int n, double x, double y) {
            this.ContactNumber = n;
            this.X = x;
            this.Y = y;
        }
    }

    public static enum ContainerType {
        CONTAINER,
        LIST,
        CALLOUT,
        HEADING;

    }

    public static class VsdxTextInfo {
        public short nodeType;
        public String name;
        public String content;
        public Map<String, String> attributes;
    }

    public static class VsdxTextPart {
        public String text;
        public String cp;
        public String pp;
        public String tp;
        public boolean newLine;
    }
}

