/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxUtils;
import java.util.ArrayList;

public class VsdxTabs {
    public static String POSITION_NAME = "Position";
    public static String ALIGNMENT_NAME = "Alignment";
    public ArrayList<VsdxTab> TabList;

    public VsdxTab findVsdxTabByIndex(String index) {
        if (this.TabList == null || index == null) {
            return null;
        }
        for (VsdxTab tab : this.TabList) {
            if (!index.equals(tab.Index)) continue;
            return tab;
        }
        return null;
    }

    void applyProperties(VsdxTabs props) {
        this.applyProperties(props, false);
    }

    void applyProperties(VsdxTabs props, boolean checkThemed) {
        if (props == null || props.TabList == null || props.TabList.isEmpty()) {
            return;
        }
        if (this.TabList == null) {
            this.TabList = new ArrayList();
        }
        for (VsdxTab propsTab : props.TabList) {
            if (propsTab.Index == null || propsTab.Index.isEmpty()) continue;
            VsdxTab tab = this.findVsdxTabByIndex(propsTab.Index);
            if (tab == null) {
                tab = new VsdxTab();
                tab.Index = propsTab.Index;
                this.TabList.add(tab);
            }
            if (!(propsTab.Position == null || checkThemed && VsdxUtils.isThemed(propsTab.Position))) {
                tab.Position = propsTab.Position;
            }
            if (propsTab.Alignment == null || checkThemed && VsdxUtils.isThemed(propsTab.Alignment)) continue;
            tab.Alignment = propsTab.Alignment;
        }
    }

    public static class VsdxTab {
        public String Index;
        public String Position;
        public String Alignment;
    }
}

