/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx.evaluator;

import inform.agent.schemes.converters.vsdx.evaluator.Token;

public class ExpressionTokenizer {
    private static final byte SKIP = 1;
    private static final byte WORD = 2;
    private static final byte NUMBER = 4;
    private static final byte SYMBOL = 8;
    private final byte[] syntax = new byte[256];
    private final String expression;
    private Token token = null;
    private Token prevToken = null;
    private int position = 0;
    private int count = 0;

    public ExpressionTokenizer(String expression) {
        this.expression = expression;
        this.charTypes(97, 122);
        this.charTypes(65, 90);
        for (int i = 48; i <= 57; ++i) {
            this.syntax[i] = 6;
        }
        this.syntax[34] = (byte)(this.syntax[34] | 2);
        this.syntax[69] = (byte)(this.syntax[69] | 4);
        this.syntax[101] = (byte)(this.syntax[101] | 4);
        this.syntax[46] = 6;
        this.syntax[45] = 12;
        this.syntax[42] = 8;
        this.syntax[47] = 8;
        this.syntax[43] = 8;
        this.syntax[44] = 8;
        this.syntax[40] = 8;
        this.syntax[41] = 8;
        this.syntax[61] = 8;
        this.syntax[32] = 1;
    }

    public Token nextToken() throws Exception {
        this.prevToken = this.token;
        this.position += this.count;
        this.count = 0;
        this.skip();
        return this.token;
    }

    private void skip() throws Exception {
        Token t = this.determineToken();
        while (t == null && this.position < this.expression.length()) {
            ++this.position;
            t = this.determineToken();
        }
        this.token = t == null ? Token.createEofToken() : t;
    }

    private Token determineToken() throws Exception {
        String tokenValue;
        Token.Type tokenType;
        if (this.expression == null || this.position >= this.expression.length()) {
            return Token.createEofToken();
        }
        char symbol = this.expression.charAt(this.position);
        if ((this.syntax[symbol] & 4) != 0 && symbol != 'e' && symbol != 'E') {
            tokenType = Token.Type.Number;
            tokenValue = this.readValue(4);
            if ("-".equals(tokenValue)) {
                tokenType = Token.Type.Subtraction;
            }
            this.count = tokenValue.length();
        } else if ((this.syntax[symbol] & 2) != 0) {
            tokenValue = this.readValue(2);
            this.count = tokenValue.length();
            int nextTokenPos = this.position + this.count;
            tokenType = nextTokenPos < this.expression.length() && this.expression.charAt(nextTokenPos) == '(' ? Token.Type.Function : Token.Type.Variable;
        } else {
            if ((this.syntax[symbol] & 1) != 0) {
                return null;
            }
            tokenValue = this.expression.substring(this.position, this.position + 1);
            this.count = 1;
            tokenType = this.determineSymbolType(tokenValue);
        }
        return new Token(tokenValue, tokenType);
    }

    private Token.Type determineSymbolType(String symbol) throws Exception {
        switch (symbol) {
            case "*": {
                return Token.Type.Multiplication;
            }
            case "/": {
                return Token.Type.Division;
            }
            case "-": {
                return Token.Type.Subtraction;
            }
            case "+": {
                return Token.Type.Addition;
            }
            case "=": {
                return Token.Type.Equality;
            }
            case "(": {
                return Token.Type.OpeningBracket;
            }
            case ")": {
                return Token.Type.ClosingBracket;
            }
            case ",": {
                return Token.Type.Comma;
            }
        }
        throw new Exception("\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0439 \u0441\u0438\u043c\u0432\u043e\u043b: " + symbol);
    }

    private void charTypes(int low, int high) {
        int i = low;
        while (i <= high) {
            int n = i++;
            this.syntax[n] = (byte)(this.syntax[n] | 2);
        }
    }

    private String readValue(int symbolType) {
        int index;
        if (this.expression.charAt(this.position) == '-' && this.prevToken != null && (this.prevToken.type == Token.Type.Variable || this.prevToken.type == Token.Type.Number)) {
            return String.valueOf(this.expression.charAt(this.position));
        }
        for (index = this.position + 1; index < this.expression.length() && (this.syntax[this.expression.charAt(index)] & symbolType) != 0 && (this.expression.charAt(index) != '-' || this.expression.charAt(index - 1) == 'E' || this.expression.charAt(index - 1) == 'e'); ++index) {
        }
        return this.expression.substring(this.position, index);
    }
}

