/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx.themes;

import inform.agent.schemes.converters.vsdx.themes.VsdxColorParser;
import inform.agent.schemes.converters.vsdx.themes.types.simple.Percentage;
import inform.agent.web.utils.Color;
import java.util.HashMap;
import java.util.Map;

public class VsdxColorProperties {
    public String Color;
    public Map<String, String> ColorModifications = new HashMap<String, String>();

    public String mergeColorWithStyles(String color) {
        int[] rgb = inform.agent.web.utils.Color.hexToRgb(color);
        block12: for (Map.Entry<String, String> style : this.ColorModifications.entrySet()) {
            switch (style.getKey()) {
                case "tint": {
                    double val = Double.parseDouble(style.getValue()) / 100000.0 / 2.0;
                    for (int i = 0; i < 3; ++i) {
                        rgb[i] = (int)((double)rgb[i] * val + 255.0 * (1.0 - val));
                    }
                    continue block12;
                }
                case "shade": {
                    double val = Double.parseDouble(style.getValue()) / 100000.0;
                    for (int i = 0; i < 3; ++i) {
                        rgb[i] = (int)((double)rgb[i] * (1.0 + val) / 2.0);
                    }
                    continue block12;
                }
                case "lumMod": {
                    int i;
                    double val = Double.parseDouble(style.getValue()) / 100000.0;
                    double[] hsl = VsdxColorParser.rgbToHsl(rgb);
                    hsl[2] = hsl[2] * val;
                    rgb = VsdxColorParser.hslToRgb(hsl);
                    for (i = 0; i < 3; ++i) {
                        rgb[i] = Math.min(255, rgb[i]);
                    }
                    continue block12;
                }
                case "satMod": {
                    int i;
                    double val = Double.parseDouble(style.getValue()) / 100000.0;
                    double[] hsl = VsdxColorParser.rgbToHsl(rgb);
                    hsl[1] = hsl[1] * val;
                    rgb = VsdxColorParser.hslToRgb(hsl);
                    for (i = 0; i < 3; ++i) {
                        rgb[i] = Math.min(255, rgb[i]);
                    }
                    continue block12;
                }
            }
        }
        return inform.agent.web.utils.Color.rgbToHex(rgb);
    }

    public double getAlpha() {
        for (Map.Entry<String, String> style : this.ColorModifications.entrySet()) {
            if (!"alpha".equals(style.getKey())) continue;
            int val = Integer.parseInt(style.getValue());
            return 1.0 - new Percentage(val).getFraction();
        }
        return 0.0;
    }
}

