/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx.themes;

import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.converters.vsdx.VsdxCharacter;
import inform.agent.schemes.converters.vsdx.VsdxGradientStops;
import inform.agent.schemes.converters.vsdx.VsdxPage;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import inform.agent.schemes.converters.vsdx.themes.VsdxColorParser;
import inform.agent.schemes.converters.vsdx.themes.VsdxColorProperties;
import inform.agent.schemes.converters.vsdx.themes.VsdxShapeStyle;
import inform.agent.schemes.converters.vsdx.themes.VsdxThemeParser;
import inform.agent.schemes.converters.vsdx.themes.types.complex.ColorEffect;
import inform.agent.schemes.converters.vsdx.themes.types.complex.Effect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VsdxTheme {
    private static final VsdxTheme DEFAULT_BASE_THEME = new VsdxTheme();
    public int id;
    public int connectorSchemeId;
    public int effectSchemeId;
    public int colorSchemeId;
    public int fontSchemeId;
    public String backgroundColor;
    public Map<String, String> colorScheme;
    public List<VsdxVariant> variants = new ArrayList<VsdxVariant>();
    public VsdxShapeStyle[] shapeFillStyles;
    public VsdxShapeStyle[] shapeLineStyles;
    public VsdxShapeStyle[] shapeEffectStyles;
    public VsdxShapeStyle[] shapeFontStyles;
    public VsdxShapeStyle[] shapeLineTypes;
    public VsdxShapeStyle[] connectorFillStyles;
    public VsdxShapeStyle[] connectorLineStyles;
    public VsdxShapeStyle[] connectorEffectStyles;
    public VsdxShapeStyle[] connectorFontStyles;
    public VsdxShapeStyle[] connectorLineTypes;

    public static Optional<VsdxTheme> getTheme(VsdxPage page, VsdxShape shape) {
        int colorSchemeId = SchemeUtils.convertInt(SchemeUtils.isShapeInheritingThemeIdx(shape.ColorSchemeIndex) ? page.ColorSchemeIndex : shape.ColorSchemeIndex);
        int connectorSchemeId = SchemeUtils.convertInt(SchemeUtils.isShapeInheritingThemeIdx(shape.ConnectorSchemeIndex) ? page.ConnectorSchemeIndex : shape.ConnectorSchemeIndex);
        int fontSchemeId = SchemeUtils.convertInt(SchemeUtils.isShapeInheritingThemeIdx(shape.FontSchemeIndex) ? page.FontSchemeIndex : shape.FontSchemeIndex);
        int effectSchemeId = SchemeUtils.convertInt(SchemeUtils.isShapeInheritingThemeIdx(shape.EffectSchemeIndex) ? page.EffectSchemeIndex : shape.EffectSchemeIndex);
        int themeId = SchemeUtils.convertInt(SchemeUtils.isShapeInheritingThemeIdx(shape.ThemeIndex) ? page.ThemeIndex : shape.ThemeIndex);
        if (colorSchemeId == 0 && connectorSchemeId == 0 && fontSchemeId == 0 && effectSchemeId == 0 && themeId == 0) {
            return Optional.empty();
        }
        return VsdxTheme.findThemeByIds(page.vsdx.themes, themeId, colorSchemeId, connectorSchemeId, fontSchemeId, effectSchemeId).or(() -> VsdxTheme.constructTheme(page.vsdx.themes, themeId, colorSchemeId, connectorSchemeId, fontSchemeId, effectSchemeId));
    }

    private static Optional<VsdxTheme> findThemeByIds(List<VsdxTheme> themes, int themeId, int colorSchemeId, int connectorSchemeId, int fontSchemeId, int effectSchemeId) {
        return themes.stream().filter(t -> t.colorSchemeId == colorSchemeId && t.id == themeId && t.connectorSchemeId == connectorSchemeId && t.fontSchemeId == fontSchemeId && t.effectSchemeId == effectSchemeId).findAny();
    }

    private static Optional<VsdxTheme> constructTheme(List<VsdxTheme> themes, int themeId, int colorSchemeId, int connectorSchemeId, int fontSchemeId, int effectSchemeId) {
        VsdxTheme baseTheme = DEFAULT_BASE_THEME;
        VsdxTheme connectorTheme = null;
        VsdxTheme fontTheme = null;
        VsdxTheme effectTheme = null;
        VsdxTheme colorTheme = null;
        for (VsdxTheme theme : themes) {
            if (theme.colorSchemeId == colorSchemeId) {
                colorTheme = theme;
            }
            if (theme.id == themeId) {
                baseTheme = theme;
            }
            if (theme.connectorSchemeId == connectorSchemeId) {
                connectorTheme = theme;
            }
            if (theme.fontSchemeId == fontSchemeId) {
                fontTheme = theme;
            }
            if (theme.effectSchemeId != effectSchemeId) continue;
            effectTheme = theme;
        }
        return VsdxTheme.construct(baseTheme, connectorTheme, fontTheme, effectTheme, colorTheme);
    }

    private static Optional<VsdxTheme> construct(VsdxTheme baseTheme, VsdxTheme connectorTheme, VsdxTheme fontTheme, VsdxTheme effectTheme, VsdxTheme colorTheme) {
        if (baseTheme == null || connectorTheme == null || fontTheme == null || effectTheme == null || colorTheme == null) {
            return Optional.empty();
        }
        VsdxTheme constructedTheme = new VsdxTheme();
        constructedTheme.connectorFillStyles = connectorTheme.connectorFillStyles;
        constructedTheme.connectorLineStyles = connectorTheme.connectorLineStyles;
        constructedTheme.connectorLineTypes = connectorTheme.connectorLineTypes;
        constructedTheme.colorScheme = colorTheme.colorScheme;
        constructedTheme.backgroundColor = colorTheme.backgroundColor;
        for (int i = 0; i < 4; ++i) {
            VsdxVariant variant = new VsdxVariant();
            if (i < baseTheme.variants.size()) {
                VsdxVariant baseVariant = baseTheme.variants.get(i);
                variant.variantStyles = baseVariant.variantStyles;
            }
            if (i < colorTheme.variants.size()) {
                VsdxVariant colorVariant = colorTheme.variants.get(i);
                variant.colorSchemeVariations = colorVariant.colorSchemeVariations;
                variant.isMonotone = colorVariant.isMonotone;
            }
            constructedTheme.variants.add(variant);
        }
        constructedTheme.connectorFontStyles = fontTheme.connectorFontStyles;
        constructedTheme.shapeFontStyles = fontTheme.shapeFontStyles;
        constructedTheme.shapeLineStyles = effectTheme.shapeLineStyles;
        constructedTheme.shapeFillStyles = effectTheme.shapeFillStyles;
        constructedTheme.shapeLineTypes = effectTheme.shapeLineTypes;
        constructedTheme.shapeEffectStyles = effectTheme.shapeEffectStyles;
        constructedTheme.connectorEffectStyles = effectTheme.connectorEffectStyles;
        return Optional.of(constructedTheme);
    }

    public void applyStyleToShape(VsdxShape shape, int varColorIndex) {
        String fillColor;
        if (shape == null) {
            return;
        }
        if (shape.shapes != null) {
            for (VsdxShape sh : shape.shapes.shapes) {
                this.applyStyleToShape(sh, varColorIndex);
            }
        }
        int qsVariation = SchemeUtils.convertInt(shape.QuickStyleVariation);
        int qsFillColor = SchemeUtils.convertInt(shape.QuickStyleFillColor);
        int qsLineColor = SchemeUtils.convertInt(shape.QuickStyleLineColor);
        int qsFontColor = SchemeUtils.convertInt(shape.QuickStyleFontColor);
        int qsShadowColor = SchemeUtils.convertInt(shape.QuickStyleShadowColor);
        int qsFillMatrix = SchemeUtils.convertInt(shape.QuickStyleFillMatrix);
        int qsLineMatrix = SchemeUtils.convertInt(shape.QuickStyleLineMatrix);
        int qsFontMatrix = SchemeUtils.convertInt(shape.QuickStyleFontMatrix);
        int qsEffectMatrix = SchemeUtils.convertInt(shape.QuickStyleEffectsMatrix);
        VsdxShapeStyle fillStyle = this.getFillShapeStyle(varColorIndex, qsFillMatrix, qsFillColor, shape.isOneD());
        this.applyFillStyle(shape, fillStyle);
        VsdxShapeStyle lineStyle = this.getLineShapeStyle(varColorIndex, qsLineMatrix, qsLineColor, shape.isOneD());
        this.applyLineStyle(shape, lineStyle);
        VsdxShapeStyle fontStyle = this.getFontShapeStyle(varColorIndex, qsFontMatrix, qsFontColor, shape.isOneD());
        this.applyFontStyle(shape, fontStyle);
        int effectIdx = this.getEffectIdx(varColorIndex, qsEffectMatrix);
        VsdxShapeStyle effectsStyle = shape.isOneD() ? this.connectorEffectStyles[effectIdx % 3] : this.shapeEffectStyles[effectIdx % 6];
        for (ColorEffect colorEffect : effectsStyle.colorEffects) {
            String shadowBaseColor = this.getColorFromMatrix(varColorIndex, qsShadowColor);
            String resultingColor = this.convertLabelToColor(colorEffect.colorLabel(), shadowBaseColor);
            colorEffect.applyToShape(shape, resultingColor);
        }
        for (Effect effect : effectsStyle.effects) {
            effect.applyToShape(shape);
        }
        if (shape.isOneD()) {
            VsdxShapeStyle lineStyleEx = this.getLineExShapeStyle(qsLineMatrix, shape.isConnector());
            this.applyLineStyleEx(shape, lineStyleEx);
        }
        String string = fillColor = "1".equals(fillStyle.FillGradientEnabled) ? fillStyle.gradientStopColors.get(0) : fillStyle.FillForegroundColor;
        if ((qsVariation & 2) == 2) {
            shape.Character.Color = this.evaluateContrastColor(shape.Character.Color, fillColor, lineStyle.LineColor);
            if (shape.Characters != null) {
                for (VsdxCharacter c : shape.Characters) {
                    c.Color = this.evaluateContrastColor(c.Color, fillColor, lineStyle.LineColor);
                }
            }
        }
        if ((qsVariation & 4) == 4) {
            shape.LineColor = this.evaluateContrastColor(shape.LineColor, fillColor);
        }
        if ((qsVariation & 8) == 8) {
            shape.FillForegnd = this.evaluateContrastColor(shape.FillForegnd, lineStyle.LineColor);
        }
    }

    private int getEffectIdx(int variantId, int qsEffectMatrix) {
        if (qsEffectMatrix >= 100 && qsEffectMatrix % 10 < 4) {
            if (variantId >= 0 && variantId < this.variants.size()) {
                VsdxVariant currentVariant = this.variants.get(variantId);
                int id = qsEffectMatrix % 10;
                VsdxVariant.VsdxVariantStyle style = currentVariant != null && currentVariant.variantStyles != null && id < currentVariant.variantStyles.size() ? currentVariant.variantStyles.get(id) : null;
                return style != null ? style.effectIdx : id;
            }
            return qsEffectMatrix % 10;
        }
        return Math.max(qsEffectMatrix % 10 - 1, 0);
    }

    private VsdxShapeStyle getFillShapeStyle(int variantId, int qsFillMatrix, int qsFillColor, boolean isOneDimensional) {
        VsdxShapeStyle fillStyle;
        int fillId;
        String baseColor = this.getColorFromMatrix(variantId, qsFillColor);
        if (qsFillMatrix >= 100 && qsFillMatrix % 10 < 4) {
            VsdxVariant currentVariant = this.variants != null && 0 <= variantId && variantId < this.variants.size() ? this.variants.get(variantId) : null;
            int id = qsFillMatrix % 10;
            VsdxVariant.VsdxVariantStyle style = currentVariant != null && currentVariant.variantStyles != null && id < currentVariant.variantStyles.size() ? currentVariant.variantStyles.get(id) : null;
            fillId = style != null ? style.fillId : qsFillMatrix % 10;
        } else {
            fillId = qsFillMatrix % 10;
            if (fillId > 0) {
                --fillId;
            }
        }
        VsdxShapeStyle vsdxShapeStyle = fillStyle = isOneDimensional ? this.connectorFillStyles[fillId % 3] : this.shapeFillStyles[fillId % 6];
        if (fillStyle.FillForegroundProperties != null) {
            fillStyle.FillForegroundColor = this.convertLabelToColor(fillStyle.FillForegroundProperties.Color, baseColor);
            fillStyle.FillForegroundColor = fillStyle.FillForegroundProperties.mergeColorWithStyles(fillStyle.FillForegroundColor);
        }
        if (fillStyle.FillBackgroundProperties != null) {
            fillStyle.FillBackgroundColor = this.convertLabelToColor(fillStyle.FillBackgroundProperties.Color, baseColor);
            fillStyle.FillBackgroundColor = fillStyle.FillBackgroundProperties.mergeColorWithStyles(fillStyle.FillBackgroundColor);
        }
        if (fillStyle.gradientStopsProperties != null) {
            fillStyle.gradientStopColors = new ArrayList<String>();
            for (VsdxColorProperties gradColor : fillStyle.gradientStopsProperties) {
                String color = this.convertLabelToColor(gradColor.Color, baseColor);
                color = gradColor.mergeColorWithStyles(color);
                fillStyle.gradientStopColors.add(color);
            }
        }
        return fillStyle;
    }

    private VsdxShapeStyle getLineShapeStyle(int variantId, int qsLineMatrix, int qsLineColor, boolean isOneDimensional) {
        int lineId;
        if (qsLineMatrix >= 100) {
            VsdxVariant currentVariant = this.variants != null && 0 <= variantId && variantId < this.variants.size() ? this.variants.get(variantId) : null;
            int id = qsLineMatrix % 10;
            VsdxVariant.VsdxVariantStyle style = currentVariant != null && currentVariant.variantStyles != null && id < currentVariant.variantStyles.size() ? currentVariant.variantStyles.get(id) : null;
            lineId = style != null ? style.lineId : qsLineMatrix % 10;
        } else {
            lineId = qsLineMatrix;
            if (lineId > 0) {
                --lineId;
            }
        }
        VsdxShapeStyle lineStyle = isOneDimensional ? this.connectorLineStyles[lineId % 3] : this.shapeLineStyles[lineId % 6];
        String baseColor = this.getColorFromMatrix(variantId, qsLineColor);
        lineStyle.LineColor = this.convertLabelToColor(lineStyle.LineProperties.Color, baseColor);
        lineStyle.LineColor = lineStyle.LineProperties.mergeColorWithStyles(lineStyle.LineColor);
        return lineStyle;
    }

    private VsdxShapeStyle getFontShapeStyle(int variantId, int qsFontMatrix, int qsFontColor, boolean isOneDimensional) {
        int fontId;
        String baseColor = this.getColorFromMatrix(variantId, qsFontColor);
        if (qsFontMatrix >= 100) {
            VsdxVariant currentVariant = this.variants != null && 0 <= variantId && variantId < this.variants.size() ? this.variants.get(variantId) : null;
            int id = qsFontMatrix % 10;
            VsdxVariant.VsdxVariantStyle style = currentVariant != null && currentVariant.variantStyles != null && id < currentVariant.variantStyles.size() ? currentVariant.variantStyles.get(id) : null;
            fontId = style != null ? style.fontId : qsFontMatrix % 10;
        } else {
            fontId = qsFontMatrix;
            if (fontId > 0) {
                --fontId;
            }
        }
        VsdxShapeStyle fontStyle = isOneDimensional ? this.connectorFontStyles[fontId % 3] : this.shapeFontStyles[fontId % 6];
        fontStyle.FontColor = this.convertLabelToColor(fontStyle.FontProperties.Color, baseColor);
        fontStyle.FontColor = fontStyle.FontProperties.mergeColorWithStyles(fontStyle.FontColor);
        return fontStyle;
    }

    private VsdxShapeStyle getLineExShapeStyle(int qsLineMatrix, boolean isConnector) {
        int exId;
        int n = exId = (qsLineMatrix = Math.max(0, qsLineMatrix)) >= 100 ? 0 : qsLineMatrix;
        if (isConnector) {
            return this.connectorLineTypes[exId % this.connectorLineTypes.length];
        }
        return this.shapeLineTypes[exId % this.shapeLineTypes.length];
    }

    private String getColorFromMatrix(int variantId, int qsColor) {
        if (qsColor > 8) {
            VsdxVariant currentVariant = this.variants != null && 0 <= variantId && variantId < this.variants.size() ? this.variants.get(variantId) : null;
            int n = qsColor = qsColor < 200 && currentVariant != null && currentVariant.isMonotone ? 1 : qsColor % 10 + 1;
            if (currentVariant != null) {
                return currentVariant.colorSchemeVariations.get("varColor" + qsColor);
            }
        }
        assert (qsColor <= 8);
        switch (qsColor) {
            case 0: {
                return this.colorScheme.get("dk1");
            }
            case 1: {
                return this.colorScheme.get("lt1");
            }
            case 8: {
                return this.backgroundColor;
            }
        }
        return this.colorScheme.get("accent" + (qsColor - 1));
    }

    private String convertLabelToColor(String color, String styleColor) {
        if ("phClr".equals(color)) {
            return styleColor;
        }
        for (String type : VsdxThemeParser.COLOR_TYPES) {
            if (!type.equals(color)) continue;
            return this.colorScheme.get(color);
        }
        return color;
    }

    private void applyFontStyle(VsdxShape shape, VsdxShapeStyle fontStyle) {
        if (shape.Character == null) {
            shape.Character = new VsdxCharacter();
        }
        if (VsdxUtils.isThemed(shape.Character.Color)) {
            shape.Character.Color = fontStyle.FontColor;
        }
        if (VsdxUtils.isThemed(shape.Character.Style)) {
            shape.Character.Style = "0";
        }
        if (shape.Characters != null) {
            for (VsdxCharacter c : shape.Characters) {
                if (VsdxUtils.isThemed(c.Color)) {
                    c.Color = fontStyle.FontColor;
                }
                if (!VsdxUtils.isThemed(c.Style)) continue;
                c.Style = "0";
            }
        }
    }

    private void applyLineStyle(VsdxShape shape, VsdxShapeStyle lineStyle) {
        if (VsdxUtils.isThemed(shape.LineColor)) {
            shape.LineColor = lineStyle.LineColor;
        }
        if (lineStyle.LineWeight != null && VsdxUtils.isThemed(shape.LineWeight)) {
            int EMU_IN_ONE_PT = 12700;
            int PTS_IN_INCHES = 72;
            double lineWeight = Double.parseDouble(lineStyle.LineWeight) / 12700.0;
            shape.LineWeight = Double.toString(lineWeight /= 72.0);
        }
        if (lineStyle.LineCap != null && VsdxUtils.isThemed(shape.LineCap)) {
            String capValue = "0";
            switch (lineStyle.LineCap) {
                case "rnd": {
                    capValue = "0";
                    break;
                }
                case "sq": {
                    capValue = "1";
                    break;
                }
                case "flat": {
                    capValue = "2";
                }
            }
            shape.LineCap = capValue;
        }
        if (VsdxUtils.isThemed(shape.LineColorTrans)) {
            shape.LineColorTrans = "0";
        }
    }

    private void applyLineStyleEx(VsdxShape shape, VsdxShapeStyle lineStyle) {
        if (VsdxUtils.isThemed(shape.BeginArrow)) {
            shape.BeginArrow = lineStyle.BeginArrow;
        }
        if (VsdxUtils.isThemed(shape.BeginArrowSize)) {
            shape.BeginArrowSize = lineStyle.BeginArrowSize;
        }
        if (VsdxUtils.isThemed(shape.EndArrow)) {
            shape.EndArrow = lineStyle.EndArrow;
        }
        if (VsdxUtils.isThemed(shape.EndArrowSize)) {
            shape.EndArrowSize = lineStyle.EndArrowSize;
        }
        if (VsdxUtils.isThemed(shape.LinePattern)) {
            shape.LinePattern = lineStyle.LinePattern;
        }
        if (VsdxUtils.isThemed(shape.Rounding)) {
            shape.Rounding = lineStyle.Rounding;
        }
    }

    private void applyFillStyle(VsdxShape shape, VsdxShapeStyle fillStyle) {
        if (VsdxUtils.isThemed(shape.FillGradientEnabled)) {
            shape.FillGradientEnabled = fillStyle.FillGradientEnabled;
        }
        if ("1".equals(shape.FillGradientEnabled) && fillStyle.gradientStopColors != null) {
            VsdxGradientStops.VsdxGradientStopsRow row;
            int i;
            for (i = 0; i < fillStyle.gradientStopColors.size(); ++i) {
                if (i < shape.fillGradient.rows.size()) {
                    row = shape.fillGradient.rows.get(i);
                    if (row == null) continue;
                    if (VsdxUtils.isThemed(row.GradientStopColor)) {
                        row.GradientStopColor = fillStyle.gradientStopColors.get(i);
                    }
                    if (!VsdxUtils.isThemed(row.GradientStopPosition)) continue;
                    row.GradientStopPosition = "0";
                    continue;
                }
                row = new VsdxGradientStops.VsdxGradientStopsRow();
                row.ID = String.valueOf(i);
                row.GradientStopColor = fillStyle.gradientStopColors.get(i);
                row.GradientStopPosition = "0";
                shape.fillGradient.rows.add(row);
            }
            for (i = fillStyle.gradientStopColors.size(); i < shape.fillGradient.rows.size(); ++i) {
                row = shape.fillGradient.rows.get(i);
                if (!VsdxUtils.isThemed(row.GradientStopColor)) continue;
                row.Del = "1";
            }
        }
        if (VsdxUtils.isThemed(shape.FillPattern)) {
            shape.FillPattern = fillStyle.FillPattern;
        }
        if (VsdxUtils.isThemed(shape.FillForegnd)) {
            shape.FillForegnd = fillStyle.FillForegroundColor;
        }
        if (VsdxUtils.isThemed(shape.FillForegndTrans)) {
            shape.FillForegndTrans = "0";
        }
        if (VsdxUtils.isThemed(shape.FillBkgnd)) {
            shape.FillBkgnd = fillStyle.FillBackgroundColor;
        }
        if (VsdxUtils.isThemed(shape.FillGradientDir)) {
            shape.FillGradientDir = fillStyle.FillGradientDir;
        }
        if (VsdxUtils.isThemed(shape.FillGradientAngle)) {
            shape.FillGradientAngle = fillStyle.FillGradientAngle;
        }
    }

    private String evaluateContrastColor(String baseColor, String ... colors) {
        double lumCurrentColor;
        if (!VsdxColorParser.isHex(this.backgroundColor) || !VsdxColorParser.isHex(baseColor)) {
            return baseColor;
        }
        double ABSOLUTE_DIFFERENCE_IN_LUMINANCE = 0.1666;
        double BACKGROUND_MINIMAL_LUMINANCE = 0.7292;
        double lumBackground = VsdxColorParser.hexToHsl(this.backgroundColor)[2];
        if (Math.abs(lumBackground - (lumCurrentColor = VsdxColorParser.hexToHsl(baseColor)[2])) <= 0.1666) {
            if (lumBackground <= 0.7292) {
                return "#FFFFFF";
            }
            double maxDiff = -1.0;
            String maxDiffColor = "";
            for (String color : colors) {
                double lumColor;
                double absDiff;
                if (!VsdxColorParser.isHex(color) || !((absDiff = Math.abs((lumColor = VsdxColorParser.hexToHsl(color)[2]) - lumBackground)) > maxDiff)) continue;
                maxDiff = absDiff;
                maxDiffColor = color;
            }
            return maxDiff == -1.0 ? baseColor : maxDiffColor;
        }
        return baseColor;
    }

    static {
        for (int varaintIdx = 0; varaintIdx < 4; ++varaintIdx) {
            VsdxVariant variant = new VsdxVariant();
            int variantStyleIdx = 0;
            while (variantStyleIdx < 4) {
                VsdxVariant.VsdxVariantStyle variantStyle = new VsdxVariant.VsdxVariantStyle();
                variantStyle.effectIdx = variantStyleIdx;
                variantStyle.fillId = variantStyleIdx;
                variantStyle.fontId = variantStyleIdx;
                variantStyle.lineId = variantStyleIdx++;
                variant.variantStyles.add(variantStyle);
            }
            VsdxTheme.DEFAULT_BASE_THEME.variants.add(variant);
        }
    }

    public static class VsdxVariant {
        public Map<String, String> colorSchemeVariations;
        public boolean isMonotone = false;
        public List<VsdxVariantStyle> variantStyles = new ArrayList<VsdxVariantStyle>();

        public static class VsdxVariantStyle {
            public int fillId;
            public int lineId;
            public int fontId;
            public int effectIdx;
        }
    }
}

