/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx.themes;

import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.themes.VsdxColorProperties;
import inform.agent.schemes.converters.vsdx.themes.VsdxShapeStyle;
import inform.agent.schemes.converters.vsdx.themes.VsdxTheme;
import inform.agent.schemes.converters.vsdx.themes.types.complex.Effect;
import inform.agent.schemes.converters.vsdx.themes.types.complex.InnerShadowEffect;
import inform.agent.schemes.converters.vsdx.themes.types.complex.OuterShadowEffect;
import inform.agent.schemes.converters.vsdx.themes.types.complex.ReflectionEffect;
import inform.agent.schemes.converters.vsdx.themes.types.complex.UnimplementedEffect;
import inform.agent.schemes.converters.vsdx.themes.types.simple.FixedAngle;
import inform.agent.schemes.converters.vsdx.themes.types.simple.Percentage;
import inform.agent.schemes.converters.vsdx.themes.types.simple.PositiveCoordinate;
import inform.agent.schemes.converters.vsdx.themes.types.simple.PositiveFixedAngle;
import inform.agent.schemes.converters.vsdx.themes.types.simple.PositiveFixedPercentage;
import inform.agent.schemes.converters.vsdx.themes.types.simple.RectAlignment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VsdxThemeParser {
    public static final String[] COLOR_TYPES = new String[]{"dk1", "lt1", "dk2", "lt2", "accent1", "accent2", "accent2", "accent3", "accent4", "accent5", "accent6", "hlink", "folHlink"};
    private int themeIndex;
    private int connectorSchemeIndex;
    private int effectSchemeIndex;
    private int colorSchemeIndex;
    private int fontSchemeIndex;
    private Map<String, String> colorScheme;
    private String backgroundColor;
    private List<Map<String, String>> colorSchemeVariations;
    private final VsdxShapeStyle[] shapeFillStyles = new VsdxShapeStyle[6];
    private final VsdxShapeStyle[] shapeLineStyles = new VsdxShapeStyle[6];
    private final VsdxShapeStyle[] shapeEffectStyles = new VsdxShapeStyle[6];
    private final VsdxShapeStyle[] shapeFontStyles = new VsdxShapeStyle[6];
    private final VsdxShapeStyle[] shapeLineStylesEx = new VsdxShapeStyle[7];
    private final VsdxShapeStyle[] shapeConnectorFillStyles = new VsdxShapeStyle[3];
    private final VsdxShapeStyle[] shapeConnectorLineStyles = new VsdxShapeStyle[3];
    private VsdxShapeStyle[] shapeConnectorEffectStyles = new VsdxShapeStyle[3];
    private final VsdxShapeStyle[] shapeConnectorFontStyles = new VsdxShapeStyle[3];
    private final VsdxShapeStyle[] shapeConnectorLineStylesEx = new VsdxShapeStyle[4];
    private List<List<Map<String, String>>> variationStyleSchemes;

    private static Optional<Element> getFirstChildElement(Element parent) {
        Iterator<Element> it = new IterableElementList(parent.getChildNodes()).iterator();
        return it.hasNext() ? Optional.ofNullable(it.next()) : Optional.empty();
    }

    private static Optional<Element> getLastChildElement(Element parent) {
        NodeList children = parent.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            if (children.item(i).getNodeType() != 1) continue;
            return Optional.of((Element)children.item(i));
        }
        return Optional.empty();
    }

    public VsdxThemeParser(Document themeContent) {
        this.parseTheme(themeContent.getDocumentElement());
    }

    public VsdxTheme getTheme() {
        VsdxTheme theme = new VsdxTheme();
        theme.id = this.themeIndex;
        theme.colorSchemeId = this.colorSchemeIndex;
        theme.fontSchemeId = this.fontSchemeIndex;
        theme.effectSchemeId = this.effectSchemeIndex;
        theme.connectorSchemeId = this.connectorSchemeIndex;
        theme.backgroundColor = this.backgroundColor;
        theme.colorScheme = this.colorScheme;
        theme.shapeFillStyles = this.shapeFillStyles;
        theme.shapeLineStyles = this.shapeLineStyles;
        theme.shapeEffectStyles = this.shapeEffectStyles;
        theme.shapeFontStyles = this.shapeFontStyles;
        theme.connectorFillStyles = this.shapeConnectorFillStyles;
        theme.connectorFontStyles = this.shapeConnectorFontStyles;
        theme.connectorEffectStyles = this.shapeConnectorEffectStyles;
        theme.connectorLineStyles = this.shapeConnectorLineStyles;
        theme.shapeLineTypes = this.shapeLineStylesEx;
        theme.connectorLineTypes = this.shapeConnectorLineStylesEx;
        if (this.colorSchemeVariations != null) {
            for (int variantIndex = 0; variantIndex < this.colorSchemeVariations.size(); ++variantIndex) {
                theme.variants.add(this.getThemeVariant(variantIndex));
            }
        }
        return theme;
    }

    private VsdxTheme.VsdxVariant getThemeVariant(int variantIndex) {
        VsdxTheme.VsdxVariant variant = new VsdxTheme.VsdxVariant();
        variant.colorSchemeVariations = this.colorSchemeVariations.get(variantIndex);
        if (variant.colorSchemeVariations.get("monotone") != null) {
            variant.isMonotone = "1".equals(variant.colorSchemeVariations.get("monotone"));
            variant.colorSchemeVariations.remove("monotone");
        }
        if (this.variationStyleSchemes != null) {
            for (int variantStyleIndex = 0; variantStyleIndex < this.variationStyleSchemes.size(); ++variantStyleIndex) {
                variant.variantStyles.add(this.getThemeVariantStyle(variantIndex, variantStyleIndex));
            }
        }
        return variant;
    }

    private VsdxTheme.VsdxVariant.VsdxVariantStyle getThemeVariantStyle(int variantIndex, int variantStyleIndex) {
        VsdxTheme.VsdxVariant.VsdxVariantStyle variantStyle = new VsdxTheme.VsdxVariant.VsdxVariantStyle();
        Map<String, String> idxes = this.variationStyleSchemes.get(variantIndex).get(variantStyleIndex);
        variantStyle.fillId = Integer.parseInt(idxes.get("fillIdx")) - 1;
        variantStyle.lineId = Integer.parseInt(idxes.get("lineIdx")) - 1;
        variantStyle.fontId = Integer.parseInt(idxes.get("fontIdx")) - 1;
        variantStyle.effectIdx = Integer.parseInt(idxes.get("effectIdx")) - 1;
        return variantStyle;
    }

    private void parseTheme(Element theme) {
        Element themeElements = VsdxThemeParser.getFirstChildElement(theme).orElseThrow();
        for (Element section : new IterableElementList(themeElements.getChildNodes())) {
            switch (section.getLocalName()) {
                case "clrScheme": {
                    this.parseClrSchemeSection(section);
                    break;
                }
                case "fontScheme": {
                    this.parseFontSchemeSection(section);
                    break;
                }
                case "fmtScheme": {
                    this.parseFmtSchemeSection(section);
                    break;
                }
                case "extLst": {
                    this.parseExtLstSection(section);
                }
            }
        }
    }

    private void parseClrSchemeSection(Element clrSchemeSection) {
        this.colorScheme = new HashMap<String, String>();
        for (String colorType : COLOR_TYPES) {
            List<Element> rgbColor;
            List<Element> colorTypeElement = VsdxParser.getElementsByLocalName(clrSchemeSection, colorType);
            if (colorTypeElement == null || colorTypeElement.isEmpty() || (rgbColor = VsdxParser.getElementsByLocalName(colorTypeElement.get(0), "srgbClr")) == null || rgbColor.isEmpty()) continue;
            String colorHex = "#" + rgbColor.get(0).getAttribute("val");
            this.colorScheme.put(colorType, colorHex);
        }
        List<Element> extensionList = VsdxParser.getElementsByLocalName(clrSchemeSection, "extLst");
        if (extensionList == null || extensionList.isEmpty()) {
            return;
        }
        for (Element extension : new IterableElementList(extensionList.get(0).getChildNodes())) {
            Element colorExtension = VsdxThemeParser.getFirstChildElement(extension).orElseThrow();
            switch (colorExtension.getLocalName()) {
                case "schemeID": {
                    this.colorSchemeIndex = Integer.parseInt(colorExtension.getAttribute("schemeEnum"));
                    break;
                }
                case "bkgnd": {
                    Element srgbColor = VsdxThemeParser.getFirstChildElement(colorExtension).orElseThrow();
                    this.backgroundColor = "#" + srgbColor.getAttribute("val");
                    break;
                }
                case "variationClrSchemeLst": {
                    this.colorSchemeVariations = new ArrayList<Map<String, String>>();
                    for (Element variationColorScheme : new IterableElementList(colorExtension.getChildNodes())) {
                        String monotone = variationColorScheme.getAttribute("monotone");
                        HashMap<String, String> colorScheme = new HashMap<String, String>();
                        colorScheme.put("monotone", monotone);
                        for (Element variationColor : new IterableElementList(variationColorScheme.getChildNodes())) {
                            Element srgbColor = VsdxThemeParser.getFirstChildElement(variationColor).orElseThrow();
                            String color = srgbColor.getAttribute("val");
                            colorScheme.put(variationColor.getLocalName(), color);
                        }
                        this.colorSchemeVariations.add(colorScheme);
                    }
                    break;
                }
            }
        }
    }

    private void parseFontSchemeSection(Element fontSchemeSection) {
        List<Element> extensionList = VsdxParser.getElementsByLocalName(fontSchemeSection, "extLst");
        if (extensionList == null || extensionList.isEmpty()) {
            return;
        }
        List<Element> extension = VsdxParser.getElementsByLocalName(extensionList.get(0), "ext");
        if (extension == null || extension.isEmpty()) {
            return;
        }
        List<Element> schemeId = VsdxParser.getElementsByLocalName(extension.get(0), "schemeID");
        if (schemeId == null || schemeId.isEmpty()) {
            return;
        }
        String id = schemeId.get(0).getAttribute("schemeEnum");
        if (id.isEmpty()) {
            return;
        }
        this.fontSchemeIndex = Integer.parseInt(id);
    }

    private Map<String, String> parseFont(Element fontSection, String fontType) {
        HashMap<String, String> fontsCollection = new HashMap<String, String>();
        List<Element> fontsList = VsdxParser.getElementsByLocalName(fontSection, fontType);
        if (fontsList == null || fontsList.isEmpty()) {
            return fontsCollection;
        }
        for (Element font : new IterableElementList(fontsList.get(0).getChildNodes())) {
            if (font.getLocalName().equals("font")) {
                fontsCollection.put(font.getAttribute("script"), font.getAttribute("typeface"));
                continue;
            }
            fontsCollection.put(font.getLocalName(), font.getAttribute("typeface"));
        }
        return fontsCollection;
    }

    private void parseFmtSchemeSection(Element fmtSchemeSection) {
        block12: for (Element fillStyle : new IterableElementList(fmtSchemeSection.getChildNodes())) {
            switch (fillStyle.getLocalName()) {
                case "fillStyleLst": {
                    int idx = 0;
                    for (Element fill : new IterableElementList(fillStyle.getChildNodes())) {
                        this.shapeFillStyles[idx++] = this.parseFill(fill);
                    }
                    continue block12;
                }
                case "bgFillStyleLst": {
                    break;
                }
                case "lnStyleLst": {
                    int idx = 0;
                    for (Element ln : new IterableElementList(fillStyle.getChildNodes())) {
                        this.shapeLineStyles[idx++] = this.parseLineFill(ln);
                    }
                    continue block12;
                }
                case "effectStyleLst": {
                    int idx = 0;
                    for (Element effectStyle : new IterableElementList(fillStyle.getChildNodes())) {
                        this.shapeEffectStyles[idx++] = this.parseEffectStyle(effectStyle);
                    }
                    continue block12;
                }
            }
        }
    }

    private VsdxShapeStyle parseLineFill(Element coloringProperties) {
        Optional<Element> lineColorPropertiesResult = VsdxThemeParser.getFirstChildElement(coloringProperties);
        if (lineColorPropertiesResult.isPresent()) {
            VsdxShapeStyle shapeStyle = this.parseFill(lineColorPropertiesResult.get());
            shapeStyle.LineCap = coloringProperties.getAttribute("cap");
            shapeStyle.LineCompoundType = coloringProperties.getAttribute("cmpd");
            shapeStyle.LineWeight = coloringProperties.getAttribute("w");
            shapeStyle.LineProperties = shapeStyle.FillForegroundProperties == null ? shapeStyle.gradientStopsProperties.get(0) : shapeStyle.FillForegroundProperties;
            shapeStyle.FillForegroundProperties = null;
            shapeStyle.gradientStopsProperties = null;
            return shapeStyle;
        }
        return null;
    }

    private VsdxShapeStyle parseFill(Element coloringProperties) {
        VsdxShapeStyle shapeStyle = new VsdxShapeStyle();
        switch (coloringProperties.getLocalName()) {
            case "solidFill": {
                Element clr = VsdxThemeParser.getFirstChildElement(coloringProperties).orElseThrow();
                shapeStyle.FillForegroundProperties = this.parseColorWithStyles(clr);
                shapeStyle.FillGradientEnabled = "0";
                break;
            }
            case "gradFill": {
                Element gradProperties = VsdxThemeParser.getLastChildElement(coloringProperties).orElseThrow();
                String rotateWithShape = coloringProperties.getAttribute("rotWithShape");
                String gradAngle = gradProperties.getAttribute("ang");
                Element gsLst = VsdxThemeParser.getFirstChildElement(coloringProperties).orElseThrow();
                ArrayList<VsdxColorProperties> gradStopColors = new ArrayList<VsdxColorProperties>();
                for (Element gradientStop : new IterableElementList(gsLst.getChildNodes())) {
                    Element clr = VsdxThemeParser.getFirstChildElement(gradientStop).orElseThrow();
                    gradStopColors.add(this.parseColorWithStyles(clr));
                }
                shapeStyle.gradientStopsProperties = gradStopColors;
                String gradType = gradProperties.getLocalName();
                if ("lin".equals(gradType)) {
                    shapeStyle.FillGradientDir = "0";
                    double angle = Double.parseDouble(gradAngle) / 60000.0;
                    shapeStyle.FillGradientAngle = Double.toString(Math.PI * angle / 180.0);
                } else {
                    shapeStyle.FillGradientDir = "8";
                    shapeStyle.FillGradientAngle = "0";
                }
                shapeStyle.FillGradientEnabled = "1";
                break;
            }
            case "pattFill": {
                Element fgColor = (Element)VsdxParser.getElementsByLocalName(coloringProperties, "fgClr").get(0).getFirstChild();
                Element bgColor = (Element)VsdxParser.getElementsByLocalName(coloringProperties, "bgClr").get(0).getFirstChild();
                shapeStyle.FillForegroundProperties = this.parseColorWithStyles(fgColor);
                shapeStyle.FillBackgroundProperties = this.parseColorWithStyles(bgColor);
                shapeStyle.FillGradientEnabled = "0";
                break;
            }
        }
        return shapeStyle;
    }

    private VsdxShapeStyle parseEffectStyle(Element effectStyle) {
        return VsdxThemeParser.getFirstChildElement(effectStyle).map(this::parseEffectLst).orElse(null);
    }

    private VsdxShapeStyle parseEffectLst(Element effectLst) {
        VsdxShapeStyle style = new VsdxShapeStyle();
        for (Element effect : new IterableElementList(effectLst.getChildNodes())) {
            this.parseEffect(style, effect);
        }
        return style;
    }

    private void parseEffect(VsdxShapeStyle style, Element effect) {
        switch (effect.getLocalName()) {
            case "reflection": {
                style.effects.add(this.parseReflection(effect));
                break;
            }
            case "outerShdw": {
                style.colorEffects.add(this.parseOuterShdw(effect));
                break;
            }
            case "innerShdw": {
                style.colorEffects.add(this.parseInnerShdw(effect));
                break;
            }
            default: {
                style.effects.add(new UnimplementedEffect(effect.getLocalName()));
            }
        }
    }

    private Optional<RectAlignment> parseRectAlignment(Element element, String attributeName) {
        if (!element.hasAttribute(attributeName)) {
            return Optional.empty();
        }
        return Optional.of(RectAlignment.parseRectAlignment(element.getAttribute(attributeName)));
    }

    private Optional<PositiveCoordinate> parsePositiveCoordinate(Element element, String attributeName) {
        if (!element.hasAttribute(attributeName)) {
            return Optional.empty();
        }
        long value = Long.parseLong(element.getAttribute(attributeName));
        return Optional.of(new PositiveCoordinate(value));
    }

    private Optional<PositiveFixedAngle> parsePositiveFixedAngle(Element element, String attributeName) {
        if (!element.hasAttribute(attributeName)) {
            return Optional.empty();
        }
        int value = Integer.parseInt(element.getAttribute(attributeName));
        return Optional.of(new PositiveFixedAngle(value));
    }

    private Optional<FixedAngle> parseFixedAngle(Element element, String attributeName) {
        if (!element.hasAttribute(attributeName)) {
            return Optional.empty();
        }
        int value = Integer.parseUnsignedInt(element.getAttribute(attributeName));
        return Optional.of(new FixedAngle(value));
    }

    private Optional<Boolean> parseBool(Element element, String attributeName) {
        if (!element.hasAttribute(attributeName)) {
            return Optional.empty();
        }
        boolean value = element.getAttribute(attributeName).equals("1");
        return Optional.of(value);
    }

    private Optional<Percentage> parsePercentage(Element element, String attributeName) {
        if (!element.hasAttribute(attributeName)) {
            return Optional.empty();
        }
        int value = Integer.parseInt(element.getAttribute(attributeName));
        return Optional.of(new Percentage(value));
    }

    private Optional<PositiveFixedPercentage> parsePositiveFixedPercentage(Element element, String attributeName) {
        if (!element.hasAttribute(attributeName)) {
            return Optional.empty();
        }
        int value = Integer.parseUnsignedInt(element.getAttribute(attributeName));
        return Optional.of(new PositiveFixedPercentage(value));
    }

    private Effect parseReflection(Element reflection) {
        RectAlignment reflectionAlignment = this.parseRectAlignment(reflection, "algn").orElse(RectAlignment.BOTTOM);
        PositiveCoordinate blurRadius = this.parsePositiveCoordinate(reflection, "blurRad").orElse(PositiveCoordinate.ZERO_LENGTH);
        PositiveFixedAngle direction = this.parsePositiveFixedAngle(reflection, "dir").orElse(PositiveFixedAngle.ZERO_ANGLE);
        PositiveCoordinate distance = this.parsePositiveCoordinate(reflection, "dist").orElse(PositiveCoordinate.ZERO_LENGTH);
        PositiveFixedAngle fadeDirection = this.parsePositiveFixedAngle(reflection, "fadeDir").orElse(PositiveFixedAngle.ZERO_ANGLE);
        PositiveFixedPercentage startOpacity = this.parsePositiveFixedPercentage(reflection, "stA").orElse(PositiveFixedPercentage.ONE_HUNDRED_PERCENT);
        PositiveFixedPercentage startPosition = this.parsePositiveFixedPercentage(reflection, "stPos").orElse(PositiveFixedPercentage.ZERO_PERCENT);
        PositiveFixedPercentage endOpacity = this.parsePositiveFixedPercentage(reflection, "endA").orElse(PositiveFixedPercentage.ZERO_PERCENT);
        PositiveFixedPercentage endPosition = this.parsePositiveFixedPercentage(reflection, "endPos").orElse(PositiveFixedPercentage.ONE_HUNDRED_PERCENT);
        boolean rotateWithShape = this.parseBool(reflection, "rotWithShape").orElse(true);
        FixedAngle horizontalSkew = this.parseFixedAngle(reflection, "kx").orElse(FixedAngle.ZERO_ANGLE);
        FixedAngle verticalSkew = this.parseFixedAngle(reflection, "ky").orElse(FixedAngle.ZERO_ANGLE);
        Percentage horizontalRatio = this.parsePercentage(reflection, "sx").orElse(Percentage.ONE_HUNDRED_PERCENT);
        Percentage verticalRatio = this.parsePercentage(reflection, "sy").orElse(Percentage.ONE_HUNDRED_PERCENT);
        return new ReflectionEffect(reflectionAlignment, blurRadius, direction, distance, fadeDirection, startOpacity, startPosition, endOpacity, endPosition, rotateWithShape, horizontalSkew, verticalSkew, horizontalRatio, verticalRatio);
    }

    private OuterShadowEffect parseOuterShdw(Element outerShdw) {
        RectAlignment shadowAlignment = this.parseRectAlignment(outerShdw, "algn").orElse(RectAlignment.BOTTOM);
        PositiveCoordinate blurRadius = this.parsePositiveCoordinate(outerShdw, "blurRad").orElse(PositiveCoordinate.ZERO_LENGTH);
        PositiveFixedAngle shadowDirection = this.parsePositiveFixedAngle(outerShdw, "dir").orElse(PositiveFixedAngle.ZERO_ANGLE);
        PositiveCoordinate shadowOffsetDistance = this.parsePositiveCoordinate(outerShdw, "dist").orElse(PositiveCoordinate.ZERO_LENGTH);
        FixedAngle horizontalSkew = this.parseFixedAngle(outerShdw, "kx").orElse(FixedAngle.ZERO_ANGLE);
        FixedAngle verticalSkew = this.parseFixedAngle(outerShdw, "ky").orElse(FixedAngle.ZERO_ANGLE);
        boolean rotateWithShape = this.parseBool(outerShdw, "rotWithShape").orElse(true);
        Percentage horizontalScalingFactor = this.parsePercentage(outerShdw, "sx").orElse(Percentage.ONE_HUNDRED_PERCENT);
        Percentage verticalScalingFactor = this.parsePercentage(outerShdw, "sy").orElse(Percentage.ONE_HUNDRED_PERCENT);
        VsdxColorProperties colorProps = this.parseColorWithStyles((Element)outerShdw.getFirstChild());
        return new OuterShadowEffect(shadowAlignment, shadowDirection, shadowOffsetDistance, horizontalSkew, verticalSkew, horizontalScalingFactor, verticalScalingFactor, blurRadius, rotateWithShape, colorProps);
    }

    private InnerShadowEffect parseInnerShdw(Element innerShdw) {
        PositiveCoordinate blurRadius = this.parsePositiveCoordinate(innerShdw, "blurRad").orElse(PositiveCoordinate.ZERO_LENGTH);
        PositiveFixedAngle shadowDirection = this.parsePositiveFixedAngle(innerShdw, "dir").orElse(PositiveFixedAngle.ZERO_ANGLE);
        PositiveCoordinate shadowOffsetDistance = this.parsePositiveCoordinate(innerShdw, "dist").orElse(PositiveCoordinate.ZERO_LENGTH);
        VsdxColorProperties colorProps = this.parseColorWithStyles((Element)innerShdw.getFirstChild());
        return new InnerShadowEffect(shadowDirection, shadowOffsetDistance, blurRadius, colorProps);
    }

    private VsdxColorProperties parseColorWithStyles(Element clr) {
        VsdxColorProperties vsdxColorProperties = new VsdxColorProperties();
        vsdxColorProperties.Color = clr.getAttribute("val");
        for (Element clrStyle : new IterableElementList(clr.getChildNodes())) {
            vsdxColorProperties.ColorModifications.put(clrStyle.getLocalName(), clrStyle.getAttribute("val"));
        }
        return vsdxColorProperties;
    }

    private void parseExtLstSection(Element extLstSection) {
        for (Element ext : new IterableElementList(extLstSection.getChildNodes())) {
            this.parseExtension(VsdxThemeParser.getFirstChildElement(ext).orElseThrow());
        }
    }

    private void parseExtension(Element ext) {
        switch (ext.getLocalName()) {
            case "fmtConnectorScheme": {
                this.parseFmtConnectorScheme(ext);
                break;
            }
            case "themeScheme": {
                String id = VsdxThemeParser.getFirstChildElement(ext).orElseThrow().getAttribute("schemeEnum");
                this.themeIndex = Integer.parseInt(id);
                break;
            }
            case "fmtSchemeEx": {
                String id = VsdxThemeParser.getFirstChildElement(ext).orElseThrow().getAttribute("schemeEnum");
                this.effectSchemeIndex = Integer.parseInt(id);
                break;
            }
            case "fmtConnectorSchemeEx": {
                String id = VsdxThemeParser.getFirstChildElement(ext).orElseThrow().getAttribute("schemeEnum");
                this.connectorSchemeIndex = Integer.parseInt(id);
                break;
            }
            case "fillStyles": {
                int idx = 0;
                for (Element fillProp : new IterableElementList(ext.getChildNodes())) {
                    this.shapeFillStyles[idx++].FillPattern = fillProp.getAttribute("pattern");
                }
                break;
            }
            case "lineStyles": {
                this.parseLineStyles(ext);
                break;
            }
            case "fontStylesGroup": {
                this.parseFontStylesGroup(ext);
                break;
            }
            case "variationStyleSchemeLst": {
                this.parseVariationStyleSchemeLst(ext);
            }
        }
    }

    private void parseFmtConnectorScheme(Element fmtConnectorScheme) {
        block11: for (Element styleList : new IterableElementList(fmtConnectorScheme.getChildNodes())) {
            switch (styleList.getLocalName()) {
                case "fillStyleLst": {
                    int idx = 0;
                    for (Element lineProp : new IterableElementList(styleList.getChildNodes())) {
                        this.shapeConnectorFillStyles[idx++] = this.parseFill(lineProp);
                    }
                    continue block11;
                }
                case "lnStyleLst": {
                    int idx = 0;
                    for (Element lineProp : new IterableElementList(styleList.getChildNodes())) {
                        this.shapeConnectorLineStyles[idx++] = this.parseLineFill(lineProp);
                    }
                    continue block11;
                }
                case "effectStyleLst": {
                    this.shapeConnectorEffectStyles = (VsdxShapeStyle[])StreamSupport.stream(new IterableElementList(styleList.getChildNodes()).spliterator(), false).map(this::parseEffectStyle).toArray(VsdxShapeStyle[]::new);
                    break;
                }
            }
        }
    }

    private void parseVariationStyleSchemeLst(Element variationStyleSchemeLst) {
        this.variationStyleSchemes = new ArrayList<List<Map<String, String>>>();
        for (Element variation : new IterableElementList(variationStyleSchemeLst.getChildNodes())) {
            ArrayList varStyle = new ArrayList();
            for (Element variationStyle : new IterableElementList(variation.getChildNodes())) {
                HashMap<String, String> variationStyleFormats = new HashMap<String, String>();
                variationStyleFormats.put("fillIdx", variationStyle.getAttribute("fillIdx"));
                variationStyleFormats.put("lineIdx", variationStyle.getAttribute("lineIdx"));
                variationStyleFormats.put("effectIdx", variationStyle.getAttribute("effectIdx"));
                variationStyleFormats.put("fontIdx", variationStyle.getAttribute("fontIdx"));
                varStyle.add(variationStyleFormats);
            }
            this.variationStyleSchemes.add(varStyle);
        }
    }

    private void parseFontStylesGroup(Element fontStylesGroup) {
        block8: for (Element fontStyle : new IterableElementList(fontStylesGroup.getChildNodes())) {
            switch (fontStyle.getLocalName()) {
                case "connectorFontStyles": {
                    int idx = 0;
                    for (Element connectorFontProp : new IterableElementList(fontStyle.getChildNodes())) {
                        this.shapeConnectorFontStyles[idx++] = this.parseFontStyles(connectorFontProp);
                    }
                    continue block8;
                }
                case "fontStyles": {
                    int idx = 0;
                    for (Element connectorFontProp : new IterableElementList(fontStyle.getChildNodes())) {
                        this.shapeFontStyles[idx++] = this.parseFontStyles(connectorFontProp);
                    }
                    continue block8;
                }
            }
        }
    }

    private void parseLineStyles(Element lineStyles) {
        block8: for (Element schemeLineStyle : new IterableElementList(lineStyles.getChildNodes())) {
            switch (schemeLineStyle.getLocalName()) {
                case "fmtConnectorSchemeLineStyles": {
                    int idx = 0;
                    for (Element lineStyle : new IterableElementList(schemeLineStyle.getChildNodes())) {
                        this.shapeConnectorLineStylesEx[idx++] = this.parseLineStyleEx(lineStyle);
                    }
                    continue block8;
                }
                case "fmtSchemeLineStyles": {
                    int idx = 0;
                    for (Element lineStyle : new IterableElementList(schemeLineStyle.getChildNodes())) {
                        this.shapeLineStylesEx[idx++] = this.parseLineStyleEx(lineStyle);
                    }
                    continue block8;
                }
            }
        }
    }

    private VsdxShapeStyle parseLineStyleEx(Element lineStyle) {
        VsdxShapeStyle shapeStyle = new VsdxShapeStyle();
        Element lineEx = VsdxThemeParser.getFirstChildElement(lineStyle).orElseThrow();
        shapeStyle.Rounding = lineEx.getAttribute("rndg");
        shapeStyle.BeginArrow = lineEx.getAttribute("start");
        shapeStyle.BeginArrowSize = lineEx.getAttribute("startSize");
        shapeStyle.EndArrow = lineEx.getAttribute("end");
        shapeStyle.EndArrowSize = lineEx.getAttribute("endSize");
        shapeStyle.LinePattern = lineEx.getAttribute("pattern");
        return shapeStyle;
    }

    private VsdxShapeStyle parseFontStyles(Element fontProp) {
        VsdxShapeStyle fontStyle = new VsdxShapeStyle();
        Element color = VsdxThemeParser.getFirstChildElement(fontProp).orElseThrow();
        Element schemeColor = VsdxThemeParser.getFirstChildElement(color).orElseThrow();
        fontStyle.FontProperties = this.parseColorWithStyles(schemeColor);
        return fontStyle;
    }

    private static class IterableElementList
    implements Iterable<Element> {
        private final NodeList items;

        IterableElementList(NodeList items) {
            this.items = items;
        }

        @Override
        public Iterator<Element> iterator() {
            return new ElementIterator(this.items);
        }

        private static class ElementIterator
        implements Iterator<Element> {
            private int currentIndex = 0;
            private final NodeList items;

            ElementIterator(NodeList items) {
                this.items = items;
            }

            @Override
            public boolean hasNext() {
                int len = this.items.getLength();
                while (this.currentIndex < len) {
                    if (this.items.item(this.currentIndex).getNodeType() == 1) {
                        return true;
                    }
                    ++this.currentIndex;
                }
                return false;
            }

            @Override
            public Element next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (Element)this.items.item(this.currentIndex++);
            }
        }
    }
}

