/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.effects;

import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;

public class Reflection {
    public static final Reflection NO_EFFECT = new Reflection(0, 0, 0.0, 0.0);
    private final int transparency;
    private final int size;
    private final double blurSize;
    private final double offset;

    public Reflection(int transparency, int size, double blurSize, double offset) {
        this.transparency = transparency;
        this.size = size;
        this.blurSize = blurSize;
        this.offset = offset;
    }

    public boolean isEnabled() {
        return this.transparency != 0 || this.size != 0 || this.blurSize >= 0.0 || this.offset >= 0.0;
    }

    public synchronized void writeTaggedData(TaggedWriter writer) throws IOException {
        if (this.transparency != 0) {
            writer.putInt08(1, (byte)((double)this.transparency / 100.0 * 255.0));
        }
        if (this.size != 0) {
            writer.putInt32(2, this.size);
        }
        if (this.blurSize >= 0.0) {
            writer.putDouble(3, this.blurSize);
        }
        if (this.offset >= 0.0) {
            writer.putDouble(4, this.offset);
        }
    }
}

