/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.Core;
import inform.agent.SmartNumberConverter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class AsmoFormatter {
    private String format;
    private Object[] args;
    private static final int INVALID_FORMAR_ERROR = 1;
    private static final int ARGUMENT_MISSING_ERROR = 2;

    public AsmoFormatter(String format, Object[] args) {
        this.format = format;
        this.args = args;
    }

    private static boolean charIsNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean charIsLetter(char c) {
        return c >= 'A' && c <= 'z';
    }

    private static String createExceptionString(int code, String format) {
        switch (code) {
            case 1: {
                return "Format '" + format + "' invalid or incompatible with argument";
            }
            case 2: {
                return "'No argument for format  '" + format + "'";
            }
        }
        return "";
    }

    private void applyWidth(StringBuilder buff, int numChar, int negitive, char formatChar, int precision, int width) {
        int max;
        int n = max = precision > numChar && formatChar != 'S' ? precision : numChar;
        if (width != -1 && width > max + negitive) {
            for (int i = max + 1 + negitive; i <= width; ++i) {
                buff.append(formatChar == 'D' ? (char)'0' : ' ');
            }
        }
    }

    private void addBuf(String ch, StringBuilder buff, char formatChar, int itemLen, int strLen, boolean leftJustification, int precision, int width) {
        int negitive;
        int index;
        int numChar;
        int n = numChar = strLen == -1 ? ch.length() : strLen;
        if (itemLen > -1 && numChar > itemLen) {
            numChar = itemLen;
        }
        if (ch.charAt(index = 0) == '-' && formatChar != 'S') {
            --numChar;
            negitive = 1;
        } else {
            negitive = 0;
        }
        if (!leftJustification) {
            this.applyWidth(buff, numChar, negitive, formatChar, precision, width);
        }
        if (negitive == 1 && formatChar != 'U') {
            ++index;
            buff.append('-');
        }
        if (precision != -1 && precision > numChar && formatChar != 'S' && formatChar != 'G') {
            for (int i = numChar + 1; i <= precision; ++i) {
                buff.append('0');
            }
        }
        if (formatChar != 'S' || precision == -1) {
            buff.append(ch.substring(index));
        } else {
            buff.append(ch.substring(index, index + precision));
        }
    }

    public String execute() throws Exception {
        if (this.format.isEmpty()) {
            return "";
        }
        int argsIndex = -1;
        int i = 0;
        StringBuilder buffer = new StringBuilder();
        block16: while (i < this.format.length()) {
            if (this.format.charAt(i) == '%') {
                int precision;
                boolean leftJustification;
                Object numStr;
                if (++i < this.format.length() - 1 && this.format.charAt(i) == '%') {
                    ++i;
                    continue;
                }
                int width = -1;
                ++argsIndex;
                if (AsmoFormatter.charIsNumber(this.format.charAt(i))) {
                    numStr = "";
                    while (i < this.format.length() && AsmoFormatter.charIsNumber(this.format.charAt(i))) {
                        numStr = (String)numStr + this.format.charAt(i);
                        ++i;
                    }
                    int firstNumber = Integer.parseInt((String)numStr);
                    if (i < this.format.length() && this.format.charAt(i) == ':') {
                        ++i;
                        argsIndex = firstNumber;
                    } else {
                        width = firstNumber;
                    }
                } else if (this.format.charAt(i) == ':') {
                    argsIndex = 0;
                    ++i;
                }
                if (this.format.charAt(i) == '-') {
                    leftJustification = true;
                    ++i;
                } else {
                    leftJustification = false;
                }
                if (this.format.charAt(i) == '*') {
                    width = -2;
                    ++i;
                } else if (AsmoFormatter.charIsNumber(this.format.charAt(i))) {
                    numStr = new StringBuilder();
                    while (i < this.format.length() && AsmoFormatter.charIsNumber(this.format.charAt(i))) {
                        ((StringBuilder)numStr).append(this.format.charAt(i));
                        ++i;
                    }
                    if (((StringBuilder)numStr).length() > 0) {
                        width = Integer.parseInt(((StringBuilder)numStr).toString());
                    }
                }
                if (this.format.charAt(i) == '.') {
                    if (++i >= this.format.length()) break;
                    if (this.format.charAt(i) == '*') {
                        precision = -2;
                        ++i;
                    } else {
                        numStr = new StringBuilder();
                        while (i < this.format.length() && AsmoFormatter.charIsNumber(this.format.charAt(i))) {
                            ((StringBuilder)numStr).append(this.format.charAt(i));
                            ++i;
                        }
                        try {
                            precision = Integer.parseInt(((StringBuilder)numStr).toString());
                        }
                        catch (Exception e) {
                            Core.logger.error(null, e);
                            precision = -1;
                        }
                    }
                } else {
                    precision = -1;
                }
                if (!AsmoFormatter.charIsLetter(this.format.charAt(i))) break;
                char formatChar = Character.toUpperCase(this.format.charAt(i));
                ++i;
                if (width == -2) {
                    if (argsIndex >= this.args.length) {
                        throw new Exception(AsmoFormatter.createExceptionString(2, this.format));
                    }
                    if (this.args[argsIndex] instanceof Integer) {
                        width = (Integer)this.args[argsIndex];
                        if (width < 0) {
                            leftJustification = !leftJustification;
                            width = -width;
                        }
                        ++argsIndex;
                    } else {
                        throw new Exception(AsmoFormatter.createExceptionString(1, this.format));
                    }
                }
                if (precision == -2) {
                    if (argsIndex >= this.args.length) {
                        throw new Exception(AsmoFormatter.createExceptionString(2, this.format));
                    }
                    if (this.args[argsIndex] instanceof Integer) {
                        precision = (Integer)this.args[argsIndex];
                        ++argsIndex;
                    } else {
                        throw new Exception(AsmoFormatter.createExceptionString(1, this.format));
                    }
                }
                if (argsIndex >= this.args.length) {
                    throw new Exception(AsmoFormatter.createExceptionString(2, this.format));
                }
                Object currentArg = this.args[argsIndex];
                boolean overwrite = false;
                if (currentArg instanceof Character) {
                    if (formatChar == 'S') {
                        this.addBuf(Character.toString(((Character)currentArg).charValue()), buffer, formatChar, -1, -1, leftJustification, precision, width);
                        continue;
                    }
                    throw new Exception(AsmoFormatter.createExceptionString(1, this.format));
                }
                if (currentArg instanceof Number) {
                    Number arg = (Number)currentArg;
                    if (!SmartNumberConverter.isFinite(arg.doubleValue())) {
                        return arg.toString();
                    }
                    if (formatChar == 'G' || formatChar == 'E') {
                        if (precision > 18) {
                            precision = 15;
                        }
                    } else if (precision > 18) {
                        precision = 2;
                    }
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
                    decimalFormatSymbols.setDecimalSeparator('.');
                    decimalFormatSymbols.setGroupingSeparator(' ');
                    Object fmtStr = "";
                    DecimalFormat df = null;
                    String val = "";
                    switch (formatChar) {
                        case 'F': {
                            int j;
                            if (precision == -1) {
                                precision = 2;
                            }
                            for (j = 0; j < precision; ++j) {
                                fmtStr = (String)fmtStr + "0";
                            }
                            fmtStr = "." + (String)fmtStr;
                            fmtStr = "0" + (String)fmtStr;
                            for (j = 0; j < 17; ++j) {
                                fmtStr = "#" + (String)fmtStr;
                            }
                            df = new DecimalFormat((String)fmtStr, decimalFormatSymbols);
                            val = df.format(arg.doubleValue());
                            break;
                        }
                        case 'M': {
                            int j;
                            for (j = 0; j < 2; ++j) {
                                fmtStr = (String)fmtStr + "0";
                            }
                            fmtStr = "." + (String)fmtStr;
                            fmtStr = "0" + (String)fmtStr;
                            for (j = 0; j < 17; ++j) {
                                fmtStr = "#" + (String)fmtStr;
                            }
                            df = new DecimalFormat((String)fmtStr, decimalFormatSymbols);
                            df.setGroupingSize(3);
                            df.setGroupingUsed(true);
                            val = df.format(arg.doubleValue());
                            break;
                        }
                        case 'G': {
                            int j;
                            if (precision == -1) {
                                precision = 15;
                            }
                            if (Integer.toString(arg.intValue()).length() <= precision || arg.doubleValue() >= 1.0E-5) {
                                for (j = 0; j < precision; ++j) {
                                    fmtStr = (String)fmtStr + "#";
                                }
                                fmtStr = "." + (String)fmtStr;
                                fmtStr = "0" + (String)fmtStr;
                                for (j = 0; j < 17; ++j) {
                                    fmtStr = "#" + (String)fmtStr;
                                }
                                df = new DecimalFormat((String)fmtStr, decimalFormatSymbols);
                                val = df.format(arg.doubleValue());
                                break;
                            }
                            fmtStr = "0.#E0";
                            df = new DecimalFormat((String)fmtStr, decimalFormatSymbols);
                            val = df.format(arg.doubleValue());
                            break;
                        }
                        case 'N': {
                            int j;
                            if (precision == -1) {
                                precision = 2;
                            }
                            for (j = 0; j < precision; ++j) {
                                fmtStr = (String)fmtStr + "0";
                            }
                            fmtStr = "." + (String)fmtStr;
                            fmtStr = "0" + (String)fmtStr;
                            for (j = 0; j < 17; ++j) {
                                fmtStr = "#" + (String)fmtStr;
                            }
                            df = new DecimalFormat((String)fmtStr, decimalFormatSymbols);
                            if (formatChar == 'N') {
                                df.setGroupingSize(3);
                                df.setGroupingUsed(true);
                            }
                            val = df.format(arg.doubleValue());
                            break;
                        }
                        case 'X': {
                            if (arg.doubleValue() - (double)arg.intValue() != 0.0) {
                                val = Double.toHexString(arg.doubleValue());
                                break;
                            }
                            val = Integer.toHexString(arg.intValue());
                            break;
                        }
                        case 'D': {
                            val = Integer.toString(arg.intValue());
                            break;
                        }
                        case 'U': {
                            val = Integer.toString(arg.intValue());
                            break;
                        }
                        case 'E': {
                            int j;
                            fmtStr = "0.";
                            if (precision == -1) {
                                precision = 15;
                            }
                            for (j = 0; j < precision - 1; ++j) {
                                fmtStr = (String)fmtStr + "0";
                            }
                            fmtStr = (String)fmtStr + "E0";
                            df = new DecimalFormat((String)fmtStr, decimalFormatSymbols);
                            val = df.format(arg.doubleValue());
                            break;
                        }
                        default: {
                            throw new Exception(AsmoFormatter.createExceptionString(1, this.format));
                        }
                    }
                    if (val.isEmpty()) continue;
                    this.addBuf(val, buffer, formatChar, -1, -1, leftJustification, precision, width);
                    continue;
                }
                if (!(currentArg instanceof String)) continue;
                switch (formatChar) {
                    case 'S': {
                        this.addBuf(String.valueOf(currentArg), buffer, formatChar, -1, -1, leftJustification, precision, width);
                        continue block16;
                    }
                    case 'D': {
                        this.addBuf(String.valueOf(Integer.parseInt((String)currentArg)), buffer, formatChar, -1, -1, leftJustification, precision, width);
                        continue block16;
                    }
                }
                throw new Exception(AsmoFormatter.createExceptionString(1, this.format));
            }
            buffer.append(this.format.charAt(i));
            ++i;
        }
        return buffer.toString();
    }
}

