/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.Folder;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.Script;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.Task;
import java.io.IOException;
import org.mozilla.javascript.Scriptable;

public class ComponentsFactory {
    private static final int HEADER_SIZE = 28;
    public static final int TAG_SS_COMPONENT = 2;
    public static final int CT_FOLDER = 1101;
    public static final int CT_DATASOURCE = 1102;
    public static final int CT_SCRIPT = 1103;

    public static ServerSideComponent readAndCreateComponent(SSContext parentContext, Task task, Scriptable parentScope, TaggedReader reader) throws InformException {
        return ComponentsFactory.readAndCreateComponent(parentContext, task, parentScope, 2, reader);
    }

    public static ServerSideComponent readAndCreateComponent(SSContext parentContext, Task task, Scriptable parentScope, int componentTag, TaggedReader reader) throws InformException {
        ServerSideComponent createdComponent = null;
        try {
            byte[] headerData = new byte[28];
            reader.get(componentTag, headerData, 28);
            ComponentHeader header = new ComponentHeader(headerData);
            TaggedReader subReader = new TaggedReader(reader.getSubStream());
            switch (header.getTypeID()) {
                case 1101: {
                    createdComponent = new Folder(parentContext, task, parentScope, header, subReader);
                    break;
                }
                case 1102: {
                    createdComponent = new Datasource(parentContext, task, parentScope, header, subReader);
                    break;
                }
                case 1103: {
                    createdComponent = new Script(parentContext, task, parentScope, header, subReader);
                }
            }
        }
        catch (TaggedReaderException | IOException ex) {
            Core.logger.error(null, ex);
        }
        return createdComponent;
    }
}

