/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.TimeZoneHost;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.types.DataType;
import inform.agent.exchange.ConstEntry;
import inform.agent.exchange.ConstantsSet;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.ConstantsNode;
import inform.agent.scripts.Constant;
import inform.agent.scripts.format.FormatManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Constants
extends ScriptableObject {
    public static final int DEFAULT_CUR_USER_CONST_ID = -2;
    public static final int DEFAULT_REPLICA_SLICE_BEGIN_TIME = -8;
    public static final int DEFAULT_REPLICA_SLICE_END_TIME = -9;
    private static final int DEFAULT_CUR_TIME_ID = -6;
    public static final int DEFAULT_WORK_PERIOD_CONST_ID = -7;
    private final ArrayList<Constant> constants = new ArrayList();
    private final double userNodeId;
    private boolean isActualConstantsLoaded;
    private final IntegerHash<Constant> byId = new IntegerHash();
    private final HashMap<String, Constant> byName = new HashMap();
    private Hashtable<Integer, ConstEntry> descriptors = null;
    private static final String[] availJSFunctionsNames = new String[]{"toString"};

    public Constants(double userNodeId) {
        this.userNodeId = userNodeId;
        this.isActualConstantsLoaded = false;
        this.defineFunctionProperties(availJSFunctionsNames, Constants.class, 0);
    }

    public ArrayList<Constant> getAllConstants() {
        return this.constants;
    }

    private double loadDateValue(Constant constant, double value, TimeZoneHost timeZoneHost) {
        if (!DateTime.isServerTimeZoneHost(timeZoneHost)) {
            ConstEntry descriptor;
            if (this.descriptors == null) {
                this.descriptors = ConstantsSet.getConstantDescriptors();
            }
            if ((descriptor = this.descriptors.get(constant.getId())) != null && FormatManager.hasTime(descriptor.getFormatId())) {
                return FormatManager.toServerTime(value, descriptor.getFormatId(), timeZoneHost);
            }
        }
        return value;
    }

    private void loadTag(Constant constant, TaggedReader reader, TimeZoneHost timeZoneHost) throws IOException, TaggedReaderException {
        assert (constant != null);
        ObjectArrayList valueList = null;
        if (constant.value instanceof ObjectArrayList) {
            valueList = (ObjectArrayList)constant.value;
        }
        switch (reader.getCurrentTag()) {
            case 11: {
                assert (constant != null);
                String name = reader.getAnsi();
                if (name.isEmpty() || constant.getName().equals(name)) break;
                if (this.byName.containsKey(name)) {
                    this.byName.remove(name);
                }
                constant.setName(name);
                this.byName.put(name, constant);
                break;
            }
            case 31: {
                assert (constant != null);
                constant.setDataType(reader.getInt());
                break;
            }
            case 26: {
                assert (constant != null);
                constant.setIgnored();
                break;
            }
            case 17: {
                assert (constant != null);
                if (valueList == null) {
                    constant.value = null;
                    break;
                }
                valueList.add(null);
                break;
            }
            case 13: {
                assert (constant != null);
                constant.updateDataType(DataType.INTEGER);
                if (valueList == null) {
                    constant.value = reader.getInt();
                    break;
                }
                valueList.add(reader.getInt());
                break;
            }
            case 14: 
            case 22: 
            case 28: {
                assert (constant != null);
                constant.updateDataType(DataType.FLOAT);
                if (valueList == null) {
                    constant.value = reader.getDouble();
                    break;
                }
                valueList.add(reader.getDouble());
                break;
            }
            case 16: {
                assert (constant != null);
                constant.updateDataType(DataType.DATE_TIME);
                if (valueList == null) {
                    constant.value = this.loadDateValue(constant, reader.getDouble(), timeZoneHost);
                    break;
                }
                valueList.add(this.loadDateValue(constant, reader.getDouble(), timeZoneHost));
                break;
            }
            case 15: {
                assert (constant != null);
                constant.updateDataType(DataType.STRING);
                if (valueList == null) {
                    constant.value = reader.getAnsi();
                    break;
                }
                valueList.add(reader.getAnsi());
                break;
            }
            case 34: {
                assert (constant != null);
                constant.updateDataType(DataType.STRING);
                if (valueList == null) {
                    constant.value = reader.getUnicode();
                    break;
                }
                valueList.add(reader.getUnicode());
                break;
            }
            case 27: {
                assert (constant != null);
                constant.setFunction(reader.getInt());
            }
        }
    }

    private void afterLoad() {
        for (Constant c : this.constants) {
            Object val = c.getRawValue();
            if (!(val instanceof ObjectArrayList)) continue;
            ObjectArrayList listVal = (ObjectArrayList)val;
            if (listVal.isEmpty()) {
                c.setRawValue(null);
                continue;
            }
            if (listVal.size() == 1) {
                c.setRawValue(listVal.get(0));
                continue;
            }
            Object[] arrayVal = new Object[listVal.size()];
            int i = 0;
            for (Object e : listVal) {
                arrayVal[i++] = e;
            }
            c.setRawValue(arrayVal);
        }
    }

    private Constant createConstant(int id) {
        Constant constant = new Constant((Scriptable)this, id);
        ObjectArrayList valueList = new ObjectArrayList();
        constant.setRawValue(valueList);
        this.byId.add(constant);
        this.constants.add(constant);
        return constant;
    }

    public Constant findConstant(int id) {
        return this.byId.get(id);
    }

    public void load(byte[] constantsContent, TimeZoneHost timeZoneHost) throws IOException, TaggedReaderException {
        if (constantsContent != null && constantsContent.length != 0) {
            this.load(new TaggedReader(constantsContent), timeZoneHost);
        }
    }

    public void loadFromUser(double groupId, byte[] globalContent, byte[] userConstantContent) throws IOException, TaggedReaderException {
        AccountNode accountNode;
        if (globalContent != null && globalContent.length != 0) {
            this.load(new TaggedReader(globalContent), false, Core.serverTimeZoneHost);
        }
        if (groupId != 0.0 && (accountNode = MtdEngine.getAccountNode(groupId)) != null) {
            this.load(new TaggedReader(accountNode.getActualConstants()), false, Core.serverTimeZoneHost);
        }
        if (userConstantContent != null && userConstantContent.length != 0) {
            this.load(new TaggedReader(userConstantContent), true, Core.serverTimeZoneHost);
        }
        this.isActualConstantsLoaded = true;
        this.afterLoad();
    }

    private void load(TaggedReader reader, TimeZoneHost timeZoneHost) throws IOException, TaggedReaderException {
        this.load(reader, true, timeZoneHost);
    }

    private void load(TaggedReader reader, boolean updateActual, TimeZoneHost timeZoneHost) throws IOException, TaggedReaderException {
        if (updateActual) {
            this.isActualConstantsLoaded = true;
            for (Constant constant : this.constants) {
                constant.setOrgValue();
            }
        }
        Constant constant = null;
        block5: while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 10: {
                    byte[] header = reader.getRaw();
                    int id = LittleEndian.getInt(header, 0);
                    int type = LittleEndian.getInt(header, 4);
                    constant = this.byId.get(id);
                    if (constant == null) {
                        constant = this.createConstant(id);
                    }
                    constant.setConstantType(type);
                    continue block5;
                }
                case 19: {
                    int id = reader.getInt();
                    constant = this.byId.get(id);
                    if (constant == null) {
                        constant = this.createConstant(id);
                    }
                    constant.setRawValue(null);
                    if (!updateActual) continue block5;
                    constant.setActual();
                    continue block5;
                }
            }
            this.loadTag(constant, reader, timeZoneHost);
        }
        this.afterLoad();
    }

    public byte[] storeActualConstants() throws IOException {
        OutputStream data = null;
        TaggedWriter out = null;
        for (Constant constant : this.constants) {
            if (!constant.isActual()) continue;
            if (out == null) {
                data = new ByteArrayOutputStream();
                out = new TaggedWriter(data);
            }
            out.putInt32(19, constant.getId());
            if (constant.getIsIgnored()) {
                out.putEmpty(26);
                continue;
            }
            if (constant.getIsNull()) {
                out.putEmpty(17);
                continue;
            }
            switch (constant.constantType()) {
                case INTEGER: {
                    out.putInt32(13, (int)constant.getAsNumber());
                    break;
                }
                case BOOLEAN: {
                    out.putInt32(13, constant.getAsBoolean() ? 1 : 0);
                    break;
                }
                case FLOAT: 
                case INTERVAL: 
                case METATREE_NODE: {
                    out.putDouble(14, constant.getAsNumber());
                    break;
                }
                case STRING: {
                    out.putAnsi(15, constant.getAsString());
                    break;
                }
                case UNICODE: {
                    out.putUnicode(34, constant.getAsString());
                    break;
                }
                case DATE_TIME: {
                    out.putDouble(16, constant.getAsNumber());
                    break;
                }
                case DIRECTORY: {
                    out.putDouble(22, constant.getAsNumber());
                    break;
                }
                case PRIMARY_KEY: {
                    out.putDouble(28, constant.getAsNumber());
                }
            }
        }
        if (out != null) {
            out.flush();
        }
        if (data != null) {
            data.flush();
            return ((java.io.ByteArrayOutputStream)data).toByteArray();
        }
        return null;
    }

    private void update() {
        if (this.isActualConstantsLoaded) {
            return;
        }
        this.isActualConstantsLoaded = true;
        for (Constant constant : this.constants) {
            constant.setOrgValue();
        }
        Constant constant = null;
        try {
            TaggedReader reader;
            if (this.userNodeId == 0.0) {
                IntegerSet complete = new IntegerSet();
                for (Constant i : this.constants) {
                    complete.add(i.getId());
                }
                ByteArrayOutputStream content = new ByteArrayOutputStream();
                TaggedWriter out = new TaggedWriter(content);
                ConstantsNode.getActualContstants(out, complete);
                out.flush();
                reader = new TaggedReader(content.toByteArray());
            } else {
                AccountNode accountNode = MtdEngine.getValidAccountNode(this.userNodeId);
                reader = new TaggedReader(new ByteArrayInputStream(accountNode.getActualConstants()));
            }
            block7: while (reader.getNextTag() != 0) {
                switch (reader.getCurrentTag()) {
                    case 19: {
                        int constId = reader.getInt();
                        constant = this.byId.get(constId);
                        if (constant != null) {
                            if (constant.isActual()) {
                                constant = null;
                                continue block7;
                            }
                            constant.setActual();
                            continue block7;
                        }
                        constant = this.createConstant(constId);
                        continue block7;
                    }
                }
                if (constant == null) continue;
                this.loadTag(constant, reader, Core.serverTimeZoneHost);
            }
        }
        catch (InformException | IOException ex) {
            Core.logger.error(null, ex);
        }
        this.afterLoad();
    }

    public Constant get(int id) {
        this.update();
        Constant r = this.byId.get(id);
        if (r != null) {
            return r;
        }
        switch (id) {
            case -2: {
                Constant c = new Constant((Scriptable)this, id);
                c.updateDataType(DataType.METATREE_NODE);
                c.setRawValue(this.userNodeId);
                this.byId.add(c);
                return c;
            }
            case -6: {
                Constant c = new Constant((Scriptable)this, id);
                c.updateDataType(DataType.DATE_TIME);
                c.setRawValue(DateTime.currentDateTime());
                this.byId.add(c);
                return c;
            }
            case -8: {
                Constant c = new Constant((Scriptable)this, id);
                c.updateDataType(DataType.DATE_TIME);
                c.setIsIgnored(true);
                this.byId.add(c);
                return c;
            }
            case -9: {
                Constant c = new Constant((Scriptable)this, id);
                c.updateDataType(DataType.DATE_TIME);
                c.setIsIgnored(true);
                this.byId.add(c);
                return c;
            }
        }
        return this.byId.get(id);
    }

    public boolean isModified() {
        for (Constant c : this.constants) {
            if (!c.isModified()) continue;
            return true;
        }
        return false;
    }

    public void clearModifiedFlag() {
        for (Constant c : this.constants) {
            c.clearModifiedFlag();
        }
    }

    public Constant get(String name) {
        this.update();
        return this.byName.get(name);
    }

    @Override
    public String getClassName() {
        return "Constants";
    }

    @Override
    public Object get(String name, Scriptable start) {
        Constant c = this.get(name);
        if (c == null) {
            return super.get(name, start);
        }
        return c;
    }

    public String toString() {
        return "constants(" + this.byId.size() + ")";
    }

    private static class ObjectArrayList
    extends ArrayList<Object> {
        private ObjectArrayList() {
        }
    }
}

