/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.RowsetRandomAccessor;
import inform.agent.db.ScrollableRowset;
import inform.agent.db.SortingField;
import inform.agent.db.TableDescriptor;
import inform.agent.replication.SelectableDataset;
import inform.agent.scripts.ActualPoint;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.DatasourceFieldList;
import inform.agent.scripts.DirectoryField;
import inform.agent.scripts.SSContext;
import inform.common.SmartScriptableObject;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class DatasourceCursor
extends SmartScriptableObject
implements RowsetRandomAccessor,
SelectableDataset {
    public final SSContext.Component ssContext;
    private static final Object S_UNKNOWN = null;
    private static final Object S_SORTED = "\u043e\u0442\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d";
    private final Datasource datasource;
    private final ScrollableRowset rows;
    private final DatasourceFieldList fields;
    private final ArrayList<SortingField> sorting;
    private final boolean sortingHasStringFields;
    private Object wellSorted;

    public DatasourceCursor(Datasource datasource, Rowset rowset, ArrayList<SortingField> sorting, boolean sortingHasStringFields) throws InformException {
        this.datasource = datasource;
        this.ssContext = datasource.ssContext == null ? null : new SSContext.Component(datasource.ssContext, 5);
        this.rows = new ScrollableRowset(this.ssContext, datasource.getDBManager(), datasource.table(), datasource.getBlobReceiving(), false);
        this.rows.setDisabledGenerators(datasource.disabledGenerators);
        this.sorting = new ArrayList<SortingField>(sorting);
        this.sortingHasStringFields = sortingHasStringFields;
        this.fields = new DatasourceFieldList();
        for (FieldDescriptor fd : datasource.table().getFields()) {
            DatasourceField field = DatasourceField.createInstance(this.ssContext, this, fd, datasource.task, this);
            if (field == null) continue;
            this.fields.put(field);
        }
        if (rowset != null) {
            for (Row row : rowset) {
                this.rows.add(row);
            }
        }
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.datasource.getTableDescriptor();
    }

    @Override
    public int getId() {
        return this.datasource.getId();
    }

    @Override
    public Rowset executeSelect() throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public boolean isSelected() {
        return true;
    }

    @Override
    public boolean canRandomAccess() {
        return true;
    }

    @Override
    public Row getRow(int recordIndex) {
        this.idle();
        return (Row)this.rows.get(recordIndex);
    }

    @Override
    public int getRowsCount() {
        this.idle();
        return this.rows.size();
    }

    @Override
    public int getCurrentRowIndex() {
        this.idle();
        return this.rows.getRecordIndex();
    }

    @Override
    public int getNullSortKind() {
        return this.datasource.getNullSortKind();
    }

    private void throwNotPositionedError() throws InformException {
        throw new InformException(String.format("\u041a\u0443\u0440\u0441\u043e\u0440 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 %s \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u0438.", this.datasource.toString()));
    }

    @Override
    public Row getCurrentRow() throws InformException {
        this.idle();
        Row curRow = this.rows.getCurrentRow();
        if (curRow == null) {
            this.throwNotPositionedError();
        }
        return curRow;
    }

    @Override
    public boolean isCurrentRowAvailable() throws InformException {
        return this.rows.getCurrentRow() != null;
    }

    @Override
    public AbstractConnectionManager getDBManager() {
        return this.datasource.getDBManager();
    }

    @Override
    public ServerSideHost getHost() {
        return this.datasource.getHost();
    }

    @Override
    public boolean internStrings() {
        return false;
    }

    @Override
    public ActualPoint getPeriodicBind() {
        if (this.datasource == null) {
            return null;
        }
        return this.datasource.getPeriodicBind();
    }

    public void idle() {
        this.datasource.getHost().idle();
    }

    @SmartScriptableObject.FunctionTag
    public void reset() throws InformException {
        this.idle();
        this.rows.reset();
    }

    @Override
    @SmartScriptableObject.FunctionTag
    public boolean next() throws InformException {
        this.idle();
        return this.rows.next();
    }

    @Override
    @SmartScriptableObject.FunctionTag
    public DatasourceField findfieldById(int fieldId) {
        return this.fields.get(fieldId);
    }

    @Override
    public void enableFieldValueGenerator(int fieldIndex, boolean value) {
        this.datasource.enableFieldValueGenerator(fieldIndex, value);
    }

    @SmartScriptableObject.FunctionTag
    public boolean prev() throws InformException {
        this.idle();
        return this.rows.prev();
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws InformException {
        this.rows.clear();
        this.rows.close();
        for (DatasourceField f : this.fields.values()) {
            if (!(f instanceof DirectoryField)) continue;
            ((DirectoryField)f).detachDirectoryRowset();
        }
        this.datasource.task.detach(this);
    }

    @SmartScriptableObject.FunctionTag
    public static Object locate(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (thisObj == null || !(thisObj instanceof DatasourceCursor)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u0443\u0440\u0441\u043e\u0440\u043e\u043c \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        DatasourceCursor ds = (DatasourceCursor)thisObj;
        ds.mustBeWellSorted();
        return Datasource.locateRecord(ds.datasource, ds.rows, ds.fields, ds.sorting, args);
    }

    @SmartScriptableObject.FunctionTag
    public boolean locateByID(double rowID) throws InformException {
        this.idle();
        return this.rows.setRecord(rowID);
    }

    @SmartScriptableObject.FunctionTag
    public static void sort(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (args.length % 2 != 0) {
            throw new InformException("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c [field, bool, field, bool, ...]");
        }
        DatasourceCursor ds = (DatasourceCursor)thisObj;
        Datasource.doSort(ds, ds.rows, ds.datasource.table(), ds.fields, ds.sorting, args);
        ds.wellSorted = S_SORTED;
    }

    @SmartScriptableObject.FunctionTag
    public static Object filterRange(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (thisObj == null || !(thisObj instanceof DatasourceCursor)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u0443\u0440\u0441\u043e\u0440\u043e\u043c \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        DatasourceCursor ds = (DatasourceCursor)thisObj;
        ds.mustBeWellSorted();
        Datasource.doFilterRange(ds.rows, ds.getNullSortKind(), ds.fields, ds.sorting, args);
        return null;
    }

    @SmartScriptableObject.FunctionTag
    public void clearFilter() {
        this.rows.clearFilter();
    }

    @SmartScriptableObject.FunctionTag
    public DatasourceField findLinkField(double tableID) throws InformException {
        return this.fields.findLink(tableID);
    }

    @SmartScriptableObject.FunctionTag
    public DatasourceField fieldByName(String name) throws InformException {
        DatasourceField field = this.fields.get(name);
        if (field == null) {
            throw new InformException("\u041f\u043e\u043b\u0435 " + name + " \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 " + this.datasource.toString() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
        }
        return field;
    }

    @SmartScriptableObject.FunctionTag
    public DatasourceField findFieldByName(String name) {
        return this.fields.get(name);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.fields.contains(name)) {
            return super.get(name, start);
        }
        return this.fields.get(name);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.fields.contains(name)) {
            if (value instanceof DatasourceField) {
                try {
                    this.fields.get(name).assignField((DatasourceField)value);
                }
                catch (Exception e) {
                    Core.logger.error("{} in {}", e, this.toString());
                }
            }
        } else {
            super.put(name, start, value);
        }
    }

    @Override
    public void notifySortingFieldModified(Object field) {
        assert (field != null);
        this.wellSorted = field;
    }

    private void mustBeWellSorted() throws InformException {
        if (this.wellSorted == S_UNKNOWN) {
            if (this.sortingHasStringFields && !this.rows.wellSorted(this.sorting)) {
                this.rows.sort(this.sorting);
            }
            this.wellSorted = S_SORTED;
            return;
        }
        if (this.wellSorted != S_SORTED) {
            String cause = this.wellSorted instanceof DatasourceField ? "\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f " + ((DatasourceField)this.wellSorted).desc.getRawName() : this.wellSorted.toString();
            throw new InformException(String.format("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043a\u0443\u0440\u0441\u043e\u0440\u0430 %s (\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0430 \u0438\u0437-\u0437\u0430 %s)", this, cause));
        }
    }
}

