/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.ObjectSizer;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.DatasourceStatistics;
import inform.agent.ServerSideHost;
import inform.agent.db.Row;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.mtd.obj.DForm;
import inform.agent.mtd.obj.DslRuntime;
import inform.agent.net.Client;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.Script;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.SharedFields;
import inform.agent.scripts.Task;
import inform.common.Base64BinString;
import inform.common.SmartScriptableObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Queue;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;

public class DebugLibrary
extends SmartScriptableObject {
    private static final int LEVEL_BRIEF = 0;
    private static final int LEVEL_DETAILED = 1;
    private static final int LEVEL_DEBUG = 2;
    Task task;
    private static final String[] jsMethods = new String[]{"testJOP", "compileFormDsl"};
    private final ServerSideHost ssHost;

    private static String formatNumber(double n) {
        if (n < 1.0) {
            return String.format("%.3f", n);
        }
        if (n < 10.0) {
            return String.format("%.2f", n);
        }
        if (n < 100.0) {
            return String.format("%.1f", n);
        }
        return String.format("%.0f", n);
    }

    public static String formatSize(long size) {
        if (size < 1024L) {
            return size + "B";
        }
        if (size < 0x100000L) {
            return String.format("%sKB", DebugLibrary.formatNumber((double)size / 1024.0));
        }
        if ((size /= 1024L) < 0x100000L) {
            return String.format("%sMB", DebugLibrary.formatNumber((double)size / 1024.0));
        }
        return String.format("%sGB", DebugLibrary.formatNumber((double)(size /= 1024L) / 1024.0));
    }

    public DebugLibrary(Scriptable scope, ServerSideHost ssHost, Task task) {
        this.setParentScope(scope);
        this.ssHost = ssHost;
        this.task = task;
        this.defineProperty("LEVEL_BRIEF", (Object)0, 13);
        this.defineProperty("LEVEL_DETAILED", (Object)1, 13);
        this.defineProperty("LEVEL_DEBUG", (Object)2, 13);
        this.defineFunctionProperties(jsMethods, DebugLibrary.class, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static void fillDatamodelStatistics(int level, Task task, ServerSideComponent component, StringBuilder result) {
        double nodeId;
        result.append('\n');
        AbstractCollection tmp = level != 0 ? new PriorityQueue(1, (o1, o2) -> {
            if (level == 2) {
                return Long.compare(o2.getMemoryUsage(), o1.getMemoryUsage());
            }
            return o2.getRecordsCount() - o1.getRecordsCount();
        }) : new LinkedList();
        ArrayList<Object> modules = null;
        ArrayList<ServerSideComponent> dynamicalModules = null;
        for (Object c : task.getComponents()) {
            if (c instanceof Datasource) {
                tmp.add(new DatasourceInfo((Datasource)c));
                continue;
            }
            Task childTask = ((ServerSideComponent)c).childTask();
            if (childTask == null) continue;
            if (modules == null) {
                modules = new ArrayList<Object>();
            }
            modules.add(c);
        }
        Collection<ScriptableObject> dynamical = task.getDynamical();
        if (dynamical != null) {
            for (ScriptableObject d : dynamical) {
                if (!(d instanceof ServerSideComponent)) continue;
                ServerSideComponent c = (ServerSideComponent)d;
                if (c instanceof Datasource) {
                    tmp.add(new DatasourceInfo((Datasource)c, true));
                    continue;
                }
                Task childTask = c.childTask();
                if (childTask == null) continue;
                if (dynamicalModules == null) {
                    dynamicalModules = new ArrayList<ServerSideComponent>();
                }
                dynamicalModules.add(c);
            }
        }
        int recordsCount = 0;
        long memoryUsage = 0L;
        for (DatasourceInfo ds : tmp) {
            recordsCount += ds.getRecordsCount();
            if (level != 2) continue;
            memoryUsage += ds.getMemoryUsage();
        }
        if (component != null) {
            result.append("Component: [").append(component.getId()).append("] \"").append(component._title).append("\"\n");
        }
        if ((nodeId = task.nodeId()) != 0.0) {
            result.append("Node: ");
            MtdEngine.appendNodeNameForLog(result, nodeId);
            result.append('\n');
        }
        result.append("Datamodel: ");
        if (level == 2) {
            result.append(DebugLibrary.formatSize(memoryUsage)).append(" used in ");
        }
        result.append(recordsCount).append(" records ");
        if (level != 2) {
            result.append("loaded ");
        }
        result.append("in ").append(tmp.size()).append(" datasources\n");
        result.append(task.getDBManager().getModifiedRows().size()).append(" modified records\n");
        if (level != 0) {
            while (!tmp.isEmpty()) {
                void var14_17;
                String string;
                DatasourceInfo ds = (DatasourceInfo)tmp.poll();
                if (ds == null) continue;
                result.append(ds.getRecordsCount()).append('\t').append(DebugLibrary.formatSize(ds.memoryUsage)).append('\t');
                if (ds.dynamical) {
                    result.append("DYNAMIC DATASOURCE\t");
                }
                if ((string = ds.datasource.getName()) == null) {
                    String string2 = ds.datasource.getTitle();
                }
                result.append("  ");
                if (var14_17 == null) {
                    result.append(ds.datasource.getId());
                } else {
                    result.append((String)var14_17);
                }
                result.append('\n');
            }
        }
        if (modules != null) {
            for (ServerSideComponent serverSideComponent : modules) {
                DebugLibrary.fillDatamodelStatistics(level, serverSideComponent.childTask(), serverSideComponent, result);
            }
        }
        if (dynamicalModules != null) {
            for (ServerSideComponent serverSideComponent : dynamicalModules) {
                result.append("DYNAMIC MODULE");
                DebugLibrary.fillDatamodelStatistics(level, serverSideComponent.childTask(), serverSideComponent, result);
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public Object getStatistics(int level) throws ClassNotFoundException {
        SharedFields.registerSharedFields();
        StringBuilder result = new StringBuilder();
        MemoryUsage memUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        result.append("Memory usage: ").append(DebugLibrary.formatSize(memUsage.getUsed())).append(" of ").append(DebugLibrary.formatSize(memUsage.getMax())).append(" used\n");
        DebugLibrary.fillDatamodelStatistics(level, this.task, null, result);
        return result.toString();
    }

    @SmartScriptableObject.FunctionTag
    public Boolean testBase64(String str) throws InformException {
        byte[] ADTBytes;
        byte[] CPPBytes = Core.strToBase64(str);
        if (!Arrays.equals(CPPBytes, ADTBytes = Base64BinString.Decode(str))) {
            return false;
        }
        String CPPStr = Core.base64ToStr(ADTBytes);
        String ADTStr = Base64BinString.Encode(CPPBytes);
        return CPPStr.equals(str) && ADTStr.equals(str);
    }

    @SmartScriptableObject.FunctionTag
    public static String exceptionToString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Scriptable exs;
        Object re;
        if (args.length != 1) {
            throw new IllegalArgumentException("One argument expected");
        }
        Object arg = args[0];
        Object ex = arg;
        if (ex instanceof Scriptable && (re = (exs = (Scriptable)ex).get("rhinoException", exs)) != null && re != Undefined.instance && re != UniqueTag.NOT_FOUND) {
            ex = re;
        }
        if (ex instanceof NativeJavaObject) {
            ex = ((NativeJavaObject)ex).unwrap();
        }
        if (ex instanceof Throwable) {
            Throwable th = (Throwable)ex;
            StringWriter sw = new StringWriter();
            th.printStackTrace(new PrintWriter((Writer)sw, true));
            sw.flush();
            return sw.toString();
        }
        return ex != null ? ex.toString() : "<null>";
    }

    private DatabaseDescriptor getDBDescriptor(double dbId) {
        if (dbId == 2.0) {
            return DatabaseDescriptor.getMetabase();
        }
        Node node = MtdEngine.getValidNode(dbId);
        if (!(node instanceof DatabaseNode)) {
            MtdEngine.throwError(dbId, " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0443\u0437\u043b\u043e\u043c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f");
        }
        return ((DatabaseNode)MtdEngine.getValidNode(dbId)).getDescriptor();
    }

    @SmartScriptableObject.FunctionTag
    public DatasourceStatistics getSQLStatistics(double dbId, double dsId) throws Exception {
        return this.getDBDescriptor((double)dbId).statistics.getDSS(dsId);
    }

    @SmartScriptableObject.FunctionTag
    public DatasourceStatistics getSQLSummaryStatistics(double dbId) throws Exception {
        return this.getDBDescriptor((double)dbId).statistics.getDSSSummary();
    }

    @SmartScriptableObject.FunctionTag
    public String dumpHeap() throws Exception {
        return Core.dumpHeap();
    }

    @SmartScriptableObject.FunctionTag
    public void invalidateContent(double nodeId) throws Exception {
        Client client = this.ssHost.client();
        if (client != null) {
            if (client.security().role() != UserRole.ADMIN) {
                return;
            }
            Node node = MtdEngine.getNode(nodeId);
            if (node != null) {
                node.invalidateContent();
            }
        }
    }

    @Override
    public String getClassName() {
        return "Debug";
    }

    @SmartScriptableObject.FunctionTag
    public Object getMemoryUsage(Object object) throws ClassNotFoundException {
        SharedFields.registerSharedFields();
        Top top = new Top();
        if (object != null && object != Undefined.instance) {
            return DebugLibrary.formatSize(ObjectSizer.calculateObjectSize(object, top, true));
        }
        StringBuilder result = new StringBuilder();
        MemoryUsage memUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        result.append("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043e \u043f\u0430\u043c\u044f\u0442\u0438: ").append(DebugLibrary.formatSize(memUsage.getUsed())).append(" \u0438\u0437 ").append(DebugLibrary.formatSize(memUsage.getMax())).append("\n");
        String ObjectsSizeStr = this.calcObjectsSize(top);
        result.append(ObjectsSizeStr);
        return result.toString();
    }

    public String calcObjectsSize(Top top) {
        if (this.task == null) {
            return "";
        }
        long tick = Core.clock();
        top.scan((ServerSideExecutable)this.task, false);
        long size = top.scan((ServerSideExecutable)this.task, true);
        long tick2 = Core.clock();
        Core.logger.warn("memory usage for {} = {} (calculated in {}ms)", this.task, DebugLibrary.formatSize(size), tick2 - tick);
        StringBuilder buff = new StringBuilder();
        buff.append("\u041c\u043e\u0434\u0435\u043b\u044c \u0434\u0430\u043d\u043d\u044b\u0445: ");
        buff.append(DebugLibrary.formatSize(top.dsMemoryUsage));
        buff.append(", \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(top.recordsCount);
        buff.append(", \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 ").append(top.dsCount);
        buff.append(", \u043c\u043e\u0434\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(top.modifRecordsCount).append("\n");
        buff.append("\u0417\u0430\u043d\u044f\u0442\u0430\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430\u043c\u0438 \u043f\u0430\u043c\u044f\u0442\u044c, B: ").append(String.format("%,d", size));
        while (!top.MemUsageInfos.isEmpty()) {
            MemUsageInfo obj = top.MemUsageInfos.poll();
            if (obj == null || obj.obj == null || obj.obj instanceof FunctionObject || ObjectSizer.isPrimitiveClass(obj.obj.getClass())) continue;
            double part = (double)Math.round(100000.0 * (double)obj.memSize / (double)size) / 1000.0;
            buff.append('\n').append("  ").append(String.format("%,d", obj.memSize)).append(" (").append(part).append("%) - ").append(obj.desc);
            if (obj.recordsCount > 0) {
                buff.append(", \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(obj.recordsCount);
            }
            buff.append(" ").append(obj.hobj);
        }
        return buff.toString();
    }

    public static Object testJOP(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        if (args.length == 0) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 (ID) \u0443\u0437\u043b\u0430");
        }
        double nodeId = ValueCaster.toDouble(args[0]);
        Node node = MtdEngine.getValidNode(nodeId);
        if (node.getType() != 11) {
            MtdEngine.throwDetailError("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430 \u0443\u0437\u043b\u0430", nodeId);
        }
        byte[] content = MtdEngine.getNodeContent(nodeId);
        DForm form = new DForm();
        form.loadTaggedContent(new TaggedReader(content));
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        form.storeTaggedContent(out);
        out.flush();
        form = new DForm();
        form.loadTaggedContent(new TaggedReader(data.toByteArray()));
        StringBuilder textContent = new StringBuilder();
        form.storeTextContent(0, textContent, 0, false);
        return textContent.toString();
    }

    public static Object compileFormDsl(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        if (args.length != 2) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0444\u043e\u0440\u043c\u044b");
        }
        double nodeId = ValueCaster.toDouble(args[0]);
        BasicNode node = MtdEngine.getValidTranslatedNode(nodeId);
        String dsl = ValueCaster.toString(args[1]);
        return new BinaryObject(DslRuntime.getContent(null, null, null, node, dsl));
    }

    private static class Top
    extends ObjectSizer.Objects {
        Queue<MemUsageInfo> MemUsageInfos = new PriorityQueue<MemUsageInfo>(1, (o1, o2) -> Long.compare(o2.memSize, o1.memSize));
        int dsCount = 0;
        long dsMemoryUsage = 0L;
        int recordsCount = 0;
        int modifRecordsCount = 0;

        Top() {
        }

        long scanComponent(ServerSideComponent c, boolean calculate, ServerSideExecutable exec) {
            Scriptable s;
            long result = 0L;
            if (c instanceof Datasource) {
                String name = c.getName();
                result += this.push(c, calculate, exec, name + " {\u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445}");
            } else if (c instanceof Script && (s = ((Script)c).scriptableOrNull()) instanceof ServerSideExecutable) {
                result += this.scan((ServerSideExecutable)s, calculate);
            }
            return result;
        }

        long scanDynamical(ServerSideExecutable exec, boolean calculate) {
            Collection<ScriptableObject> dynamical = exec.getDynamical();
            if (dynamical == null) {
                return 0L;
            }
            long result = 0L;
            for (ScriptableObject d : dynamical) {
                if (!(d instanceof ServerSideComponent)) continue;
                result += this.scanComponent((ServerSideComponent)d, calculate, exec);
            }
            return result;
        }

        long scan(ServerSideExecutable exec, boolean calculate) {
            long result = 0L;
            ArrayList<Row> ModifiedRows = exec.dbManager.getModifiedRows();
            if (calculate) {
                this.modifRecordsCount += ModifiedRows.size();
            }
            result += this.push(ModifiedRows, calculate, exec, "\u0438\u0437\u043c\u0435\u043d\u0451\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 {" + ModifiedRows.getClass().getSimpleName() + "}");
            result += this.push(exec.dbManager, calculate, exec, "\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0431\u0434 {" + exec.dbManager.getClass().getSimpleName() + "}");
            for (ServerSideComponent c : exec.getComponents()) {
                result += this.scanComponent(c, calculate, exec);
            }
            result += this.scanDynamical(exec, calculate);
            for (Object k : exec.getAllIds()) {
                Object obj = exec.get(k);
                if (obj == null) continue;
                result += this.push(obj, calculate, exec, k + " {" + obj.getClass().getSimpleName() + "}");
            }
            return result += this.push(exec, calculate, exec, "\u043f\u0440\u043e\u0447\u0435\u0435 {" + exec.getClass().getSimpleName() + "}");
        }

        MemUsageInfo getMemUsageInfo(Object object) {
            for (MemUsageInfo info : this.MemUsageInfos) {
                if (info == null || info.obj != object) continue;
                return info;
            }
            return null;
        }

        long push(Object object, boolean calculate, Object hintobj, String hintstr) {
            if (!calculate) {
                this.add(object);
                return 0L;
            }
            if (this.getMemUsageInfo(object) != null) {
                return 0L;
            }
            long objsize = ObjectSizer.calculateObjectSize(object, this, true);
            MemUsageInfo obj = new MemUsageInfo();
            obj.memSize = objsize;
            obj.obj = object;
            obj.hobj = hintobj;
            obj.desc = hintstr;
            obj.recordsCount = 0;
            if (object instanceof Datasource) {
                int rCount;
                Datasource ds = (Datasource)object;
                if (ds.isLoaded() && (rCount = ds.getRecordCount()) > 0) {
                    obj.recordsCount = rCount;
                    this.recordsCount += rCount;
                }
                ++this.dsCount;
                this.dsMemoryUsage += objsize;
            }
            this.MemUsageInfos.add(obj);
            return objsize;
        }
    }

    private static class MemUsageInfo {
        long memSize;
        Object obj;
        Object hobj;
        String desc;
        int recordsCount;

        private MemUsageInfo() {
        }
    }

    private static class DatasourceInfo {
        Datasource datasource;
        long memoryUsage;
        final boolean dynamical;

        public DatasourceInfo(Datasource datasource) {
            this.dynamical = false;
            this.datasource = datasource;
        }

        public DatasourceInfo(Datasource datasource, boolean dynamical) {
            this.dynamical = dynamical;
            this.datasource = datasource;
        }

        public int getRecordsCount() {
            return this.datasource.isLoaded() ? this.datasource.getRecordCount() : 0;
        }

        public long getMemoryUsage() {
            if (this.memoryUsage == 0L) {
                this.memoryUsage = ObjectSizer.calculateObjectSize(this.datasource, new ObjectSizer.Objects(), true);
            }
            return this.memoryUsage;
        }
    }
}

