/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.db.types.ValueCaster;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class Decimal
extends ScriptableObject {
    private BigDecimal number;
    private static final int PRECISION_DIGITS = 15;
    private static final int PRECISION_DIGITS2 = 17;
    private static final int DECNUMDIGITS = 30;

    public Object jsConstructor(Object n) {
        this.jsFunction_assign(n);
        return this;
    }

    public Object jsFunction_toString() {
        return this.number.stripTrailingZeros().toPlainString();
    }

    public Object jsFunction_toNumber() {
        return this.number.doubleValue();
    }

    public String toString() {
        return this.number.stripTrailingZeros().toPlainString();
    }

    public double toDouble() {
        return this.number.doubleValue();
    }

    public Object jsFunction_assign(Object n) {
        if (n instanceof NativeJavaObject) {
            n = ((NativeJavaObject)n).unwrap();
        }
        this.number = n == Undefined.instance ? new BigDecimal(0) : (n instanceof Number ? new BigDecimal(Decimal.decimalString(((Number)n).doubleValue())) : (n instanceof Decimal ? ((Decimal)n).number : new BigDecimal(Decimal.decimalString(ValueCaster.toDouble(n)))));
        return this;
    }

    public Object jsFunction_inc(Object n) {
        if (n instanceof NativeJavaObject) {
            n = ((NativeJavaObject)n).unwrap();
        }
        if (n == Undefined.instance) {
            this.number = this.number.add(BigDecimal.ONE);
        } else if (n instanceof String) {
            this.number = this.number.add(new BigDecimal((String)n));
        } else if (n instanceof Number) {
            double d = ((Number)n).doubleValue();
            if (d == 0.0) {
                return this;
            }
            this.number = this.number.add(new BigDecimal(Decimal.decimalString(d)));
        } else if (n instanceof Decimal) {
            this.number = this.number.add(((Decimal)n).number);
        } else {
            double d = ValueCaster.toDouble(n);
            if (d == 0.0) {
                return this;
            }
            this.number = this.number.add(new BigDecimal(Decimal.decimalString(d)));
        }
        return this;
    }

    public Object jsFunction_dec(Object n) {
        if (n instanceof NativeJavaObject) {
            n = ((NativeJavaObject)n).unwrap();
        }
        if (n == Undefined.instance) {
            this.number = this.number.subtract(BigDecimal.ONE);
        } else if (n instanceof String) {
            this.number = this.number.subtract(new BigDecimal((String)n));
        } else if (n instanceof Number) {
            double d = ((Number)n).doubleValue();
            if (d == 0.0) {
                return this;
            }
            this.number = this.number.subtract(new BigDecimal(Decimal.decimalString(d)));
        } else if (n instanceof Decimal) {
            this.number = this.number.subtract(((Decimal)n).number);
        } else {
            double d = ValueCaster.toDouble(n);
            if (d == 0.0) {
                return this;
            }
            this.number = this.number.subtract(new BigDecimal(Decimal.decimalString(d)));
        }
        return this;
    }

    public static Object jsFunction_add(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args == null || args.length == 0) {
            return thisObj;
        }
        BigDecimal number = ((Decimal)thisObj).number;
        for (int i = 0; i < args.length; ++i) {
            double d;
            Object n = args[i];
            if (n instanceof NativeJavaObject) {
                n = ((NativeJavaObject)n).unwrap();
            }
            if (n == Undefined.instance) continue;
            if (n instanceof String) {
                number = number.add(new BigDecimal((String)n));
                continue;
            }
            if (n instanceof Number) {
                d = ((Number)n).doubleValue();
                if (d == 0.0) continue;
                number = number.add(new BigDecimal(Decimal.decimalString(d)));
                continue;
            }
            if (n instanceof Decimal) {
                number = number.add(((Decimal)n).number);
                continue;
            }
            d = ValueCaster.toDouble(n);
            if (d == 0.0) continue;
            number = number.add(new BigDecimal(Decimal.decimalString(d)));
        }
        Decimal nd = new Decimal();
        nd.number = number;
        Scriptable ps = thisObj.getParentScope();
        Scriptable proto = Decimal.getClassPrototype(ps, thisObj.getClassName());
        nd.setParentScope(ps);
        nd.setPrototype(proto);
        return nd;
    }

    public static Object jsStaticFunction_add(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Decimal nd = new Decimal();
        nd.number = new BigDecimal(0);
        Scriptable ps = thisObj.getParentScope();
        if (ps != null) {
            Scriptable proto = Decimal.getClassPrototype(ps, thisObj.getClassName());
            nd.setParentScope(ps);
            nd.setPrototype(proto);
        }
        return Decimal.jsFunction_add(cx, nd, args, funObj);
    }

    public static Object jsFunction_sub(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args == null || args.length == 0) {
            return thisObj;
        }
        BigDecimal number = ((Decimal)thisObj).number;
        for (int i = 0; i < args.length; ++i) {
            double d;
            Object n = args[i];
            if (n instanceof NativeJavaObject) {
                n = ((NativeJavaObject)n).unwrap();
            }
            if (n == Undefined.instance) continue;
            if (n instanceof String) {
                number = number.subtract(new BigDecimal((String)n));
                continue;
            }
            if (n instanceof Number) {
                d = ((Number)n).doubleValue();
                if (d == 0.0) continue;
                number = number.subtract(new BigDecimal(Decimal.decimalString(d)));
                continue;
            }
            if (n instanceof Decimal) {
                number = number.subtract(((Decimal)n).number);
                continue;
            }
            d = ValueCaster.toDouble(n);
            if (d == 0.0) continue;
            number = number.subtract(new BigDecimal(Decimal.decimalString(d)));
        }
        Decimal nd = new Decimal();
        nd.number = number;
        Scriptable ps = thisObj.getParentScope();
        Scriptable proto = Decimal.getClassPrototype(ps, thisObj.getClassName());
        nd.setParentScope(ps);
        nd.setPrototype(proto);
        return nd;
    }

    public static Object jsStaticFunction_sub(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Decimal nd = new Decimal();
        if (args == null || args.length == 0) {
            nd.number = new BigDecimal(0);
        } else {
            nd.jsFunction_assign(args[0]);
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        Scriptable ps = thisObj.getParentScope();
        if (ps == null) {
            ps = thisObj;
        }
        Scriptable proto = Decimal.getClassPrototype(ps, thisObj.getClassName());
        nd.setParentScope(ps);
        nd.setPrototype(proto);
        return Decimal.jsFunction_sub(cx, nd, args, funObj);
    }

    public Object jsFunction_mul(Object n) {
        double d;
        if (n instanceof NativeJavaObject) {
            n = ((NativeJavaObject)n).unwrap();
        }
        Decimal nd = new Decimal();
        Scriptable ps = this.getParentScope();
        Scriptable proto = Decimal.getClassPrototype(ps, this.getClassName());
        nd.setParentScope(ps);
        nd.setPrototype(proto);
        nd.number = n == Undefined.instance ? this.number : (n instanceof String ? this.number.multiply(new BigDecimal((String)n)) : (n instanceof Number ? ((d = ((Number)n).doubleValue()) == 0.0 ? BigDecimal.ZERO : this.number.multiply(new BigDecimal(Decimal.decimalString(d)))) : (n instanceof Decimal ? this.number.multiply(((Decimal)n).number) : ((d = ValueCaster.toDouble(n)) == 0.0 ? BigDecimal.ZERO : this.number.multiply(new BigDecimal(Decimal.decimalString(d)))))));
        return nd;
    }

    public Object jsFunction_div(Object n) {
        if (n instanceof NativeJavaObject) {
            n = ((NativeJavaObject)n).unwrap();
        }
        Decimal nd = new Decimal();
        Scriptable ps = this.getParentScope();
        Scriptable proto = Decimal.getClassPrototype(ps, this.getClassName());
        nd.setParentScope(ps);
        nd.setPrototype(proto);
        if (n == Undefined.instance) {
            nd.number = this.number;
        } else if (n instanceof String) {
            nd.number = this.number.divide(new BigDecimal((String)n), 30, RoundingMode.HALF_UP);
        } else if (n instanceof Number) {
            double d = ((Number)n).doubleValue();
            nd.number = this.number.divide(new BigDecimal(Decimal.decimalString(d)), 30, RoundingMode.HALF_UP);
        } else if (n instanceof Decimal) {
            nd.number = this.number.divide(((Decimal)n).number, 30, RoundingMode.HALF_UP);
        } else {
            double d = ValueCaster.toDouble(n);
            nd.number = this.number.divide(new BigDecimal(Decimal.decimalString(d)), 30, RoundingMode.HALF_UP);
        }
        return nd;
    }

    public Object jsFunction_round(Object n) {
        double d;
        if (n instanceof NativeJavaObject) {
            n = ((NativeJavaObject)n).unwrap();
        }
        Decimal nd = new Decimal();
        Scriptable ps = this.getParentScope();
        Scriptable proto = Decimal.getClassPrototype(ps, this.getClassName());
        nd.setParentScope(ps);
        nd.setPrototype(proto);
        nd.number = n == Undefined.instance ? this.number.setScale(0, 4) : (n instanceof String ? this.number.setScale(-new BigDecimal((String)n).intValueExact(), 4) : (n instanceof Number ? ((d = ((Number)n).doubleValue()) == 0.0 ? this.number.setScale(0, 4) : this.number.setScale(-new BigDecimal(Decimal.decimalString(d)).intValueExact(), 4)) : (n instanceof Decimal ? this.number.setScale(-((Decimal)n).number.intValueExact(), 4) : ((d = ValueCaster.toDouble(n)) == 0.0 ? this.number.setScale(0, 4) : this.number.setScale(-new BigDecimal(Decimal.decimalString(d)).intValueExact(), 4)))));
        return nd;
    }

    @Override
    public String getClassName() {
        return "Decimal";
    }

    private static String decimalString(double val) {
        int exp10;
        long valBits = Double.doubleToLongBits(val);
        int exp = (int)(valBits >> 52 & 0x7FFL);
        long m = valBits & 0xFFFFFFFFFFFFFL;
        if (exp == 0 && m == 0L) {
            return "0";
        }
        if (exp == 2047) {
            return "NaN";
        }
        if (exp == 0) {
            long n = valBits;
            while ((n & 0x8000000000000L) == 0L) {
                --exp;
                n <<= 1;
            }
        }
        int precision = (exp10 = ((exp -= 1023) * 19728 >> 16) + 1) > 12 ? 17 : 15;
        long value = Math.round(val * Math.pow(10.0, precision - exp10));
        String result = Long.toString(value) + "E" + (exp10 -= precision);
        return result;
    }
}

