/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.utils.PackedRowContent;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.ITableDataResult;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.ServerSideTable;
import inform.agent.scripts.Task;
import inform.agent.scripts.expr.SSTableEvaluator;
import inform.agent.scripts.expr.SSTableExpression;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GetServerSideTableDataRequest
extends ScriptableRequest
implements ITableDataResult {
    private ServerSideTable node = null;
    private final RequestResult result = new RequestResult(this);
    private int sendedRecords = 0;
    private long sendedDataSize = 0L;
    private byte[] bindedParametersContent = null;
    private byte[] constantsContent = null;
    private byte[] ssTableContent = null;
    private int blobReceiving = 0;
    private int geoFormat;
    private AbstractConnectionManager dbManager = null;
    private int nullSortKind = 0;
    double userNodeId = 0.0;
    double tableNodeId = 0.0;
    double ownerNodeId = 0.0;
    int ownerDatasourceId = 0;
    private byte[] filterContent = null;
    private int fetchLimit = -1;
    private SSTableExpression filterExpression = null;
    private SSTableEvaluator filter = null;

    public GetServerSideTableDataRequest(RequestHeader rq) {
        super(rq);
    }

    private StringBuilder getLogInfo() {
        StringBuilder logInfo = new StringBuilder();
        logInfo.append("rq: ").append(504).append(" u: ").append(NumberConverter.doubleToString(this.userNodeId)).append(" t: ").append(NumberConverter.doubleToString(this.tableNodeId));
        logInfo.append(" q: ").append(NumberConverter.doubleToString(this.rq.nodeId));
        if (this.ownerNodeId != 0.0) {
            logInfo.append(" o:").append((long)this.ownerNodeId);
        }
        if (this.ownerDatasourceId != 0) {
            logInfo.append(" uid:").append(this.ownerDatasourceId);
        }
        return logInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        this.userNodeId = this.getUserID();
        Context cx = Core.asmoJsContextFactory.enterContext();
        this.dbManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:GetServerSideTableDataRequest");
        try {
            Node nodeInfo;
            double nodeID;
            block35: {
                nodeID = this.getNodeID();
                nodeInfo = MtdEngine.getValidNode(nodeID);
                this.node = new ServerSideTable(this.ssContext, this.nullSortKind, nodeID, this, this.dbManager, null);
                this.topLevelScope = ScriptableRequest.createTopLevelScope(cx, this.node, this, this.dbManager);
                this.loadRequestContent(this.node, this.createRequestContentReader());
                this.node.table.fetchLimit = this.fetchLimit;
                this.rqstat.ownerId = this.ownerNodeId;
                this.rqstat.ownerDatasourceId = this.ownerDatasourceId;
                this.node.setBlobReceiving(this.blobReceiving);
                if (this.constantsContent != null) {
                    this.node.setConstantsContent(this.constantsContent);
                }
                if (this.ssTableContent != null) {
                    this.node.load(new TaggedReader(new ByteArrayInputStream(this.ssTableContent), this.ssTableContent.length));
                } else {
                    this.node.load();
                }
                this.setServerSideExecutable(this.node);
                this.tableNodeId = this.node.getTableId();
                if (!AccessMask.accessDenied(0x4000000, this.security().accessMask(nodeInfo))) break block35;
                this.sendResult();
                this.node.close();
                return;
            }
            try {
                try {
                    if (this.bindedParametersContent != null) {
                        this.node.getParameters().loadParametersValues(this.node.getConstants(), new TaggedReader(this.bindedParametersContent), this);
                    }
                    this.node.setParentScope(this.getTopLevelScope());
                    if (this.filterContent != null && this.filterExpression == null) {
                        this.filterExpression = new SSTableExpression(this.node, (Scriptable)this.topLevelScope);
                        this.filterExpression.load(new TaggedReader(this.filterContent));
                        this.filterExpression.afterLoad();
                        this.filter = (SSTableEvaluator)this.filterExpression.compile();
                        if (this.filter != null) {
                            this.filter.afterLoad(this.node);
                        }
                    }
                    this.setConstants(this.node.getConstants());
                    this.node.executeScript(cx);
                    TableDescriptor tableDescriptor = TableDescriptor.getIfExists(this.tableNodeId);
                    if (tableDescriptor == null) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b '").append(nodeInfo.getName()).append("' [").append(NumberConverter.doubleToString(nodeID)).append("]: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b [\u0443\u0437\u0435\u043b: ").append(NumberConverter.doubleToString(this.tableNodeId)).append(']');
                        throw new InformException(msg.toString());
                    }
                    DatabaseDescriptor databaseDescriptor = tableDescriptor.getDbDescIfExists();
                    if (databaseDescriptor == null) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b '").append(nodeInfo.getName()).append("' [").append(NumberConverter.doubleToString(nodeID)).append("]: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f[").append(NumberConverter.doubleToString(tableDescriptor.getDbId())).append("] \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b '").append(tableDescriptor.getCaption()).append("' [").append(NumberConverter.doubleToString(this.tableNodeId)).append(']');
                        throw new InformException(msg.toString());
                    }
                    double databaseId = databaseDescriptor.getNodeId();
                    DatabaseConnection conn = this.dbManager.getConnection(databaseId, "ServerSideTableDataRequest::execute");
                    if (this.node.isDebugMode()) {
                        conn.getDescriptor().statistics.startDSStatistics();
                    }
                    if (this.node.getOnQueryData() == null || this.node.getOnQueryData().length() <= 0) {
                        throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u044f onQueryData \u0434\u043b\u044f %s", nodeInfo.toLogString()));
                    }
                    ScriptableObject.callMethod(this.node, this.node.getOnQueryData(), null);
                    Rowset rowset = this.node.getResultRowset();
                    conn.getDescriptor().statistics.clearDSStatistics();
                    if (this.node.isDebugMode()) {
                        conn.getDescriptor().statistics.stopDSStatistics();
                    }
                    if (rowset != null) {
                        this.sendTableData(rowset, true, false);
                    }
                    if (this.dbManager.hasModifications()) {
                        StringBuilder message = new StringBuilder("\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 ");
                        HashSet<String> dsNames = new HashSet<String>();
                        String delimiter = "";
                        for (Row r : this.dbManager.getModifiedRows()) {
                            dsNames.add(MtdEngine.getValidNode(r.getTableDescriptor().getNodeId()).toLogString());
                        }
                        if (dsNames.size() > 1) {
                            message.append("\u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0430\u0445 ");
                        } else {
                            message.append("\u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ");
                        }
                        for (String tableName : dsNames) {
                            message.append(delimiter);
                            message.append(tableName);
                            delimiter = ", ";
                        }
                        throw new InformException(message.toString());
                    }
                    String profile = this.node.getProfile();
                    if (profile != null) {
                        ByteArrayOutputStream o = new ByteArrayOutputStream();
                        TaggedWriter w = new TaggedWriter(o);
                        w.putAnsi(13, profile);
                        w.flush();
                        this.sendRequestState(o.internalBuffer(), o.size());
                    }
                    this.result.sendResult();
                    this.dbManager.commit();
                    if (this.sendedRecords > 30000 || this.sendedDataSize > 0x4000000L) {
                        Core.logger.warn("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u043e\u043b\u044c\u0448\u043e\u0433\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0434\u0430\u043d\u043d\u044b\u0445: {} \u0437\u0430\u043f\u0438\u0441\u0435\u0439, {} \u0431\u0430\u0439\u0442", (Object)this.sendedRecords, (Object)this.sendedDataSize);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.node.close();
                }
            }
            catch (Throwable e) {
                throw InformException.detail(e, this.getLogInfo().toString());
            }
        }
        finally {
            try {
                this.dbManager.release();
                Context.exit();
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
        }
    }

    private void loadRequestContent(Task task, TaggedReader reader) throws IOException, InformException {
        int tag;
        do {
            tag = reader.getNextTag();
            switch (tag) {
                case 14: {
                    this.ssTableContent = new byte[reader.getCurrentTagSize()];
                    reader.getRaw(this.ssTableContent, this.ssTableContent.length);
                    break;
                }
                case 32: {
                    this.constantsContent = new byte[reader.getCurrentTagSize()];
                    reader.getRaw(this.constantsContent, this.constantsContent.length);
                    break;
                }
                case 36: {
                    this.bindedParametersContent = new byte[reader.getCurrentTagSize()];
                    reader.getRaw(this.bindedParametersContent, this.bindedParametersContent.length);
                    break;
                }
                case 39: {
                    this.blobReceiving = reader.getInt();
                    break;
                }
                case 41: {
                    this.ssContext.ownerId = this.ownerNodeId = reader.getDouble();
                    break;
                }
                case 42: {
                    this.ssContext.uid = this.ownerDatasourceId = reader.getInt();
                    break;
                }
                case 43: {
                    this.geoFormat = reader.getInt();
                    break;
                }
                case 47: {
                    task.setDatasourceProfile();
                    break;
                }
                case 46: {
                    this.filterContent = reader.getRaw();
                    break;
                }
                case 23: {
                    this.fetchLimit = reader.getInt();
                    break;
                }
                case 50: {
                    this.nullSortKind = reader.getInt();
                    this.node.setNullSortKind(this.nullSortKind);
                }
            }
        } while (tag != 0);
    }

    @Override
    public boolean isCurrentRowFiltered() throws Exception {
        return this.filter == null || this.filter.execute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendTableData(Rowset rowset, boolean flush, boolean alreadyFiltered) throws Exception {
        if (this.filter != null && !alreadyFiltered) {
            rowset.reset();
            while (rowset.next()) {
                if (this.filter.execute()) continue;
                Row row = rowset.getCurrentRow();
                if (row == null) {
                    throw new InformException("Can not get current record for delete");
                }
                row.markDelete();
            }
            rowset.compact();
        }
        if (this.node.isSorting()) {
            if (!flush) return;
            rowset.sort(this.node.getSorting());
        } else if (rowset.isEmpty() && !flush) {
            return;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream(4096);
        PackedRowContent content = new PackedRowContent(this.blobReceiving, this.geoFormat, this.client().isClientLevel(3), this, this.rq.client.isClientLevel(6));
        TaggedWriter out = this.result.getWriter();
        if (this.sendedRecords == 0) {
            out.putInt32(39, this.blobReceiving);
            out.putBool(44, true);
            content.packMetadata(rowset.getTableDescriptor(), (OutputStream)data);
            out.putRaw(27, data);
        }
        rowset.clearFilter();
        rowset.reset();
        while (rowset.next()) {
            Row row = rowset.getCurrentRow();
            if (row == null) {
                throw new InformException("Can not get current record");
            }
            data.reset();
            content.packRecordContent(row, data);
            out.putEmpty(21);
            out.putDouble(1, row.getId());
            out.putRaw(2, data);
            out.flush();
            this.sendedDataSize += (long)this.result.sendChunkIf(4032);
            ++this.sendedRecords;
        }
        rowset.clearFilter();
        rowset.clear();
        rowset.reset();
    }

    @Override
    public void contextMessage(LogContext.Builder out) {
        super.contextMessage(out);
        out.append("u", NumberConverter.doubleToString(this.userNodeId)).append("t", NumberConverter.doubleToString(this.tableNodeId));
        out.append("q", NumberConverter.doubleToString(this.rq.nodeId));
        if (this.ownerNodeId != 0.0) {
            out.append("o", (long)this.ownerNodeId);
        }
        if (this.ownerDatasourceId != 0) {
            out.append("uid", this.ownerDatasourceId);
        }
    }
}

