/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TagVersionInfo;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.EdDsa;
import inform.agent.Ini;
import inform.agent.VersionInfo;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.util.Base64;

public class License
extends SmartScriptableObject {
    public static final int PRODUCT_ID_AM = 1;
    public static final int PRODUCT_ID_PHA = 2;
    public static final int PRODUCT_ID_AMCONSOLE = 3;
    public static final int PRODUCT_ID_PHX = 4;
    public static final int PRODUCT_ID_RE = 5;
    public static final int PRODUCT_ID_AVES = 6;
    public static final int PRODUCT_ID_METADATA = 7;
    public static final int PRODUCT_ID_CLIENT_V6 = 8;
    public static final int LICENCE_TYPE_GENERAL = 0;
    public static final int LICENCE_TYPE_DEMO = 1;
    public static final int LICENCE_TYPE_TRIAL = 2;
    public static final int MIN_CONNECTION_COUNT = 2;
    public static final String TRIAL_AGENT_LICENSE_TEXT = "\u0423\u0441\u043b\u043e\u0432\u043d\u043e-\u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u0430\u044f \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\r\n\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432: 2 \u0448\u0442";
    public static final String TRIAL_METADATA_LICENSE_TEXT = "\u0423\u0441\u043b\u043e\u0432\u043d\u043e-\u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u0430\u044f \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445.\r\n\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432: 2 \u0448\u0442";
    public static final int TAG_LICENCE_FILE_CONTENT = 1;
    public static final int TAG_LICENCE_FILE_SIGNATURE = 2;
    public static final int TAG_LICENCE_FILE_INSTALL_DATE = 3;
    public static final int TAG_LICENCE_PRODUCT = 1;
    public static final int TAG_LICENCE_TEXT = 2;
    public static final int TAG_LICENCE_MIN_VERSION = 3;
    public static final int TAG_LICENCE_MAX_VERSION = 4;
    public static final int TAG_LICENCE_MIN_PRODUCT_DATE = 5;
    public static final int TAG_LICENCE_MAX_PRODUCT_DATE = 6;
    public static final int TAG_LICENCE_MIN_LICENCE_DATE = 7;
    public static final int TAG_LICENCE_MAX_LICENCE_DATE = 8;
    public static final int TAG_LICENCE_LICENCE_TYPE = 9;
    public static final int TAG_LICENCE_SIGN_DATE = 10;
    public static final int TAG_LICENCE_CLIENT_LIMIT = 11;
    private String text = null;
    private int productCode = 0;
    private long minVersion = 0L;
    private long maxVersion = 0L;
    private double minProductDate = 0.0;
    private double maxProductDate = 0.0;
    private double minLicenceDate = 0.0;
    private double maxLicenceDate = 0.0;
    private int licenceType = 0;
    private double signDate = 0.0;
    private int clientLimit = 0;
    private double installDate = 0.0;
    private String licenseNo = null;
    private String ppkPath = null;
    private static final String[] PRODUCT_NAMES = new String[]{"am", "pha", "amconsole", "phx", "asmo-re", "aves", "metadata", "asmo-client"};

    @SmartScriptableObject.PropertyTag
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @SmartScriptableObject.PropertyTag
    public int getProductCode() {
        return this.productCode;
    }

    public void setProductCode(int product) {
        this.productCode = product;
    }

    @SmartScriptableObject.PropertyTag
    public String getMinVersion() {
        if (this.minVersion == 0L) {
            return "";
        }
        return TagVersionInfo.toString(this.minVersion);
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = Strings.isVoid(minVersion) ? 0L : TagVersionInfo.fromString(minVersion);
    }

    @SmartScriptableObject.PropertyTag
    public String getMaxVersion() {
        if (this.maxVersion == 0L) {
            return "";
        }
        return TagVersionInfo.toString(this.maxVersion);
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = Strings.isVoid(maxVersion) ? 0L : TagVersionInfo.fromString(maxVersion);
    }

    @SmartScriptableObject.PropertyTag
    public double getMinProductDate() {
        return this.minProductDate;
    }

    public void setMinProductDate(double minProductDate) {
        this.minProductDate = minProductDate;
    }

    @SmartScriptableObject.PropertyTag
    public double getMaxProductDate() {
        return this.maxProductDate;
    }

    public void setMaxProductDate(double maxProductDate) {
        this.maxProductDate = maxProductDate;
    }

    @SmartScriptableObject.PropertyTag
    public double getMinLicenceDate() {
        return this.minLicenceDate;
    }

    public void setMinLicenceDate(double minLicenceDate) {
        this.minLicenceDate = minLicenceDate;
    }

    @SmartScriptableObject.PropertyTag
    public double getMaxLicenceDate() {
        return this.maxLicenceDate;
    }

    public void setMaxLicenceDate(double maxLicenceDate) {
        this.maxLicenceDate = maxLicenceDate;
    }

    @SmartScriptableObject.PropertyTag
    public boolean isTrial() {
        return this.licenceType == 2;
    }

    @SmartScriptableObject.PropertyTag
    public boolean isDemo() {
        return this.licenceType == 1;
    }

    @SmartScriptableObject.PropertyTag
    public boolean isGeneral() {
        return this.licenceType == 0;
    }

    @SmartScriptableObject.FunctionTag
    public void setTrial() {
        this.licenceType = 2;
    }

    @SmartScriptableObject.FunctionTag
    public void setDemo() {
        this.licenceType = 1;
    }

    @SmartScriptableObject.FunctionTag
    public void setGeneral() {
        this.licenceType = 0;
    }

    @SmartScriptableObject.PropertyTag
    public double getSignDate() {
        return this.signDate;
    }

    @SmartScriptableObject.PropertyTag
    public String getNo() {
        return this.licenseNo;
    }

    @SmartScriptableObject.PropertyTag
    public String getPpk() {
        return this.ppkPath;
    }

    public void setPpk(String ppkPath) {
        this.ppkPath = ppkPath;
    }

    @SmartScriptableObject.FunctionTag
    public String generateKey() {
        ByteArrayOutputStream content = this.getContent();
        byte[] signature = EdDsa.createSignature(this.ppkPath, content.internalBuffer(), content.size());
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        try {
            out.putRaw(1, content);
            out.putRaw(2, signature);
            if (this.installDate != 0.0) {
                out.putDouble(3, this.installDate);
            }
            out.flush();
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
        this.calcLicenseNo(content.internalBuffer(), content.size());
        byte[] bytes = data.toByteArray();
        String result = Base64.getEncoder().encodeToString(bytes);
        return result;
    }

    private byte[] base64LicenceToBytes(String licence) {
        boolean needTransform = false;
        int count = licence.length();
        for (int i = 0; i < count; ++i) {
            char ch = licence.charAt(i);
            if ('\u0000' > ch || ch > ' ') continue;
            needTransform = true;
            break;
        }
        if (needTransform) {
            StringBuilder licenceBuilder = new StringBuilder();
            int count2 = licence.length();
            for (int i = 0; i < count2; ++i) {
                char ch = licence.charAt(i);
                if ('\u0000' <= ch && ch <= ' ') continue;
                licenceBuilder.append(ch);
            }
            licence = licenceBuilder.toString();
        }
        return Base64.getDecoder().decode(licence);
    }

    public void setLicenseContent(String licence) {
        this.installDate = 0.0;
        this.licenseNo = null;
        byte[] content = null;
        byte[] signature = null;
        byte[] bytes = this.base64LicenceToBytes(licence);
        ByteArrayInputStream data = new ByteArrayInputStream(bytes);
        TaggedReader in = new TaggedReader(data, bytes.length);
        try {
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 1: {
                        content = in.getRaw();
                        this.calcLicenseNo(content, content.length);
                        break;
                    }
                    case 2: {
                        signature = in.getRaw();
                        break;
                    }
                    case 3: {
                        this.installDate = in.getDouble();
                    }
                }
            }
        }
        catch (Throwable e) {
            throw InformException.wrap(e, "\u041a\u043b\u044e\u0447 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u043b\u044e\u0447.");
        }
        if (content == null || signature == null) {
            throw new InformException("\u041a\u043b\u044e\u0447 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u043b\u044e\u0447.");
        }
        EdDsa.verifySignature(signature, signature.length, content, content.length);
        this.loadContent(content);
    }

    @SmartScriptableObject.PropertyTag
    public double getInstallDate() {
        return this.installDate;
    }

    @SmartScriptableObject.PropertyTag
    public int getClientLimit() {
        return this.clientLimit;
    }

    public void setClientLimit(int clientLimit) {
        this.clientLimit = clientLimit;
    }

    public int effectiveClientLimit() {
        int limit;
        int n = limit = this.clientLimit == 0 ? (limit = Ini.MaxConnectionCount) : this.clientLimit;
        if (limit != 0 && limit < 2) {
            return 2;
        }
        return limit;
    }

    public String install(String licence) {
        this.installDate = 0.0;
        this.licenseNo = null;
        byte[] content = null;
        byte[] signature = null;
        byte[] bytes = this.base64LicenceToBytes(licence);
        ByteArrayInputStream inputData = new ByteArrayInputStream(bytes);
        TaggedReader in = new TaggedReader(inputData, bytes.length);
        try {
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 1: {
                        content = in.getRaw();
                        break;
                    }
                    case 2: {
                        signature = in.getRaw();
                    }
                }
            }
        }
        catch (Throwable e) {
            throw InformException.wrap(e, "\u041a\u043b\u044e\u0447 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u043b\u044e\u0447.");
        }
        if (content == null || signature == null) {
            throw new InformException("\u041a\u043b\u044e\u0447 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u043b\u044e\u0447.");
        }
        EdDsa.verifySignature(signature, signature.length, content, content.length);
        this.installDate = DateTime.currentDateTime();
        this.calcLicenseNo(content, content.length);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        try {
            out.putRaw(1, content);
            out.putRaw(2, signature);
            out.putDouble(3, this.installDate);
            out.flush();
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
        return Base64.getEncoder().encodeToString(data.toByteArray());
    }

    public boolean checkLicence(int productId, String licence) {
        this.installDate = 0.0;
        this.licenseNo = null;
        byte[] content = null;
        byte[] signature = null;
        byte[] bytes = this.base64LicenceToBytes(licence);
        ByteArrayInputStream data = new ByteArrayInputStream(bytes);
        TaggedReader in = new TaggedReader(data, bytes.length);
        try {
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 1: {
                        content = in.getRaw();
                        this.calcLicenseNo(content, content.length);
                        break;
                    }
                    case 2: {
                        signature = in.getRaw();
                        break;
                    }
                    case 3: {
                        this.installDate = in.getDouble();
                    }
                }
            }
        }
        catch (Throwable e) {
            Core.logger.error(null, InformException.wrap(e, "\u041a\u043b\u044e\u0447 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u043b\u044e\u0447."));
            return false;
        }
        if (content == null || signature == null) {
            Core.logger.error(null, new InformException("\u041a\u043b\u044e\u0447 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u043b\u044e\u0447."));
            return false;
        }
        if (EdDsa.isSignValid(signature, signature.length, content, content.length)) {
            this.loadContent(content);
            return this.productCode == productId;
        }
        return false;
    }

    public void limitsToString(StringBuilder text) {
        text.append(this.text);
        if (!Strings.isVoid(this.licenseNo)) {
            text.append("\r\n").append("\u041d\u043e\u043c\u0435\u0440 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438: ").append(this.licenseNo);
        }
        if (this.signDate != 0.0) {
            text.append("\r\n").append("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u0432\u044b\u0434\u0430\u043d\u0430: ").append(DateTime.toText(this.signDate));
        }
        if (this.installDate != 0.0) {
            text.append("\r\n").append("\u0414\u0430\u0442\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438: ").append(DateTime.toText(this.installDate));
        }
        if (this.minVersion != 0L || this.maxVersion != 0L) {
            text.append("\r\n").append("\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0438:");
            if (this.minVersion != 0L) {
                text.append(" \u043e\u0442 ").append(VersionInfo.toString(this.minVersion));
            }
            if (this.maxVersion != 0L) {
                text.append(" \u0434\u043e ").append(VersionInfo.toString(this.maxVersion));
            }
        }
        if (this.minProductDate != 0.0 || this.maxProductDate != 0.0) {
            text.append("\r\n").append("\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435:");
            if (this.minProductDate != 0.0) {
                text.append(" \u043e\u0442 ").append(DateTime.toText((long)this.minProductDate));
            }
            if (this.maxProductDate != 0.0) {
                text.append(" \u0434\u043e ").append(DateTime.toText((long)this.maxProductDate));
            }
        }
        text.append("\r\n").append("\u0421\u0440\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438:");
        if (this.minLicenceDate != 0.0) {
            text.append(" \u043e\u0442 ").append(DateTime.toText((long)this.minLicenceDate));
        }
        if (this.maxLicenceDate != 0.0) {
            text.append(" \u0434\u043e ").append(DateTime.toText((long)this.maxLicenceDate));
        } else if (this.minLicenceDate == 0.0) {
            text.append(" \u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d");
        }
        if (this.clientLimit != 0) {
            text.append("\r\n").append("\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432: ").append(this.clientLimit).append(" \u0448\u0442");
        }
    }

    private ByteArrayOutputStream getContent() {
        License.checkProductId(this.productCode);
        if (Strings.isVoid(this.text)) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u043e\u043d\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        try {
            this.signDate = DateTime.currentDateTime();
            out.putInt32(1, this.productCode);
            out.putString(2, this.text);
            if (this.minVersion != 0L) {
                out.putLong(3, this.minVersion);
            }
            if (this.maxVersion != 0L) {
                out.putLong(4, this.maxVersion);
            }
            if (this.minProductDate != 0.0) {
                out.putDouble(5, this.minProductDate);
            }
            if (this.maxProductDate != 0.0) {
                out.putDouble(6, this.maxProductDate);
            }
            if (this.minLicenceDate != 0.0) {
                out.putDouble(7, this.minLicenceDate);
            }
            if (this.maxLicenceDate != 0.0) {
                out.putDouble(8, this.maxLicenceDate);
            }
            out.putInt32(9, this.licenceType);
            out.putDouble(10, this.signDate);
            if (this.clientLimit != 0) {
                out.putInt32(11, this.clientLimit);
            }
            out.flush();
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
        return data;
    }

    private void loadContent(byte[] content) {
        this.text = null;
        this.productCode = 0;
        this.minVersion = 0L;
        this.maxVersion = 0L;
        this.minProductDate = 0.0;
        this.maxProductDate = 0.0;
        this.minLicenceDate = 0.0;
        this.maxLicenceDate = 0.0;
        this.licenceType = 0;
        this.signDate = 0.0;
        ByteArrayInputStream data = new ByteArrayInputStream(content);
        TaggedReader in = new TaggedReader(data, content.length);
        try {
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 1: {
                        this.productCode = in.getInt();
                        break;
                    }
                    case 2: {
                        this.text = in.getString();
                        break;
                    }
                    case 3: {
                        this.minVersion = in.getLong();
                        break;
                    }
                    case 4: {
                        this.maxVersion = in.getLong();
                        break;
                    }
                    case 5: {
                        this.minProductDate = in.getDouble();
                        break;
                    }
                    case 6: {
                        this.maxProductDate = in.getDouble();
                        break;
                    }
                    case 7: {
                        this.minLicenceDate = in.getDouble();
                        break;
                    }
                    case 8: {
                        this.maxLicenceDate = in.getDouble();
                        break;
                    }
                    case 9: {
                        this.licenceType = in.getInt();
                        break;
                    }
                    case 10: {
                        this.signDate = in.getDouble();
                        break;
                    }
                    case 11: {
                        this.clientLimit = in.getInt();
                    }
                }
            }
        }
        catch (Throwable e) {
            throw InformException.wrap(e, "\u041a\u043b\u044e\u0447 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u043b\u044e\u0447.");
        }
    }

    private void calcLicenseNo(byte[] data, int size) {
        long crc = Core.calcCrc64(data, size);
        String hex = String.format("%016X", crc);
        this.licenseNo = hex.substring(0, 4) + "-" + hex.substring(4, 8) + "-" + hex.substring(8, 12) + "-" + hex.substring(12, 16);
    }

    private static void checkProductId(int productId) {
        switch (productId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new InformException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 (productId: " + productId + ")");
    }
}

