/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.MailMessage;
import inform.common.Base64BinString;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeUtility;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class MailAttachment
extends ScriptableObject {
    private MimeBodyPart content = null;

    void encodeFileName() {
        try {
            byte[] utf8;
            if (this.content == null) {
                return;
            }
            String fileName = this.content.getFileName();
            if (fileName == null) {
                return;
            }
            byte[] usascii = fileName.getBytes(StandardCharsets.US_ASCII);
            if (Arrays.equals(usascii, utf8 = fileName.getBytes(StandardCharsets.UTF_8))) {
                return;
            }
            fileName = String.format("=?UTF-8?B?%s?=", Base64BinString.Encode(utf8));
            this.content.setFileName(fileName);
        }
        catch (Throwable t) {
            Core.logger.error("\u043e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f", t);
        }
    }

    void decodeFileName() {
        try {
            if (this.content == null) {
                return;
            }
            String fileName = this.content.getFileName();
            if (fileName == null) {
                return;
            }
            if (fileName.equals(MimeUtility.decodeText(fileName)) && !MailMessage.is7BitEncoding(fileName)) {
                byte[] bytes = new byte[fileName.length()];
                fileName.getBytes(0, fileName.length(), bytes, 0);
                String contentType = this.content.getContentType();
                if (contentType != null && contentType.contains("charset")) {
                    ContentType type = new ContentType(contentType);
                    String encoding = type.getParameter("charset");
                    if (encoding != null && Charset.isSupported(encoding)) {
                        this.content.setFileName(new String(bytes, Charset.forName(encoding)));
                    } else {
                        this.content.setFileName(fileName);
                    }
                } else {
                    String encoding = MailMessage.getCharset(fileName);
                    if (encoding != null) {
                        this.content.setFileName(new String(bytes, Charset.forName(encoding)));
                    } else {
                        this.content.setFileName(fileName);
                    }
                }
            } else {
                this.content.setFileName(MimeUtility.decodeText(fileName));
            }
        }
        catch (Throwable t) {
            Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f: ", t);
        }
    }

    MailAttachment() {
        this.defineFunctionProperties(MailAttachmentFunction.availJSFunctionsNames, this.getClass(), 0);
        for (String propertyName : MailAttachmentFunction.jsRWProperties) {
            this.defineProperty(propertyName, MailAttachment.class, 0);
        }
        for (String propertyName : MailAttachmentFunction.jsROProperties) {
            this.defineProperty(propertyName, MailAttachment.class, 1);
        }
    }

    @Override
    public String getClassName() {
        return "MailAttachment";
    }

    public MimeBodyPart getContent() {
        return this.content;
    }

    public void setContent(MimeBodyPart content) {
        this.content = content;
    }

    public String getFileName() throws MessagingException {
        if (this.content != null) {
            return this.content.getFileName();
        }
        return "";
    }

    public void setFileName(String fileName) throws MessagingException {
        if (this.content == null) {
            this.content = new MimeBodyPart();
        }
        this.content.setFileName(fileName);
    }

    public static String strOrEmpty(String str) {
        if (str != null) {
            return str;
        }
        return "";
    }

    public String getContentID() throws MessagingException {
        if (this.content != null) {
            return MailAttachment.strOrEmpty(this.content.getContentID());
        }
        return "";
    }

    public void setContentID(String id) throws MessagingException {
        if (this.content == null) {
            this.content = new MimeBodyPart();
        }
        this.content.setContentID(id);
    }

    public boolean isInline() throws Exception {
        String disp = this.getDisposition();
        return disp.equalsIgnoreCase("inline");
    }

    public boolean isAttachment() throws Exception {
        String disp = this.getDisposition();
        return disp.equalsIgnoreCase("attachment");
    }

    public String getDisposition() throws Exception {
        if (this.content != null) {
            return MailAttachment.strOrEmpty(this.content.getDisposition());
        }
        return "";
    }

    public void setDisposition(String disp) throws Exception {
        if (this.content != null) {
            this.content.setDisposition(disp);
        }
    }

    public String getContentType() throws Exception {
        if (this.content != null) {
            return MailAttachment.strOrEmpty(this.content.getContentType());
        }
        return "";
    }

    public static void loadFromFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        String fileName;
        MailAttachment self = (MailAttachment)thisObj;
        if (self.content == null) {
            self.content = new MimeBodyPart();
        }
        if (args.length > 0 && args[0] instanceof String) {
            self.content.setFileName((String)args[0]);
        }
        if ((fileName = self.content.getFileName()) != null) {
            try {
                self.content.attachFile(Core.mountfs.resolve(new File(fileName)));
            }
            catch (Exception e) {
                throw new Exception(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 \"%s\"", fileName), e);
            }
        } else {
            throw new Exception("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveToFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        String fileName;
        MailAttachment self = (MailAttachment)thisObj;
        if (self.content == null) {
            throw new Exception("\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        if (args.length <= 0 || !(args[0] instanceof String)) throw new Exception("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0442\u043e\u0447\u043a\u0430 \u043c\u043e\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
        if (args.length > 1 && args[1] instanceof String) {
            self.content.setFileName((String)args[1]);
        }
        if ((fileName = self.content.getFileName()) == null) throw new Exception("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
        try {
            self.content.saveFile(Core.mountfs.resolve(new File((String)args[0] + "\\" + fileName)));
            return;
        }
        catch (Exception e) {
            throw new Exception(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0432 \u0444\u0430\u0439\u043b \"%s\"", fileName), e);
        }
    }

    public void loadFromBinary(BinaryObject binary) throws Exception {
        this.loadFromBytes(binary.toByteArray());
        this.content.setDisposition("attachment");
    }

    void loadFromBytes(byte[] bytes) throws Exception {
        MailAttachment self = this;
        if (self.content == null) {
            self.content = new MimeBodyPart();
        }
        try {
            self.content.setContent(bytes, "application/octet-stream");
        }
        catch (Exception e) {
            throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f", e);
        }
    }

    public void loadFromBlob(DatasourceField field) throws Exception {
        if (field == null) {
            throw new InformException("loadFromBlob \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043f\u043e\u043b\u0435");
        }
        BinaryObject binary = field.getAsBinary();
        assert (binary != null);
        this.loadFromBinary(binary);
    }

    public void saveToBlob(DatasourceField field) throws Exception {
        if (field == null) {
            throw new InformException("saveToBlob \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043f\u043e\u043b\u0435");
        }
        BinaryObject bin = this.toBinary();
        field.setAsBinary(bin);
    }

    public BinaryObject toBinary() throws Exception {
        BinaryObject result = new BinaryObject();
        if (this.content != null) {
            result.loadFromStream(this.content.getInputStream());
        }
        return result;
    }

    public BinaryObject getAsBinary() throws Exception {
        return this.toBinary();
    }

    static class MailAttachmentFunction {
        public static final String[] availJSFunctionsNames = new String[]{"loadFromFile", "saveToFile", "loadFromBinary", "loadFromBlob", "saveToBlob", "toBinary"};
        public static final String[] jsRWProperties = new String[]{"fileName", "asBinary", "contentID", "disposition"};
        public static final String[] jsROProperties = new String[]{"contentType", "isInline", "isAttachment"};

        MailAttachmentFunction() {
        }
    }
}

