/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.scripts.FileSystemLibrary;
import inform.agent.scripts.SSLTest;
import inform.agent.scripts.ScriptDigest;
import inform.agent.scripts.ScriptableBinaryFileReader;
import inform.agent.scripts.ScriptableTextFileReader;
import inform.agent.scripts.TCRC32;
import inform.agent.scripts.Task;
import inform.agent.scripts.libs.SNMP;
import inform.agent.scripts.net.ThreadLocalCookieHandler;
import inform.common.SmartScriptableObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;
import org.mozilla.javascript.Scriptable;

public class NetLibrary
extends SmartScriptableObject {
    static final String URL_ENCODING = "UTF-8";
    private final Task task;
    private final ServerSideHost host;
    private Map<String, Object> params;

    public NetLibrary(Scriptable scope, Task task) {
        this.setParentScope(scope);
        this.task = task;
        this.host = task == null ? null : task.getHost();
        this.setUseProxy(false);
        try {
            this.setHttpProxy(null);
            this.setFtpProxy(null);
        }
        catch (MalformedURLException e) {
            Core.logger.error("Impossible MalformedURLException occurred: {}", e.getMessage());
        }
    }

    public void idle() {
        if (this.host != null) {
            this.host.idle();
        }
    }

    @Override
    public String getClassName() {
        return "Net";
    }

    @SmartScriptableObject.PropertyTag
    public String getFtpProxy() {
        XAuthenticator.XProxy proxy = XAuthenticator.FTP_PROXY.get();
        return proxy == null ? null : proxy.toString();
    }

    public void setFtpProxy(String proxy) throws MalformedURLException {
        if (Strings.isEmpty((CharSequence)proxy)) {
            XAuthenticator.FTP_PROXY.remove();
        } else {
            XAuthenticator.FTP_PROXY.set(new XAuthenticator.XProxy(new URL("ftp://" + proxy)));
        }
    }

    @SmartScriptableObject.PropertyTag
    public String getHttpProxy() {
        XAuthenticator.XProxy proxy = XAuthenticator.HTTP_PROXY.get();
        return proxy == null ? null : proxy.toString();
    }

    public void setHttpProxy(String proxy) throws MalformedURLException {
        if (Strings.isEmpty((CharSequence)proxy)) {
            XAuthenticator.HTTP_PROXY.remove();
        } else {
            XAuthenticator.HTTP_PROXY.set(new XAuthenticator.XProxy(new URL("http://" + proxy)));
        }
    }

    @SmartScriptableObject.PropertyTag
    public boolean getUseProxy() {
        Boolean useProxy = XAuthenticator.USE_PROXY.get();
        return useProxy != null && useProxy != false;
    }

    public void setUseProxy(boolean value) {
        XAuthenticator.USE_PROXY.set(value);
    }

    public static URLConnection openConnection(URL url) throws IOException {
        XAuthenticator.cleanup();
        XAuthenticator.XProxy proxy = XAuthenticator.getProxyForUrl(url);
        if (proxy != null) {
            return url.openConnection(proxy);
        }
        return url.openConnection();
    }

    @SmartScriptableObject.FunctionTag
    public Object openTextFile(String pathname, Object cs) throws IOException {
        URL url = Core.mountfs.resolve(new URL(pathname));
        Charset charset = cs instanceof String ? Charset.forName(FileSystemLibrary.resolveUtf16Trable((String)cs)) : FileSystemLibrary.DEFAULT_CHARSET;
        URLConnection conn = NetLibrary.openConnection(url);
        this.applyHttpRequest(conn);
        return new ScriptableTextFileReader((Scriptable)this, new InputStreamReader(conn.getInputStream(), charset));
    }

    @SmartScriptableObject.FunctionTag
    public Object openBinaryFile(String pathname) throws IOException {
        URL url = Core.mountfs.resolve(new URL(pathname));
        URLConnection conn = NetLibrary.openConnection(url);
        this.applyHttpRequest(conn);
        return new ScriptableBinaryFileReader((Scriptable)this, conn.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public void downloadTo(String fileUrl, String fileName) throws IOException {
        URL url = Core.mountfs.resolve(new URL(fileUrl));
        try (FileOutputStream out = new FileOutputStream(Core.mountfs.resolve(new File(fileName)));){
            URLConnection conn = NetLibrary.openConnection(url);
            this.applyHttpRequest(conn);
            try (InputStream in = conn.getInputStream();){
                int readen;
                this.idle();
                byte[] buffer = new byte[65536];
                while ((readen = in.read(buffer, 0, buffer.length)) >= 0) {
                    if (readen > 0) {
                        out.write(buffer, 0, readen);
                    }
                    this.idle();
                }
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public String testHttps(String url) throws IOException {
        URL u = Core.mountfs.resolve(new URL(url));
        XAuthenticator.XProxy proxy = XAuthenticator.getProxyForUrl(u);
        SSLTest test = new SSLTest();
        return test.doGet(url, proxy);
    }

    @SmartScriptableObject.FunctionTag
    public String urlEncode(String url, Object cp) throws UnsupportedEncodingException {
        String codepage = URL_ENCODING;
        if (cp instanceof String) {
            codepage = FileSystemLibrary.resolveUtf16Trable((String)cp);
        }
        return URLEncoder.encode(url, codepage);
    }

    @SmartScriptableObject.FunctionTag
    public String urlDecode(String url, Object cp) throws UnsupportedEncodingException {
        String codepage = URL_ENCODING;
        if (cp instanceof String) {
            codepage = FileSystemLibrary.resolveUtf16Trable((String)cp);
        }
        return URLDecoder.decode(url, codepage);
    }

    @SmartScriptableObject.FunctionTag
    public Object createCRC32() {
        return new TCRC32(this.getParentScope());
    }

    @SmartScriptableObject.FunctionTag
    public Object createMD5() throws NoSuchAlgorithmException {
        return new ScriptDigest(this.getParentScope(), "MD5");
    }

    @SmartScriptableObject.FunctionTag
    public Object createSha1() throws NoSuchAlgorithmException {
        return new ScriptDigest(this.getParentScope(), "SHA-1");
    }

    @SmartScriptableObject.FunctionTag
    public Object createSha256() throws NoSuchAlgorithmException {
        return new ScriptDigest(this.getParentScope(), "SHA-256");
    }

    @SmartScriptableObject.FunctionTag
    public Object createSnmp() throws IOException {
        SNMP result = new SNMP(this.task, this.getParentScope());
        this.task.registerCloseable(result);
        return result;
    }

    private void applyHttpRequest(URLConnection connection) throws ProtocolException, UnsupportedEncodingException, IOException {
        if (connection instanceof HttpURLConnection && this.params != null) {
            HttpURLConnection conn = (HttpURLConnection)connection;
            connection.setDoOutput(true);
            StringBuilder sb = new StringBuilder();
            String dlm = "";
            for (String name : this.params.keySet()) {
                sb.append(dlm).append(name).append("=");
                String value = (String)this.params.get(name);
                sb.append(URLEncoder.encode(value, URL_ENCODING));
                dlm = "&";
            }
            String content = sb.toString();
            connection.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Length", "" + content.length());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStream os = conn.getOutputStream();
            os.write(content.getBytes(URL_ENCODING));
            os.close();
        }
    }

    @SmartScriptableObject.FunctionTag
    public void httpParameter(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, value);
    }

    private static class XAuthenticator
    extends Authenticator {
        private static final ThreadLocal<XProxy> FTP_PROXY = new ThreadLocal();
        private static final ThreadLocal<XProxy> HTTP_PROXY = new ThreadLocal();
        private static final ThreadLocal<Boolean> USE_PROXY = new ThreadLocal();

        private XAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            URL url;
            switch (this.getRequestorType()) {
                case PROXY: {
                    XProxy proxy = XAuthenticator.getProxyForUrl(this.getRequestingURL());
                    url = proxy == null ? null : proxy.url;
                    break;
                }
                case SERVER: {
                    url = this.getRequestingURL();
                    break;
                }
                default: {
                    url = null;
                }
            }
            return url == null ? null : XProxy.getAuthentication(url);
        }

        private static XProxy getProxyForUrl(URL url) {
            Boolean useProxy = USE_PROXY.get();
            if (useProxy != null && !useProxy.booleanValue()) {
                return null;
            }
            String protocol = url.getProtocol();
            XProxy proxy = null;
            if ("ftp".equals(protocol)) {
                proxy = FTP_PROXY.get();
            }
            if ("http".equals(protocol) || "https".equals(protocol)) {
                proxy = HTTP_PROXY.get();
            }
            if (proxy != null && proxy.isDisabled()) {
                proxy = null;
            }
            return proxy;
        }

        static void cleanup() {
            ThreadLocalCookieHandler.clearLocalCookies();
        }

        static {
            ThreadLocalCookieHandler.install();
            Authenticator.setDefault(new XAuthenticator());
        }

        private static class XProxy
        extends Proxy {
            URL url;

            public XProxy(URL url) {
                super(Proxy.Type.HTTP, new InetSocketAddress(url.getHost(), url.getPort()));
                this.url = url;
            }

            static PasswordAuthentication getAuthentication(URL url) {
                String auth = url.getUserInfo();
                if (auth == null) {
                    return null;
                }
                String[] tmp = auth.split(":");
                return new PasswordAuthentication(tmp[0], (tmp.length > 1 ? tmp[1] : "").toCharArray());
            }

            @Override
            public String toString() {
                StringBuilder result = new StringBuilder();
                if (this.url.getUserInfo() != null) {
                    result.append(this.url.getUserInfo()).append('@');
                }
                result.append(this.url.getHost());
                if (this.url.getPort() > 0) {
                    result.append(':').append(this.url.getPort());
                }
                return result.toString();
            }

            public boolean isDisabled() {
                return Strings.isEmpty((CharSequence)this.url.getHost());
            }
        }
    }
}

