/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.TimeZoneHost;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.db.types.DateTimeInterval;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.Constant;
import inform.agent.scripts.Constants;
import inform.agent.scripts.CursorParents;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.Decimal;
import inform.agent.scripts.DirectoryField;
import inform.agent.scripts.NumericField;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.Task;
import inform.agent.scripts.format.FormatManager;
import inform.agent.scripts.util.Binding;
import inform.common.DateFunction;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class ParametersList
extends ScriptableObject {
    private HashMap<String, Parameter> nameHash = new HashMap();
    private IntegerHash<Parameter> idHash = new IntegerHash();
    private ArrayList<Parameter> paramList = new ArrayList(50);
    private boolean hasDatasourceBindings = false;
    private static final String[] availJSFunctionsNames = new String[]{"clearBindings", "toString"};

    public ParametersList() {
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
    }

    public void attachParams(ParametersList parametersList) {
        this.nameHash = parametersList.nameHash;
        this.idHash = parametersList.idHash;
        this.paramList = parametersList.paramList;
        this.hasDatasourceBindings = parametersList.hasDatasourceBindings;
    }

    public Parameter get(int id) {
        return this.idHash.get(id);
    }

    public Parameter get(String name) {
        return this.nameHash.get(name);
    }

    public boolean containsKey(int id) {
        return this.idHash.get(id) != null;
    }

    public boolean containsKey(String name) {
        return this.nameHash.containsKey(name);
    }

    public ArrayList<Parameter> values() {
        return this.paramList;
    }

    public void load(Constants constants, TaggedReader reader, TimeZoneHost timeZoneHost) throws IOException, TaggedReaderException {
        this.load(constants, reader, timeZoneHost, false);
    }

    public Parameter createParameterByField(FieldDescriptor field) {
        Parameter param = this.createParameter(field.getId(), field.getType());
        param.setCaption(field.getCaption());
        String ident = field.getIdent();
        if (!Strings.isVoid(ident)) {
            param.setName(ident);
            this.nameHash.put(param.getName(), param);
        }
        param.setFormatId(field.getFormat());
        return param;
    }

    public Parameter createParameter(DataType type) {
        int id = 0;
        for (Parameter p : this.paramList) {
            id = Math.max(id, p.getId() + 1);
        }
        return this.createParameter(id, type);
    }

    public Parameter createParameter(int id, DataType type) {
        Parameter param = this.createParameter(id, type.getTypeId());
        param.parameterIndex = this.paramList.size();
        this.idHash.add(param);
        this.paramList.add(param);
        param.setIgnore();
        param.setParentScope(this);
        param.clearModified();
        return param;
    }

    public ParametersList cloneModifiedParams() {
        ParametersList list = null;
        for (Parameter p : this.paramList) {
            if (!p.isModified()) continue;
            list = new ParametersList();
            break;
        }
        if (list != null) {
            for (Parameter p : this.paramList) {
                if (!p.isModified()) continue;
                list.idHash.add(p);
                list.paramList.add(p);
            }
        }
        return list;
    }

    public void load(Constants constants, TaggedReader reader, TimeZoneHost timeZoneHost, boolean isBinding) throws IOException, TaggedReaderException {
        int tag;
        byte[] headerBuffer = new byte[8];
        int valIndex = -1;
        Parameter curParam = null;
        block26: do {
            tag = reader.getNextTag();
            switch (tag) {
                case 1: {
                    reader.getRaw(headerBuffer, 8);
                    int paramId = LittleEndian.getInt(headerBuffer, 0);
                    int paramDataTypeId = LittleEndian.getInt(headerBuffer, 4);
                    valIndex = -1;
                    if (isBinding && (curParam = this.get(paramId)) != null) {
                        curParam.clear();
                        curParam.withDateTimeInterval = false;
                        curParam.clearModified();
                        break;
                    }
                    curParam = this.createParameter(paramId, paramDataTypeId);
                    curParam.setParentScope(this);
                    this.idHash.add(curParam);
                    this.paramList.add(curParam);
                    break;
                }
                case 2: {
                    if (isBinding) continue block26;
                    assert (curParam != null);
                    curParam.setCaption(reader.getAnsi());
                    break;
                }
                case 37: {
                    if (isBinding) continue block26;
                    assert (curParam != null);
                    curParam.setReturnValue(true);
                    break;
                }
                case 16: {
                    if (isBinding) continue block26;
                    assert (curParam != null);
                    curParam.setName(reader.getAnsi());
                    this.nameHash.put(curParam.getName(), curParam);
                    break;
                }
                case 22: {
                    if (isBinding) continue block26;
                    assert (curParam != null);
                    curParam.setIsNotNull(true);
                    break;
                }
                case 6: {
                    if (isBinding) continue block26;
                    assert (curParam != null);
                    curParam.hidden(true);
                    break;
                }
                case 18: {
                    if (isBinding) continue block26;
                    assert (curParam != null);
                    curParam.fieldAssoc(reader.getInt());
                    break;
                }
                case 32: {
                    assert (curParam != null);
                    curParam.setDatasourceBinding(reader.getInt());
                    break;
                }
                case 33: {
                    assert (curParam != null);
                    curParam.setFieldBinding(reader.getInt());
                    break;
                }
                case 34: {
                    assert (curParam != null);
                    IntegerSet metadataFilter = curParam.metadataFilter;
                    if (metadataFilter == null) {
                        curParam.metadataFilter = metadataFilter = new IntegerSet();
                    }
                    metadataFilter.add(reader.getInt());
                    break;
                }
                case 30: {
                    if (isBinding) continue block26;
                    assert (curParam != null);
                    curParam.selectedField(reader.getInt());
                    break;
                }
                case 21: {
                    if (curParam == null) continue block26;
                    curParam.setParamBinding(reader.getInt());
                    break;
                }
                case 23: {
                    if (isBinding) continue block26;
                    assert (curParam != null);
                    curParam.setIsOneValue(true);
                    break;
                }
                case 10: {
                    Object curParamValue;
                    Integer val;
                    if (curParam == null) break;
                    Constable constable = curParam.getDataType() == DataType.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(reader.getInt() != 0) : (Comparable<Boolean>)(val = Integer.valueOf(reader.getInt()));
                    if (valIndex >= 0) {
                        curParamValue = curParam.getRawValue();
                        if (curParamValue instanceof Object[]) {
                            ((Object[])curParamValue)[valIndex++] = val;
                        }
                    } else {
                        curParam.setInitValue(val);
                    }
                    if (!isBinding) continue block26;
                    curParam.updateBindingType(DataType.INTEGER);
                    break;
                }
                case 11: {
                    Object curParamValue;
                    if (curParam == null) break;
                    if (valIndex >= 0) {
                        curParamValue = curParam.getRawValue();
                        if (curParamValue instanceof Object[]) {
                            ((Object[])curParamValue)[valIndex++] = reader.getDouble();
                        }
                    } else {
                        curParam.setInitValue(reader.getDouble());
                    }
                    if (!isBinding) break;
                    curParam.updateBindingType(DataType.FLOAT);
                    break;
                }
                case 12: {
                    Object curParamValue;
                    if (curParam == null) continue block26;
                    if (valIndex >= 0) {
                        curParamValue = curParam.getRawValue();
                        if (!(curParamValue instanceof Object[])) break;
                        ((Object[])curParamValue)[valIndex++] = reader.getAnsi();
                        break;
                    }
                    curParam.setInitValue(reader.getAnsi());
                    break;
                }
                case 13: {
                    Object curParamValue;
                    if (curParam == null) continue block26;
                    if (valIndex >= 0) {
                        curParamValue = curParam.getRawValue();
                        if (!(curParamValue instanceof Object[])) break;
                        ((Object[])curParamValue)[valIndex++] = FormatManager.toServerTime(reader.getDouble(), curParam.getFormatId(), timeZoneHost);
                        break;
                    }
                    curParam.setInitValue(FormatManager.toServerTime(reader.getDouble(), curParam.getFormatId(), timeZoneHost));
                    break;
                }
                case 14: {
                    Object curParamValue;
                    if (curParam == null) continue block26;
                    if (valIndex >= 0) {
                        curParamValue = curParam.getRawValue();
                        if (!(curParamValue instanceof Object[])) break;
                        ((Object[])curParamValue)[valIndex++] = null;
                        break;
                    }
                    curParam.setInitValue(null);
                    break;
                }
                case 15: {
                    if (curParam == null) continue block26;
                    curParam.setInitValue(new Object[reader.getInt()]);
                    valIndex = 0;
                    break;
                }
                case 9: {
                    DateFunction function;
                    int functionId;
                    if (curParam == null || (functionId = reader.getInt()) == 0 || (function = DateFunction.fromID(functionId)) == DateFunction.sfNone) continue block26;
                    if (curParam.getDataType() == DataType.DATE_TIME) {
                        curParam.setInitValue(function.getDate());
                        break;
                    }
                    curParam.setInitValue(null);
                    break;
                }
                case 17: {
                    if (curParam == null) continue block26;
                    curParam.setInitConstant(reader.getInt(), constants);
                    break;
                }
                case 7: {
                    if (curParam == null) continue block26;
                    curParam.setIsIgnored(true);
                    break;
                }
                case 3: {
                    if (isBinding) continue block26;
                    assert (curParam != null);
                    curParam.setFormatId(reader.getInt());
                    break;
                }
                case 19: {
                    if (isBinding) continue block26;
                    assert (curParam != null);
                    curParam.refTableId = reader.getNodeID();
                }
            }
        } while (tag != 0);
        if (!isBinding) {
            int index = 0;
            for (Parameter p : this.paramList) {
                p.parameterIndex = index++;
                p.clearModified();
            }
        }
    }

    public void storeFsParameterValue(TaggedWriter writer, DataType type, Object value) throws IOException, InformException {
        if (value == null) {
            writer.putEmpty(14);
        } else {
            switch (type) {
                case BOOLEAN: {
                    writer.putInt32(10, ValueCaster.toBoolean(value) != false ? 1 : 0);
                    break;
                }
                case DATE_TIME: {
                    writer.putDouble(13, ValueCaster.toNumber(value).doubleValue());
                    break;
                }
                case FLOAT: 
                case DIRECTORY: 
                case INTERVAL: 
                case METATREE_NODE: 
                case PRIMARY_KEY: {
                    writer.putDouble(11, ValueCaster.toNumber(value).doubleValue());
                    break;
                }
                case INTEGER: {
                    writer.putInt32(10, ValueCaster.toNumber(value).intValue());
                    break;
                }
                case BIG_NUMBER: 
                case STRING: 
                case UNICODE: {
                    writer.putAnsi(12, ValueCaster.toString(value));
                }
            }
        }
    }

    public void store(TaggedWriter writer) throws IOException {
        for (Parameter p : this.paramList) {
            if (!p.isModified()) continue;
            DataType t = p.getDataType();
            writer.putIntArray(1, new int[]{p.getId(), t.getTypeId()});
            if (p.getIsIgnored()) {
                writer.putEmpty(7);
                continue;
            }
            Object v = p.getRawValue();
            if (v instanceof Object[]) {
                Object[] vv = (Object[])v;
                writer.putInt32(15, vv.length);
                for (Object av : vv) {
                    this.storeFsParameterValue(writer, t, av);
                }
                continue;
            }
            this.storeFsParameterValue(writer, t, v);
        }
    }

    protected Parameter createParameter(int paramId, int paramDataTypeId) {
        return new Parameter(paramId, paramDataTypeId, this.paramList.size());
    }

    public void applyDatasourceBindings(Task task, CursorParents parents) throws Exception {
        if (this.hasDatasourceBindings) {
            for (Parameter parameter : this.paramList) {
                parameter.applyDatasourceBindings(task, parents);
            }
        }
    }

    private void setParamValueByIndexChecked(Parameter parameter, int index, Object value) {
        Object rawValue = parameter.getRawValue();
        if (rawValue instanceof Object[]) {
            Object[] paramValues = (Object[])rawValue;
            if (0 <= index && index < paramValues.length) {
                paramValues[index] = value;
                return;
            }
        }
        throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0438\u0437 \u0442\u0435\u0433\u043e\u0432\u043e\u0433\u043e \u043f\u043e\u0442\u043e\u043a\u0430");
    }

    public void loadParametersBindings(ParametersList taskParameters, Constants constants, TaggedReader reader) throws IOException, TaggedReaderException {
        int tag;
        int valIndex = -1;
        Parameter param = null;
        Parameter ignorable = null;
        Binding binding = null;
        block18: do {
            tag = reader.getNextTag();
            switch (tag) {
                case 1: {
                    reader.skipInt();
                    binding = null;
                    ignorable = null;
                    break;
                }
                case 2: {
                    valIndex = -1;
                    ignorable = null;
                    int paramId = reader.getInt();
                    param = this.get(paramId);
                    if (param == null) break;
                    param.binded = true;
                    param.setIsIgnored(false);
                    break;
                }
                case 4: {
                    if (param == null) break;
                    param.hidden(true);
                    break;
                }
                case 28: {
                    int constId;
                    if (param == null || (constId = reader.getInt()) == 0) continue block18;
                    assert (param != null);
                    Constant constant = constants.get(constId);
                    if (valIndex >= 0) {
                        this.setParamValueByIndexChecked(param, valIndex++, constant);
                    } else {
                        param.setInitConstant(constId, constant);
                    }
                    ignorable = param;
                    param = null;
                    break;
                }
                case 26: {
                    if (param != null) {
                        param.setIsIgnored(true);
                        break;
                    }
                    if (ignorable == null) break;
                    ignorable.setIsIgnored(true);
                    ignorable = null;
                    break;
                }
                case 24: {
                    DateFunction function;
                    int functionId;
                    if (param == null || (functionId = reader.getInt()) == 0 || (function = DateFunction.fromID(functionId)) == DateFunction.sfNone) continue block18;
                    if (param.getDataType() == DataType.DATE_TIME) {
                        param.setInitValue(function.getDate());
                    } else {
                        param.setInitValue(null);
                    }
                    ignorable = param;
                    param = null;
                    break;
                }
                case 15: {
                    if (param == null) break;
                    param.setInitValue(new Object[reader.getInt()]);
                    valIndex = 0;
                    break;
                }
                case 13: {
                    if (param == null) break;
                    if (valIndex >= 0) {
                        this.setParamValueByIndexChecked(param, valIndex++, reader.getDouble());
                        break;
                    }
                    param.setInitValue(reader.getDouble());
                    break;
                }
                case 11: {
                    if (param == null) break;
                    if (valIndex >= 0) {
                        this.setParamValueByIndexChecked(param, valIndex++, reader.getDouble());
                        break;
                    }
                    param.setInitValue(reader.getDouble());
                    break;
                }
                case 10: {
                    Integer val;
                    if (param == null) break;
                    Constable constable = param.getDataType() == DataType.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(reader.getInt() != 0) : (Comparable<Boolean>)(val = Integer.valueOf(reader.getInt()));
                    if (valIndex >= 0) {
                        this.setParamValueByIndexChecked(param, valIndex++, val);
                        break;
                    }
                    param.setInitValue(val);
                    break;
                }
                case 14: {
                    if (param == null) break;
                    if (valIndex >= 0) {
                        this.setParamValueByIndexChecked(param, valIndex++, null);
                        break;
                    }
                    param.setInitValue(null);
                    break;
                }
                case 12: {
                    if (param == null) break;
                    if (valIndex >= 0) {
                        this.setParamValueByIndexChecked(param, valIndex++, reader.getAnsi());
                        break;
                    }
                    param.setInitValue(reader.getAnsi());
                    break;
                }
                case 23: {
                    if (param == null) break;
                    param.setInitValue(this.get(reader.getInt()));
                    break;
                }
                case 21: {
                    int srcParamHost;
                    if (param == null || (srcParamHost = reader.getInt()) == -1) continue block18;
                    binding = new Binding(srcParamHost);
                    break;
                }
                case 22: {
                    if (param == null) break;
                    if (binding != null) {
                        binding.setFieldId(reader.getInt());
                        param.setInitValue(binding);
                        this.hasDatasourceBindings = true;
                        break;
                    }
                    param.setInitValue(taskParameters.get(reader.getInt()));
                    break;
                }
                case 27: {
                    if (param == null) break;
                    param.souCtrlID = reader.getInt();
                }
            }
        } while (tag != 0);
    }

    public void loadParametersValues(Constants constants, TaggedReader reader, TimeZoneHost timeZoneHost) throws IOException {
        int tag;
        Parameter param = null;
        ArrayList paramVal = null;
        DateTimeInterval interval = null;
        block15: do {
            tag = reader.getNextTag();
            switch (tag) {
                case 1: {
                    int paramId = reader.getInt();
                    param = this.get(paramId);
                    if (param == null) continue block15;
                    assert (param != null);
                    paramVal = new ObjectArrayList();
                    param.setInitValue(paramVal);
                    param.setIsIgnored(false);
                    break;
                }
                case 7: {
                    if (param == null) continue block15;
                    assert (param != null);
                    param.setIsIgnored(true);
                    break;
                }
                case 2: {
                    if (param == null) continue block15;
                    assert (param != null);
                    paramVal.add(null);
                    break;
                }
                case 3: {
                    if (param == null) continue block15;
                    assert (param != null);
                    Integer val = param.getDataType() == DataType.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(reader.getInt() != 0) : (Comparable<Boolean>)Integer.valueOf(reader.getInt());
                    paramVal.add(val);
                    break;
                }
                case 4: {
                    if (param == null) continue block15;
                    assert (param != null);
                    paramVal.add(reader.getDouble());
                    break;
                }
                case 5: {
                    if (param == null) continue block15;
                    assert (param != null);
                    paramVal.add(FormatManager.toServerTime(reader.getDouble(), param.getFormatId(), timeZoneHost));
                    break;
                }
                case 6: {
                    if (param == null) continue block15;
                    assert (param != null);
                    paramVal.add(reader.getString());
                    break;
                }
                case 8: {
                    if (param == null) continue block15;
                    assert (param != null);
                    interval = new DateTimeInterval();
                    paramVal.add(interval);
                    interval.setStartDate(FormatManager.toServerTime(reader.getDouble(), param.getFormatId(), timeZoneHost));
                    param.withDateTimeInterval = true;
                    break;
                }
                case 9: {
                    if (param == null) continue block15;
                    assert (param != null);
                    assert (interval != null);
                    interval.setEndDate(FormatManager.toServerTime(reader.getDouble(), param.getFormatId(), timeZoneHost));
                    break;
                }
                case 10: {
                    if (param == null) continue block15;
                    assert (param != null);
                    paramVal.add(reader.getRaw());
                    break;
                }
                case 12: {
                    DateFunction function;
                    int functionId;
                    if (param == null || (functionId = reader.getInt()) == 0 || (function = DateFunction.fromID(functionId)) == DateFunction.sfNone) continue block15;
                    if (param.getDataType() == DataType.DATE_TIME) {
                        param.setInitValue(function.getDate());
                        break;
                    }
                    param.setInitValue(null);
                    break;
                }
                case 13: {
                    if (param == null) continue block15;
                    param.setInitConstant(reader.getInt(), constants);
                    break;
                }
                case 14: {
                    String paramName = reader.getString();
                    param = this.get(paramName);
                    if (param == null) continue block15;
                    assert (param != null);
                    paramVal = new ObjectArrayList();
                    param.setInitValue(paramVal);
                    param.setIsIgnored(false);
                }
            }
        } while (tag != 0);
        for (Parameter p : this.paramList) {
            Object val = p.getRawValue();
            if (val == null || !(val instanceof ObjectArrayList)) continue;
            ObjectArrayList listVal = (ObjectArrayList)val;
            if (listVal.size() == 0) {
                p.setInitValue(null);
                continue;
            }
            if (listVal.size() == 1) {
                p.setInitValue(listVal.get(0));
                continue;
            }
            Object[] arrayVal = new Object[listVal.size()];
            int i = 0;
            for (Object e : listVal) {
                arrayVal[i++] = e;
            }
            p.setInitValue(arrayVal);
        }
    }

    public void storeParameterValue(TaggedWriter writer, DataType type, Object value) throws IOException, InformException {
        if (value == null) {
            writer.putEmpty(2);
        } else {
            switch (type) {
                case BLOB: {
                    writer.putRaw(10, ValueCaster.toBytes(value));
                    break;
                }
                case BOOLEAN: {
                    writer.putInt32(3, ValueCaster.toBoolean(value) != false ? 1 : 0);
                    break;
                }
                case DATE_TIME: {
                    if (value instanceof DateTimeInterval) {
                        DateTimeInterval v = (DateTimeInterval)value;
                        writer.putDouble(8, v.getStartDate());
                        writer.putDouble(9, v.getEndDate());
                        break;
                    }
                    writer.putDouble(5, ValueCaster.toNumber(value).doubleValue());
                    break;
                }
                case FLOAT: 
                case DIRECTORY: 
                case INTERVAL: 
                case METATREE_NODE: 
                case PRIMARY_KEY: {
                    writer.putDouble(4, ValueCaster.toNumber(value).doubleValue());
                    break;
                }
                case INTEGER: {
                    writer.putInt32(3, ValueCaster.toNumber(value).intValue());
                    break;
                }
                case UNICODE: {
                    writer.putUnicode(11, ValueCaster.toString(value));
                    break;
                }
                case BIG_NUMBER: 
                case STRING: {
                    writer.putString(6, ValueCaster.toString(value));
                }
            }
        }
    }

    public void storeModifiedParameters(TaggedWriter out) throws IOException {
        for (Parameter p : this.paramList) {
            if (!p.isModified()) continue;
            this.storeParameter(out, p);
        }
    }

    public byte[] getModifiedParameters() throws IOException {
        ByteArrayOutputStream data = null;
        for (Parameter p : this.paramList) {
            if (!p.isModified()) continue;
            data = new ByteArrayOutputStream();
            break;
        }
        if (data == null) {
            return null;
        }
        TaggedWriter out = new TaggedWriter(data);
        this.storeModifiedParameters(out);
        out.flush();
        return data.size() != 0 ? data.toByteArray() : null;
    }

    public void storeParameter(TaggedWriter writer, Parameter p) throws IOException, InformException {
        this.storeParameter(writer, p, false);
    }

    public void storeParameter(TaggedWriter writer, Parameter p, boolean storeParamName) throws IOException, InformException {
        String paramName;
        writer.putInt32(1, p.getId());
        if (storeParamName && !Strings.isVoid(paramName = p.getName())) {
            writer.putString(14, paramName);
        }
        if (p.getIsIgnored()) {
            writer.putEmpty(7);
        } else {
            DataType t = p.getDataType();
            Object v = p.getRawValue();
            if (v instanceof Object[]) {
                for (Object av : (Object[])v) {
                    this.storeParameterValue(writer, t, av);
                }
            } else {
                this.storeParameterValue(writer, t, v);
            }
        }
    }

    public static void storeNamedParameterValue(TaggedWriter out, Object value) throws IOException {
        if (value == null) {
            out.putEmpty(2);
        } else {
            if (value instanceof NativeJavaObject) {
                value = ((NativeJavaObject)value).unwrap();
            }
            if (value instanceof Number) {
                out.putDouble(4, ValueCaster.toNumber(value).doubleValue());
            } else if (value instanceof NumericField) {
                out.putDouble(4, ValueCaster.toNumber(value).doubleValue());
            } else if (value instanceof DirectoryField) {
                out.putDouble(4, ValueCaster.toNumber(value).doubleValue());
            } else if (value instanceof Decimal) {
                out.putDouble(4, ValueCaster.toNumber(value).doubleValue());
            } else if (value instanceof CharSequence) {
                out.putString(6, ValueCaster.toString(value));
            } else if (value instanceof Boolean) {
                out.putInt32(3, (Boolean)value != false ? 1 : 0);
            } else if (value instanceof BinaryObject) {
                out.putRaw(10, ValueCaster.toBytes(value));
            } else if (value instanceof Date) {
                out.putDouble(5, ValueCaster.toNumber(value).doubleValue());
            } else if (value instanceof DateTimeInterval) {
                DateTimeInterval v = (DateTimeInterval)value;
                out.putDouble(8, v.getStartDate());
                out.putDouble(9, v.getEndDate());
            } else {
                out.putEmpty(2);
            }
        }
    }

    public static void storeNamedParameter(TaggedWriter out, String paramName, Object value) throws IOException {
        if (!Strings.isVoid(paramName)) {
            out.putString(14, paramName);
        }
        if (value == Undefined.instance) {
            out.putEmpty(7);
        } else {
            if (value instanceof NativeJavaObject) {
                value = ((NativeJavaObject)value).unwrap();
            }
            if (value instanceof Object[]) {
                for (Object v : (Object[])value) {
                    ParametersList.storeNamedParameterValue(out, v);
                }
            } else {
                ParametersList.storeNamedParameterValue(out, value);
            }
        }
    }

    public static void loadScriptParams(Scriptable scope, TaggedReader in, Scriptable arg, String[] names) throws IOException {
        int tag;
        ParametersList list = new ParametersList();
        Parameter param = null;
        ArrayList paramVal = null;
        DateTimeInterval interval = null;
        block14: do {
            tag = in.getNextTag();
            switch (tag) {
                case 1: {
                    param = null;
                    break;
                }
                case 7: {
                    if (param == null) continue block14;
                    assert (param != null);
                    param.setIsIgnored(true);
                    break;
                }
                case 2: {
                    if (param == null) continue block14;
                    assert (param != null);
                    paramVal.add(null);
                    break;
                }
                case 3: {
                    if (param == null) continue block14;
                    assert (param != null);
                    Integer val = param.getDataType() == DataType.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(in.getInt() != 0) : (Comparable<Boolean>)Integer.valueOf(in.getInt());
                    paramVal.add(val);
                    break;
                }
                case 4: {
                    if (param == null) continue block14;
                    assert (param != null);
                    paramVal.add(in.getDouble());
                    break;
                }
                case 5: {
                    if (param == null) continue block14;
                    assert (param != null);
                    paramVal.add(in.getDouble());
                    break;
                }
                case 6: {
                    if (param == null) continue block14;
                    assert (param != null);
                    paramVal.add(in.getString());
                    break;
                }
                case 8: {
                    if (param == null) continue block14;
                    assert (param != null);
                    interval = new DateTimeInterval();
                    paramVal.add(interval);
                    interval.setStartDate(in.getDouble());
                    param.withDateTimeInterval = true;
                    break;
                }
                case 9: {
                    if (param == null) continue block14;
                    assert (param != null);
                    assert (interval != null);
                    interval.setEndDate(in.getDouble());
                    break;
                }
                case 10: {
                    if (param == null) break;
                    paramVal.add(new BinaryObject(in.getRaw()));
                    break;
                }
                case 12: {
                    DateFunction function;
                    int functionId;
                    if (param == null || (functionId = in.getInt()) == 0 || (function = DateFunction.fromID(functionId)) == DateFunction.sfNone) continue block14;
                    if (param.getDataType() == DataType.DATE_TIME) {
                        param.setInitValue(function.getDate());
                        break;
                    }
                    param.setInitValue(null);
                    break;
                }
                case 14: {
                    String paramName = in.getString();
                    boolean has = false;
                    for (int i = 0; i < names.length && !(has = names[i].equals(paramName)); ++i) {
                    }
                    if (!has) continue block14;
                    param = list.get(paramName);
                    if (param == null) {
                        param = list.createParameter(list.size(), 0);
                        param.setName(paramName);
                        list.paramList.add(param);
                        list.nameHash.put(paramName, param);
                    }
                    paramVal = new ObjectArrayList();
                    param.setInitValue(paramVal);
                    param.setIsIgnored(false);
                }
            }
        } while (tag != 0);
        for (Parameter p : list.paramList) {
            if (p.getIsIgnored()) {
                arg.put(p.getName(), arg, Undefined.instance);
                continue;
            }
            arg.put(p.getName(), arg, p.jsVal(scope));
        }
    }

    public void applyParamBinding(ParametersList rootParams) {
        if (rootParams == null || rootParams.paramList.isEmpty()) {
            return;
        }
        for (Parameter p : this.paramList) {
            Parameter root;
            if (p.getParamBinding() == 0 || (root = rootParams.get(p.getParamBinding())) == null) continue;
            p.applyParamBinding(root);
        }
    }

    public void checkSettings() {
        for (Parameter parameter : this.paramList) {
            if (parameter.getIsIgnored() || parameter.missingConstantId == 0) continue;
            if (parameter.getIsIgnored()) {
                parameter.missingConstantId = 0;
                continue;
            }
            StringBuilder msg = new StringBuilder();
            msg.append("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 ");
            String text = parameter.getCaption();
            if (!Strings.isVoid(text)) {
                msg.append(text);
            }
            if (!Strings.isVoid(text = parameter.getName())) {
                msg.append('[').append(text).append(']');
            }
            msg.append('[').append(parameter.getId()).append("] \u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0441 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0439 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u043e\u0439 [").append(parameter.missingConstantId).append(']');
            throw new InformException(msg.toString());
        }
    }

    @Override
    public String getClassName() {
        return "Parameters";
    }

    @Override
    public Object get(int index, Scriptable start) {
        return this.paramList.get(index);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.containsKey(name)) {
            if (name.equals("count")) {
                return this.paramList.size();
            }
            for (String f : availJSFunctionsNames) {
                if (!f.equals(name)) continue;
                return super.get(name, start);
            }
            return NOT_FOUND;
        }
        return this.get(name);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.containsKey(name)) {
            if (value instanceof Parameter) {
                try {
                    Parameter parameter = this.get(name);
                    if (parameter != null) {
                        parameter.assignParameter((Parameter)value);
                    }
                }
                catch (InformException ex) {
                    Core.logger.error(null, ex);
                }
            } else if (value instanceof DatasourceField) {
                try {
                    Parameter parameter = this.get(name);
                    if (parameter != null) {
                        parameter.setValue(((DatasourceField)value).getAvailableValue());
                    }
                }
                catch (Exception ex) {
                    Core.logger.error(null, ex);
                }
            }
        } else {
            super.put(name, start, value);
        }
    }

    public String toString() {
        return "Parameters";
    }

    public void clearBindings() {
        for (Parameter p : this.values()) {
            p.clearBinding();
        }
    }

    public void makeWrapUp() {
        if (this.paramList != null) {
            for (Parameter parameter : this.paramList) {
                parameter.makeWrapUp();
            }
        }
    }

    public static class ParametersValues {
        public static final int TAG_FS_VAL_PARAM_ID = 1;
        public static final int TAG_FS_VAL_PARAM_NULL = 2;
        public static final int TAG_FS_VAL_PARAM_INT = 3;
        public static final int TAG_FS_VAL_PARAM_DOUBLE = 4;
        public static final int TAG_FS_VAL_PARAM_DATATIME = 5;
        public static final int TAG_FS_VAL_PARAM_STRING = 6;
        public static final int TAG_FS_VAL_PARAM_IGNORE = 7;
        public static final int TAG_FS_VAL_PARAM_DATATIME_P1 = 8;
        public static final int TAG_FS_VAL_PARAM_DATATIME_P2 = 9;
        public static final int TAG_FS_VAL_PARAM_BLOB = 10;
        public static final int TAG_FS_VAL_PARAM_UNICODE = 11;
        public static final int TAG_FS_VAL_PARAM_FUNCTION_ID = 12;
        public static final int TAG_FS_VAL_PARAM_CONST_ID = 13;
        public static final int TAG_FS_VAL_PARAM_NAME = 14;
    }

    public static class ParametersBindingsTags {
        public static final int TAG_PARAM_MAP_KIND = 1;
        public static final int TAG_PARAM_MAP_PARAM_ID = 2;
        public static final int TAG_PARAM_MAP_DATA_TYPE = 3;
        public static final int TAG_PARAM_MAP_PARAM_HIDDEN = 4;
        public static final int TAG_PARAM_MAP_PARAM_ONEVAL = 6;
        public static final int TAG_PARAM_MAP_PARAM_NOTNULL = 5;
        public static final int TAG_PARAM_MAP_CONST = 28;
        public static final int TAG_PARAM_MAP_DATATIME_FUNC = 24;
        public static final int TAG_PARAM_MAP_IGNORED = 26;
        public static final int TAG_PARAM_MAP_SOU_PARAM_ID = 23;
        public static final int TAG_PARAM_MAP_SOU_UID = 21;
        public static final int TAG_PARAM_MAP_SOU_FIELD_ID = 22;
        public static final int TAG_PARAM_MAP_HIDDEN = 25;
        public static final int TAG_PARAM_MAP_SOU_CTRL_ID = 27;
        public static final int mvkUpdatedValue = 0;
        public static final int mvkOwnParameters = 1;
        public static final int mvkSouField = 2;
        public static final int mvkSouControl = 3;
    }

    public static class SearchParametersTags {
        public static final int TAG_FS_PARAM_HEADER = 1;
        public static final int TAG_FS_PARAM_CAPTION = 2;
        public static final int TAG_FS_PARAM_FORMAT_ID = 3;
        public static final int TAG_FS_PARAM_HIDE = 6;
        public static final int TAG_FS_PARAM_IGNORE = 7;
        public static final int TAG_FS_PARAM_FUNC = 9;
        public static final int TAG_FS_PARAM_VALUE_INT = 10;
        public static final int TAG_FS_PARAM_VALUE_DOUBLE = 11;
        public static final int TAG_FS_PARAM_VALUE_STRING = 12;
        public static final int TAG_FS_PARAM_VALUE_DATATIME = 13;
        public static final int TAG_FS_PARAM_VALUE_NULL = 14;
        public static final int TAG_FS_PARAM_VALUE_ARRAY_COUNT = 15;
        public static final int TAG_FS_PARAM_NAME = 16;
        public static final int TAG_FS_PARAM_CONST = 17;
        public static final int TAG_FS_PARAM_FIELD_ASSOC = 18;
        public static final int TAG_FS_PARAM_TABLE_ASSOC = 19;
        public static final int TAG_FS_PARAM_PARAM = 21;
        public static final int TAG_FS_PARAM_NOTNULL = 22;
        public static final int TAG_FS_PARAM_ONEVALUE = 23;
        public static final int TAG_FS_PARAM_SELECTED_FIELD = 30;
        public static final int TAG_FS_PARAM_ASSOC_DS_UID = 32;
        public static final int TAG_FS_PARAM_ASSOC_FIELD_ID = 33;
        public static final int TAG_FS_PARAM_NODE_TYPE = 34;
        public static final int TAG_FS_PARAM_RETURN_VALUE = 37;
    }

    private static class ObjectArrayList
    extends ArrayList<Object> {
        private ObjectArrayList() {
        }
    }
}

