/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.ServerSideHost;
import inform.agent.db.types.ValueCaster;
import inform.common.SmartScriptableObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class RequestStateDialog
extends SmartScriptableObject {
    private ServerSideHost ssHost;
    private Task task = new Task(null);

    public RequestStateDialog(ServerSideHost ssHost) {
        this.ssHost = ssHost;
    }

    @SmartScriptableObject.PropertyTag
    public String getCaption() {
        return this.task.caption;
    }

    public void setCaption(String caption) throws Exception {
        this.task.caption = caption;
        this.ssHost.putRequestStateCaption(caption);
    }

    @SmartScriptableObject.PropertyTag
    public String getResultText() {
        return this.task.resultText;
    }

    public void setResultText(String text) throws Exception {
        this.task.resultText = text;
        this.ssHost.putRequestStateResultText(text);
    }

    @SmartScriptableObject.PropertyTag
    public String getText() {
        return this.task.text;
    }

    public void setText(String text) throws Exception {
        this.task.text = text;
        this.ssHost.putRequestStateText(text);
    }

    @SmartScriptableObject.PropertyTag
    public String getInstruction() {
        return this.task.instruction;
    }

    public void setInstruction(String instruction) throws Exception {
        this.task.instruction = instruction;
        this.ssHost.putRequestStateInstruction(instruction);
    }

    @SmartScriptableObject.PropertyTag
    public int getPosition() {
        return this.task.pos;
    }

    public void setPosition(int pos) throws Exception {
        this.task.pos = pos;
        this.ssHost.putRequestStateProgressPosition(pos);
    }

    @SmartScriptableObject.FunctionTag
    public void setProgressRange(int min, int max) throws Exception {
        this.task.pos = min;
        this.ssHost.putRequestStateProgressVisible(true);
        this.ssHost.putRequestStateProgressMin(min);
        this.ssHost.putRequestStateProgressMax(max);
        this.ssHost.putRequestStateProgressPosition(this.task.pos);
    }

    @SmartScriptableObject.FunctionTag
    public void next() throws Exception {
        this.ssHost.putRequestStateProgressPosition(++this.task.pos);
    }

    @Override
    public String getClassName() {
        return "RequestStateDialog";
    }

    @SmartScriptableObject.FunctionTag
    public static void writeLog(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        StringBuilder buffer = new StringBuilder();
        boolean spaceNeed = false;
        for (Object o : args) {
            if (spaceNeed) {
                buffer.append(' ');
            }
            spaceNeed = true;
            buffer.append(ValueCaster.toString(o));
        }
        ((RequestStateDialog)thisObj).ssHost.putRequestStateLog(buffer.toString());
    }

    @SmartScriptableObject.FunctionTag
    public void enter() throws Exception {
        this.task = new Task(this.task);
        this.ssHost.putRequestStateEnter();
    }

    @SmartScriptableObject.FunctionTag
    public void leave() throws Exception {
        if (this.task.parent == null) {
            throw new IllegalStateException("requestState stack is empty");
        }
        this.ssHost.putRequestStateLeave();
        this.task = this.task.parent;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsCancelled() {
        return this.ssHost.isCancelled();
    }

    private static class Task {
        private final Task parent;
        private String caption;
        private String text;
        private int pos;
        private String instruction;
        private String resultText;

        public Task(Task parent) {
            this.parent = parent;
        }
    }
}

