/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.CompiledScriptsCache;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Javascript;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptWorker;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.ServerTask;
import inform.agent.scripts.Task;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class Script
extends ServerSideComponent {
    private static final int TAG_SS_SCRIPT_NODE = 40;
    private static final int TAG_SS_SCRIPT_ISOLATED = 41;
    private double nodeId;
    private boolean isolated;
    private Scriptable scriptable;
    protected final SSContext.Component context;
    private String workerLogInfo = null;
    private DoubleHash<ScriptWorker> workers;

    Script(SSContext parentContext, Task task, Scriptable parentScope, ComponentHeader header, TaggedReader reader) throws IOException, InformException {
        super(task, parentScope, header);
        this.context = new SSContext.Component(parentContext, 7);
        this.load(reader);
        this.context.id = this.getId();
    }

    Script(SSContext parentContext, Task task, double nodeId) throws IOException, InformException {
        super(task, "dynamic_module", 0);
        this.nodeId = nodeId;
        this.context = new SSContext.Component(parentContext, 7);
        this.scriptable();
    }

    @Override
    protected void readTag(int tag, TaggedReader reader) throws IOException, InformException {
        switch (tag) {
            case 40: {
                reader.skip();
                this.nodeId = reader.getDouble(151);
                break;
            }
            case 41: {
                this.isolated = true;
            }
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        if ("close".equals(name)) {
            return super.get(name, start);
        }
        Scriptable sc = this.scriptable();
        return sc == null ? super.get(name, start) : sc.get(name, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        this.scriptable();
        return super.get(index, start);
    }

    @Override
    public String getClassName() {
        return "Script";
    }

    @Override
    public Task childTask() {
        return this.scriptable instanceof Task ? (Task)((Object)this.scriptable) : null;
    }

    private Scriptable scriptable() {
        org.mozilla.javascript.Script compiledScript;
        this.context.nodeId = this.nodeId;
        if (this.scriptable != null || this.nodeId == 0.0) {
            return this.scriptable;
        }
        Node nodeInfo = MtdEngine.getValidNode(this.nodeId);
        Scriptable toplevelScope = null;
        ServerSideHost ssHost = this.getTask().getHost();
        if (ssHost instanceof ScriptableHost) {
            toplevelScope = ((ScriptableHost)((Object)ssHost)).getTopLevelScope();
        }
        if (nodeInfo.getType() == 14) {
            Javascript script = new Javascript(this.task, this.nodeId);
            this.scriptable = script;
            script.setParentScope(toplevelScope);
            Javascript.putConstProperty(script, "moduleID", this.nodeId);
        } else if (nodeInfo.getType() == 47) {
            for (Task i = this.getTask(); i != null; i = i.parentTask()) {
                if (i.nodeId() != this.nodeId) continue;
                StringBuilder msg = new StringBuilder();
                msg.append("\u0426\u0438\u043a\u043b\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u0435\u0439: ").append((long)this.nodeId);
                for (i = this.getTask(); i != null; i = i.parentTask()) {
                    msg.append('>').append((long)i.nodeId());
                    if (i.nodeId() == this.nodeId) break;
                }
                throw new InformException(msg.toString());
            }
            ServerTask scriptTask = new ServerTask((SSContext)this.context, this.nodeId, this.getTask().getHost(), this.getTask().getDBManager(), this.getTask());
            this.scriptable = scriptTask;
            try {
                scriptTask.setConstantsContent(this.getTask().getConstantsContent());
                scriptTask.load();
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            scriptTask.setParentScope(toplevelScope);
            if (this.isolated) {
                scriptTask.setIsolated();
            }
        } else {
            throw new UnsupportedOperationException(String.format("\u0422\u0438\u043f \u0443\u0437\u043b\u0430 %d \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u043e\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u044f", nodeInfo.getType()));
        }
        try {
            compiledScript = CompiledScriptsCache.get((BasicNode)nodeInfo);
        }
        catch (IOException e) {
            throw InformException.wrap(e);
        }
        compiledScript.exec(Context.getCurrentContext(), this.scriptable);
        return this.scriptable;
    }

    public Scriptable scriptableOrNull() {
        return this.scriptable;
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws InformException {
        this.internalClose();
        this.getTask().detach(this);
    }

    void internalClose() throws InformException {
        if (this.scriptable instanceof ServerSideExecutable) {
            ((ServerSideExecutable)this.scriptable).close();
        }
        if (this.workers != null) {
            for (ScriptWorker worker : this.workers) {
                if (worker.getIsStandalone() || worker.getIsDone()) continue;
                worker.scriptCancel();
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public ScriptWorker createWorker(double workerId) throws IOException, NoSuchMethodException {
        ScriptWorker worker;
        Scriptable scrip = this.scriptable();
        if (scrip == null) {
            throw new InformException("\u041c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        if (!(scrip instanceof ServerTask)) {
            throw new UnsupportedOperationException("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 worker \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0442\u0438\u043f\u0430 \u0443\u0437\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c");
        }
        if (this.workers == null) {
            this.workers = new DoubleHash();
        }
        if ((worker = this.workers.get(workerId)) != null) {
            throw new InformException("Worker \u0441 \u0442\u0430\u043a\u0438\u043c ID \u0443\u0436\u0435 \u0441\u043e\u0437\u0434\u0430\u043d");
        }
        ServerTask serverTask = (ServerTask)scrip;
        byte[] parameters = serverTask.getModifiedParameters();
        double ownerId = this.task.nodeId();
        if (this.workerLogInfo == null) {
            Node nodeInfo = MtdEngine.getValidNode(ownerId);
            this.workerLogInfo = nodeInfo.getName() + "[" + NumberConverter.doubleToString(ownerId) + ")";
        }
        double userId = this.task.getHost().getUserID();
        worker = new ScriptWorker(workerId, userId, ownerId, this.workerLogInfo, this.nodeId, parameters);
        this.workers.add(worker);
        try {
            worker.launch();
        }
        catch (InterruptedException ex) {
            Core.logger.error(null, ex);
        }
        return worker;
    }

    @SmartScriptableObject.FunctionTag
    public ScriptWorker createJob(double workerId) throws IOException, NoSuchMethodException {
        ScriptWorker worker;
        Scriptable scrip = this.scriptable();
        if (scrip == null) {
            throw new InformException("\u041c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        if (!(scrip instanceof ServerTask)) {
            throw new UnsupportedOperationException("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 worker \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0442\u0438\u043f\u0430 \u0443\u0437\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c");
        }
        if (this.workers == null) {
            this.workers = new DoubleHash();
        }
        if ((worker = this.workers.get(workerId)) != null) {
            throw new InformException("Worker \u0441 \u0442\u0430\u043a\u0438\u043c ID \u0443\u0436\u0435 \u0441\u043e\u0437\u0434\u0430\u043d");
        }
        ServerTask serverTask = (ServerTask)scrip;
        byte[] parameters = serverTask.getModifiedParameters();
        double ownerId = this.task.nodeId();
        if (this.workerLogInfo == null) {
            Node nodeInfo = MtdEngine.getValidNode(ownerId);
            this.workerLogInfo = nodeInfo.getName() + "[" + NumberConverter.doubleToString(ownerId) + ")";
        }
        double userId = this.task.getHost().getUserID();
        worker = new ScriptWorker(workerId, userId, ownerId, this.workerLogInfo, this.nodeId, parameters);
        worker.setStandalone(true);
        this.workers.add(worker);
        try {
            worker.launch();
        }
        catch (InterruptedException ex) {
            Core.logger.error(null, ex);
        }
        return worker;
    }
}

