/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.request.GetMD5;
import inform.agent.db.types.Geometry;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.FileSystemLibrary;
import inform.agent.scripts.libs.MessageDigestOutputStream;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import org.mozilla.javascript.Scriptable;

public class ScriptDigest
extends SmartScriptableObject {
    private final String algorithm;
    private final MessageDigest md;
    private final LittleEndianDataOutputStream out;
    private byte[] finished;

    public ScriptDigest(Scriptable scope, String algorithm) throws NoSuchAlgorithmException {
        this.algorithm = algorithm;
        this.md = MessageDigest.getInstance(algorithm);
        this.out = new LittleEndianDataOutputStream(new MessageDigestOutputStream(this.md));
        this.setParentScope(scope);
    }

    @SmartScriptableObject.FunctionTag
    public void reset() {
        this.finished = null;
        this.md.reset();
    }

    @SmartScriptableObject.FunctionTag
    public ScriptDigest update(Object value) throws Exception {
        if (value instanceof DatasourceField) {
            this.writeField(this.out, (DatasourceField)value);
        } else if (value instanceof Boolean) {
            this.out.writeBoolean((Boolean)value);
        } else if (value instanceof Number) {
            ScriptDigest.writeNumber(this.out, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            this.out.writeUTF8((String)value);
        } else if (value instanceof BinaryObject) {
            BinaryObject bo = (BinaryObject)value;
            byte[] buf = bo.getInternalBuffer();
            int size = bo.getSize();
            this.out.write(buf, 0, size);
        } else if (value instanceof ScriptDigest) {
            byte[] fin = ((ScriptDigest)value).finished;
            if (fin == null) {
                throw new InformException("\u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d \u0440\u0430\u0441\u0447\u0451\u0442 " + this.algorithm + " \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430");
            }
            this.out.write(fin);
        } else if (value instanceof FileSystemLibrary.BinaryReader) {
            int l;
            FileSystemLibrary.BinaryReader r = (FileSystemLibrary.BinaryReader)value;
            byte[] buffer = new byte[4096];
            while ((l = r.read(buffer, 0, buffer.length)) >= 0) {
                this.out.write(buffer, 0, l);
            }
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public void finish() throws IOException {
        this.out.flush();
        this.finished = this.md.digest();
    }

    @SmartScriptableObject.PropertyTag
    public String value() {
        if (this.finished == null) {
            throw new InformException("\u0440\u0430\u0441\u0447\u0451\u0442 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d");
        }
        return Strings.bytes2hex(this.finished);
    }

    private static void writeNumber(LittleEndianDataOutputStream out, double n) throws IOException {
        int i = (int)n;
        double di = i;
        if (di == n) {
            out.writeInt(i);
        } else {
            out.writeDouble(n);
        }
    }

    private void writeField(LittleEndianDataOutputStream out, DatasourceField f) throws Exception {
        if (f.getIsNull()) {
            out.write(GetMD5.NULL);
        }
        switch (f.getDataType()) {
            case BOOLEAN: {
                out.writeBoolean(f.getAsBoolean());
                break;
            }
            case INTEGER: {
                out.writeInt((int)f.getAsNumber());
                break;
            }
            case PRIMARY_KEY: 
            case FLOAT: 
            case DATE_TIME: 
            case INTERVAL: 
            case DIRECTORY: 
            case METATREE_NODE: {
                out.writeDouble(f.getAsNumber());
                break;
            }
            case STRING: 
            case BIG_NUMBER: 
            case UNICODE: {
                String s = f.getAsString();
                if (s == null) break;
                out.writeUTF8(s);
                break;
            }
            case BLOB: {
                MessageDigest md;
                if (f.getDescriptor().getBlobRawType() == FieldDescriptor.BlobRawType.TEXT) {
                    String clob = f.getAsString();
                    out.write(clob.getBytes(TaggedWriter.ANSI));
                    break;
                }
                BinaryObject bo = ((BlobField)f).getAsBinary();
                try {
                    md = MessageDigest.getInstance(this.algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw InformException.wrap(e);
                }
                md.update(bo.getInternalBuffer(), 0, bo.getSize());
                out.write(md.digest());
                break;
            }
            case FILE: {
                MessageDigest md;
                BinaryObject bo = ((BlobFileField)f).getAsBinary();
                try {
                    md = MessageDigest.getInstance(this.algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw InformException.wrap(e);
                }
                md.update(bo.getInternalBuffer(), 0, bo.getSize());
                out.write(md.digest());
                break;
            }
            case GEOMETRY: {
                Geometry g;
                if (f.getIsNull() || (g = (Geometry)f.getValue()) == null) break;
                ByteArrayOutputStream wkb = new ByteArrayOutputStream();
                try {
                    g.serializeWkb(wkb);
                }
                catch (SQLException e) {
                    throw InformException.wrap(e);
                }
                MessageDigest md = null;
                try {
                    md = MessageDigest.getInstance(this.algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw InformException.wrap(e);
                }
                md.update(wkb.internalBuffer(), 0, wkb.size());
                out.write(md.digest());
                break;
            }
            default: {
                throw new InformException("\u0442\u0438\u043f \u043f\u043e\u043b\u044f " + f.getDataType() + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
            }
        }
    }
}

