/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.VirtualRowset;
import inform.agent.scripts.ActualPoint;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.DatasourceFieldList;
import inform.agent.scripts.ServerSideExecutable;
import java.io.IOException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ServerSideRecord
extends ScriptableObject
implements RowsetAccessor {
    protected ServerSideExecutable task;
    protected TableDescriptor metadata = null;
    protected final DatasourceFieldList fields = new DatasourceFieldList();
    protected VirtualRowset rowset = null;
    protected int blobReceiving;
    protected Row tempCurrentRow = null;
    private final int nullSortKind;

    public ServerSideRecord(ServerSideExecutable task, int nullSortKind) {
        this.task = task;
        this.nullSortKind = nullSortKind;
    }

    public DatasourceFieldList getFields() {
        return this.fields;
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.metadata;
    }

    @Override
    public int getNullSortKind() {
        return this.nullSortKind;
    }

    @Override
    public DatasourceField findfieldById(int fieldId) {
        return this.fields.get(fieldId);
    }

    @Override
    public void enableFieldValueGenerator(int fieldIndex, boolean value) {
    }

    @Override
    public void notifySortingFieldModified(Object field) {
    }

    public TableDescriptor getMetadata() {
        return this.metadata;
    }

    public void setBlobReceiving(int blobReceiving) {
        this.blobReceiving = blobReceiving;
    }

    public void setTable(double tableId) throws IOException, InformException {
        this.metadata = TableDescriptor.get(tableId);
        for (FieldDescriptor fd : this.metadata.getFields()) {
            DatasourceField field = DatasourceField.createInstance(this.task.ssContext, this, fd, this.task, this);
            if (field == null) continue;
            this.fields.put(field);
        }
        this.rowset = new VirtualRowset(this.task.ssContext, this.task.getDBManager(), this.metadata, this.blobReceiving);
    }

    protected void compact() {
    }

    public Rowset getResultRowset() {
        this.compact();
        this.rowset.reset();
        return this.rowset;
    }

    ServerSideExecutable getTask() {
        return this.task;
    }

    @Override
    public Row getCurrentRow() throws InformException {
        if (this.tempCurrentRow != null) {
            return this.tempCurrentRow;
        }
        return this.rowset == null ? null : this.rowset.getCurrentRow();
    }

    @Override
    public boolean isCurrentRowAvailable() {
        if (this.tempCurrentRow != null) {
            return true;
        }
        return this.rowset != null && this.rowset.size() > 0;
    }

    @Override
    public AbstractConnectionManager getDBManager() {
        return this.task.getDBManager();
    }

    @Override
    public ServerSideHost getHost() {
        return this.task.getHost();
    }

    @Override
    public String getClassName() {
        return "ServerSideRecord";
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.fields.contains(name)) {
            return super.get(name, start);
        }
        return this.fields.get(name);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.fields.contains(name)) {
            if (value instanceof DatasourceField) {
                try {
                    this.fields.get(name).assignField((DatasourceField)value);
                }
                catch (Exception e) {
                    Core.logger.error("%s in %s", e, this.toString());
                }
            }
        } else {
            super.put(name, start, value);
        }
    }

    @Override
    public boolean internStrings() {
        return false;
    }

    @Override
    public ActualPoint getPeriodicBind() {
        return null;
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        return typeHint == String.class ? this.toString() : super.getDefaultValue(typeHint);
    }
}

