/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.Rowset;
import inform.agent.db.SortDirection;
import inform.agent.db.SortingField;
import inform.agent.db.TableDescriptor;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.ServerSideTableRecord;
import inform.agent.scripts.Task;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class ServerSideTable
extends ServerSideExecutable {
    public static final int TAG_SST_TABLE = 6;
    private static final int TAG_SST_ONQUERYDATA = 7;
    private static final int TAG_SST_DEBUG = 8;
    public static final int TAG_SST_ONAPPEND = 9;
    public static final int TAG_SST_ONCHANGE = 10;
    public static final int TAG_SST_ONDELETE = 11;
    private static final int TAG_SST_SORTING = 40;
    private double tableId;
    private String onQueryData;
    final ServerSideTableRecord table;
    private final ArrayList<SortingField> sorting = new ArrayList();
    private boolean debug = false;
    private int nullSortKind;

    ServerSideTable(SSContext parentContext, int nullSortKind, double nodeID, ServerSideHost ssHost, AbstractConnectionManager dbManager, Task parent) throws IOException, InformException {
        super(parentContext, 7, nodeID, ssHost, dbManager, parent);
        this.nullSortKind = nullSortKind;
        if (this.ssContext != null) {
            this.ssContext.nodeId = nodeID;
            this.ssContext.script = "table";
        }
        this.table = new ServerSideTableRecord(this, nullSortKind);
        ServerSideTable.putConstProperty(this, "table", this.table);
    }

    public ServerSideTableRecord getTable() {
        return this.table;
    }

    public double getTableId() {
        return this.tableId;
    }

    public void setNullSortKind(int nullSortKind) {
        this.nullSortKind = nullSortKind;
    }

    public int getNullSortKind() {
        return this.nullSortKind;
    }

    public void setBlobReceiving(int blobReceiving) {
        this.table.setBlobReceiving(blobReceiving);
    }

    public String getOnQueryData() {
        return this.onQueryData;
    }

    public Rowset getResultRowset() {
        return this.table.getResultRowset();
    }

    @Override
    public String getClassName() {
        return "ServerSideTable";
    }

    @Override
    public void load(TaggedReader reader) throws IOException {
        super.load(reader);
        this.table.chunkSend = !this.isSorting();
    }

    @Override
    protected void loadTag(int tag, TaggedReader reader) throws IOException, InformException {
        switch (tag) {
            case 6: {
                reader.skip();
                this.tableId = reader.getDouble(151);
                this.table.setParentScope(this);
                this.table.setTable(this.tableId);
                break;
            }
            case 7: {
                this.onQueryData = reader.getAnsi();
                break;
            }
            case 8: {
                this.debug = true;
                break;
            }
            case 40: {
                this.sorting.clear();
                TaggedReader stream = reader.getSubStreamReader();
                int[] fieldPath = null;
                SortDirection direction = SortDirection.ASCENDING;
                while (stream.next()) {
                    block6 : switch (stream.getCurrentTag()) {
                        case 43: {
                            fieldPath = LittleEndian.toIntArray(stream.getRaw());
                            switch (stream.getNextTag()) {
                                case 44: {
                                    direction = SortDirection.ASCENDING;
                                    break block6;
                                }
                                case 45: {
                                    direction = SortDirection.DESCENDING;
                                }
                            }
                        }
                    }
                    if (fieldPath == null || fieldPath.length <= 0) continue;
                    TableDescriptor metadata = this.table.getMetadata();
                    SortingField sf = new SortingField(metadata, this.nullSortKind, metadata.getFieldDescriptor(fieldPath[0]), direction, fieldPath);
                    this.sorting.add(sf);
                }
                break;
            }
        }
    }

    public boolean isSorting() {
        return !this.sorting.isEmpty();
    }

    public Collection<SortingField> getSorting() {
        return this.sorting;
    }

    public void setSorting(Collection<SortingField> sorting) {
        this.sorting.clear();
        this.sorting.addAll(sorting);
    }

    public boolean isDebugMode() {
        return this.debug;
    }
}

