/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.agent.RequestStatistics;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.Task;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatManager;
import inform.agent.scripts.libs.SdoLibrary;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class SqlStatement
extends ScriptableObject {
    private static final String[] availableJSMethods = new String[]{"setBlob", "setDouble", "setDateValue", "setString", "setNString", "setInt", "setBoolean", "setGeometry", "execute", "next", "close", "executeBatch", "addBatch", "clearBatch"};
    private static final String[] availableJSProperties = new String[]{"sql", "timeout"};
    private static final String[] availableJSConsts = new String[]{"fields", "updateCount"};
    static final String[] availJSFieldPropertiesNames = new String[]{"asDate", "asDateValue", "asString", "asNumber", "asBoolean", "isNull", "value"};
    private final Task task;
    private AbstractConnectionManager dbManager;
    private DatabaseConnection db;
    private DBConnection scriptDB;
    private long timeout = 2280000L;
    private PreparedStatement stmt;
    private String sqlStatement;
    ResultSet resultSet;
    ResultField[] resultFields;
    private int updateCount = -1;
    private final SSContext ssContext;

    private ResultField createField(int sqlType) throws InformException {
        switch (sqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 1111: 
            case 2005: {
                return new ResultStringField();
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new ResultNumberField();
            }
            case 91: 
            case 92: 
            case 93: {
                return new ResultDateField();
            }
            case -7: 
            case 16: {
                return new ResultBoolField();
            }
            case 2002: {
                return new ResultGeometryField();
            }
            case -2: 
            case 2004: {
                return new ResultBlobField();
            }
        }
        return null;
    }

    SqlStatement(Task task, double connectionID) throws InformException, SQLException {
        this.task = task;
        this.dbManager = task.getDBManager();
        this.db = this.dbManager.getConnection(connectionID, "JS:SqlStatement");
        this.scriptDB = new DBConnection();
        ServerSideHost host = task.getHost();
        SSContext parentContext = host instanceof ScriptableHost ? ((ScriptableHost)((Object)host)).getRootContext() : null;
        SSContext sSContext = this.ssContext = parentContext == null ? null : new SSContext.Component(parentContext, 3);
        if (this.ssContext != null) {
            this.ssContext.nodeId = connectionID;
        }
        this.defineFunctionProperties(availableJSMethods, SqlStatement.class, 0);
        for (String propertyName : availableJSProperties) {
            this.defineProperty(propertyName, SqlStatement.class, 0);
        }
        for (String constName : availableJSConsts) {
            this.defineProperty(constName, SqlStatement.class, 1);
        }
        SqlStatement.putConstProperty(this, "database", task.getDatabase(connectionID));
    }

    @Override
    public String getClassName() {
        return "SqlStatement";
    }

    public void setDouble(int index, Object objValue) throws SQLException, InformException {
        if (objValue == null) {
            this.stmt.setNull(index, SqlDataType.DOUBLE);
        } else {
            double value = ValueCaster.toDouble(objValue);
            this.stmt.setDouble(index, value);
        }
    }

    public void setBlob(int index, Object objValue) throws SQLException, InformException {
        if (objValue == null) {
            this.stmt.setNull(index, SqlDataType.BLOB);
        } else {
            byte[] value = ValueCaster.toBytes(objValue);
            this.stmt.setBlob(index, value);
        }
    }

    public void setInt(int index, Object objValue) throws SQLException, InformException {
        if (objValue == null) {
            this.stmt.setNull(index, SqlDataType.INTEGER);
        } else {
            int value = ValueCaster.toInt(objValue);
            this.stmt.setInt(index, value);
        }
    }

    public void setBoolean(int index, Object objValue) throws SQLException {
        if (objValue == null) {
            this.stmt.setNull(index, SqlDataType.BOOLEAN);
        } else {
            boolean value = ValueCaster.toBoolean(objValue);
            this.stmt.setBoolean(index, value);
        }
    }

    public void setString(int index, Object objValue) throws SQLException, InformException {
        if (objValue == null) {
            this.stmt.setNull(index, SqlDataType.STRING);
        } else {
            String value = ValueCaster.toString(objValue);
            this.stmt.setString(index, value);
        }
    }

    public void setNString(int index, Object objValue) throws SQLException, InformException {
        if (objValue == null) {
            this.stmt.setNull(index, SqlDataType.STRING);
        } else {
            String value = ValueCaster.toString(objValue);
            this.stmt.setNString(index, value);
        }
    }

    public void setDateValue(int index, Object objValue) throws SQLException, InformException {
        if (objValue == null) {
            this.stmt.setNull(index, SqlDataType.TIMESTAMP);
        } else {
            double value = ValueCaster.toDouble(objValue);
            this.stmt.setDateTime(index, value);
        }
    }

    public void setGeometry(int index, Object objValue) throws SQLException, IOException {
        if (this.stmt != null) {
            if (objValue == null) {
                this.stmt.setNull(index, SqlDataType.GEOMETRY);
            } else {
                this.stmt.setGeometry(index, ((SdoLibrary.GeoObject)objValue).toGeometry());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws SQLException {
        this.updateCount = -1;
        ServerSideHost ssh = this.task.getHost();
        ssh.idle();
        if (this.stmt == null) {
            throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d sql \u0432 SqlStatement", new Object[0]));
        }
        RequestStatistics.Value old = ssh.rqstat();
        try {
            long st = System.currentTimeMillis();
            RequestStatistics.Value n = new RequestStatistics.Value();
            n.reset(-4, ssh.getUserID(), 0.0);
            n.ownerId = this.task.nodeId();
            try {
                this.updateCount = this.stmt.execute(this.ssContext);
                if (this.updateCount == -1) {
                    this.prepareResultSet();
                }
            }
            finally {
                n.apply(System.currentTimeMillis() - st);
            }
        }
        finally {
            ssh.rqstat(old);
        }
        ssh.idle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws SQLException {
        this.updateCount = -1;
        ServerSideHost ssh = this.task.getHost();
        ssh.idle();
        RequestStatistics.Value old = ssh.rqstat();
        try {
            long st = System.currentTimeMillis();
            RequestStatistics.Value n = new RequestStatistics.Value();
            n.reset(-4, ssh.getUserID(), 0.0);
            n.ownerId = this.task.nodeId();
            try {
                this.stmt.executeBatch(this.ssContext);
                this.updateCount = this.stmt.getLastBatchUpdateCount();
            }
            finally {
                n.apply(System.currentTimeMillis() - st);
            }
        }
        finally {
            ssh.rqstat(old);
        }
        ssh.idle();
    }

    public void addBatch() throws SQLException, InterruptedException, InformException {
        this.stmt.addBatch();
    }

    public void clearBatch() throws SQLException, InterruptedException, InformException {
        this.stmt.clearBatch();
    }

    private void prepareResultSet() throws SQLException, InformException {
        this.resultSet = this.stmt.getResultSet();
        if (this.resultSet == null) {
            return;
        }
        ResultSetMetaData metadata = this.resultSet.getMetaData();
        int colCount = metadata.getColumnCount();
        this.resultFields = new ResultField[colCount];
        for (int i = 0; i < colCount; ++i) {
            int sqlType = metadata.getColumnType(i + 1);
            String name = metadata.getColumnLabel(i + 1);
            ResultField field = this.createField(sqlType);
            if (field == null) {
                throw new InformException("\u041f\u043e\u043b\u0435 " + name + " \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 " + sqlType);
            }
            field.name = name.toUpperCase();
            field.rawName = name;
            field.init(DataType.getDataTypeBySqlTypeId(sqlType));
            this.resultFields[i] = field;
        }
    }

    public boolean next() throws Exception {
        this.task.getHost().idle();
        if (this.resultSet == null) {
            throw new InformException("SqlStatement \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0430\u0431\u043e\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        if (!this.resultSet.next()) {
            return false;
        }
        for (int i = 0; i < this.resultFields.length; ++i) {
            ResultField field = this.resultFields[i];
            field.isNull = true;
            field.numValue = 0.0;
            field.strValue = null;
            field.load(this.resultSet, i + 1);
        }
        return true;
    }

    public String getSql() {
        return this.sqlStatement;
    }

    public void setSql(String sql) throws SQLException {
        this.internalClose();
        this.stmt = this.db.prepareStatement("SqlStatement", sql);
        this.stmt.setLogDangerSQL();
        this.stmt.setQueryTimeout(this.timeout);
        this.sqlStatement = sql;
    }

    public Object[] getFields() {
        return this.resultFields;
    }

    public void close() throws SQLException {
        this.internalClose();
        this.task.detach(this);
    }

    void internalClose() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.resultFields = null;
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this.resultFields != null) {
            for (ResultField field : this.resultFields) {
                if (!field.name.equals(name)) continue;
                return field;
            }
        }
        return super.get(name, start);
    }

    public int getTimeout() {
        return (int)(this.timeout / 1000L);
    }

    public void setTimeout(int value) {
        this.timeout = value * 1000;
        if (this.stmt != null) {
            this.stmt.setQueryTimeout(this.timeout);
        }
    }

    class DBConnection
    extends ScriptableObject {
        private final String[] availableJSConsts;

        DBConnection() {
            for (String constName : this.availableJSConsts = new String[]{"scheme", "auditScheme"}) {
                this.defineProperty(constName, SqlStatement.class, 1);
            }
        }

        public String getScheme() {
            return SqlStatement.this.db.getDescriptor().getScheme();
        }

        public String getAuditScheme() {
            return SqlStatement.this.db.getDescriptor().getAuditScheme();
        }

        @Override
        public String getClassName() {
            return "DBConnection";
        }
    }

    class ResultBlobField
    extends ResultField {
        private byte[] data;

        public ResultBlobField() {
            this.defineProperty("asBinary", this.getClass(), 1);
        }

        @Override
        public void load(ResultSet rs, int index) throws Exception {
            this.data = rs.getBlobBytes(index);
            this.isNull = this.data == null;
        }

        @Override
        public Object getValue() {
            if (this.isNull) {
                return null;
            }
            return new BinaryObject(this.data);
        }

        @Override
        public String getClassName() {
            return "ResultBlobField";
        }

        public Object getAsBinary() {
            return new BinaryObject(this.data);
        }
    }

    class ResultGeometryField
    extends ResultField {
        Object geometry;

        public ResultGeometryField() {
            this.defineProperty("asGeometry", this.getClass(), 1);
        }

        @Override
        public void load(ResultSet rs, int index) throws Exception {
            this.geometry = SdoLibrary.createGeometryObject(rs.getGeometry(index));
            this.isNull = this.geometry == null;
        }

        @Override
        public Object getValue() {
            if (this.isNull) {
                return null;
            }
            return this.geometry;
        }

        @Override
        public String getClassName() {
            return "ResultGeometryField";
        }

        public Object getAsGeometry() {
            return this.geometry;
        }
    }

    class ResultBoolField
    extends ResultField {
        ResultBoolField() {
        }

        @Override
        public void load(ResultSet rs, int index) throws Exception {
            this.numValue = rs.getBoolean(index) ? 1.0 : 0.0;
            this.isNull = rs.wasNull();
        }

        @Override
        public Object getValue() {
            if (this.isNull) {
                return null;
            }
            return this.numValue != 0.0;
        }

        @Override
        public String getClassName() {
            return "ResultBoolField";
        }

        @Override
        public String getAsString() {
            if (this.strValue == null) {
                this.strValue = this.isNull ? "" : Boolean.toString(this.numValue != 0.0);
            }
            return this.strValue;
        }

        public String toString() {
            return "bool field " + this.name;
        }
    }

    class ResultDateField
    extends ResultField {
        private final Format format;

        ResultDateField() {
            this.format = FormatManager.createFormat(410, DataType.DATE_TIME, null);
        }

        @Override
        public void load(ResultSet rs, int index) throws Exception {
            double value = rs.getDateTime(index);
            this.isNull = rs.wasNull();
            if (!this.isNull) {
                this.numValue = value;
            }
        }

        @Override
        public Object getValue() {
            if (this.isNull) {
                return null;
            }
            return this.numValue;
        }

        @Override
        public String getAsString() {
            if (this.strValue == null) {
                this.strValue = this.isNull ? "" : this.format.format(this.numValue);
            }
            return this.strValue;
        }

        @Override
        public String getClassName() {
            return "ResultDateField";
        }

        public String toString() {
            return "date field " + this.name;
        }
    }

    class ResultNumberField
    extends ResultField {
        ResultNumberField() {
        }

        @Override
        public void load(ResultSet rs, int index) throws Exception {
            this.numValue = rs.getDouble(index);
            this.isNull = rs.wasNull();
        }

        @Override
        public Object getValue() {
            if (this.isNull) {
                return null;
            }
            return this.numValue;
        }

        @Override
        public String getClassName() {
            return "ResultNumberField";
        }

        @Override
        public String getAsString() {
            if (this.strValue == null) {
                this.strValue = this.isNull ? "" : NumberConverter.doubleToString(this.numValue);
            }
            return this.strValue;
        }

        public String toString() {
            return "number field " + this.name;
        }
    }

    class ResultStringField
    extends ResultField {
        ResultStringField() {
        }

        @Override
        public void load(ResultSet rs, int index) throws Exception {
            this.strValue = rs.getString(index);
            this.isNull = rs.wasNull();
            if (this.isNull) {
                this.strValue = "";
            }
        }

        @Override
        public Object getValue() {
            if (this.isNull) {
                return null;
            }
            return this.strValue;
        }

        @Override
        public String getClassName() {
            return "ResultStringField";
        }

        public String toString() {
            return "string field " + this.name;
        }
    }

    abstract class ResultField
    extends ScriptableObject {
        String name;
        String rawName;
        String strValue;
        double numValue;
        byte[] blobValue;
        boolean isNull;

        ResultField() {
        }

        public void init(DataType type) {
            for (String constName : availJSFieldPropertiesNames) {
                this.defineProperty(constName, ResultField.class, 1);
            }
            ResultField.putConstProperty(this, "name", this.name);
            ResultField.putConstProperty(this, "rawName", this.rawName);
            ResultField.putConstProperty(this, "dataType", type.getTypeId());
        }

        public double getAsNumber() {
            return this.numValue;
        }

        public boolean getAsBoolean() {
            return this.numValue != 0.0;
        }

        public boolean getIsNull() {
            return this.isNull;
        }

        public Scriptable getAsDate() {
            Object[] ctorArgs = new Object[]{DateTime.toUnixTime(this.numValue)};
            return Context.getCurrentContext().newObject(((ScriptableHost)((Object)SqlStatement.this.task.getHost())).getTopLevelScope(), "Date", ctorArgs);
        }

        public double getAsDateValue() {
            return this.numValue;
        }

        public String getAsString() {
            return this.strValue;
        }

        public abstract Object getValue();

        public abstract void load(ResultSet var1, int var2) throws Exception;
    }
}

