/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.js.ABON;
import inform.agent.js.Deserialization;
import inform.agent.js.Serialization;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.ScriptableTaggedReader;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class TaggedIOLibrary
extends ScriptableObject {
    private static final String[] jsMethods = new String[]{"createReader", "serialize", "deserialize"};

    public TaggedIOLibrary(Scriptable scope) {
        this.setParentScope(scope);
        this.defineFunctionProperties(jsMethods, TaggedIOLibrary.class, 0);
        TaggedIOLibrary.putConstProperty(this, "TAG_EOF", 0);
        TaggedIOLibrary.putConstProperty(this, "TAG_STREAM", 202);
        TaggedIOLibrary.putConstProperty(this, "TAG_NODE_REF", 151);
        TaggedIOLibrary.putConstProperty(this, "TAG_DATAMODEL", 152);
        TaggedIOLibrary.putConstProperty(this, "TAG_INPUT_PARAMETERS", 153);
        TaggedIOLibrary.putConstProperty(this, "TAG_OBJECT_ACL", 154);
        TaggedIOLibrary.putConstProperty(this, "TAG_NODE_BASED_ACL", 155);
        TaggedIOLibrary.putConstProperty(this, "TAG_OBJECT_ACCESS", 156);
        TaggedIOLibrary.putConstProperty(this, "TAG_CONTROL_PARAMETER", 157);
        TaggedIOLibrary.putConstProperty(this, "TAG_DATASOURCE_DEFINITION", 158);
        TaggedIOLibrary.putConstProperty(this, "TAG_DATASOURCE_FIELD_REF", 159);
        TaggedIOLibrary.putConstProperty(this, "TAG_CONST_REF", 160);
        TaggedIOLibrary.putConstProperty(this, "TAG_TABLE_FIELD_NAMESPACE", 161);
        TaggedIOLibrary.putConstProperty(this, "TAG_DATASOURCE_FIELD_NAMESPACE", 162);
        TaggedIOLibrary.putConstProperty(this, "TAG_FIELD_REF", 163);
        TaggedIOLibrary.putConstProperty(this, "TAG_DATAMODEL_REF", 164);
    }

    public static Object createReader(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object obj;
        byte[] data = null;
        int size = 0;
        if (args.length > 0 && (obj = args[0]) instanceof BinaryObject) {
            BinaryObject binObj = (BinaryObject)obj;
            data = binObj.getInternalBuffer();
            size = binObj.getSize();
        }
        return new ScriptableTaggedReader(thisObj, data, size);
    }

    public static byte[] serializeObject(Object object) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        Serialization s = new Serialization();
        try {
            s.Serialize(object, writer);
            writer.flush();
            stream.flush();
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw InformException.wrap(e);
        }
    }

    public BinaryObject serialize(Object obj) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(result);
        ABON.serialize(obj, writer);
        return new BinaryObject(result.toByteArray());
    }

    public Object deserialize(Object obj) throws IOException, TaggedReaderException {
        if (!(obj instanceof BinaryObject)) {
            throw new InformException("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f BinaryObject");
        }
        BinaryObject binObj = (BinaryObject)obj;
        if (binObj.getSize() == 0) {
            return null;
        }
        TaggedReader reader = new TaggedReader(BinaryObject.toInputStream(binObj), binObj.getSize());
        if (!reader.next() || reader.getCurrentTag() == 3 || reader.getCurrentTag() == 5 || reader.getCurrentTag() == 1) {
            Deserialization d = new Deserialization(Context.getCurrentContext(), this.getParentScope());
            return d.DeserializeCurrent(reader);
        }
        reader.tagback();
        return ABON.deserialize(reader, Context.getCurrentContext(), this.getParentScope());
    }

    public static Object deserializeToJS(Context cx, Scriptable scope, TaggedReader reader) throws IOException, TaggedReaderException {
        if (!reader.next() || reader.getCurrentTag() == 3 || reader.getCurrentTag() == 5 || reader.getCurrentTag() == 1) {
            Deserialization d = new Deserialization(cx, scope);
            return d.DeserializeCurrent(reader);
        }
        reader.tagback();
        return ABON.deserialize(reader, cx, scope);
    }

    @Override
    public String getClassName() {
        return "TaggedIO";
    }
}

