/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.schemes.DxfWriter;
import inform.agent.schemes.MifWriter;
import inform.agent.schemes.OdgWriter;
import inform.agent.schemes.PdfWriter;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemesManager;
import inform.agent.schemes.SvgWriter;
import inform.agent.schemes.VsdxWriter;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.WebCanvas;
import inform.agent.scripts.WebImage;
import inform.agent.srv.ProxyConverterService;
import java.util.zip.GZIPOutputStream;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class WebCanvasLibrary
extends ScriptableObject {
    private static final String[] availJSFunctionsNames = new String[]{"createCanvas2D", "imageFromNode", "convertAvesTo"};

    public WebCanvasLibrary(Scriptable scope) {
        this.setParentScope(scope);
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
    }

    @Override
    public String getClassName() {
        return "WebCanvasLibrary";
    }

    public Object createCanvas2D(int width, int height) {
        return new WebCanvas(this.getParentScope(), width, height);
    }

    public Object imageFromNode(double nodeid) {
        return new WebImage(this.getParentScope(), nodeid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryObject convertAvesTo(String format, BinaryObject data, double keepSettingID, double tableID, int fieldID, double recordID) throws Exception {
        SchemeKeepSettings keepSettings = null;
        if (!Double.isNaN(keepSettingID) && keepSettingID != 0.0) {
            Node node = MtdEngine.getNode(keepSettingID);
            if (node == null) {
                throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c");
            }
            if (node.getType() != 52) {
                throw new InformException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0437\u043b\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c");
            }
            byte[] nodeContent = MtdEngine.getNodeContent(keepSettingID);
            if (nodeContent != null && nodeContent.length > 0) {
                keepSettings = new SchemeKeepSettings(new TaggedReader(nodeContent));
            }
        }
        ConnectionManager dbMgr = new ConnectionManager(null, "js:convertAvesTo");
        try {
            byte[] content;
            Scheme scheme = null;
            byte[] byArray = content = data == null ? null : data.getInternalBuffer();
            if (content != null && content.length > 0) {
                double id = 1.0;
                scheme = SchemesManager.getScheme(id, content, dbMgr.getSSHost(), keepSettings);
            } else if (!Double.isNaN(tableID) && !Double.isNaN(recordID) && tableID != 0.0 && fieldID != 0 && recordID != 0.0) {
                int dateFieldID = keepSettings == null ? 0 : keepSettings.getSchemeDate();
                scheme = SchemesManager.getScheme(null, dbMgr, tableID, recordID, fieldID, dateFieldID, false, true, keepSettings);
            }
            if (scheme == null) {
                BinaryObject dateFieldID = null;
                return dateFieldID;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if ("aves".equalsIgnoreCase(format)) {
                scheme.saveAll(out, null, true, false);
            } else if ("dxf".equalsIgnoreCase(format)) {
                DxfWriter dxfWriter = new DxfWriter(scheme);
                dxfWriter.saveToStream(dbMgr, out);
            } else if ("svg".equalsIgnoreCase(format)) {
                SvgWriter svgWriter = new SvgWriter(scheme);
                svgWriter.saveToStream(dbMgr, out);
            } else if ("pdf".equalsIgnoreCase(format)) {
                PdfWriter pdfWriter = new PdfWriter(scheme);
                pdfWriter.saveToStream(dbMgr, out);
            } else if ("mif".equalsIgnoreCase(format) || "mid".equalsIgnoreCase(format)) {
                MifWriter mifWriter = new MifWriter(scheme);
                mifWriter.saveToStream(dbMgr, out);
            } else if ("vsdx".equalsIgnoreCase(format)) {
                VsdxWriter vsdxWriter = new VsdxWriter(scheme);
                vsdxWriter.saveToStream(dbMgr, out);
            } else {
                OdgWriter odfWriter;
                if ("vsd".equalsIgnoreCase(format)) {
                    VsdxWriter vsdxConverter = new VsdxWriter(scheme);
                    vsdxConverter.saveToStream(dbMgr, out);
                    BinaryObject binaryObject = new BinaryObject(ProxyConverterService.convertVSDXtoVSD(dbMgr.getSSHost(), out.toByteArray()));
                    return binaryObject;
                }
                if ("svgz".equalsIgnoreCase(format)) {
                    SvgWriter svgzWriter = new SvgWriter(scheme);
                    svgzWriter.saveToStream(dbMgr, new GZIPOutputStream(out));
                } else if ("odg".equalsIgnoreCase(format) || "otg".equalsIgnoreCase(format)) {
                    odfWriter = new OdgWriter(scheme);
                    odfWriter.saveToStream(dbMgr, out, false);
                } else if ("fodg".equalsIgnoreCase(format)) {
                    odfWriter = new OdgWriter(scheme);
                    odfWriter.saveToStream(dbMgr, out, true);
                } else {
                    throw new InformException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 ('" + format + "') \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 \u0441\u0445\u0435\u043c\u044b AVES");
                }
            }
            BinaryObject binaryObject = new BinaryObject(out.toByteArray());
            return binaryObject;
        }
        finally {
            dbMgr.release();
        }
    }
}

