/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.crypto.CryptoCertificate;
import inform.agent.scripts.crypto.CryptoPrivateKey;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.agent.scripts.crypto.CryptoXmlCipher;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xpath.XPathAPI;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CryptoSoapCipher
extends CryptoXmlCipher {
    private byte[] soapEnvelopeMessage = null;
    private CryptoCertificate responceCertificate = null;

    public CryptoSoapCipher(Scriptable scope, CryptoPrivateKey privateKey, CryptoCertificate certificate, String exchKeyAlgName, String algorithmName) {
        super(scope, privateKey, certificate, exchKeyAlgName, algorithmName);
    }

    @Override
    public String getClassName() {
        return "SoapCipher";
    }

    @Override
    @SmartScriptableObject.FunctionTag
    public BinaryObject encrypt(String transportName, String cipherName, boolean contentOnly, Object data, Object codepage) throws Exception {
        Document encryptedDoc = this.doEncrypt(transportName, cipherName, data, codepage, contentOnly);
        Node encryptedData = XPathAPI.selectSingleNode((Node)encryptedDoc, (String)"//*[local-name()='EncryptedData']");
        if (encryptedData == null) {
            throw new Exception("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0443\u0437\u0435\u043b c \u0438\u043c\u0435\u043d\u0435\u043c EncryptedData");
        }
        assert (encryptedData != null);
        Document soapDoc = this.doSoapEnvelope(encryptedData);
        return new BinaryObject(CryptoUtils.documentAsBytes(soapDoc));
    }

    @SmartScriptableObject.FunctionTag
    public void setEnvelope(Object data, Object codepage) throws Exception {
        this.soapEnvelopeMessage = CryptoUtils.dataAsBytes(data, codepage);
    }

    @SmartScriptableObject.FunctionTag
    public void setResponceCertificate(CryptoCertificate certificate) {
        this.responceCertificate = certificate;
    }

    private Document doSoapEnvelope(Node contentNode) throws Exception {
        if (this.soapEnvelopeMessage == null || this.soapEnvelopeMessage.length == 0) {
            throw new Exception("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u0430\u0440\u043a\u0430\u0441 SOAP-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f");
        }
        if (this.responceCertificate != null) {
            Node certificateNode = XPathAPI.selectSingleNode((Node)contentNode, (String)"//*[local-name()='X509Certificate']");
            if (certificateNode == null) {
                throw new Exception("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0443\u0437\u0435\u043b c \u0438\u043c\u0435\u043d\u0435\u043c X509Certificate");
            }
            certificateNode.setTextContent(this.responceCertificate.getAsBase64());
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setCoalescing(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        Document doc = documentBuilder.parse(new ByteArrayInputStream(this.soapEnvelopeMessage));
        Node body = XPathAPI.selectSingleNode((Node)doc.getDocumentElement(), (String)"//*[local-name()='Body']");
        if (body == null) {
            throw new Exception("\u0412 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u043c \u043a\u0430\u0440\u043a\u0430\u0441\u0435 SOAP-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0443\u0437\u0435\u043b c \u0438\u043c\u0435\u043d\u0435\u043c Body");
        }
        Node n = doc.importNode(contentNode, true);
        body.appendChild(n);
        return doc;
    }

    @Override
    protected Document doDecrypt(Document srcDoc) throws Exception {
        Node encryptedData = XPathAPI.selectSingleNode((Node)srcDoc, (String)"//*[local-name()='EncryptedData']");
        if (encryptedData == null) {
            throw new Exception("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0443\u0437\u0435\u043b c \u0438\u043c\u0435\u043d\u0435\u043c EncryptedData");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setCoalescing(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        Document doc = documentBuilder.newDocument();
        Node n = doc.importNode(encryptedData, true);
        doc.appendChild(n);
        super.doDecrypt(doc);
        if (XPathAPI.selectSingleNode((Node)doc.getDocumentElement(), (String)"//*[local-name()='Envelope']/*[local-name()='Body']") != null) {
            return doc;
        }
        return super.doDecrypt(srcDoc);
    }
}

