/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.crypto.CryptoCertificate;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.agent.scripts.crypto.CryptoXmlSignature;
import inform.agent.scripts.crypto.XmlVerifyResults;
import inform.agent.scripts.crypto.XmlVerifyValue;
import inform.common.Base64BinString;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xpath.XPathAPI;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.CryptoPro.JCPxml.dsig.internal.dom.XMLDSigRI;

public class CryptoSoapSignature
extends CryptoXmlSignature {
    public CryptoSoapSignature(Scriptable scope) {
        super(scope);
    }

    @Override
    public String getClassName() {
        return "SoapSignature";
    }

    @Override
    @SmartScriptableObject.FunctionTag
    public BinaryObject sign(Object data, Object codepage) throws Exception {
        if (this.signMethod == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0438");
        }
        if (this.digestMethod == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c\u0430 \u043f\u043e\u0434\u0441\u0447\u0435\u0442\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0441\u0443\u043c\u043c\u044b");
        }
        if (this.privateKey == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430");
        }
        if (this.certificate == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430");
        }
        byte[] value = CryptoUtils.dataAsBytes(data, codepage);
        if (value == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        }
        Document doc = CryptoUtils.loadDocument(value);
        Node header = XPathAPI.selectSingleNode((Node)doc, (String)"./*[local-name()='Envelope']/*[local-name()='Header']");
        Element security = doc.createElement("wsse:Security");
        security.setAttribute("xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (this.actorValue != null && !this.actorValue.isEmpty()) {
            security.setAttribute(this.actorName, this.actorValue);
        }
        header.appendChild(security);
        Element token = doc.createElement("wsse:BinarySecurityToken");
        security.appendChild(token);
        token.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        token.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        token.setAttribute("wsu:Id", this.signatureId);
        XMLDSigRI xmlDSigProvider = new XMLDSigRI();
        Transforms transforms = new Transforms(doc);
        transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)xmlDSigProvider);
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        Transform transformC14N = fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", (XMLStructure)null);
        transformList.add(transformC14N);
        Reference ref = fac.newReference("#" + this.documentId, fac.newDigestMethod(this.digestMethod, null), transformList, null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), fac.newSignatureMethod(this.signMethod, null), Collections.singletonList(ref));
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        X509Data x509d = kif.newX509Data(Collections.singletonList(this.certificate.certificate()));
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(x509d));
        XMLSignature sig = fac.newXMLSignature(si, ki);
        DOMSignContext signContext = new DOMSignContext(this.privateKey.privateKey(), (Node)security);
        signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        sig.sign(signContext);
        NodeList nodeList = XPathAPI.selectNodeList((Node)signContext.getParent(), (String)"//ds:Signature");
        Element sigE = (Element)nodeList.item(nodeList.getLength() - 1);
        NodeList keyList = XPathAPI.selectNodeList((Node)sigE, (String)"//ds:KeyInfo");
        Node keyE = keyList.item(keyList.getLength() - 1);
        token.setTextContent(XPathAPI.selectSingleNode((Node)keyE, (String)"//ds:X509Certificate", (Node)keyE).getFirstChild().getNodeValue());
        keyE.removeChild(XPathAPI.selectSingleNode((Node)keyE, (String)"//ds:X509Data", (Node)keyE));
        NodeList chl = keyE.getChildNodes();
        for (int i = 0; i < chl.getLength(); ++i) {
            keyE.removeChild(chl.item(i));
        }
        Node str = keyE.appendChild(doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference"));
        Element strRef = (Element)str.appendChild(doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference"));
        strRef.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        strRef.setAttribute("URI", "#" + this.signatureId);
        security.appendChild(sigE);
        return new BinaryObject(CryptoUtils.documentAsBytes(doc));
    }

    @Override
    @SmartScriptableObject.FunctionTag
    public XmlVerifyResults verify(Object data, Object codepage) throws Exception {
        byte[] value = CryptoUtils.dataAsBytes(data, codepage);
        if (value == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        }
        Document doc = CryptoUtils.loadDocument(value);
        Element wssecontext = doc.createElementNS(null, "namespaceContext");
        wssecontext.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        NodeList secnodeList = XPathAPI.selectNodeList((Node)doc.getDocumentElement(), (String)"//wsse:Security");
        if (secnodeList == null || secnodeList.getLength() == 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 Security.");
        }
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl == null || nl.getLength() == 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 Signature.");
        }
        if (nl.getLength() != secnodeList.getLength()) {
            throw new Exception("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 Signature (" + nl.getLength() + ") \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e\u043c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 Security (" + secnodeList.getLength() + ")");
        }
        NodeList tokenList = XPathAPI.selectNodeList((Node)doc.getDocumentElement(), (String)"//wsse:BinarySecurityToken");
        if (tokenList.getLength() != secnodeList.getLength()) {
            throw new Exception("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 BinarySecurityToken (" + tokenList.getLength() + ") \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e\u043c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 Security (" + secnodeList.getLength() + ")");
        }
        XMLDSigRI xmlDSigProvider = new XMLDSigRI();
        XmlVerifyResults results = new XmlVerifyResults(this);
        for (int i = 0; i < tokenList.getLength(); ++i) {
            Element r = (Element)tokenList.item(i);
            byte[] tokenData = Base64BinString.Decode(r.getTextContent());
            Certificate cert = CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(tokenData));
            if (cert == null) {
                throw new Exception("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
            }
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)xmlDSigProvider);
            DOMValidateContext valContext = new DOMValidateContext(KeySelector.singletonKeySelector(cert.getPublicKey()), nl.item(i));
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            boolean validity = signature.validate(valContext);
            results.list.add(new XmlVerifyValue((Scriptable)results, new CryptoCertificate((Scriptable)results, cert), validity));
        }
        return results;
    }
}

