/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.expr;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.expr.SSTableArgument;
import java.util.Arrays;

public class SSTableValue
extends SSTableArgument {
    private final DataType dataType;
    private final ValueTerm value;
    private boolean compacted = false;

    public SSTableValue(ValueTerm term) {
        super(term);
        this.dataType = term.getType();
        this.value = term;
    }

    @Override
    public boolean execute() {
        throw new IllegalStateException();
    }

    @Override
    boolean isNull() throws Exception {
        if (this.value.getRawValue() == null) {
            return true;
        }
        if (SSTableValue.isStringable(this.dataType)) {
            return ValueCaster.toString(this.value.getRawValue()).trim().length() == 0;
        }
        return false;
    }

    @Override
    int valueCount() {
        return this.value.valueCount();
    }

    @Override
    Object getValue() throws Exception {
        return this.value.getRawValue();
    }

    @Override
    DataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isStringType() throws Exception {
        return SSTableValue.isStringable(this.dataType);
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored();
    }

    @Override
    public void compactNulls() {
        if (this.compacted) {
            return;
        }
        this.compacted = true;
        if (this.isIgnored()) {
            return;
        }
        if (!this.hasNull()) {
            return;
        }
        Object raw = this.value.getRawValue();
        if (raw == null) {
            return;
        }
        if (raw instanceof Object[]) {
            if (this.isSingleNull()) {
                this.value.setValue(this.dataType, null);
                return;
            }
            Object[] array = (Object[])raw;
            if (array.length == 0) {
                return;
            }
            if (array.length == 1) {
                return;
            }
            Object[] compact = new Object[array.length];
            int compactCount = 0;
            for (Object v : array) {
                if (v == null) continue;
                compact[compactCount++] = v;
            }
            if (compactCount == array.length) {
                return;
            }
            this.value.setValue(this.dataType, Arrays.copyOf(compact, compactCount));
        }
    }

    @Override
    public void compactNonNulls(boolean findMin, boolean ignoreCase) {
        if (this.compacted) {
            return;
        }
        this.compacted = true;
        if (this.isIgnored()) {
            return;
        }
        Object raw = this.value.getRawValue();
        if (raw != null && raw instanceof Object[]) {
            Object[] array = (Object[])raw;
            if (array.length == 0) {
                return;
            }
            if (array.length == 1) {
                return;
            }
            raw = null;
            for (Object v : array) {
                if (v == null) continue;
                if (raw == null) {
                    raw = v;
                    continue;
                }
                try {
                    switch (this.dataType) {
                        case PRIMARY_KEY: 
                        case INTEGER: 
                        case FLOAT: 
                        case DATE_TIME: 
                        case INTERVAL: 
                        case DIRECTORY: 
                        case METATREE_NODE: 
                        case BOOLEAN: {
                            if (findMin) {
                                if (!(ValueCaster.toDouble(raw) > ValueCaster.toDouble(v))) break;
                                raw = v;
                                break;
                            }
                            if (!(ValueCaster.toDouble(raw) < ValueCaster.toDouble(v))) break;
                            raw = v;
                            break;
                        }
                        case STRING: 
                        case BIG_NUMBER: 
                        case UNICODE: {
                            int cmp = ignoreCase ? ValueCaster.toString(raw).compareToIgnoreCase(ValueCaster.toString(v)) : ValueCaster.toString(raw).compareTo(ValueCaster.toString(v));
                            if (findMin) {
                                if (cmp <= 0) break;
                                raw = v;
                                break;
                            }
                            if (cmp >= 0) break;
                            raw = v;
                            break;
                        }
                    }
                }
                catch (InformException e) {
                    Core.logger.error(null, e);
                }
            }
            if (raw != null) {
                this.value.setValue(this.dataType, raw);
            }
        }
    }

    public boolean isSingleNull() {
        if (this.isIgnored()) {
            return false;
        }
        Object raw = this.value.getRawValue();
        if (raw == null) {
            return true;
        }
        if (raw instanceof Object[]) {
            Object[] array;
            for (Object v : array = (Object[])raw) {
                if (v == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasNull() {
        if (this.value == null) {
            return false;
        }
        if (this.value.getIsIgnored()) {
            return false;
        }
        Object raw = this.value.getRawValue();
        if (raw == null) {
            return true;
        }
        if (raw instanceof Object[]) {
            for (Object r : (Object[])raw) {
                if (r != null) continue;
                return true;
            }
        }
        return false;
    }
}

