/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

import inform.adt.InformException;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.format.FormatAligment;
import inform.common.SmartScriptableObject;

public class Format
extends SmartScriptableObject {
    public final int id;

    protected Format(int id) {
        this.id = id;
    }

    protected final String setThousandSeparators(String value, String separator) {
        if (value.length() <= 3) {
            return value.trim();
        }
        StringBuilder result = new StringBuilder();
        result.append(value.substring(0, value.length() % 3));
        for (int i = result.length(); i < value.length(); i += 3) {
            result.append(separator);
            result.append(value.substring(i, i + 3));
        }
        return result.toString().trim();
    }

    public FormatAligment getAlignment() {
        return FormatAligment.LEFT;
    }

    @SmartScriptableObject.FunctionTag
    public String format(Object value) throws InformException {
        return ValueCaster.toString(value);
    }

    public DataType getDataType() {
        return DataType.STRING;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getClassName() {
        return "Format";
    }
}

