/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectsTypes;
import inform.agent.schemes.SchemesManager;
import inform.agent.scripts.SSContext;
import inform.common.SmartScriptableObject;
import org.mozilla.javascript.Scriptable;

public class SchemeDescriptor
extends SmartScriptableObject {
    private double ID = 0.0;
    private double keepNode = 0.0;
    private SchemeKeepSettings keepSettings = null;
    private final SSContext ssContext;
    private static final String[] availJSPropertiesNames = new String[]{"ID", "keepNode", "name"};
    private static final String[] availJSFunctionsNames = new String[]{"tilePointToScheme", "tileXyzToScheme", "shapeByID", "shapeByPoint", "shapeByXY", "shapeByTilePoint", "shapeByTileXyz", "layersCount", "layer"};

    public SchemeDescriptor(Scriptable scope, double keepNodeID, double schemeID, SSContext context) {
        this.ssContext = context;
        this.keepNode = keepNodeID;
        this.ID = schemeID;
        this.setParentScope(scope);
        for (String s : availJSPropertiesNames) {
            this.defineProperty(s, this.getClass(), 1);
        }
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
    }

    @Override
    public String getClassName() {
        return "Scheme";
    }

    @SmartScriptableObject.PropertyTag
    public double getKeepNode() {
        return this.keepNode;
    }

    @SmartScriptableObject.PropertyTag
    public double getID() {
        return this.ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scheme getScheme() throws Throwable {
        Scheme scheme = null;
        if (this.keepNode != 0.0 && this.ID != 0.0) {
            if (this.keepSettings == null) {
                BasicNode node = MtdEngine.getValidNode(this.keepNode).getRealNode();
                if (node == null) {
                    throw new InformException("MtdEngine.getValidNode node == null");
                }
                if (node.getType() != 52) {
                    throw new InformException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f \u0443\u0437\u0435\u043b \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c [" + NumberConverter.doubleToString(this.keepNode) + "] \u0442\u0438\u043f \u0443\u0437\u043b\u0430 (" + node.getType() + ")");
                }
                byte[] content = node.getContent();
                if (content.length > 0) {
                    TaggedReader reader = new TaggedReader(content);
                    this.keepSettings = new SchemeKeepSettings(reader);
                    if (this.keepSettings.getSchemeTable() == 0.0) {
                        throw new InformException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0441\u0445\u0435\u043c \u0432 \u0443\u0437\u043b\u0435 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c");
                    }
                    if (this.keepSettings.getSchemeBlob() == 0) {
                        throw new InformException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043f\u043e\u043b\u0435 \u0441\u0445\u0435\u043c\u044b \u0432 \u0443\u0437\u043b\u0435 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c");
                    }
                } else {
                    throw new InformException("\u041d\u0443\u043b\u0435\u0432\u043e\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0443\u0437\u043b\u0430 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c");
                }
            }
            ConnectionManager dbMgr = new ConnectionManager(this.ssContext, "SchemeDescriptor");
            try {
                scheme = SchemesManager.getScheme(this.ssContext, dbMgr, this.keepSettings.getSchemeTable(), this.ID, this.keepSettings.getSchemeBlob(), this.keepSettings.getSchemeDate(), true, true, this.keepSettings);
                if (scheme != null) {
                    scheme.parse(dbMgr, false);
                    scheme.sortObjects();
                    scheme.calcSchemeBounds();
                }
            }
            finally {
                dbMgr.release();
            }
        }
        return scheme;
    }

    public Object tilePointToScheme(TilePoint point) throws InformException, Throwable {
        Object res = null;
        if (point != null) {
            res = this.tileXyzToScheme(point.x, point.y, point.z);
        }
        return res;
    }

    public Object tileXyzToScheme(int x, int y, int z) throws InformException, Throwable {
        Scheme scheme;
        Point res = null;
        if (z >= 0 && (scheme = this.getScheme()) != null) {
            double w = scheme.getSchemeWidth();
            double h = scheme.getSchemeHeight();
            double k = 1.0;
            k = w >= h ? w / (256.0 * Math.pow(2.0, z)) : h / (256.0 * Math.pow(2.0, z));
            double x1 = scheme.getSchemeLeft() + k * (double)x;
            double y1 = scheme.getSchemeTop() + k * (double)y;
            res = new Point(this.getParentScope(), x1, y1);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getShapeDescriptor(SchemeObject so, Scheme scheme) throws InformException, Throwable {
        ShapeDescriptor res = null;
        if (so != null && scheme != null) {
            SchemeObject schemeObject = so;
            synchronized (schemeObject) {
                if (!so.isDeleted() && SchemeObjectsTypes.ObjTypeIsShape(so.getType()) && so.BG != null) {
                    res = new ShapeDescriptor(this.getParentScope());
                    res.ID = so.getID();
                    res.type = so.getType();
                    Point p1 = new Point(this.getParentScope(), so.BG.Left, so.BG.Top);
                    Point p2 = new Point(this.getParentScope(), so.BG.Right, so.BG.Bottom);
                    res.bounds = new Bounds(this.getParentScope(), p1, p2);
                    res.layerID = so.getLayerID();
                    res.objectID = scheme.objIDByShapeID(res.ID);
                }
            }
        }
        return res;
    }

    public Object shapeByID(double ID) throws InformException, Throwable {
        Scheme scheme;
        Object res = null;
        if (ID != 0.0 && (scheme = this.getScheme()) != null) {
            SchemeObject so = scheme.schemeObjects.get(ID);
            res = this.getShapeDescriptor(so, scheme);
        }
        return res;
    }

    public Object shapeByPoint(Point point, boolean bindOnly, boolean ignoreTexts, String layersConfig) throws InformException, Throwable {
        Object res = null;
        if (point != null) {
            res = this.shapeByXY(point.x, point.y, bindOnly, ignoreTexts, layersConfig);
        }
        return res;
    }

    public Object shapeByXY(double x, double y, boolean bindOnly, boolean ignoreTexts, String layersConfig) throws InformException, Throwable {
        Object res = null;
        Scheme scheme = this.getScheme();
        if (scheme != null) {
            SchemeObject so = scheme.shapeByXY(x, y, bindOnly, ignoreTexts, layersConfig);
            res = this.getShapeDescriptor(so, scheme);
        }
        return res;
    }

    public Object shapeByTilePoint(TilePoint point, boolean bindOnly, boolean ignoreTexts, String layersConfig) throws InformException, Throwable {
        return this.shapeByPoint((Point)this.tilePointToScheme(point), bindOnly, ignoreTexts, layersConfig);
    }

    public Object shapeByTileXyz(int x, int y, int z, boolean bindOnly, boolean ignoreTexts, String layersConfig) throws InformException, Throwable {
        return this.shapeByPoint((Point)this.tileXyzToScheme(x, y, z), bindOnly, ignoreTexts, layersConfig);
    }

    public int layersCount() throws InformException, Throwable {
        int res = 0;
        Scheme scheme = this.getScheme();
        if (scheme != null) {
            res = scheme.SortLayers.size();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object layer(int index) throws InformException, Throwable {
        SchemeObject so;
        LayerDescriptor res = null;
        Scheme scheme = this.getScheme();
        if (scheme != null && (so = scheme.layerByIndex(index)) != null) {
            SchemeObject schemeObject = so;
            synchronized (schemeObject) {
                if (!so.isDeleted() && SchemeObjectsTypes.ObjTypeIsLayer(so.getType()) && so.BG != null) {
                    res = new LayerDescriptor(this.getParentScope());
                    res.ID = so.getID();
                    res.index = index;
                    if (so.BG.StringProps != null) {
                        res.name = so.BG.StringProps.Caption;
                    }
                    res.visible = ((PhxLayer)so.BG).Visible;
                    Point p1 = new Point(this.getParentScope(), so.BG.Left, so.BG.Top);
                    Point p2 = new Point(this.getParentScope(), so.BG.Right, so.BG.Bottom);
                    res.bounds = new Bounds(this.getParentScope(), p1, p2);
                }
            }
        }
        return res;
    }

    private static class LayerDescriptor
    extends SmartScriptableObject {
        private double ID = 0.0;
        private int index = 0;
        private String name = "";
        private boolean visible = false;
        private Bounds bounds = null;
        private final String[] availJSPropertiesNames = new String[]{"ID", "index", "name", "visible", "bounds"};

        LayerDescriptor(Scriptable scope) {
            this.setParentScope(scope);
            for (String s : this.availJSPropertiesNames) {
                this.defineProperty(s, this.getClass(), 1);
            }
        }

        @Override
        public String getClassName() {
            return "Layer";
        }

        @SmartScriptableObject.PropertyTag
        public double getID() {
            return this.ID;
        }

        @SmartScriptableObject.PropertyTag
        public int getIndex() {
            return this.index;
        }

        @SmartScriptableObject.PropertyTag
        public String getName() {
            return this.name;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getVisible() {
            return this.visible;
        }

        @SmartScriptableObject.PropertyTag
        public Bounds getBounds() {
            return this.bounds;
        }
    }

    private static class ShapeDescriptor
    extends SmartScriptableObject {
        private double ID = 0.0;
        private int type = 0;
        private Bounds bounds = null;
        private double layerID = 0.0;
        private double objectID = 0.0;
        private final String[] availJSPropertiesNames = new String[]{"ID", "type", "bounds", "layerID", "objectID"};

        ShapeDescriptor(Scriptable scope) {
            this.setParentScope(scope);
            for (String s : this.availJSPropertiesNames) {
                this.defineProperty(s, this.getClass(), 1);
            }
        }

        @Override
        public String getClassName() {
            return "Shape";
        }

        @SmartScriptableObject.PropertyTag
        public double getID() {
            return this.ID;
        }

        @SmartScriptableObject.PropertyTag
        public int getType() {
            return this.type;
        }

        @SmartScriptableObject.PropertyTag
        public Bounds getBounds() {
            return this.bounds;
        }

        @SmartScriptableObject.PropertyTag
        public double getLayerID() {
            return this.layerID;
        }

        @SmartScriptableObject.PropertyTag
        public double getObjectID() {
            return this.objectID;
        }
    }

    private static class Bounds
    extends SmartScriptableObject {
        private Point leftTop = null;
        private Point rightBottom = null;
        private final String[] availJSPropertiesNames = new String[]{"leftTop", "rightBottom"};

        Bounds(Scriptable scope, Point leftTop, Point rightBottom) {
            this.leftTop = leftTop;
            this.rightBottom = rightBottom;
            this.setParentScope(scope);
            for (String s : this.availJSPropertiesNames) {
                this.defineProperty(s, this.getClass(), 1);
            }
        }

        @Override
        public String getClassName() {
            return "Bounds";
        }

        @SmartScriptableObject.PropertyTag
        public Point getLeftTop() {
            return this.leftTop;
        }

        @SmartScriptableObject.PropertyTag
        public Point getRightBottom() {
            return this.rightBottom;
        }
    }

    private static class Point
    extends SmartScriptableObject {
        private double x = 0.0;
        private double y = 0.0;
        private final String[] availJSPropertiesNames = new String[]{"x", "y"};

        Point(Scriptable scope, double x, double y) {
            this.x = x;
            this.y = y;
            this.setParentScope(scope);
            for (String s : this.availJSPropertiesNames) {
                this.defineProperty(s, this.getClass(), 1);
            }
        }

        @Override
        public String getClassName() {
            return "Point";
        }

        @SmartScriptableObject.PropertyTag
        public double getX() {
            return this.x;
        }

        @SmartScriptableObject.PropertyTag
        public double getY() {
            return this.y;
        }
    }

    private static class TilePoint
    extends SmartScriptableObject {
        private int x = 0;
        private int y = 0;
        private int z = 0;
        private final String[] availJSPropertiesNames = new String[]{"x", "y", "z"};

        TilePoint(Scriptable scope, int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.setParentScope(scope);
            for (String s : this.availJSPropertiesNames) {
                this.defineProperty(s, this.getClass(), 1);
            }
        }

        @Override
        public String getClassName() {
            return "TilePoint";
        }

        @SmartScriptableObject.PropertyTag
        public double getX() {
            return this.x;
        }

        @SmartScriptableObject.PropertyTag
        public double getY() {
            return this.y;
        }

        @SmartScriptableObject.PropertyTag
        public double getZ() {
            return this.z;
        }
    }
}

