/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.agent.db.types.Geometry;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Scriptable;

public class SdoLibrary
extends SmartScriptableObject {
    private static final int BO_BIG_ENDIAN = 0;
    private static final int BO_LITTLE_ENDIAN = 1;
    private static final int GT_POINT = 1;
    private static final int GT_LINESTRING = 2;
    private static final int GT_POLYGON = 3;
    private static final int GT_MULTILINE = 5;
    private static final int GT_COLLECTION = 7;
    private static final int GTM_Z = Integer.MIN_VALUE;
    private static final int GTM_M = 0x40000000;
    private static final int GTM_S = 0x20000000;
    private static final int D_XY = 2;
    private static final int D_XYZ = 3;
    private static final int D_XYM = 18;

    public static GeoObject createGeometryObject(Geometry g) throws IOException, SQLException {
        return g == null ? null : SdoLibrary.createGeometryObject(g.toWKB());
    }

    public static GeoObject createGeometryObject(byte[] wkb) throws IOException {
        FilterInputStream din;
        if (wkb.length == 0) {
            throw new IllegalArgumentException("\u041f\u0443\u0441\u0442\u0430\u044f \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(wkb);
        int bo = ((InputStream)in).read();
        switch (bo) {
            case 0: {
                din = new DataInputStream(in);
                break;
            }
            case 1: {
                din = new LittleEndianDataInputStream(in);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a(" + bo + ") \u0431\u0430\u0439\u0442");
            }
        }
        return SdoLibrary.createGeometryObject(din);
    }

    private static void readAndCheckByteOrder(DataInput in) throws IOException {
        byte bo = in.readByte();
        switch (bo) {
            case 0: {
                if (!(in instanceof DataInputStream)) break;
                return;
            }
            case 1: {
                if (!(in instanceof LittleEndianDataInputStream)) break;
                return;
            }
            default: {
                throw new IllegalArgumentException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a(" + bo + ") \u0431\u0430\u0439\u0442");
            }
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a(" + bo + ") \u0431\u0430\u0439\u0442 \u0434\u043b\u044f " + in.getClass().getName());
    }

    private static GeoObject createGeometryObject(DataInput in) throws IOException {
        GeoObject geo;
        int type = in.readInt();
        int srid = 0;
        if ((type & 0x20000000) != 0) {
            srid = in.readInt();
        }
        int flags = (type &= 0xDFFFFFFF) & 0xFFFFFFF0;
        switch (type &= 0xF) {
            case 1: {
                geo = new GeoPoint(flags, srid);
                break;
            }
            case 2: {
                geo = new GeoLineString(flags, srid);
                break;
            }
            case 3: {
                geo = new GeoPolygon(flags, srid);
                break;
            }
            case 5: {
                geo = new GeoMultiLineString(flags, srid);
                break;
            }
            case 7: {
                geo = new GeoCollection(flags, srid);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f(" + type + ") \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438");
            }
        }
        geo.loadWkbData(in);
        return geo;
    }

    public SdoLibrary(Scriptable scope) {
        this.setParentScope(scope);
        SdoLibrary.putConstProperty(this, "XY", 2);
        SdoLibrary.putConstProperty(this, "XYM", 18);
        SdoLibrary.putConstProperty(this, "XYZ", 3);
        SdoLibrary.putConstProperty(this, "POINT", 1);
        SdoLibrary.putConstProperty(this, "LINESTRING", 2);
        SdoLibrary.putConstProperty(this, "POLYGON", 3);
        SdoLibrary.putConstProperty(this, "MULTILINE", 5);
        SdoLibrary.putConstProperty(this, "COLLECTION", 7);
    }

    private static int dim2flags(int dim) {
        switch (dim) {
            case 2: {
                return 0;
            }
            case 3: {
                return Integer.MIN_VALUE;
            }
            case 18: {
                return 0x40000000;
            }
        }
        throw new IllegalArgumentException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u0430\u044f \u0440\u0430\u0437\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u044c(" + dim + ")");
    }

    @SmartScriptableObject.FunctionTag
    public GeoObject createPoint(int dim, int srid) {
        return new GeoPoint(SdoLibrary.dim2flags(dim), srid);
    }

    @SmartScriptableObject.FunctionTag
    public GeoObject createLineString(int dim, int srid) {
        return new GeoLineString(SdoLibrary.dim2flags(dim), srid);
    }

    @SmartScriptableObject.FunctionTag
    public GeoObject createPolygon(int dim, int srid) {
        return new GeoPolygon(SdoLibrary.dim2flags(dim), srid);
    }

    @SmartScriptableObject.FunctionTag
    public GeoObject createMultiLineString(int dim, int srid) {
        return new GeoMultiLineString(SdoLibrary.dim2flags(dim), srid);
    }

    @SmartScriptableObject.FunctionTag
    public GeoObject createCollection(int dim, int srid) {
        return new GeoCollection(SdoLibrary.dim2flags(dim), srid);
    }

    private static class GeoMultiLineString
    extends GeoCollection {
        GeoMultiLineString(int flags, int srid) {
            super(5, flags, srid);
        }

        @Override
        protected void checkItemType(GeoObject g) {
            if (!(g instanceof GeoLineString)) {
                throw new IllegalArgumentException("is not line string");
            }
            super.checkItemType(g);
        }

        @SmartScriptableObject.FunctionTag
        public void addLine(GeoLineString g) {
            this.addGeometry(g);
        }

        @SmartScriptableObject.FunctionTag
        public GeoLineString line(int idx) {
            return (GeoLineString)this.geometry(idx);
        }
    }

    private static class GeoCollection
    extends GeoObject {
        final List<GeoObject> geometries = new ArrayList<GeoObject>();

        GeoCollection(int flags, int srid) {
            this(7, flags, srid);
        }

        protected GeoCollection(int type, int flags, int srid) {
            super(type | flags, srid);
        }

        protected void checkItemType(GeoObject g) {
            if ((this.type & 0xF0000000) != (g.type & 0xF0000000)) {
                throw new IllegalArgumentException("argument dimension is wrong");
            }
        }

        @SmartScriptableObject.FunctionTag
        public void addGeometry(GeoObject g) {
            this.checkItemType(g);
            this.geometries.add(g);
        }

        @SmartScriptableObject.FunctionTag
        public GeoObject geometry(int idx) {
            return this.geometries.get(idx);
        }

        @SmartScriptableObject.PropertyTag
        public int count() {
            return this.geometries.size();
        }

        @Override
        protected void loadWkbData(DataInput in) throws IOException {
            this.geometries.clear();
            int gc = in.readInt();
            for (int i = 0; i < gc; ++i) {
                SdoLibrary.readAndCheckByteOrder(in);
                GeoObject g = SdoLibrary.createGeometryObject(in);
                this.geometries.add(g);
            }
        }

        @Override
        protected void storeWkbData(DataOutput out, int byteOrder) throws IOException {
            out.writeInt(this.geometries.size());
            for (GeoObject g : this.geometries) {
                g.toWKB(out, byteOrder);
            }
        }
    }

    private static class GeoPolygon
    extends GeoLineString {
        GeoPolygon(int flags, int srid) {
            super(3, flags, srid);
        }

        @Override
        protected void loadWkbData(DataInput in) throws IOException {
            int rc = in.readInt();
            if (rc != 1) {
                throw new UnsupportedOperationException("rings count=" + rc + "<>1");
            }
            super.loadWkbData(in);
        }

        @Override
        protected void storeWkbData(DataOutput out, int byteOrder) throws IOException {
            out.writeInt(1);
            super.storeWkbData(out, byteOrder);
        }
    }

    private static class GeoLineString
    extends GeoObject {
        final List<P> points = new ArrayList<P>();

        GeoLineString(int flags, int srid) {
            this(2, flags, srid);
        }

        protected GeoLineString(int type, int flags, int srid) {
            super(type | flags, srid);
        }

        @Override
        protected void loadWkbData(DataInput in) throws IOException {
            int pc = in.readInt();
            this.points.clear();
            for (int i = 0; i < pc; ++i) {
                P p = new P();
                p.x = in.readDouble();
                p.y = in.readDouble();
                if ((this.type & Integer.MIN_VALUE) != 0) {
                    p.z = in.readDouble();
                }
                if ((this.type & 0x40000000) != 0) {
                    p.m = in.readDouble();
                }
                this.points.add(p);
            }
        }

        @Override
        protected void storeWkbData(DataOutput out, int byteOrder) throws IOException {
            out.writeInt(this.points.size());
            for (P p : this.points) {
                out.writeDouble(p.x);
                out.writeDouble(p.y);
                if ((this.type & Integer.MIN_VALUE) != 0) {
                    out.writeDouble(p.z);
                }
                if ((this.type & 0x40000000) == 0) continue;
                out.writeDouble(p.m);
            }
        }

        @SmartScriptableObject.FunctionTag
        public void addPoint(double x, double y, double z, double m) {
            P p = new P();
            p.x = x;
            p.y = y;
            if ((this.type & Integer.MIN_VALUE) != 0) {
                p.z = z;
            }
            if ((this.type & 0x40000000) != 0) {
                p.m = m;
            }
            this.points.add(p);
        }

        @SmartScriptableObject.FunctionTag
        public double x(int idx, double v) {
            P p = this.points.get(idx);
            if (Double.isNaN(v)) {
                return p.x;
            }
            p.x = v;
            return Double.NaN;
        }

        @SmartScriptableObject.FunctionTag
        public double y(int idx, double v) {
            P p = this.points.get(idx);
            if (Double.isNaN(v)) {
                return p.y;
            }
            p.y = v;
            return Double.NaN;
        }

        @SmartScriptableObject.FunctionTag
        public double z(int idx, double v) {
            P p = this.points.get(idx);
            if (Double.isNaN(v)) {
                return p.z;
            }
            p.z = v;
            return Double.NaN;
        }

        @SmartScriptableObject.FunctionTag
        public double m(int idx, double v) {
            P p = this.points.get(idx);
            if (Double.isNaN(v)) {
                return p.m;
            }
            p.m = v;
            return Double.NaN;
        }

        @SmartScriptableObject.PropertyTag
        public int length() {
            return this.points.size();
        }

        static final class P {
            double x;
            double y;
            double z;
            double m;

            P() {
            }
        }
    }

    private static class GeoPoint
    extends GeoObject {
        double x;
        double y;
        double z;
        double m;

        GeoPoint(int flags, int srid) {
            super(1 + flags, srid);
        }

        @SmartScriptableObject.PropertyTag
        public double x() {
            return this.x;
        }

        public void x(double v) {
            this.x = v;
        }

        @SmartScriptableObject.PropertyTag
        public double y() {
            return this.y;
        }

        public void y(double v) {
            this.y = v;
        }

        @SmartScriptableObject.PropertyTag
        public double z() {
            return this.z;
        }

        public void z(double v) {
            this.z = v;
        }

        @SmartScriptableObject.PropertyTag
        public double m() {
            return this.m;
        }

        public void m(double v) {
            this.m = v;
        }

        @Override
        protected void loadWkbData(DataInput in) throws IOException {
            this.x = in.readDouble();
            this.y = in.readDouble();
            if ((this.type & Integer.MIN_VALUE) != 0) {
                this.z = in.readDouble();
            }
            if ((this.type & 0x40000000) != 0) {
                this.m = in.readDouble();
            }
        }

        @Override
        public void storeWkbData(DataOutput out, int byteOrder) throws IOException {
            out.writeDouble(this.x);
            out.writeDouble(this.y);
            if ((this.type & Integer.MIN_VALUE) != 0) {
                out.writeDouble(this.z);
            }
            if ((this.type & 0x40000000) != 0) {
                out.writeDouble(this.m);
            }
        }
    }

    public static abstract class GeoObject
    extends SmartScriptableObject {
        final int type;
        final int srid;

        GeoObject(int type, int srid) {
            this.type = type;
            this.srid = srid;
        }

        @SmartScriptableObject.FunctionTag
        public String toString() {
            return this.getClassName();
        }

        @SmartScriptableObject.PropertyTag
        public int type() {
            return this.type & 0xF;
        }

        public void toWKB(OutputStream out) throws IOException {
            DataOutputStream dout = new DataOutputStream(out);
            this.toWKB(dout, 0);
            dout.flush();
        }

        public Geometry toGeometry() throws IOException {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.toWKB(buffer);
            return new Geometry.WkbGeometry(buffer.toByteArray());
        }

        protected void toWKB(DataOutput out, int byteOrder) throws IOException {
            out.writeByte(byteOrder);
            if (this.srid != 0) {
                out.writeInt(this.type | 0x20000000);
                out.writeInt(this.srid);
            } else {
                out.writeInt(this.type);
            }
            this.storeWkbData(out, byteOrder);
        }

        protected abstract void loadWkbData(DataInput var1) throws IOException;

        protected abstract void storeWkbData(DataOutput var1, int var2) throws IOException;
    }
}

