/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.adt.InformException;
import inform.adt.collections.ObjectHash;
import inform.agent.Core;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.FileSystemLibrary;
import inform.agent.scripts.Task;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.agent.scripts.libs.XmlWriter;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlLibrary
extends SmartScriptableObject {
    static final Locale LOCALE_RU = new Locale("ru");
    private final Task task;

    public XmlLibrary(Task task) {
        this.task = task;
    }

    @SmartScriptableObject.FunctionTag
    public static Object validate(Object xml, Object xsd, final Object adv) throws Exception {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (adv instanceof NativeObject) {
            sf.setResourceResolver(new LSResourceResolver(){
                final NativeObject advmap;
                {
                    this.advmap = (NativeObject)adv;
                }

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    final Object val = this.advmap.get(systemId);
                    if (val == Undefined.instance) {
                        return null;
                    }
                    return new LSInput(){

                        @Override
                        public String getStringData() {
                            return val instanceof String ? (String)val : null;
                        }

                        @Override
                        public void setStringData(String stringData) {
                        }

                        @Override
                        public Reader getCharacterStream() {
                            return null;
                        }

                        @Override
                        public void setCharacterStream(Reader characterStream) {
                        }

                        @Override
                        public InputStream getByteStream() {
                            return null;
                        }

                        @Override
                        public void setByteStream(InputStream byteStream) {
                        }

                        @Override
                        public String getSystemId() {
                            return null;
                        }

                        @Override
                        public void setSystemId(String systemId) {
                        }

                        @Override
                        public String getPublicId() {
                            return null;
                        }

                        @Override
                        public void setPublicId(String publicId) {
                        }

                        @Override
                        public String getBaseURI() {
                            return null;
                        }

                        @Override
                        public void setBaseURI(String baseURI) {
                        }

                        @Override
                        public String getEncoding() {
                            return null;
                        }

                        @Override
                        public void setEncoding(String encoding) {
                        }

                        @Override
                        public boolean getCertifiedText() {
                            return false;
                        }

                        @Override
                        public void setCertifiedText(boolean certifiedText) {
                        }
                    };
                }
            });
        }
        Schema s = sf.newSchema(XmlLibrary.obj2source(xsd));
        Validator v = s.newValidator();
        v.setProperty("http://apache.org/xml/properties/locale", LOCALE_RU);
        final ArrayList<SAXParseException> errors = new ArrayList<SAXParseException>();
        final ArrayList<SAXParseException> warnings = new ArrayList<SAXParseException>();
        v.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                warnings.add(exception);
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                errors.add(exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                errors.add(exception);
            }
        });
        try {
            v.validate(XmlLibrary.obj2source(xml));
        }
        catch (SAXParseException e) {
            Core.logger.error(null, e);
            errors.add(e);
        }
        return errors.isEmpty() ? null : new XmlValidateError(errors, warnings);
    }

    @SmartScriptableObject.FunctionTag
    public Object createReader(Object xml) throws Exception {
        return XmlLibrary.createReaderImpl(xml, this.task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createReaderImpl(Object xml, Task task) throws Exception {
        XMLInputFactory f = XMLInputFactory.newFactory();
        f.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        XMLStreamReader r = null;
        Closeable closeable = null;
        try {
            StreamSource source = XmlLibrary.obj2source(xml);
            closeable = source.getInputStream();
            if (closeable == null) {
                closeable = source.getReader();
            }
            r = new XMLStreamReader(f.createXMLStreamReader(source), closeable);
            closeable = null;
            while (r.hasNext()) {
                if (r.next() != 1) continue;
                RootXmlReader result = new RootXmlReader(r, task);
                r = null;
                RootXmlReader rootXmlReader = result;
                return rootXmlReader;
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (closeable != null) {
                closeable.close();
            }
        }
        throw new InformException("\u043d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430");
    }

    @SmartScriptableObject.FunctionTag
    public static Object createWriter(String str) throws Exception {
        return new XmlWriter(str);
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject canonicalize(Object data, Object algorithmURI, Object expression) throws Exception {
        Element node;
        String algorithm;
        byte[] value = CryptoUtils.dataAsBytes(data, "UTF-8");
        if (value == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0434\u043b\u044f \u043a\u0430\u043d\u043e\u043d\u0438\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
        }
        String string = algorithm = algorithmURI == null ? null : algorithmURI.toString();
        if (algorithm == null || algorithm.isEmpty()) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c \u043a\u0430\u043d\u043e\u043d\u0438\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
        }
        String expressionValue = expression instanceof String ? (String)expression : null;
        Document doc = CryptoUtils.loadDocument(value);
        Node node2 = node = expressionValue == null ? doc.getDocumentElement() : this.findNode(doc, expressionValue);
        if (node == null) {
            return null;
        }
        if (!Init.isInitialized()) {
            Init.init();
        }
        XMLSignatureInput xmlInput = new XMLSignatureInput((Node)node);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Transforms transforms = new Transforms(doc);
        transforms.addTransform(algorithm);
        int cnt = transforms.getLength();
        for (int i = 0; i < cnt; ++i) {
            transforms.item(i).performTransform(xmlInput, (OutputStream)os);
        }
        return new BinaryObject(os.toByteArray());
    }

    private static StreamSource obj2source(final Object o) throws Exception {
        if (o instanceof String) {
            return new StreamSource(new StringReader((String)o));
        }
        if (o instanceof BinaryObject) {
            return new StreamSource(BinaryObject.toInputStream((BinaryObject)o));
        }
        if (o instanceof DatasourceField) {
            DatasourceField field = (DatasourceField)o;
            switch (field.getDataType()) {
                case STRING: 
                case UNICODE: {
                    return new StreamSource(new StringReader(field.getAsString()));
                }
                case BLOB: {
                    return new StreamSource(BinaryObject.toInputStream(((BlobField)field).getAsBinary()));
                }
                case FILE: {
                    return new StreamSource(((BlobFileField)o).openFileStream());
                }
            }
        }
        if (o instanceof FileSystemLibrary.TextReader) {
            return new StreamSource(new Reader(){
                final FileSystemLibrary.TextReader reader;
                {
                    this.reader = (FileSystemLibrary.TextReader)o;
                }

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    return this.reader.read(cbuf, off, len);
                }

                @Override
                public void close() {
                }
            });
        }
        if (o instanceof FileSystemLibrary.BinaryReader) {
            return new StreamSource(new InputStream(){
                final byte[] buff_one = new byte[1];
                final FileSystemLibrary.BinaryReader reader = (FileSystemLibrary.BinaryReader)o;

                @Override
                public int read() throws IOException {
                    int r;
                    while ((r = this.reader.read(this.buff_one, 0, 1)) == 0) {
                    }
                    if (r < 0) {
                        return -1;
                    }
                    return this.buff_one[0] & 0xFF;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return this.reader.read(b, off, len);
                }

                @Override
                public void close() {
                }
            });
        }
        throw new InformException("\u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0441\u0442\u0440\u043e\u043a\u0430, \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u0439 \u043e\u0431\u044a\u0435\u043a\u0442, \u043f\u043e\u043b\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 (\u0441\u0442\u0440\u043e\u043a\u0430, Blob \u0438\u043b\u0438 Blob File), \u043f\u043e\u0442\u043e\u043a \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 \u0438\u043b\u0438 \u043f\u043e\u0442\u043e\u043a \u0431\u0430\u0439\u0442");
    }

    private Node findNode(Document doc, String expression) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new UniversalNamespaceContext(doc, false));
        XPathExpression expr = xpath.compile(expression);
        NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return nodes.item(0);
    }

    private class UniversalNamespaceContext
    implements NamespaceContext {
        private static final String DEFAULT_NS = "DEFAULT";
        private Map<String, String> prefix2Uri = new HashMap<String, String>();
        private Map<String, String> uri2Prefix = new HashMap<String, String>();

        public UniversalNamespaceContext(Document document, boolean toplevelOnly) {
            this.examineNode(document.getFirstChild(), toplevelOnly);
        }

        private void examineNode(Node node, boolean attributesOnly) {
            NamedNodeMap attributes = node.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                this.storeAttribute((Attr)attribute);
            }
            if (!attributesOnly) {
                NodeList chields = node.getChildNodes();
                for (int i = 0; i < chields.getLength(); ++i) {
                    Node chield = chields.item(i);
                    if (chield.getNodeType() != 1) continue;
                    this.examineNode(chield, false);
                }
            }
        }

        private void storeAttribute(Attr attribute) {
            if (attribute.getNamespaceURI() != null && attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                if (attribute.getNodeName().equals("xmlns")) {
                    this.putInCache(DEFAULT_NS, attribute.getNodeValue());
                } else {
                    this.putInCache(attribute.getLocalName(), attribute.getNodeValue());
                }
            }
        }

        private void putInCache(String prefix, String uri) {
            this.prefix2Uri.put(prefix, uri);
            this.uri2Prefix.put(uri, prefix);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null || prefix.equals("")) {
                return this.prefix2Uri.get(DEFAULT_NS);
            }
            return this.prefix2Uri.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.uri2Prefix.get(namespaceURI);
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }

    private static class XmlDomTag
    extends TagScriptableObject
    implements ObjectHash.Entry {
        static final TagScriptableObject.Attr[] EMPTY_ATTRS = new TagScriptableObject.Attr[0];
        static final XmlDomTag[] EMPTY_TAGS = new XmlDomTag[0];
        final String tag;
        final String text;

        XmlDomTag(XMLStreamReader reader) throws XMLStreamException {
            if (reader.getEventType() != 1) {
                throw new InformException("\u043d\u0435\u0442 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0442\u0435\u0433\u0430");
            }
            this.tag = reader.getLocalName();
            int attrCount = reader.getAttributeCount();
            if (attrCount > 0) {
                this.attributes = new TagScriptableObject.Attr[attrCount];
                for (int i = 0; i < attrCount; ++i) {
                    this.attributes[i] = new TagScriptableObject.Attr(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                }
                Arrays.sort(this.attributes, TagScriptableObject.Attr.CMP_BY_NAME);
            } else {
                this.attributes = EMPTY_ATTRS;
            }
            StringBuilder txt = new StringBuilder();
            this.children = XmlDomTag.parse(reader, txt);
            this.text = txt.toString();
        }

        static List<XmlDomTag> parse(XMLStreamReader reader, StringBuilder text) throws XMLStreamException {
            ArrayList<XmlDomTag> ch = null;
            boolean run = true;
            while (run && reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        if (ch == null) {
                            ch = new ArrayList<XmlDomTag>();
                        }
                        ch.add(new XmlDomTag(reader));
                        break;
                    }
                    case 4: {
                        text.append(reader.getText());
                        break;
                    }
                    case 2: {
                        run = false;
                    }
                }
            }
            if (ch == null) {
                return Collections.emptyList();
            }
            return ch;
        }

        @Override
        public String key() {
            return this.tag;
        }

        @Override
        void needAttributes() {
        }

        @Override
        void needTags() {
        }

        @SmartScriptableObject.PropertyTag
        public String getTagName() {
            return this.tag;
        }

        @SmartScriptableObject.PropertyTag
        public String getTagText() {
            return this.text;
        }

        @SmartScriptableObject.FunctionTag
        public void checkTag(String expectedTagName) {
            if (!this.tag.equals(expectedTagName)) {
                throw new InformException("\u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0435\u0433 '" + this.tag + "', \u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f '" + expectedTagName + "'");
            }
        }
    }

    private static class RootXmlReader
    extends XmlReader
    implements Closeable {
        private final Task task;

        RootXmlReader(XMLStreamReader reader, Task task) {
            super(reader, 0);
            this.task = task;
            assert (reader.getEventType() == 1);
            reader.owner = this;
            this.tag = reader.getLocalName();
            task.registerCloseable(this);
        }

        @Override
        @SmartScriptableObject.FunctionTag
        public void close() {
            try {
                this.reader.close();
                this.task.detachCloseable(this);
            }
            catch (XMLStreamException ex) {
                throw InformException.wrap(ex);
            }
        }
    }

    private static class ChildXmlReader
    extends XmlReader {
        ChildXmlReader(XMLStreamReader reader, int level) {
            super(reader, level);
        }

        @SmartScriptableObject.FunctionTag
        public boolean next(Object expectedTagName) throws XMLStreamException {
            if (this.reader.level < this.level) {
                return false;
            }
            this.reader.skipToLevelAndSetOwner(this);
            while (this.reader.hasNext()) {
                switch (this.reader.next()) {
                    case 1: {
                        this.reset();
                        this.tag = this.reader.getLocalName();
                        if (expectedTagName != Undefined.instance) {
                            this.checkTag(expectedTagName.toString());
                        }
                        return true;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
            if (this.tag != null) {
                throw new InformException("\u043d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430");
            }
            return false;
        }
    }

    private static class XmlReader
    extends TagScriptableObject {
        final XMLStreamReader reader;
        final int level;
        String tag;
        String text;
        ChildXmlReader subreader;

        XmlReader(XMLStreamReader reader, int level) {
            this.reader = reader;
            this.level = level;
        }

        void reset() {
            this.text = null;
            this.tag = null;
            this.attributes_sorted = null;
            this.attributes = null;
            this.children = null;
            this.childrenhash = null;
        }

        void tagneed() {
            if (this.tag == null) {
                throw new InformException("\u043d\u0435\u0442 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0442\u0435\u0433\u0430");
            }
        }

        @SmartScriptableObject.PropertyTag
        public String getTagName() {
            this.tagneed();
            return this.tag;
        }

        @Override
        void needAttributes() {
            this.tagneed();
            this.reader.checkOwner(this);
            int event = this.reader.getEventType();
            if (event != 10 && event != 1) {
                return;
            }
            if (this.attributes == null) {
                this.attributes = new TagScriptableObject.Attr[this.reader.getAttributeCount()];
                for (int i = 0; i < this.attributes.length; ++i) {
                    this.attributes[i] = new TagScriptableObject.Attr(this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
                }
            }
        }

        @Override
        void needTags() throws XMLStreamException {
            this.tagneed();
            this.reader.checkOwner(this);
            if (this.children == null) {
                StringBuilder txt = new StringBuilder();
                this.children = XmlDomTag.parse(this.reader, txt);
                this.text = txt.toString();
            }
        }

        @SmartScriptableObject.PropertyTag
        public String getTagText() throws XMLStreamException {
            this.tagneed();
            if (this.text == null) {
                this.reader.checkOwner(this);
                assert (this.reader.getEventType() == 1);
                StringBuilder tmp = new StringBuilder();
                while (this.reader.hasNext()) {
                    switch (this.reader.next()) {
                        case 4: {
                            tmp.append(this.reader.getText());
                            break;
                        }
                        case 1: {
                            throw new InformException(this.reader.LC() + " \u0432\u0441\u0442\u0440\u0435\u0442\u0438\u043b\u0441\u044f \u043d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0435\u0433 '" + this.reader.getLocalName() + "'").detail("\u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u0442\u0435\u0433\u0430 '" + this.tag + "'");
                        }
                        case 2: {
                            this.text = tmp.toString();
                            return this.text;
                        }
                    }
                }
                throw new InformException("\u043d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430");
            }
            return this.text;
        }

        @SmartScriptableObject.FunctionTag
        public Object subReader() {
            this.tagneed();
            this.reader.checkOwner(this);
            if (this.subreader == null) {
                this.subreader = new ChildXmlReader(this.reader, this.level + 1);
            }
            this.subreader.reset();
            return this.subreader;
        }

        @SmartScriptableObject.FunctionTag
        public void checkTag(String expectedTagName) {
            this.tagneed();
            if (!this.tag.equals(expectedTagName)) {
                throw new InformException(this.reader.LC() + " \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0435\u0433 '" + this.tag + "', \u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f '" + expectedTagName + "'");
            }
        }
    }

    private static abstract class TagScriptableObject
    extends SmartScriptableObject {
        Attr[] attributes;
        Attr[] attributes_sorted;
        List<XmlDomTag> children;
        ObjectHash<XmlDomTag> childrenhash;

        private TagScriptableObject() {
        }

        @SmartScriptableObject.FunctionTag
        public static Object attr(Context cx, Scriptable self, Object[] args, Function func) {
            Object v = ((TagScriptableObject)self).attr(args[0]);
            if (v == Undefined.instance) {
                if (args.length > 1) {
                    return args[1];
                }
                throw new InformException("\u0430\u0442\u0440\u0438\u0431\u0443\u0442 '" + args[0] + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            return v;
        }

        Object attr(Object k) {
            String name;
            Attr key;
            int idx;
            this.needAttributes();
            if (this.attributes == null) {
                return Undefined.instance;
            }
            if (k instanceof Number) {
                return this.attributes[((Number)k).intValue()].value;
            }
            if (this.attributes_sorted == null) {
                this.attributes_sorted = (Attr[])this.attributes.clone();
                Arrays.sort(this.attributes_sorted, Attr.CMP_BY_NAME);
            }
            if ((idx = Arrays.binarySearch(this.attributes_sorted, key = new Attr(name = k.toString(), null), Attr.CMP_BY_NAME)) >= 0) {
                Attr found = this.attributes_sorted[idx];
                if (found.name.equals(name)) {
                    return found.value;
                }
            }
            return Undefined.instance;
        }

        @SmartScriptableObject.FunctionTag
        public boolean hasAttr(String obj) {
            Object attr = this.attr(obj);
            return !Undefined.isUndefined(attr);
        }

        @SmartScriptableObject.FunctionTag
        public Object attrName(int index) {
            this.needAttributes();
            return this.attributes[index].name;
        }

        @SmartScriptableObject.PropertyTag
        public int getAttrCount() {
            this.needAttributes();
            return this.attributes == null ? 0 : this.attributes.length;
        }

        abstract void needAttributes();

        @SmartScriptableObject.PropertyTag
        public int getTagCount() throws XMLStreamException {
            this.needTags();
            return this.children == null ? 0 : this.children.size();
        }

        @SmartScriptableObject.FunctionTag
        public static Object tag(Context cx, Scriptable self, Object[] args, Function func) throws XMLStreamException {
            Object v = ((TagScriptableObject)self).tag(args[0]);
            if (v == Undefined.instance) {
                if (args.length > 1) {
                    return args[1];
                }
                throw new InformException("\u0442\u0435\u0433 '" + args[0] + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            return v;
        }

        Object tag(Object k) throws XMLStreamException {
            String name;
            XmlDomTag found;
            this.needTags();
            if (k instanceof Number) {
                return this.children.get(((Number)k).intValue());
            }
            if (this.childrenhash == null) {
                this.childrenhash = new ObjectHash();
                for (XmlDomTag t : this.children) {
                    this.childrenhash.add(t);
                }
            }
            if ((found = this.childrenhash.get(name = k.toString())) != null) {
                return found;
            }
            return Undefined.instance;
        }

        abstract void needTags() throws XMLStreamException;

        static class Attr {
            static final Comparator<Attr> CMP_BY_NAME = new Comparator<Attr>(){

                @Override
                public int compare(Attr o1, Attr o2) {
                    return o1.name.compareTo(o2.name);
                }
            };
            final String name;
            final String value;

            Attr(String name, String value) {
                this.name = name;
                this.value = value;
            }
        }
    }

    private static class XMLStreamReader
    extends StreamReaderDelegate {
        final Closeable closeable;
        XmlReader owner;
        int level;

        XMLStreamReader(javax.xml.stream.XMLStreamReader reader, Closeable closeable) {
            super(reader);
            this.closeable = closeable;
        }

        @Override
        public int next() throws XMLStreamException {
            int event = super.next();
            switch (event) {
                case 1: {
                    ++this.level;
                    break;
                }
                case 2: {
                    --this.level;
                }
            }
            return event;
        }

        void checkOwner(XmlReader owner) {
            if (this.owner != owner) {
                throw new InformException(this.LC() + " \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0442\u0435\u0433 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0434\u0440\u0443\u0433\u043e\u043c\u0443 \u0447\u0438\u0442\u0430\u0442\u0435\u043b\u044e");
            }
        }

        void skipToLevelAndSetOwner(XmlReader owner) throws XMLStreamException {
            this.owner = owner;
            while (this.level != owner.level && this.hasNext()) {
                this.next();
            }
            if (this.level != owner.level) {
                throw new InformException(this.LC() + " \u043d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430");
            }
        }

        String LC() {
            Location l = this.getLocation();
            return "[" + l.getLineNumber() + ":" + l.getColumnNumber() + "]";
        }

        @Override
        public void close() throws XMLStreamException {
            super.close();
            if (this.closeable != null) {
                try {
                    this.closeable.close();
                }
                catch (IOException ex) {
                    throw InformException.wrap(ex);
                }
            }
        }
    }

    private static class XmlValidateError
    extends SmartScriptableObject {
        static final int MAX_ERRORS_IN_MESSAGE = 100;
        static final int MAX_WARNINGS_IN_MESSAGE = 20;
        final List<SAXParseException> errors;
        final List<SAXParseException> warnings;
        String message_;

        XmlValidateError(List<SAXParseException> errors, List<SAXParseException> warnings) {
            this.errors = errors;
            this.warnings = warnings;
        }

        @SmartScriptableObject.PropertyTag
        public String getMessage() {
            if (this.message_ == null) {
                StringBuilder msg = new StringBuilder();
                if (!this.warnings.isEmpty()) {
                    msg.append("\u043e\u0448\u0438\u0431\u043a\u0438:\n");
                }
                XmlValidateError.ex2builder(this.errors, 100, msg);
                if (!this.warnings.isEmpty()) {
                    msg.append("\u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f:\n");
                    XmlValidateError.ex2builder(this.warnings, 20, msg);
                }
                this.message_ = msg.toString().trim();
            }
            return this.message_;
        }

        static void ex2builder(List<SAXParseException> exs, int max, StringBuilder to) {
            int ec = 0;
            for (SAXParseException e : exs) {
                int left;
                to.append('[').append(e.getLineNumber()).append(':').append(e.getColumnNumber()).append("] ").append(e.getMessage()).append('\n');
                if (++ec != max || (left = exs.size() - ec) <= max / 10) continue;
                to.append(" ... \u0438 \u0435\u0449\u0451 ").append(left).append(" \u0448\u0442.");
                break;
            }
        }

        @SmartScriptableObject.PropertyTag
        public int getErrorCount() {
            return this.errors.size();
        }

        @SmartScriptableObject.FunctionTag
        public Object error(int index) {
            return this.errors.get(index);
        }

        @SmartScriptableObject.PropertyTag
        public int getWarningCount() {
            return this.warnings.size();
        }

        @SmartScriptableObject.FunctionTag
        public Object warning(int index) {
            return this.errors.get(index);
        }
    }
}

