/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.adt.InformException;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.ClosableResult;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.Statement;
import inform.agent.db.request.ReplaceRecordRefsRequest;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.Restructure;
import inform.agent.db.types.ValueCaster;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.RolesTable;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.mtd.obj.DForm;
import inform.agent.mtd.obj.DslRuntime;
import inform.agent.mtd.obj.search.DSearch;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.metadata.ScriptCustomNode;
import inform.agent.scripts.metadata.ScriptNode;
import inform.agent.scripts.metadata.ScriptSymLinkNode;
import inform.agent.scripts.metadata.ScriptTableUser;
import inform.agent.scripts.metadata.ScriptTableUserNode;
import inform.agent.scripts.metadata.ScriptUserGroupNode;
import inform.agent.scripts.metadata.ScriptUserNode;
import inform.agent.scripts.metadata.UserAccessRightsHistory;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class MetadataLibrary
extends SmartScriptableObject {
    private static final String[] jsMethods = new String[]{"getNodeContent", "getUsersWithRole", "getNodeByID", "getUserByID", "isUserHasRole", "getAccessMask", "getUsersWithPermissions", "createUserAccessRightsHistory", "loadUser", "getTableFkDependencies", "replaceRecordsRefs", "backupDatabase", "createTableUser", "getNodeContentAsText", "getRuntimeNodeContent", "getDslSpec"};
    private ServerSideHost ssHost;
    private final AbstractConnectionManager dbManager;
    private DoubleHash<ScriptNodeEntry> userInTableCache;
    private DoubleHash<ScriptNodeEntry> nodeCache;
    private DoubleList userIdCache;
    private byte[] globalConstantsContent = null;
    private UserAccessRightsHistory hObj = null;
    private UsersTable usersTable;
    private RolesTable rolesTable;
    private final SSContext ssContext;

    public MetadataLibrary(Scriptable scope, ServerSideHost ssHost, AbstractConnectionManager databaseManager) {
        this.setParentScope(scope);
        this.ssHost = ssHost;
        this.dbManager = databaseManager;
        SSContext context = ssHost != null && ssHost instanceof ScriptableHost ? ((ScriptableHost)((Object)ssHost)).getRootContext() : null;
        this.ssContext = context;
        try {
            ServerNode.Descriptor descriptor = ((ServerNode)MtdEngine.getValidNode(2.0)).descriptor();
            this.usersTable = new UsersTable(descriptor, false);
            this.rolesTable = new RolesTable(descriptor, false);
        }
        catch (IOException e) {
            Core.logger.error(null, e);
            this.usersTable = null;
        }
        this.defineFunctionProperties(jsMethods, MetadataLibrary.class, 0);
        MetadataLibrary.putConstProperty(this, "ACCESS_LEVEL_USER", "0");
        MetadataLibrary.putConstProperty(this, "ACCESS_LEVEL_ADMIN", "1");
        MetadataLibrary.putConstProperty(this, "ACCESS_LEVEL_OBSERVER", "2");
        MetadataLibrary.putConstProperty(this, "NODE_FOLDER", "0");
        MetadataLibrary.putConstProperty(this, "NODE_TRASH", "1");
        MetadataLibrary.putConstProperty(this, "NODE_SYMLINK", "2");
        MetadataLibrary.putConstProperty(this, "NODE_USER", "3");
        MetadataLibrary.putConstProperty(this, "NODE_USER_GROUP", "4");
        MetadataLibrary.putConstProperty(this, "NODE_DELETED_NODE", "5");
        MetadataLibrary.putConstProperty(this, "NODE_SERVER", "6");
        MetadataLibrary.putConstProperty(this, "NODE_CONST", "7");
        MetadataLibrary.putConstProperty(this, "NODE_AUDIT", "8");
        MetadataLibrary.putConstProperty(this, "NODE_GUI_STYLES", "9");
        MetadataLibrary.putConstProperty(this, "NODE_DATABASE", "10");
        MetadataLibrary.putConstProperty(this, "NODE_FORM", "11");
        MetadataLibrary.putConstProperty(this, "NODE_TABLE", "12");
        MetadataLibrary.putConstProperty(this, "NODE_UNHAPPY_NODE", "13");
        MetadataLibrary.putConstProperty(this, "NODE_SCRIPT", "14");
        MetadataLibrary.putConstProperty(this, "NODE_REPORT", "15");
        MetadataLibrary.putConstProperty(this, "NODE_REPORT", "15");
        MetadataLibrary.putConstProperty(this, "NODE_CONFIG", "16");
        MetadataLibrary.putConstProperty(this, "NODE_BUILDUP", "17");
        MetadataLibrary.putConstProperty(this, "NODE_PICTURE", "18");
        MetadataLibrary.putConstProperty(this, "NODE_FIND", "19");
        MetadataLibrary.putConstProperty(this, "NODE_RUN_NODE", "20");
        MetadataLibrary.putConstProperty(this, "NODE_REPAIR", "21");
        MetadataLibrary.putConstProperty(this, "NODE_REPLICA", "22");
        MetadataLibrary.putConstProperty(this, "NODE_IMPORT", "23");
        MetadataLibrary.putConstProperty(this, "NODE_SCRIPT_DATA", "24");
        MetadataLibrary.putConstProperty(this, "NODE_FILES", "25");
        MetadataLibrary.putConstProperty(this, "NODE_SCHEME", "26");
        MetadataLibrary.putConstProperty(this, "NODE_SCHEME_LIBRARY", "27");
        MetadataLibrary.putConstProperty(this, "NODE_SCHEME_LIBRARY_GROUP", "28");
        MetadataLibrary.putConstProperty(this, "NODE_SCHEME_DATABIND", "29");
        MetadataLibrary.putConstProperty(this, "NODE_SCHEME_LAYER", "30");
        MetadataLibrary.putConstProperty(this, "NODE_SCHEME_LIBRARY_STYLES", "31");
        MetadataLibrary.putConstProperty(this, "NODE_STYLE_THEME", "32");
        MetadataLibrary.putConstProperty(this, "NODE_CLASSIFICATOR_PRIMITIVE", "33");
        MetadataLibrary.putConstProperty(this, "NODE_TOPOLOGY", "40");
        MetadataLibrary.putConstProperty(this, "NODE_AGREEMENT", "41");
        MetadataLibrary.putConstProperty(this, "NODE_DOCUMENT", "42");
        MetadataLibrary.putConstProperty(this, "NODE_SQL_SCRIPT", "43");
        MetadataLibrary.putConstProperty(this, "NODE_EXTERNAL_APP", "44");
        MetadataLibrary.putConstProperty(this, "NODE_WEB_FORM", "45");
        MetadataLibrary.putConstProperty(this, "NODE_ALERTING", "46");
        MetadataLibrary.putConstProperty(this, "NODE_SERVER_TASK", "47");
        MetadataLibrary.putConstProperty(this, "NODE_SERVERSIDE_TABLE", "48");
        MetadataLibrary.putConstProperty(this, "NODE_QUERY", "49");
        MetadataLibrary.putConstProperty(this, "NODE_DOC_STYLE", "50");
        MetadataLibrary.putConstProperty(this, "NODE_JOB", "51");
        MetadataLibrary.putConstProperty(this, "NODE_SCHEME_KEEP_SETTINGS", "52");
        MetadataLibrary.putConstProperty(this, "NODE_CHANNEL_OF_REPLICA", "53");
        MetadataLibrary.putConstProperty(this, "NODE_WEB_REPORT", "54");
        MetadataLibrary.putConstProperty(this, "NODE_WEB_STYLE", "55");
        MetadataLibrary.putConstProperty(this, "NODE_WEB_QUERY", "56");
        MetadataLibrary.putConstProperty(this, "NODE_ROLE", "57");
        MetadataLibrary.putConstProperty(this, "NODE_COLLECTION_ICONS", "58");
        MetadataLibrary.putConstProperty(this, "NODE_FORM_STYLE", "59");
        MetadataLibrary.putConstProperty(this, "NODE_SOAP_QUERY", "60");
        MetadataLibrary.putConstProperty(this, "RESTRUCTURE_UPDATE", (Object)Restructure.Strategy.UPDATE);
        MetadataLibrary.putConstProperty(this, "RESTRUCTURE_RECREATE", (Object)Restructure.Strategy.RECREATE);
    }

    public SSContext getSsContext() {
        return this.ssContext;
    }

    public byte[] getGlobalConstantsContent() throws InformException {
        this.idle();
        if (this.globalConstantsContent == null) {
            this.globalConstantsContent = MtdEngine.getNodeContent(3.0);
        }
        return this.globalConstantsContent;
    }

    public static Object getNodeContent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        byte[] data = null;
        if (args.length > 0) {
            double nodeId = ValueCaster.toDouble(args[0]);
            data = MtdEngine.getNodeContent(nodeId);
        }
        return new BinaryObject(data);
    }

    public static Object getNodeContentAsText(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        if (args.length == 0) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 (ID) \u0443\u0437\u043b\u0430");
        }
        double nodeId = ValueCaster.toDouble(args[0]);
        byte[] content = args.length >= 2 ? ValueCaster.toBytes(args[1]) : MtdEngine.getNodeContent(nodeId);
        Node node = MtdEngine.getValidNode(nodeId);
        StringBuilder textContent = new StringBuilder();
        switch (node.getType()) {
            case 11: {
                DForm form = new DForm();
                form.loadTaggedContent(new TaggedReader(content));
                form.storeTextContent(0, textContent, 0, false);
                break;
            }
            case 19: {
                DSearch search = new DSearch();
                search.loadTaggedContent(new TaggedReader(content));
                search.storeTextContent(0, textContent, 0, false);
                break;
            }
            default: {
                MtdEngine.throwDetailError("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430 \u0443\u0437\u043b\u0430", nodeId);
            }
        }
        return textContent.toString();
    }

    public static Object getDslSpec(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 0) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u0438\u043f (NodeType) \u0443\u0437\u043b\u0430");
        }
        int nodeType = ValueCaster.toInt(args[0]);
        StringBuilder textContent = new StringBuilder();
        if (nodeType == 11) {
            DForm f = new DForm();
            f.storeSpec(textContent);
        }
        return textContent.toString();
    }

    public static Object getRuntimeNodeContent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        if (args.length == 0) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 (ID) \u0443\u0437\u043b\u0430");
        }
        double nodeId = ValueCaster.toDouble(args[0]);
        Node node = MtdEngine.getValidNode(nodeId);
        switch (node.getType()) {
            case 11: 
            case 19: {
                break;
            }
            default: {
                MtdEngine.throwDetailError("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e runtime \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430 \u0443\u0437\u043b\u0430", nodeId);
            }
        }
        BasicNode basicNode = MtdEngine.getRealNode(nodeId);
        BasicNode.NodeContent content = basicNode.getNodeContent(MtdEngine.getPin(nodeId), false);
        byte[] result = new byte[]{};
        if (content.dslContent != null) {
            result = DslRuntime.getContent(null, null, null, basicNode, content.dslContent);
        }
        return new BinaryObject(result);
    }

    public static BinaryObject _getNodeContent(double nodeid) throws InformException {
        byte[] data = MtdEngine.getNodeContent(nodeid);
        return new BinaryObject(data);
    }

    public static Object loadUser(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        if (args.length < 1) {
            return null;
        }
        Object arg = args[0];
        if (arg == null || !(arg instanceof RowsetAccessor)) {
            return null;
        }
        MetadataLibrary lib = (MetadataLibrary)thisObj;
        RowsetAccessor ra = (RowsetAccessor)arg;
        SqlParameter[] fields = lib.usersTable.selectFromDatasource(ra);
        if (fields == null) {
            return null;
        }
        ScriptTableUserNode user = new ScriptTableUserNode(lib, fields, lib.usersTable, lib.rolesTable);
        user.init();
        return user;
    }

    public static Object getAccessMask(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, TaggedReaderException, InformException, SQLException {
        if (args.length < 2) {
            return 0;
        }
        double nodeId = ValueCaster.toDouble(args[0]);
        double userId = ValueCaster.toDouble(args[1]);
        MetadataLibrary lib = (MetadataLibrary)thisObj;
        lib.idle();
        ScriptNode node = lib.getNode(nodeId);
        if (!(node instanceof ScriptCustomNode)) {
            return 0;
        }
        ScriptCustomNode customNode = (ScriptCustomNode)node;
        lib.idle();
        return customNode.calculateAccessMask(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUsersInTable() throws IOException, SQLException {
        if (this.usersTable.enabled()) {
            ClosableResult userInTable;
            if (this.userInTableCache == null) {
                this.userInTableCache = new DoubleHash();
            }
            if ((userInTable = this.usersTable.selectAll(this.ssContext)) != null) {
                try {
                    ResultSet resultSet = userInTable.getResultSet();
                    while (resultSet.next()) {
                        SqlParameter[] fields = this.usersTable.getValues(resultSet);
                        if (fields == null) continue;
                        double nodeId = fields[0].getDouble();
                        ScriptTableUserNode user = new ScriptTableUserNode(this, fields, this.usersTable, this.rolesTable);
                        this.userInTableCache.add(new ScriptNodeEntry(nodeId, user));
                        this.userIdCache.add(nodeId);
                    }
                }
                finally {
                    userInTable.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAccountNodesToCache() throws InformException, SQLException, IOException {
        this.idle();
        if (this.userIdCache != null) {
            return;
        }
        if (this.nodeCache == null) {
            this.nodeCache = new DoubleHash();
        }
        this.userIdCache = new DoubleList(16);
        int[] types = new int[]{3, 4, 57};
        DatabaseConnection connection = this.dbManager.getConnection(2.0, "JS:MetadataLibrary");
        try (ClosableResult closableResult = MetadataNodeReader.getResultSetForTypedNode(this.ssContext, types, connection, false);){
            ResultSet resultSet = closableResult.getResultSet();
            this.idle();
            while (resultSet.next()) {
                this.idle();
                double nodeId = resultSet.getDouble(resultSet.findColumn("ID"));
                ScriptNode node = null;
                SoftReference item = this.nodeCache.get(nodeId);
                if (item != null) {
                    node = (ScriptNode)item.get();
                }
                if (node == null) {
                    MetadataNodeReader metaNode = MetadataNodeReader.createNode(nodeId, resultSet);
                    node = this.createNode(metaNode);
                    this.nodeCache.add(new ScriptNodeEntry(nodeId, node));
                }
                switch (node.getType()) {
                    case 3: {
                        this.userIdCache.add(nodeId);
                    }
                }
            }
            this.idle();
        }
        this.loadUsersInTable();
    }

    public static Object getNodeByID(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, TaggedReaderException, InformException, SQLException {
        MetadataLibrary lib = (MetadataLibrary)thisObj;
        if (args.length == 0) {
            return null;
        }
        double nodeId = ValueCaster.toDouble(args[0]);
        return lib.getNode(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public double[] findNodesByType(int type) throws SQLException {
        DatabaseConnection connection = this.dbManager.getConnection(2.0, "JS:MetadataLibrary:findNodesByType");
        try (ClosableResult cr = MetadataNodeReader.getResultSetForTypedNode(this.ssContext, new int[]{type}, connection, false);){
            ResultSet rs = cr.getResultSet();
            int fid = rs.findColumn("ID");
            this.idle();
            DoubleList result = new DoubleList(64);
            while (rs.next()) {
                this.idle();
                result.add(rs.getDouble(fid));
            }
            double[] dArray = result.toArray();
            return dArray;
        }
    }

    public static Object getUserByID(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, TaggedReaderException, InformException, SQLException {
        ScriptNode node;
        MetadataLibrary lib = (MetadataLibrary)thisObj;
        if (args.length == 0) {
            return null;
        }
        double nodeId = ValueCaster.toDouble(args[0]);
        if (MtdEngine.serverNode().descriptor().useUsersTable && (node = lib.getUserInTable(nodeId)) != null) {
            return node;
        }
        return lib.getNode(nodeId);
    }

    public static Object isUserHasRole(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws SQLException, IOException, TaggedReaderException, InformException {
        if (args.length < 2) {
            return false;
        }
        MetadataLibrary lib = (MetadataLibrary)thisObj;
        double userId = ValueCaster.toDouble(args[0]);
        double roleId = ValueCaster.toDouble(args[1]);
        ScriptNode node = lib.getNode(userId);
        if (node == null || !(node instanceof ScriptUserNode)) {
            return false;
        }
        ScriptUserNode userNode = (ScriptUserNode)node;
        return userNode.containsRole(roleId);
    }

    public static Object getUsersWithRole(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws SQLException, IOException, TaggedReaderException, InformException {
        if (args.length == 0) {
            return null;
        }
        MetadataLibrary lib = (MetadataLibrary)thisObj;
        lib.loadAccountNodesToCache();
        double roleId = ValueCaster.toDouble(args[0]);
        DoubleList users = new DoubleList(2);
        for (Cursor.Double c : lib.userIdCache) {
            ScriptUserNode userNode;
            lib.idle();
            ScriptNode node = lib.getNode(c.value);
            if (node == null || !(userNode = (ScriptUserNode)node).containsRole(roleId)) continue;
            users.add(userNode.getId());
        }
        users.shrink();
        return users.internalArray();
    }

    public static Object getUsersWithPermissions(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws SQLException, IOException, TaggedReaderException, InformException {
        if (args.length < 2) {
            return null;
        }
        MetadataLibrary lib = (MetadataLibrary)thisObj;
        lib.loadAccountNodesToCache();
        double nodeId = ValueCaster.toDouble(args[0]);
        int accessMask = ValueCaster.toInt(args[1]);
        ScriptNode aNode = lib.getNode(nodeId);
        if (aNode == null || !(aNode instanceof ScriptCustomNode)) {
            return null;
        }
        ScriptCustomNode node = (ScriptCustomNode)aNode;
        DoubleList users = new DoubleList(2);
        for (Cursor.Double c : lib.userIdCache) {
            lib.idle();
            int nodeMask = node.calculateAccessMask(c.value);
            if ((accessMask & nodeMask) != nodeMask) continue;
            users.add(c.value);
        }
        users.shrink();
        return users.internalArray();
    }

    public static Object getTableFkDependencies(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws SQLException, IOException, TaggedReaderException, InformException {
        if (args.length < 1) {
            return null;
        }
        double tableId = ValueCaster.toDouble(args[0]);
        TableDescriptor tDesc = new TableDescriptor(tableId, false);
        double[] refTables = tDesc.getReferences(((MetadataLibrary)thisObj).ssHost);
        if (refTables != null && refTables.length > 0) {
            DoubleList res = new DoubleList(0);
            for (double refNodeId : refTables) {
                TableDescriptor refTable = TableDescriptor.getIfExists(refNodeId);
                if (refTable == null || refTable.getKind() == TableDescriptor.Kind.VIRTUAL) continue;
                res.add(refNodeId);
            }
            res.shrink();
            return res.internalArray();
        }
        return null;
    }

    public static int replaceRecordsRefs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws SQLException, IOException, TaggedReaderException, InformException, Throwable {
        if (args.length < 4) {
            return 0;
        }
        int count = 0;
        double tableID = ValueCaster.toDouble(args[0]);
        double recordID = ValueCaster.toDouble(args[1]);
        double newRecordID = ValueCaster.toDouble(args[2]);
        double fkRefsTableID = ValueCaster.toDouble(args[3]);
        MetadataLibrary lib = (MetadataLibrary)thisObj;
        count = ReplaceRecordRefsRequest.replaceRecordsRefs(lib.ssHost, tableID, recordID, newRecordID, fkRefsTableID);
        return count;
    }

    public static Object createUserAccessRightsHistory(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws SQLException, IOException, TaggedReaderException, InformException {
        MetadataLibrary lib = (MetadataLibrary)thisObj;
        if (lib.hObj == null) {
            lib.hObj = new UserAccessRightsHistory(lib.ssContext);
        }
        return lib.hObj;
    }

    public static Object createTableUser(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        double userId = args != null && args.length != 0 ? ValueCaster.toDouble(args[0]) : 0.0;
        MetadataLibrary lib = (MetadataLibrary)thisObj;
        return new ScriptTableUser(lib, lib.ssHost, lib.usersTable, lib.rolesTable, userId);
    }

    @Override
    public String getClassName() {
        return "Metadata";
    }

    MetadataNodeReader getMetadataNode(double nodeId) throws InformException {
        this.idle();
        try {
            DatabaseConnection connection = this.dbManager.getConnection(2.0, "JS:MetadataLibrary");
            return MetadataNodeReader.createNode(this.ssContext, nodeId, connection);
        }
        catch (SQLException e) {
            throw InformException.wrap(e);
        }
    }

    ScriptNode createNode(MetadataNodeReader metaNode) throws IOException, TaggedReaderException {
        this.idle();
        ScriptNode node = null;
        switch (metaNode.type) {
            case 3: {
                node = new ScriptUserNode(this, metaNode);
                break;
            }
            case 4: 
            case 57: {
                node = new ScriptUserGroupNode(this, metaNode);
                break;
            }
            case 2: {
                node = new ScriptSymLinkNode(this, metaNode);
                break;
            }
            default: {
                node = new ScriptCustomNode(this, metaNode);
            }
        }
        if (node != null) {
            node.init();
        }
        return node;
    }

    ScriptNode getUserInTable(double userId) throws SQLException, IOException {
        if (this.usersTable.enabled()) {
            if (this.userInTableCache == null) {
                this.userInTableCache = new DoubleHash();
            }
            ScriptNode node = null;
            SoftReference item = this.userInTableCache.get(userId);
            if (item != null) {
                node = (ScriptNode)item.get();
            }
            if (node != null) {
                return node;
            }
            SqlParameter[] userInTable = this.usersTable.select(this.ssContext, userId);
            if (userInTable != null) {
                node = new ScriptTableUserNode(this, userInTable, this.usersTable, this.rolesTable);
                node.init();
                this.userInTableCache.add(new ScriptNodeEntry(userId, node));
            }
            this.idle();
            return node;
        }
        return null;
    }

    ScriptNode getNode(double nodeId) throws SQLException, IOException {
        ScriptNodeEntry item;
        this.idle();
        ScriptNode node = null;
        if (this.nodeCache == null) {
            this.nodeCache = new DoubleHash();
            item = null;
        } else {
            item = this.nodeCache.get(nodeId);
            if (item != null) {
                if (item.notfound) {
                    return null;
                }
                node = (ScriptNode)item.get();
            }
        }
        if (node == null) {
            MetadataNodeReader metaNode = this.getMetadataNode(nodeId);
            if (metaNode == null) {
                if (item == null) {
                    item = new ScriptNodeEntry(nodeId, null);
                    this.nodeCache.add(item);
                }
                item.notfound = true;
                return null;
            }
            node = this.createNode(metaNode);
            this.nodeCache.add(new ScriptNodeEntry(nodeId, node));
        }
        this.idle();
        return node;
    }

    public ServerSideHost getServerSideHost() {
        return this.ssHost;
    }

    public void idle() {
        if (this.ssHost != null) {
            this.ssHost.idle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public String updateTableStructure(double nodeId, boolean inTransaction) throws SQLException {
        TableDescriptor descriptor = TableDescriptor.get(nodeId);
        DatabaseConnection connection = inTransaction ? this.dbManager.getConnection(descriptor.getDbId(), "js:Metadata.updateTableStructure") : descriptor.getDatabaseDescriptor().connect(this.ssHost, "js:Metadata.updateTableStructure");
        try {
            String string;
            DbScheme scheme = connection.openScheme();
            Statement statement = connection.createStatement();
            try {
                StringBuilderLogger logger = new StringBuilderLogger();
                Restructure.updateTable(this.ssContext, scheme, statement, descriptor, descriptor, logger, Restructure.Strategy.UPDATE);
                if (!inTransaction) {
                    connection.commit();
                }
                string = logger.log.toString().trim();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return string;
        }
        finally {
            if (!inTransaction) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public String restructureIndices(double nodeId, Object strategy) throws SQLException {
        TableDescriptor descriptor = TableDescriptor.get(nodeId);
        try (DatabaseConnection connection = descriptor.getDatabaseDescriptor().connect(this.ssHost, "js:Metadata.restructureIndices");){
            String string;
            DbScheme scheme = connection.openScheme();
            Statement statement = connection.createStatement();
            try {
                StringBuilderLogger logger = new StringBuilderLogger();
                Restructure.restructureIndices(this.ssContext, scheme, statement, descriptor, descriptor, logger, (Restructure.Strategy)((Object)strategy), null, new Restructure.Progress.FromSSHost(this.ssHost));
                connection.commit();
                string = logger.log.toString().trim();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return string;
        }
    }

    public static boolean checkFileName(String fileName) {
        Pattern pattern = Pattern.compile("/?\\w+:.*");
        return pattern.matcher(fileName).matches();
    }

    private static Object backupH2(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws SQLException, IOException, InformException {
        MetadataLibrary mdLib = (MetadataLibrary)thisObj;
        double databaseId = ((Number)args[0]).doubleValue();
        String fileName = args[1].toString();
        MetadataNodeReader node = mdLib.getMetadataNode(databaseId);
        if (node.type != 10) {
            return "\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0443\u0437\u0435\u043b \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0443\u0437\u043b\u043e\u043c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445!";
        }
        try {
            DatabaseConnection localConnection = mdLib.dbManager.getConnection(databaseId, "backupH2");
            PreparedStatement statement = localConnection.prepareStatement("backup to '" + fileName + "'");
            if (statement.execute(mdLib.ssContext) == 0) {
                statement.close();
                return "\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430 \u0432 \u0444\u0430\u0439\u043b '" + fileName + "'";
            }
            return "\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u0434\u0435\u043b\u0430\u043d\u0430!";
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
            return "\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0435 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0447\u0442\u043e \u0444\u0430\u0439\u043b \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u0434\u0440\u0443\u0433\u0438\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u043c.";
        }
    }

    public static Object backupDatabase(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws SQLException, IOException, InformException {
        if (args.length < 2) {
            return "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432!";
        }
        if (!(args[0] instanceof Double)) {
            return "\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0437\u043b\u0430 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445!";
        }
        if (!MetadataLibrary.checkFileName(args[1].toString())) {
            return "\u0423\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u0434\u043b\u044f \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438!";
        }
        if (DatabaseType.get(Ini.MetabaseDBKind) == DatabaseType.H2) {
            return MetadataLibrary.backupH2(cx, thisObj, args, funObj);
        }
        return "\u041c\u0435\u0442\u043e\u0434 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0433\u043e \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445!";
    }

    public static boolean coldBackupDatabase() {
        String fileName = Ini.BackupFileName;
        if (!MetadataLibrary.checkFileName(fileName)) {
            Core.logger.info("File name is not correct!");
            return false;
        }
        if (DatabaseType.get(Ini.MetabaseDBKind) == DatabaseType.H2) {
            return MetadataLibrary.coldBackupH2(fileName);
        }
        Core.logger.info("Backup method is not defined for this database type!");
        return false;
    }

    private static boolean coldBackupH2(String fileName) {
        try {
            DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("MtdEngine::coldBackupH2");
            try (PreparedStatement statement = connection.prepareStatement("backup to '" + fileName + "'");){
                statement.execute(null);
            }
            connection.close();
        }
        catch (SQLException e) {
            Core.logger.info("Backup aborted! Database file is locked.", e);
            return false;
        }
        catch (Exception e) {
            Core.logger.info("Backup aborted! Unknown error.", e);
            return false;
        }
        return true;
    }

    private static class StringBuilderLogger
    extends Restructure.RealLogger {
        final StringBuilder log = new StringBuilder();

        private StringBuilderLogger() {
        }

        @Override
        public void log(TableDescriptor context, String line) {
            super.log(context, line);
            this.log.append(line).append('\n');
        }
    }

    private static class ScriptNodeEntry
    extends SoftReference<ScriptNode>
    implements DoubleHash.Entry {
        private final double key;
        private boolean notfound;

        ScriptNodeEntry(double key, ScriptNode referent) {
            super(referent);
            this.key = key;
        }

        @Override
        public double key() {
            return this.key;
        }
    }
}

