/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleList;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.mtd.request.GetUserAccessRightsHistory;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.metadata.UserAccessRightsHistoryEntity;
import inform.agent.scripts.metadata.UserAccessRightsHistoryList;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.mozilla.javascript.ScriptableObject;

public class UserAccessRightsHistory
extends ScriptableObject {
    private static String[] availJSFunctionsNames = new String[]{"execute", "clear"};
    private static String[] jsRWProperties = new String[]{"beginDate", "endDate", "userID"};
    private static String[] jsRProperties = new String[]{"entities"};
    private double beginDate = -1.0;
    private double endDate = -1.0;
    private double userID = -1.0;
    private UserAccessRightsHistoryList entities = new UserAccessRightsHistoryList();
    public final SSContext ssContext;

    UserAccessRightsHistory(SSContext ssContext) {
        this.ssContext = ssContext;
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
        for (String propertyName : jsRWProperties) {
            this.defineProperty(propertyName, this.getClass(), 0);
        }
        for (String propertyName : jsRProperties) {
            this.defineProperty(propertyName, this.getClass(), 1);
        }
    }

    @Override
    public String getClassName() {
        return "UserAccessRightsHistoryObject";
    }

    public double getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(double beginDate) {
        this.beginDate = beginDate;
    }

    public double getEndDate() {
        return this.endDate;
    }

    public void setEndDate(double endDate) {
        this.endDate = endDate;
    }

    public double getUserID() {
        return this.userID;
    }

    public void setUserID(double userId) {
        this.userID = userId;
    }

    public UserAccessRightsHistoryList getEntities() {
        return this.entities;
    }

    public void clear() throws InformException, SQLException, IOException, TaggedReaderException {
        this.entities.entities.clear();
    }

    public void execute() throws InformException, SQLException, IOException, TaggedReaderException {
        Timestamp _endDate;
        if (this.beginDate == -1.0) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u0430\u0442\u0430!");
        }
        GetUserAccessRightsHistory.UserAccessRightsHistorFilter filter = new GetUserAccessRightsHistory.UserAccessRightsHistorFilter();
        filter.userId = this.userID;
        filter.startDate = new Timestamp(DateTime.toUnixTime(this.beginDate));
        filter.endDate = _endDate = this.endDate == -1.0 ? new Timestamp(System.currentTimeMillis()) : new Timestamp(DateTime.toUnixTime(this.endDate));
        if (filter.userId == -1.0) {
            DoubleList nodes = GetUserAccessRightsHistory.getNodes(this.ssContext, filter);
            for (Cursor.Double c : nodes) {
                this.fillHistory(GetUserAccessRightsHistory.getNodeAccessRightsHistory(this.ssContext, c.value, filter, false));
            }
        } else {
            this.fillHistory(GetUserAccessRightsHistory.getNodeAccessRightsHistory(this.ssContext, filter.userId, filter, false));
        }
    }

    private void fillHistory(GetUserAccessRightsHistory.UserARsHistory hist) {
        if (hist == null) {
            return;
        }
        for (GetUserAccessRightsHistory.RoleModification mod : hist.mods) {
            this.entities.entities.add(new UserAccessRightsHistoryEntity(hist, mod));
        }
    }
}

