/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.pdf;

import com.google.zxing.BarcodeFormat;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.collections.IntegerIntegerMap;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.barcode.BarcodeRequest;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasourceField;
import inform.agent.web.utils.HorizontalAlign;
import inform.common.SmartScriptableObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.DrawObject;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.multipdf.Overlay;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;

public class PdfDocument
extends SmartScriptableObject {
    private static final String MESSAGE_MISSINGFILE = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b '%s'. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u0438 \u043c\u0435\u0441\u0442\u043e\u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.";
    private static final String MESSAGE_EMPTYBINARY = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c PDF-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u0431\u0438\u043d\u0430\u0440\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430";
    private static final String MESSAGE_EMPTYFIELD = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c PDF-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445";
    private static final String MESSAGE_BADFIELDTYPE_READ = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c PDF-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 c \u0442\u0438\u043f\u043e\u043c '%s'";
    private static final String MESSAGE_BAD_PAGE_INDEX = "\u0418\u043d\u0434\u0435\u043a\u0441 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b '%s' \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u0430\u043c\u0438 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0433\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446";
    private static final String MESSAGE_EMPTYTEXT = "\u0422\u0435\u043a\u0441\u0442 \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c";
    private static final String MESSAGE_FONTABSENT = "\u0424\u0430\u0439\u043b \u0448\u0440\u0438\u0444\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
    private static final String DEFAULT_LAYER_NAME = "asmo_stamps";
    private static final double MM_PER_INCH = 25.4;
    private static final float[] PEN_PATTREN_SOLID = new float[]{15.0f, 0.0f};
    private static final float[] PEN_PATTREN_DASH = new float[]{21.0f, 9.0f};
    private static final float[] PEN_PATTREN_DOT = new float[]{6.0f, 6.0f};
    private static final float[] PEN_PATTREN_DASH_DOT = new float[]{18.0f, 9.0f, 6.0f, 9.0f};
    private static final float[] PEN_PATTREN_DASH_DOT2 = new float[]{18.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f};
    private PDDocument _pdf = null;
    private int _barcodeIndex = 1;
    private final ArrayList<StampItem> _stampItems = new ArrayList();
    private static Font _arial = null;
    private static Font _arialbd = null;
    private static Font _arialbi = null;
    private static Font _ariali = null;
    private static Font _cour = null;
    private static Font _courbd = null;
    private static Font _courbi = null;
    private static Font _couri = null;
    private static Font _tahoma = null;
    private static Font _tahomabd = null;
    private static Font _times = null;
    private static Font _timesbd = null;
    private static Font _timesbi = null;
    private static Font _timesi = null;
    private static IniFile _ini = null;
    private static Font _defaultFont = null;
    private PDFont _arialPD = null;
    private PDFont _arialbdPD = null;
    private PDFont _arialbiPD = null;
    private PDFont _arialiPD = null;
    private PDFont _courPD = null;
    private PDFont _courbdPD = null;
    private PDFont _courbiPD = null;
    private PDFont _couriPD = null;
    private PDFont _tahomaPD = null;
    private PDFont _tahomabdPD = null;
    private PDFont _timesPD = null;
    private PDFont _timesbdPD = null;
    private PDFont _timesbiPD = null;
    private PDFont _timesiPD = null;
    private PDFont _defaultFontPD = null;
    private static boolean _iniNotFound = false;

    private PdfDocument(Scriptable scope) {
        this.setParentScope(scope);
        this.checkFontIniExists();
    }

    private void checkFontIniExists() {
        _iniNotFound = true;
        String dirPath = Ini.HomePath + File.separator + "fonts";
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return;
        }
        File fontFile = new File(dir, "fonts.ini");
        if (fontFile.exists()) {
            _iniNotFound = false;
        } else {
            for (String fileName : dir.list()) {
                if (!fileName.endsWith(".ini") || !(fontFile = new File(dir, fileName)).exists()) continue;
                _iniNotFound = false;
            }
        }
    }

    public static PdfDocument openPdfDocument(Scriptable scope, String fileName) throws IOException {
        PdfDocument pdfDoc = new PdfDocument(scope);
        File file = Core.mountfs.resolve(new File(fileName));
        if (!file.exists()) {
            throw new InformException(String.format(MESSAGE_MISSINGFILE, fileName));
        }
        pdfDoc._pdf = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBufferedFile(file));
        return pdfDoc;
    }

    public static PdfDocument openPdfDocument(Scriptable scope, BinaryObject binary) throws IOException {
        PdfDocument pdfDoc = new PdfDocument(scope);
        if (binary.getSize() == 0) {
            throw new InformException(MESSAGE_EMPTYBINARY);
        }
        pdfDoc._pdf = Loader.loadPDF((byte[])binary.getInternalBuffer());
        return pdfDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PdfDocument openPdfDocument(Scriptable scope, DatasourceField field) throws Exception {
        PdfDocument pdfDoc = new PdfDocument(scope);
        if (field.getIsNull()) {
            throw new InformException(MESSAGE_EMPTYFIELD);
        }
        InputStream is = null;
        switch (field.getDataType()) {
            case BLOB: {
                if (field.getDescriptor().getBlobRawType() != FieldDescriptor.BlobRawType.BINARY) {
                    throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, DataType.BLOB + "(" + field.getDescriptor().getBlobRawType() + ")"));
                }
                BinaryObject binary = ((BlobField)field).getAsBinary();
                assert (binary != null);
                is = new ByteArrayInputStream(binary.getInternalBuffer());
                break;
            }
            case FILE: {
                is = ((BlobFileField)field).openFileStream();
                if (is != null) break;
                Core.logger.warn("\u041f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 Pdf \u0444\u0430\u0439\u043b-\u043f\u043e\u043b\u0435 \u043e\u043a\u0430\u0437\u0430\u043b\u043e\u0441\u044c \u043f\u0443\u0441\u0442\u044b\u043c.");
                return null;
            }
            default: {
                throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, new Object[]{field.getDataType()}));
            }
        }
        assert (is != null);
        try {
            pdfDoc._pdf = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer(is));
            PdfDocument pdfDocument = pdfDoc;
            return pdfDocument;
        }
        finally {
            is.close();
        }
    }

    @Override
    public String getClassName() {
        return "PdfDocument";
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        this._pdf.close();
    }

    @SmartScriptableObject.PropertyTag
    public int getpageCount() {
        return this._pdf.getNumberOfPages();
    }

    private String getCompressedStr(boolean useCompress, Object vals) {
        if (vals == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String[] arr = new String[1];
        if (vals instanceof NativeArray) {
            Object[] objArr;
            String[] arrList = new ArrayList();
            for (Object obj : objArr = ((NativeArray)vals).toArray()) {
                if (obj == null) continue;
                String str = obj.toString();
                if (obj instanceof Number) {
                    str = NumberConverter.doubleToString(((Number)obj).doubleValue());
                }
                if (!useCompress) {
                    arrList.add(str);
                    continue;
                }
                arrList.addAll(Arrays.asList(str.split("[\\s+-]")));
            }
            arr = arrList.toArray(arr);
        } else if (!useCompress) {
            arr[0] = String.valueOf(vals);
            if (vals instanceof Number) {
                arr[0] = NumberConverter.doubleToString(((Number)vals).doubleValue());
            }
        } else {
            arr = String.valueOf(vals).split("[\\s+-]");
        }
        if (!useCompress) {
            for (String val : arr) {
                result.append(val);
            }
            return result.toString();
        }
        for (int i = 0; i < arr.length; ++i) {
            if (i == arr.length - 1) {
                result.append(arr[i].toUpperCase());
                continue;
            }
            if (arr[i].length() <= 3) {
                result.append(arr[i].toUpperCase());
                continue;
            }
            result.append(arr[i].substring(0, 3).toUpperCase());
        }
        return result.toString();
    }

    @SmartScriptableObject.FunctionTag
    public String putBarcode(String barcodeType, int pageIndex, double widthMM, double heightMM, double offsetX, double offsetY, boolean useTopLeftOffset, String orientation, boolean symbVisible, int resolution, boolean useCompress, int bgColor, int borderWidthDesiredMM, Object vals) throws IOException, Exception {
        double y;
        double x;
        double h;
        double w;
        int orient;
        if (pageIndex < 1 || pageIndex > this._pdf.getNumberOfPages()) {
            throw new InformException(String.format(MESSAGE_BAD_PAGE_INDEX, pageIndex));
        }
        PDPage page = this._pdf.getPage(pageIndex - 1);
        PDRectangle vRect = page.getMediaBox();
        double pageHeight = (double)(vRect.getHeight() / 72.0f) * 25.4;
        double pageWidth = (double)(vRect.getWidth() / 72.0f) * 25.4;
        if (pageWidth < widthMM || pageHeight < heightMM) {
            throw new InformException("\u0420\u0430\u0437\u043c\u0435\u0440\u044b \u0431\u0430\u0440\u043a\u043e\u0434\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b");
        }
        PDPageContentStream contentStream = new PDPageContentStream(this._pdf, page, PDPageContentStream.AppendMode.APPEND, true, true);
        BarcodeFormat format = BarcodeFormat.EAN_13;
        if (!Strings.isVoid(barcodeType)) {
            if (barcodeType.equalsIgnoreCase("EAN8")) {
                format = BarcodeFormat.EAN_8;
            } else if (barcodeType.equalsIgnoreCase("CODE39")) {
                format = BarcodeFormat.CODE_39;
            } else if (barcodeType.equalsIgnoreCase("CODE128")) {
                format = BarcodeFormat.CODE_128;
            } else if (barcodeType.equalsIgnoreCase("PDF417")) {
                format = BarcodeFormat.PDF_417;
            } else if (barcodeType.equalsIgnoreCase("QRCODE")) {
                format = BarcodeFormat.QR_CODE;
            }
        }
        int res = 600;
        if (resolution >= 100) {
            res = resolution;
        }
        int width = (int)Math.round((double)res * widthMM / 25.4);
        int height = (int)Math.round((double)res * heightMM / 25.4);
        int borderWidthDesired = (int)Math.round((double)(res * borderWidthDesiredMM) / 25.4);
        String resultStr = this.getCompressedStr(useCompress, vals);
        int pageRotateAngle = page.getRotation();
        switch (pageRotateAngle) {
            case 270: {
                int buf = width;
                width = height;
                height = buf;
                orient = 2;
                if (orientation.equalsIgnoreCase("RightLeft")) {
                    orient = 3;
                    break;
                }
                if (orientation.equalsIgnoreCase("TopBottom")) {
                    orient = 1;
                    break;
                }
                if (!orientation.equalsIgnoreCase("BottomTop")) break;
                orient = 0;
                break;
            }
            default: {
                orient = 0;
                if (orientation.equalsIgnoreCase("RightLeft")) {
                    orient = 1;
                    break;
                }
                if (orientation.equalsIgnoreCase("TopBottom")) {
                    orient = 2;
                    break;
                }
                if (!orientation.equalsIgnoreCase("BottomTop")) break;
                orient = 3;
            }
        }
        byte[] imageContent = BarcodeRequest.drawBarCode(null, format.ordinal(), resultStr, width, height, "PNG", orient, symbVisible, true, bgColor, borderWidthDesired);
        PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)this._pdf, (byte[])imageContent, (String)("barcode" + this._barcodeIndex++));
        if (pageRotateAngle == 270) {
            w = heightMM;
            h = widthMM;
        } else {
            h = heightMM;
            w = widthMM;
        }
        if (useTopLeftOffset) {
            if (pageRotateAngle == 270) {
                x = pageWidth - offsetY - w;
                y = offsetX + h;
            } else {
                x = offsetX;
                y = offsetY + h;
            }
        } else if (pageRotateAngle == 270) {
            x = offsetY;
            y = pageHeight - offsetX;
        } else {
            x = pageWidth - w - offsetX;
            y = pageHeight - offsetY;
        }
        Point2D point = PdfDocument.getTranslatedCoord(x, y, pageHeight);
        contentStream.drawImage(pdImage, (float)point.getX(), (float)point.getY(), (float)PdfDocument.mmTo1_72inch(w), (float)PdfDocument.mmTo1_72inch(h));
        contentStream.close();
        return resultStr;
    }

    public static void modAlpha(BufferedImage image, double modAmount) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int argb = image.getRGB(x, y);
                int alpha = argb >> 24 & 0xFF;
                alpha = (int)((double)alpha * modAmount);
                argb &= 0xFFFFFF;
                image.setRGB(x, y, argb |= (alpha &= 0xFF) << 24);
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public void clearStampLayer(String userLayerName) throws IOException, Exception {
        PDOptionalContentGroup layer;
        String layerName = Strings.isVoid(userLayerName) || userLayerName.equalsIgnoreCase("undefined") ? DEFAULT_LAYER_NAME : userLayerName;
        PDDocumentCatalog catalog = this._pdf.getDocumentCatalog();
        PDOptionalContentProperties ocprops = catalog.getOCProperties();
        if (ocprops == null) {
            ocprops = new PDOptionalContentProperties();
            catalog.setOCProperties(ocprops);
        }
        if ((layer = ocprops.getGroup(layerName)) == null) {
            layer = new PDOptionalContentGroup(layerName);
            ocprops.addGroup(layer);
        }
        for (PDPage page : this._pdf.getDocumentCatalog().getPages()) {
            PDResources resources = page.getResources();
            if (resources == null) continue;
            PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
            List tokens = parser.parse();
            ArrayList<Object> newTokens = new ArrayList<Object>();
            IntegerIntegerMap deletionIndexList = new IntegerIntegerMap();
            Object[] tokensArray = tokens.toArray();
            for (int index = 0; index < tokensArray.length; ++index) {
                PDPropertyList prop;
                Object obj = tokensArray[index];
                if (!(obj instanceof COSName) || (COSName)obj != COSName.OC) continue;
                int startIndex = index++;
                if (index >= tokensArray.length || !((obj = tokensArray[index]) instanceof COSName) || (prop = resources.getProperties((COSName)obj)) == null || !(prop instanceof PDOptionalContentGroup) || !layerName.equalsIgnoreCase(((PDOptionalContentGroup)prop).getName()) || ++index >= tokensArray.length || !((obj = tokensArray[index]) instanceof Operator) || !"BDC".equals(((Operator)obj).getName())) continue;
                int endIndex = -1;
                ++index;
                while (index < tokensArray.length) {
                    obj = tokensArray[index];
                    if (obj instanceof Operator && "EMC".equals(((Operator)obj).getName())) {
                        endIndex = index;
                        break;
                    }
                    ++index;
                }
                if (endIndex < 0) continue;
                deletionIndexList.put(startIndex, endIndex);
            }
            int tokensListIndex = 0;
            for (IntegerIntegerMap.Cursor cursor : deletionIndexList) {
                while (tokensListIndex < cursor.key) {
                    newTokens.add(tokensArray[tokensListIndex]);
                    ++tokensListIndex;
                }
                tokensListIndex = cursor.value + 1;
            }
            while (tokensListIndex < tokensArray.length) {
                newTokens.add(tokensArray[tokensListIndex]);
                ++tokensListIndex;
            }
            PDStream newContents = new PDStream(this._pdf);
            try (OutputStream output = newContents.createOutputStream(COSName.FLATE_DECODE);){
                ContentStreamWriter writer = new ContentStreamWriter(output);
                writer.writeTokens(newTokens);
            }
            page.setContents(newContents);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void addStampItem(String text, String fontName, int fontSize, int fontStyle, int fontColor, int posX, int posY, String align) {
        if (align.equalsIgnoreCase("center")) {
            this._stampItems.add(new StampItem(text, fontName, fontSize, fontStyle, fontColor, posX, posY, HorizontalAlign.CENTER));
        } else {
            this._stampItems.add(new StampItem(text, fontName, fontSize, fontStyle, fontColor, posX, posY, HorizontalAlign.LEFT));
        }
    }

    @SmartScriptableObject.FunctionTag
    public void clearStampItems() {
        this._stampItems.clear();
    }

    @SmartScriptableObject.FunctionTag
    public void putStamp(int pageIndex, double widthMM, double heightMM, double offsetX, double offsetY, boolean useTopLeftOffset, String orientation, int bgColor, int borderWidthDesiredMM, BinaryObject stampTemplate, String userLayerName) throws IOException, Exception {
        double y;
        double x;
        PDOptionalContentGroup layer;
        if (stampTemplate == null || stampTemplate.getSize() == 0) {
            throw new InformException(MESSAGE_EMPTYBINARY);
        }
        if (pageIndex < 1 || pageIndex > this._pdf.getNumberOfPages()) {
            throw new InformException(String.format(MESSAGE_BAD_PAGE_INDEX, pageIndex));
        }
        PDPage page = this._pdf.getPage(pageIndex - 1);
        PDRectangle vRect = page.getMediaBox();
        double pageHeight = (double)(vRect.getHeight() / 72.0f) * 25.4;
        double pageWidth = (double)(vRect.getWidth() / 72.0f) * 25.4;
        if (pageWidth < widthMM || pageHeight < heightMM) {
            throw new InformException("\u0420\u0430\u0437\u043c\u0435\u0440\u044b \u0448\u0442\u0430\u043c\u043f\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b");
        }
        if ((double)(borderWidthDesiredMM * 2) >= widthMM || (double)(borderWidthDesiredMM * 2) >= heightMM) {
            throw new InformException("\u041e\u0442\u0441\u0442\u0443\u043f \u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u0435\u0442 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0448\u0442\u0430\u043c\u043f\u0430");
        }
        String layerName = Strings.isVoid(userLayerName) || userLayerName.equalsIgnoreCase("undefined") ? DEFAULT_LAYER_NAME : userLayerName;
        PDDocumentCatalog catalog = this._pdf.getDocumentCatalog();
        PDOptionalContentProperties ocprops = catalog.getOCProperties();
        if (ocprops == null) {
            ocprops = new PDOptionalContentProperties();
            catalog.setOCProperties(ocprops);
        }
        if ((layer = ocprops.getGroup(layerName)) == null) {
            layer = new PDOptionalContentGroup(layerName);
            ocprops.addGroup(layer);
        }
        PDPageContentStream contentStream = new PDPageContentStream(this._pdf, page, PDPageContentStream.AppendMode.APPEND, true, true);
        contentStream.beginMarkedContent(COSName.OC, (PDPropertyList)layer);
        int res = 600;
        int widthOrg = (int)Math.round((double)res * widthMM / 25.4);
        int heightOrg = (int)Math.round((double)res * heightMM / 25.4);
        int borderWidthDesired = (int)Math.round((double)(res * borderWidthDesiredMM) / 25.4);
        int width = widthOrg - 2 * borderWidthDesired;
        int height = heightOrg - 2 * borderWidthDesired;
        int r = bgColor >> 16 & 0xFF;
        int g = bgColor >> 8 & 0xFF;
        int b = bgColor & 0xFF;
        bgColor = r | g << 8 | b << 16;
        int orient = 0;
        int pageRotateAngle = page.getRotation();
        switch (pageRotateAngle) {
            case 270: {
                orient = 2;
                if (orientation.equalsIgnoreCase("RightLeft")) {
                    orient = 3;
                    break;
                }
                if (orientation.equalsIgnoreCase("TopBottom")) {
                    orient = 1;
                    break;
                }
                if (!orientation.equalsIgnoreCase("BottomTop")) break;
                orient = 0;
                break;
            }
            default: {
                orient = 0;
                if (orientation.equalsIgnoreCase("RightLeft")) {
                    orient = 1;
                    break;
                }
                if (orientation.equalsIgnoreCase("TopBottom")) {
                    orient = 2;
                    break;
                }
                if (!orientation.equalsIgnoreCase("BottomTop")) break;
                orient = 3;
            }
        }
        BufferedImage sti = ImageIO.read(new ByteArrayInputStream(stampTemplate.getInternalBuffer()));
        if (sti == null) {
            throw new InformException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0440\u0438\u0441\u0443\u043d\u043a\u0430");
        }
        Graphics2D stg = sti.createGraphics();
        block6: for (int i = 0; i < this._stampItems.size(); ++i) {
            StampItem item = this._stampItems.get(i);
            if (item == null) continue;
            int rc = item.fontColor >> 16 & 0xFF;
            int gc = item.fontColor >> 8 & 0xFF;
            int bc = item.fontColor & 0xFF;
            int itemColor = rc | gc << 8 | bc << 16;
            Font font = this.getFont(item.fontName, (item.fontStyle & 1) != 0, (item.fontStyle & 2) != 0);
            if (font == null) continue;
            font = font.deriveFont((float)item.fontSize);
            stg.setFont(font);
            stg.setColor(new Color(itemColor));
            FontMetrics fm = stg.getFontMetrics();
            int textWidth = fm.stringWidth(item.text);
            int x2 = (int)Math.round(PdfDocument.mmTo1_72inch(item.posX));
            int y2 = (int)Math.round(PdfDocument.mmTo1_72inch(item.posY));
            stg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            int xr = x2;
            switch (item.align) {
                case CENTER: {
                    xr = x2 + Math.round((sti.getWidth() - x2 - textWidth) / 2);
                    stg.drawString(item.text, xr, y2);
                    continue block6;
                }
                default: {
                    stg.drawString(item.text, xr, y2);
                }
            }
        }
        stg.dispose();
        if (orient == 2 || orient == 3) {
            double buffFloat = heightMM;
            heightMM = widthMM;
            widthMM = buffFloat;
            int buffInt = heightOrg;
            heightOrg = widthOrg;
            widthOrg = buffInt;
        }
        BufferedImage image = new BufferedImage(widthOrg, heightOrg, 2);
        Graphics2D gi = image.createGraphics();
        gi.setColor(new Color(bgColor));
        gi.fillRect(0, 0, widthOrg, heightOrg);
        if (orient == 2 || orient == 3) {
            int stiW = sti.getWidth();
            int stiH = sti.getHeight();
            BufferedImage dest = new BufferedImage(stiH, stiW, sti.getType());
            Graphics2D graphics2D = dest.createGraphics();
            if (orient == 2) {
                graphics2D.translate((stiH - stiW) / 2, (stiH - stiW) / 2);
                graphics2D.rotate(1.5707963267948966, stiH / 2, stiW / 2);
            } else {
                graphics2D.translate((stiW - stiH) / 2, (stiW - stiH) / 2 + 1);
                graphics2D.rotate(4.71238898038469, stiH / 2, stiW / 2);
            }
            graphics2D.drawRenderedImage(sti, null);
            gi.drawImage(dest, borderWidthDesired, borderWidthDesired, height, width, null);
        } else {
            gi.drawImage(sti, borderWidthDesired, borderWidthDesired, width, height, null);
        }
        gi.dispose();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PdfDocument.modAlpha(image, 64.0);
        ImageIO.write((RenderedImage)image, "PNG", stream);
        byte[] imageContent = stream.internalBuffer();
        PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)this._pdf, (byte[])imageContent, null);
        double h = heightMM;
        double w = widthMM;
        if (useTopLeftOffset) {
            if (pageRotateAngle == 270) {
                x = pageWidth - offsetY - w;
                y = offsetX + h;
            } else {
                x = offsetX;
                y = offsetY + h;
            }
        } else if (pageRotateAngle == 270) {
            x = offsetY;
            y = pageHeight - offsetX;
        } else {
            x = pageWidth - w - offsetX;
            y = pageHeight - offsetY;
        }
        Point2D point = PdfDocument.getTranslatedCoord(x, y, pageHeight);
        contentStream.drawImage(pdImage, (float)point.getX(), (float)point.getY(), (float)PdfDocument.mmTo1_72inch(w), (float)PdfDocument.mmTo1_72inch(h));
        contentStream.endMarkedContent();
        contentStream.close();
    }

    @SmartScriptableObject.FunctionTag
    public void putTextWatermark(String text, String textFont, int fontSize, double opacity, int colorR, int colorG, int colorB, double rotation, int augmentation) {
        try {
            TextWatermark watermark = new TextWatermark(text, textFont, fontSize, opacity, colorR, colorG, colorB, rotation, augmentation);
            double maxWidth = -1.0;
            double maxHeight = -1.0;
            for (int i = 0; i < this._pdf.getNumberOfPages(); ++i) {
                PDPage currPage = this._pdf.getPage(i);
                PDRectangle currPageSize = currPage.getBBox();
                maxWidth = Math.max(maxWidth, (double)currPageSize.getWidth());
                maxHeight = Math.max(maxHeight, (double)currPageSize.getHeight());
            }
            PDDocument watermarkPDF = new PDDocument();
            PDRectangle size = new PDRectangle((float)maxWidth, (float)maxHeight);
            PDPage pageWatermarksLayout = new PDPage(size);
            double centerDispositionX = Math.cos(Math.toRadians(watermark.rotation));
            double centerDispositionY = Math.sin(Math.toRadians(watermark.rotation));
            PDType0Font wmFont = PDType0Font.load((PDDocument)watermarkPDF, (File)new File(this.getFontFileNameFromINI(watermark.textFont, false, false)));
            PDPageContentStream contentStream = new PDPageContentStream(watermarkPDF, pageWatermarksLayout, PDPageContentStream.AppendMode.APPEND, true, true);
            PDExtendedGraphicsState extendedGraphicsState = new PDExtendedGraphicsState();
            extendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf(watermark.opacity));
            contentStream.setGraphicsStateParameters(extendedGraphicsState);
            contentStream.saveGraphicsState();
            contentStream.setFont((PDFont)wmFont, (float)watermark.fontSize);
            contentStream.setNonStrokingColor(watermark.textColor);
            double width = wmFont.getStringWidth(watermark.text) / 1000.0f * (float)watermark.fontSize;
            for (int xLine = 0; xLine <= watermark.augmentation + 1; ++xLine) {
                for (int yLine = 0; yLine <= watermark.augmentation + 1; ++yLine) {
                    contentStream.beginText();
                    AffineTransform at = new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)size.getUpperRightX() / (double)(watermark.augmentation + 1) * (double)xLine - width / 2.0 * centerDispositionX, (double)size.getUpperRightY() / (double)(watermark.augmentation + 1) * (double)yLine - width / 2.0 * centerDispositionY);
                    Matrix matrix = new Matrix(at);
                    matrix.rotate(Math.toRadians(watermark.rotation));
                    contentStream.setTextMatrix(matrix);
                    contentStream.showText(watermark.text);
                    contentStream.endText();
                }
            }
            contentStream.close();
            watermarkPDF.addPage(pageWatermarksLayout);
            OutputStream out = OutputStream.nullOutputStream();
            watermarkPDF.save(out);
            Overlay overlayObj = new Overlay();
            overlayObj.setInputPDF(this._pdf);
            overlayObj.setDefaultOverlayPDF(watermarkPDF);
            overlayObj.setOverlayPosition(Overlay.Position.FOREGROUND);
            HashMap ovmap = new HashMap();
            this._pdf = overlayObj.overlay(new HashMap());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void putImageWatermark(BinaryObject imageBinary, double opacity, double rotation, double imageScale, int augmentation) {
        try {
            ImageWatermark watermark = new ImageWatermark(opacity, rotation, augmentation, imageScale, imageBinary);
            double maxWidth = -1.0;
            double maxHeight = -1.0;
            for (int i = 0; i < this._pdf.getNumberOfPages(); ++i) {
                PDPage currPage = this._pdf.getPage(i);
                PDRectangle currPageSize = currPage.getBBox();
                maxWidth = Math.max(maxWidth, (double)currPageSize.getWidth());
                maxHeight = Math.max(maxHeight, (double)currPageSize.getHeight());
            }
            PDDocument watermarkPDF = new PDDocument();
            PDRectangle size = new PDRectangle((float)maxWidth, (float)maxHeight);
            PDPage pageWatermarksLayout = new PDPage(size);
            byte[] imageData = imageBinary.toByteArray();
            PDImageXObject drawnImage = PDImageXObject.createFromByteArray((PDDocument)this._pdf, (byte[])imageData, null);
            double width = (float)drawnImage.getWidth() * watermark.imageScale;
            double height = (float)drawnImage.getHeight() * watermark.imageScale;
            double centerDispositionX = Math.cos(Math.toRadians(watermark.rotation));
            double centerDispositionY = Math.sin(Math.toRadians(watermark.rotation));
            PDPageContentStream contentStream = new PDPageContentStream(watermarkPDF, pageWatermarksLayout, PDPageContentStream.AppendMode.APPEND, true, true);
            PDExtendedGraphicsState extendedGraphicsState = new PDExtendedGraphicsState();
            extendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf(watermark.opacity));
            contentStream.setGraphicsStateParameters(extendedGraphicsState);
            contentStream.saveGraphicsState();
            for (int xLine = 0; xLine <= watermark.augmentation + 1; ++xLine) {
                for (int yLine = 0; yLine <= watermark.augmentation + 1; ++yLine) {
                    AffineTransform at = new AffineTransform(width, 0.0, 0.0, height, (double)size.getUpperRightX() / (double)(watermark.augmentation + 1) * (double)xLine - width / 2.0 * centerDispositionX, (double)size.getUpperRightY() / (double)(watermark.augmentation + 1) * (double)yLine - height / 2.0 * centerDispositionY);
                    Matrix matrix = new Matrix(at);
                    matrix.rotate(Math.toRadians(watermark.rotation));
                    contentStream.drawImage(drawnImage, matrix);
                }
            }
            contentStream.close();
            watermarkPDF.addPage(pageWatermarksLayout);
            Overlay overlayObj = new Overlay();
            overlayObj.setInputPDF(this._pdf);
            overlayObj.setDefaultOverlayPDF(watermarkPDF);
            overlayObj.setOverlayPosition(Overlay.Position.FOREGROUND);
            HashMap ovmap = new HashMap();
            this._pdf = overlayObj.overlay(new HashMap());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void putText(String text, double x, double y, Object options) throws IOException, Exception {
        PDOptionalContentGroup layer;
        if (Strings.isVoid(text)) {
            throw new InformException(MESSAGE_EMPTYTEXT);
        }
        int pageIndex = 1;
        String orientation = "LeftRight";
        String fontName = "Arial";
        int fontSize = 10;
        int fontStyle = 0;
        int fontColor = 0;
        String layerName = DEFAULT_LAYER_NAME;
        if (options != null && options instanceof Scriptable) {
            Scriptable scriptableObj = (Scriptable)options;
            Object buffObj = scriptableObj.get("pageIndex", scriptableObj);
            if (buffObj != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                pageIndex = ValueCaster.toInt(buffObj);
            }
            if ((buffObj = scriptableObj.get("orientation", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                orientation = ValueCaster.toString(buffObj);
            }
            if ((buffObj = scriptableObj.get("fontName", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                fontName = ValueCaster.toString(buffObj);
            }
            if ((buffObj = scriptableObj.get("fontSize", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                fontSize = ValueCaster.toInt(buffObj);
            }
            if ((buffObj = scriptableObj.get("fontStyle", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                fontStyle = ValueCaster.toInt(buffObj);
            }
            if ((buffObj = scriptableObj.get("fontColor", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                fontColor = ValueCaster.toInt(buffObj);
            }
            if ((buffObj = scriptableObj.get("layerName", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND && Strings.isVoid(layerName = ValueCaster.toString(buffObj))) {
                layerName = DEFAULT_LAYER_NAME;
            }
        }
        if (pageIndex < 1 || pageIndex > this._pdf.getNumberOfPages()) {
            throw new InformException(String.format(MESSAGE_BAD_PAGE_INDEX, pageIndex));
        }
        PDPage page = this._pdf.getPage(pageIndex - 1);
        PDRectangle rect = page.getMediaBox();
        double pageHeight = (double)(rect.getHeight() / 72.0f) * 25.4;
        PDDocumentCatalog catalog = this._pdf.getDocumentCatalog();
        PDOptionalContentProperties ocprops = catalog.getOCProperties();
        if (ocprops == null) {
            ocprops = new PDOptionalContentProperties();
            catalog.setOCProperties(ocprops);
        }
        if ((layer = ocprops.getGroup(layerName)) == null) {
            layer = new PDOptionalContentGroup(layerName);
            ocprops.addGroup(layer);
        }
        PDPageContentStream contentStream = new PDPageContentStream(this._pdf, page, PDPageContentStream.AppendMode.APPEND, true, true);
        contentStream.beginMarkedContent(COSName.OC, (PDPropertyList)layer);
        PDFont font = this.getPDFont(fontName, (fontStyle & 1) != 0, (fontStyle & 2) != 0);
        if (font == null) {
            throw new InformException(MESSAGE_FONTABSENT);
        }
        contentStream.beginText();
        contentStream.setFont(font, (float)fontSize);
        contentStream.setNonStrokingColor(new Color(fontColor & 0xFF, fontColor >> 8 & 0xFF, fontColor >> 16 & 0xFF));
        Point2D point = PdfDocument.getTranslatedCoord(x, y, pageHeight);
        contentStream.newLineAtOffset((float)point.getX(), (float)point.getY());
        if (orientation.equalsIgnoreCase("BottomTop")) {
            contentStream.setTextMatrix(Matrix.getRotateInstance((double)1.5707963267948966, (float)((float)point.getX()), (float)((float)point.getY())));
        }
        if (orientation.equalsIgnoreCase("TopBottom")) {
            contentStream.setTextMatrix(Matrix.getRotateInstance((double)4.71238898038469, (float)((float)point.getX()), (float)((float)point.getY())));
        }
        contentStream.showText(text);
        contentStream.endText();
        contentStream.endMarkedContent();
        contentStream.close();
    }

    @SmartScriptableObject.FunctionTag
    public void putLine(Object pathObj, Object options) throws Exception {
        PDOptionalContentGroup layer;
        if (pathObj == null || !(pathObj instanceof Scriptable)) {
            return;
        }
        double[] points = null;
        Scriptable scriptablePath = (Scriptable)pathObj;
        if (scriptablePath != Undefined.instance && scriptablePath instanceof NativeArray) {
            NativeArray buffArray = (NativeArray)scriptablePath;
            int pathLength = (int)buffArray.getLength();
            if (pathLength < 4) {
                return;
            }
            points = new double[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                points[i] = ValueCaster.toDouble(buffArray.get(i));
            }
        } else {
            return;
        }
        int pageIndex = 1;
        int bgColor = 0;
        int borderStyle = 0;
        double borderWidth = 1.0;
        double transparent = 0.0;
        boolean closePath = true;
        String layerName = DEFAULT_LAYER_NAME;
        if (options != null && options instanceof Scriptable) {
            Scriptable scriptableObj = (Scriptable)options;
            Object buffObj = scriptableObj.get("pageIndex", scriptableObj);
            if (buffObj != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                pageIndex = ValueCaster.toInt(buffObj);
            }
            if ((buffObj = scriptableObj.get("bgColor", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                bgColor = ValueCaster.toInt(buffObj);
            }
            if ((buffObj = scriptableObj.get("borderWidth", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                borderWidth = ValueCaster.toDouble(buffObj);
            }
            if ((buffObj = scriptableObj.get("transparent", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                transparent = ValueCaster.toDouble(buffObj);
            }
            if ((buffObj = scriptableObj.get("borderStyle", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                borderStyle = ValueCaster.toInt(buffObj);
            }
            if ((buffObj = scriptableObj.get("closePath", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                closePath = ValueCaster.toBoolean(buffObj);
            }
            if ((buffObj = scriptableObj.get("layerName", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND && Strings.isVoid(layerName = ValueCaster.toString(buffObj))) {
                layerName = DEFAULT_LAYER_NAME;
            }
        }
        if (pageIndex < 1 || pageIndex > this._pdf.getNumberOfPages()) {
            throw new InformException(String.format(MESSAGE_BAD_PAGE_INDEX, pageIndex));
        }
        PDPage page = this._pdf.getPage(pageIndex - 1);
        PDRectangle rect = page.getMediaBox();
        double pageHeight = (double)(rect.getHeight() / 72.0f) * 25.4;
        PDDocumentCatalog catalog = this._pdf.getDocumentCatalog();
        PDOptionalContentProperties ocprops = catalog.getOCProperties();
        if (ocprops == null) {
            ocprops = new PDOptionalContentProperties();
            catalog.setOCProperties(ocprops);
        }
        if ((layer = ocprops.getGroup(layerName)) == null) {
            layer = new PDOptionalContentGroup(layerName);
            ocprops.addGroup(layer);
        }
        PDPageContentStream contentStream = new PDPageContentStream(this._pdf, page, PDPageContentStream.AppendMode.APPEND, true, true);
        contentStream.beginMarkedContent(COSName.OC, (PDPropertyList)layer);
        contentStream.setStrokingColor(new Color(bgColor & 0xFF, bgColor >> 8 & 0xFF, bgColor >> 16 & 0xFF));
        contentStream.setLineWidth((float)PdfDocument.mmTo1_72inch(borderWidth));
        switch (borderStyle) {
            case 0: {
                contentStream.setLineDashPattern(PEN_PATTREN_SOLID, 0.0f);
                break;
            }
            case 1: {
                contentStream.setLineDashPattern(PEN_PATTREN_DASH, 0.0f);
                break;
            }
            case 2: {
                contentStream.setLineDashPattern(PEN_PATTREN_DOT, 0.0f);
                break;
            }
            case 3: {
                contentStream.setLineDashPattern(PEN_PATTREN_DASH_DOT, 0.0f);
                break;
            }
            case 4: {
                contentStream.setLineDashPattern(PEN_PATTREN_DASH_DOT2, 0.0f);
                break;
            }
            default: {
                contentStream.setLineDashPattern(PEN_PATTREN_SOLID, 0.0f);
            }
        }
        if (transparent != 0.0) {
            PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
            graphicsState.setStrokingAlphaConstant(Float.valueOf((float)((256.0 - transparent) / 255.0)));
            contentStream.saveGraphicsState();
            contentStream.setGraphicsStateParameters(graphicsState);
        }
        for (int i = 0; i < points.length - 1; i += 2) {
            Point2D point = PdfDocument.getTranslatedCoord(points[i], points[i + 1], pageHeight);
            if (i == 0) {
                contentStream.moveTo((float)point.getX(), (float)point.getY());
                continue;
            }
            contentStream.lineTo((float)point.getX(), (float)point.getY());
        }
        if (closePath) {
            contentStream.closePath();
        }
        contentStream.stroke();
        if (transparent != 0.0) {
            contentStream.restoreGraphicsState();
        }
        contentStream.endMarkedContent();
        contentStream.close();
    }

    @SmartScriptableObject.FunctionTag
    public boolean isPortrait(int pageIndex) throws IOException, Exception {
        if (pageIndex < 1 || pageIndex > this._pdf.getNumberOfPages()) {
            throw new InformException(String.format(MESSAGE_BAD_PAGE_INDEX, pageIndex));
        }
        PDPage page = this._pdf.getPage(pageIndex - 1);
        PDRectangle vRect = page.getMediaBox();
        return vRect.getHeight() > vRect.getWidth();
    }

    @SmartScriptableObject.FunctionTag
    public int getWidthMM(int pageIndex) throws IOException, Exception {
        if (pageIndex < 1 || pageIndex > this._pdf.getNumberOfPages()) {
            throw new InformException(String.format(MESSAGE_BAD_PAGE_INDEX, pageIndex));
        }
        PDPage page = this._pdf.getPage(pageIndex - 1);
        PDRectangle vRect = page.getMediaBox();
        return (int)((double)(vRect.getWidth() / 72.0f) * 25.4);
    }

    @SmartScriptableObject.FunctionTag
    public int getHeightMM(int pageIndex) throws IOException, Exception {
        if (pageIndex < 1 || pageIndex > this._pdf.getNumberOfPages()) {
            throw new InformException(String.format(MESSAGE_BAD_PAGE_INDEX, pageIndex));
        }
        PDPage page = this._pdf.getPage(pageIndex - 1);
        PDRectangle vRect = page.getMediaBox();
        return (int)((double)(vRect.getHeight() / 72.0f) * 25.4);
    }

    @SmartScriptableObject.FunctionTag
    public void addNewPage(Object options) throws Exception {
        double width = 0.0;
        double height = 0.0;
        if (options != null && options instanceof Scriptable) {
            Scriptable scriptableObj = (Scriptable)options;
            Object buffObj = scriptableObj.get("width", scriptableObj);
            if (buffObj != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                width = ValueCaster.toDouble(buffObj);
            }
            if ((buffObj = scriptableObj.get("height", scriptableObj)) != null && buffObj != Undefined.instance && buffObj != UniqueTag.NOT_FOUND) {
                height = ValueCaster.toDouble(buffObj);
            }
        }
        if (width > 0.0 && height > 0.0) {
            this._pdf.addPage(new PDPage(new PDRectangle((float)((int)PdfDocument.mmTo1_72inch(width)), (float)((int)PdfDocument.mmTo1_72inch(height)))));
        } else {
            this._pdf.addPage(new PDPage());
        }
    }

    @SmartScriptableObject.FunctionTag
    public int getRestHeightMM(int pageIndex) throws IOException, Exception {
        if (pageIndex < 1 || pageIndex > this._pdf.getNumberOfPages()) {
            throw new InformException(String.format(MESSAGE_BAD_PAGE_INDEX, pageIndex));
        }
        AccessPermission ap = this._pdf.getCurrentAccessPermission();
        if (!ap.canExtractContent()) {
            throw new IOException("You do not have permission to extract text");
        }
        float lastTextY = 0.0f;
        float lastTextHeight = 0.0f;
        float lastImageY = 0.0f;
        float lastImageHeight = 0.0f;
        LastTextYAndHeightStripper stripper = new LastTextYAndHeightStripper();
        stripper.setSortByPosition(true);
        stripper.setStartPage(pageIndex);
        stripper.setEndPage(pageIndex);
        OutputStreamWriter dummy = new OutputStreamWriter(new ByteArrayOutputStream());
        stripper.writeText(this._pdf, dummy);
        lastTextY = stripper.lastTextY;
        lastTextHeight = stripper.lastTextHeight;
        LastImageYAndHeightStripper stripper2 = new LastImageYAndHeightStripper();
        stripper2.processPage(this._pdf.getPage(pageIndex - 1));
        lastImageY = stripper2.lastImageY;
        lastImageHeight = stripper2.lastImageHeight;
        PDPage page = this._pdf.getPage(pageIndex - 1);
        PDRectangle rect = page.getMediaBox();
        return (int)((double)((rect.getHeight() - Math.max(lastTextY + lastTextHeight, lastImageY + lastImageHeight)) / 72.0f) * 25.4);
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject toBinary() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this._pdf.save((OutputStream)out);
        return new BinaryObject(out.toByteArray());
    }

    private static double mmTo1_72inch(double mm) {
        return mm / 25.4 * 72.0;
    }

    private static Point2D getTranslatedCoord(double x, double y, double deltaY) {
        return new Point2D.Double(PdfDocument.mmTo1_72inch(x), PdfDocument.mmTo1_72inch(deltaY - y));
    }

    private Font getFont(String fontName, boolean isBold, boolean isItalic) throws Exception {
        Font font;
        boolean isArial = false;
        boolean isArialbd = false;
        boolean isArialbi = false;
        boolean isAriali = false;
        boolean isCour = false;
        boolean isCourbd = false;
        boolean isCourbi = false;
        boolean isCouri = false;
        boolean isTahoma = false;
        boolean isTahomabd = false;
        boolean isTimes = false;
        boolean isTimesbd = false;
        boolean isTimesbi = false;
        boolean isTimesi = false;
        if (fontName.equalsIgnoreCase("Arial")) {
            if (isBold && isItalic) {
                font = _arialbi;
                isArialbi = true;
            } else if (isBold && !isItalic) {
                font = _arialbd;
                isArialbd = true;
            } else if (!isBold && isItalic) {
                font = _ariali;
                isAriali = true;
            } else {
                font = _arial;
                isArial = true;
            }
        } else if (fontName.equalsIgnoreCase("Tahoma")) {
            if (isBold) {
                font = _tahomabd;
                isTahomabd = true;
            } else {
                font = _tahoma;
                isTahoma = true;
            }
        } else if (fontName.equalsIgnoreCase("Courier New")) {
            if (isBold && isItalic) {
                font = _courbi;
                isCourbi = true;
            } else if (isBold && !isItalic) {
                font = _courbd;
                isCourbd = true;
            } else if (!isBold && isItalic) {
                font = _couri;
                isCouri = true;
            } else {
                font = _cour;
                isCour = true;
            }
        } else if (isBold && isItalic) {
            font = _timesbi;
            isTimesbi = true;
        } else if (isBold && !isItalic) {
            font = _timesbd;
            isTimesbd = true;
        } else if (!isBold && isItalic) {
            font = _timesi;
            isTimesi = true;
        } else {
            font = _times;
            isTimes = true;
        }
        if (font == null) {
            try {
                if (_iniNotFound) {
                    if (_defaultFont != null) {
                        return _defaultFont;
                    }
                    Core.logger.info("putStamp: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b ini-\u0444\u0430\u0439\u043b\u044b. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0448\u0440\u0438\u0444\u0442 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.");
                    try (InputStream in = this._pdf.getClass().getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");){
                        File defaultFontFile = File.createTempFile("font", "ttf");
                        FileOutputStream fos = new FileOutputStream(defaultFontFile);
                        int n = 0;
                        byte[] buf = new byte[4096];
                        while ((n = in.read(buf)) > -1) {
                            fos.write(buf, 0, n);
                        }
                        fos.flush();
                        _defaultFont = Font.createFont(0, defaultFontFile);
                        fos.close();
                    }
                    return _defaultFont;
                }
                String fileName = this.getFontFileNameFromINI(fontName, isBold, isItalic);
                File file = new File(fileName);
                if (!file.exists()) {
                    if (_defaultFont != null) {
                        return _defaultFont;
                    }
                    Core.logger.info("putStamp: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0444\u0430\u0439\u043b\u044b \u0441\u043e \u0448\u0440\u0438\u0444\u0442\u0430\u043c\u0438. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0448\u0440\u0438\u0444\u0442 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.");
                    try (InputStream in = this._pdf.getClass().getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");){
                        File defaultFontFile = File.createTempFile("font", "ttf");
                        FileOutputStream fos = new FileOutputStream(defaultFontFile);
                        int n = 0;
                        byte[] buf = new byte[4096];
                        while ((n = in.read(buf)) > -1) {
                            fos.write(buf, 0, n);
                        }
                        fos.flush();
                        _defaultFont = Font.createFont(0, defaultFontFile);
                        fos.close();
                    }
                    return _defaultFont;
                }
                int font1Type = fileName.endsWith(".ttf") ? 0 : 1;
                font = Font.createFont(font1Type, file);
            }
            catch (NullPointerException e) {
                throw InformException.wrap(e, "\u0412 JDK \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 Freetype \u0438 Fontconfig!");
            }
            if (isArial) {
                _arial = font;
            }
            if (isArialbd) {
                _arialbd = font;
            }
            if (isArialbi) {
                _arialbi = font;
            }
            if (isAriali) {
                _ariali = font;
            }
            if (isCour) {
                _cour = font;
            }
            if (isCourbd) {
                _courbd = font;
            }
            if (isCourbi) {
                _courbi = font;
            }
            if (isCouri) {
                _couri = font;
            }
            if (isTahoma) {
                _tahoma = font;
            }
            if (isTahomabd) {
                _tahomabd = font;
            }
            if (isTimes) {
                _times = font;
            }
            if (isTimesbd) {
                _timesbd = font;
            }
            if (isTimesbi) {
                _timesbi = font;
            }
            if (isTimesi) {
                _timesi = font;
            }
        }
        return font;
    }

    private PDFont getPDFont(String fontName, boolean isBold, boolean isItalic) throws Exception {
        PDFont font;
        boolean isArial = false;
        boolean isArialbd = false;
        boolean isArialbi = false;
        boolean isAriali = false;
        boolean isCour = false;
        boolean isCourbd = false;
        boolean isCourbi = false;
        boolean isCouri = false;
        boolean isTahoma = false;
        boolean isTahomabd = false;
        boolean isTimes = false;
        boolean isTimesbd = false;
        boolean isTimesbi = false;
        boolean isTimesi = false;
        if (fontName.equalsIgnoreCase("Arial")) {
            if (isBold && isItalic) {
                font = this._arialbiPD;
                isArialbi = true;
            } else if (isBold && !isItalic) {
                font = this._arialbdPD;
                isArialbd = true;
            } else if (!isBold && isItalic) {
                font = this._arialiPD;
                isAriali = true;
            } else {
                font = this._arialPD;
                isArial = true;
            }
        } else if (fontName.equalsIgnoreCase("Tahoma")) {
            if (isBold) {
                font = this._tahomabdPD;
                isTahomabd = true;
            } else {
                font = this._tahomaPD;
                isTahoma = true;
            }
        } else if (fontName.equalsIgnoreCase("Courier New")) {
            if (isBold && isItalic) {
                font = this._courbiPD;
                isCourbi = true;
            } else if (isBold && !isItalic) {
                font = this._courbdPD;
                isCourbd = true;
            } else if (!isBold && isItalic) {
                font = this._couriPD;
                isCouri = true;
            } else {
                font = this._courPD;
                isCour = true;
            }
        } else if (isBold && isItalic) {
            font = this._timesbiPD;
            isTimesbi = true;
        } else if (isBold && !isItalic) {
            font = this._timesbdPD;
            isTimesbd = true;
        } else if (!isBold && isItalic) {
            font = this._timesiPD;
            isTimesi = true;
        } else {
            font = this._timesPD;
            isTimes = true;
        }
        if (font == null) {
            if (_iniNotFound) {
                if (this._defaultFontPD != null) {
                    return this._defaultFontPD;
                }
                try (InputStream in = this._pdf.getClass().getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");){
                    this._defaultFontPD = PDType0Font.load((PDDocument)this._pdf, (InputStream)in);
                }
                return this._defaultFontPD;
            }
            String fileName = this.getFontFileNameFromINI(fontName, isBold, isItalic);
            File file = new File(fileName);
            if (!file.exists()) {
                if (this._defaultFontPD != null) {
                    return this._defaultFontPD;
                }
                try (InputStream in = this._pdf.getClass().getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");){
                    this._defaultFontPD = PDType0Font.load((PDDocument)this._pdf, (InputStream)in);
                }
                return this._defaultFontPD;
            }
            try (FileInputStream fin = new FileInputStream(file);){
                font = PDType0Font.load((PDDocument)this._pdf, (InputStream)fin);
                if (isArial) {
                    this._arialPD = font;
                }
                if (isArialbd) {
                    this._arialbdPD = font;
                }
                if (isArialbi) {
                    this._arialbiPD = font;
                }
                if (isAriali) {
                    this._arialiPD = font;
                }
                if (isCour) {
                    this._courPD = font;
                }
                if (isCourbd) {
                    this._courbdPD = font;
                }
                if (isCourbi) {
                    this._courbiPD = font;
                }
                if (isCouri) {
                    this._couriPD = font;
                }
                if (isTahoma) {
                    this._tahomaPD = font;
                }
                if (isTahomabd) {
                    this._tahomabdPD = font;
                }
                if (isTimes) {
                    this._timesPD = font;
                }
                if (isTimesbd) {
                    this._timesbdPD = font;
                }
                if (isTimesbi) {
                    this._timesbiPD = font;
                }
                if (isTimesi) {
                    this._timesiPD = font;
                }
            }
        }
        return font;
    }

    String getFontFileNameFromINI(String fontName, boolean isBold, boolean isItalic) throws Exception {
        if (_ini == null) {
            _ini = new IniFile();
        }
        return _ini.getFontFileNameFromINI(fontName, isBold, isItalic);
    }

    public static class LastImageYAndHeightStripper
    extends PDFStreamEngine {
        public float lastImageY = 0.0f;
        public float lastImageHeight = 0.0f;

        public LastImageYAndHeightStripper() throws IOException {
            this.addOperator((OperatorProcessor)new Concatenate((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new DrawObject((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetGraphicsStateParameters((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new Save((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new Restore((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetMatrix((PDFStreamEngine)this));
        }

        protected void processOperator(Operator operator, List<COSBase> operands) throws IOException {
            String operation = operator.getName();
            if ("Do".equals(operation)) {
                COSName objectName = (COSName)operands.get(0);
                PDXObject xobject = this.getResources().getXObject(objectName);
                if (xobject instanceof PDImageXObject) {
                    Matrix ctmNew = this.getGraphicsState().getCurrentTransformationMatrix();
                    this.lastImageY = ctmNew.getTranslateY();
                    this.lastImageHeight = ctmNew.getScalingFactorY();
                }
            } else {
                super.processOperator(operator, operands);
            }
        }
    }

    public static class LastTextYAndHeightStripper
    extends PDFTextStripper {
        public float lastTextY = 0.0f;
        public float lastTextHeight = 0.0f;

        protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
            for (TextPosition text : textPositions) {
                this.lastTextY = text.getYDirAdj();
                this.lastTextHeight = text.getHeightDir();
            }
        }
    }

    public static class IniFile {
        final Pattern _section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
        final Pattern _keyValue = Pattern.compile("\\s*([^=]*)=(.*)");
        final Map<String, Map<String, String>> _entries = new HashMap<String, Map<String, String>>();
        final ByteArrayOutputStream _iniContent = new ByteArrayOutputStream();
        private static final String FONTS_INI_KEY = "fonts.ini";

        public IniFile() throws Exception {
            this.prepareIniContent();
            this.load();
        }

        public String getFontFileNameFromINI(String fontName, boolean isBold, boolean isItalic) {
            String fontFileName = "";
            String styleComp = "0";
            if (isBold && !isItalic) {
                styleComp = "bold";
            } else if (!isBold && isItalic) {
                styleComp = "italic";
            } else if (isBold && isItalic) {
                styleComp = "bold,italic";
            }
            for (Map.Entry<String, Map<String, String>> pair : this._entries.entrySet()) {
                fontFileName = pair.getKey();
                String name = this.getString(fontFileName, "name", "");
                String style = this.getString(fontFileName, "style", "0");
                if (fontName.compareToIgnoreCase(name) == 0 && style.compareToIgnoreCase(styleComp) == 0) break;
                fontFileName = "";
            }
            if (fontFileName.isEmpty()) {
                fontFileName = isBold ? "tahomabd.ttf" : "tahoma.ttf";
            }
            return Ini.HomePath + File.separator + "fonts" + File.separator + fontFileName;
        }

        private void prepareIniContent() throws Exception {
            String dirPath = Ini.HomePath + File.separator + "fonts";
            File dir = new File(dirPath);
            if (!dir.exists()) {
                throw new InformException("The directory 'Fonts' doesn't exist in the root path.");
            }
            File fontFile = new File(dir, FONTS_INI_KEY);
            if (fontFile.exists()) {
                this.readFile(fontFile);
            } else {
                for (String fileName : dir.list()) {
                    if (!fileName.endsWith(".ini") || !(fontFile = new File(dir, fileName)).exists()) continue;
                    this.readFile(fontFile);
                }
            }
        }

        private void load() throws Exception {
            if (this._iniContent.size() == 0) {
                throw new InformException("Ini-file content is empty!");
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this._iniContent.internalBuffer())));){
                String line;
                String section = null;
                while ((line = br.readLine()) != null) {
                    Matcher m = this._section.matcher(line);
                    if (m.matches()) {
                        section = m.group(1).trim();
                        continue;
                    }
                    if (section == null || !(m = this._keyValue.matcher(line)).matches()) continue;
                    String key = m.group(1).trim();
                    String value = m.group(2).trim();
                    Map<String, String> kv = this._entries.get(section);
                    if (kv == null) {
                        kv = new HashMap<String, String>();
                        this._entries.put(section, kv);
                    }
                    kv.put(key, value);
                }
                br.close();
            }
        }

        private String getString(String section, String key, String defaultvalue) {
            Map<String, String> kv = this._entries.get(section);
            if (kv == null) {
                return defaultvalue;
            }
            String res = kv.get(key);
            if (res == null) {
                return defaultvalue;
            }
            return res;
        }

        private void readFile(File fontFile) throws Exception {
            try (FileInputStream fin = new FileInputStream(fontFile);){
                int n = 0;
                byte[] buf = new byte[4096];
                while ((n = fin.read(buf)) > -1) {
                    this._iniContent.write(buf, 0, n);
                }
                fin.close();
            }
        }
    }

    private static class StampItem {
        public String text;
        public String fontName;
        public int fontSize;
        public int fontStyle;
        public int fontColor;
        public int posX;
        public int posY;
        public HorizontalAlign align;

        public StampItem(String text, String fontName, int fontSize, int fontStyle, int fontColor, int posX, int posY, HorizontalAlign hAlign) {
            this.text = text;
            this.fontName = fontName;
            this.fontSize = fontSize;
            this.fontStyle = fontStyle;
            this.fontColor = fontColor;
            this.posX = posX;
            this.posY = posY;
            this.align = hAlign;
        }
    }

    private class ImageWatermark {
        public float opacity;
        public float rotation;
        public int augmentation;
        public BinaryObject image;
        public float imageScale;

        public ImageWatermark(double opacity, double rotation, int augmentation, double imageScale, BinaryObject image) {
            this.opacity = (float)opacity;
            if (opacity > 1.0) {
                this.opacity = 1.0f;
            }
            if (opacity < 0.0) {
                this.opacity = 0.0f;
            }
            this.rotation = Double.isNaN(rotation) ? 0.0f : (float)rotation;
            this.augmentation = augmentation <= 0 ? 1 : Math.min(augmentation, 29);
            this.image = image;
            this.imageScale = Double.isNaN(imageScale) ? 1.0f : (float)Math.max(imageScale, 0.0);
        }
    }

    private class TextWatermark {
        public float opacity;
        public float rotation;
        public int augmentation;
        public String text;
        public String textFont;
        public int fontSize;
        public Color textColor;

        public TextWatermark(String text, String textFont, int fontSize, double opacity, int colorR, int colorG, int colorB, double rotation, int augmentation) {
            this.text = text;
            this.textFont = textFont;
            this.fontSize = fontSize < 0 ? 1 : fontSize;
            this.opacity = (float)opacity;
            if (opacity > 1.0) {
                this.opacity = 1.0f;
            }
            if (opacity < 0.0) {
                this.opacity = 0.0f;
            }
            if (colorR < 0) {
                colorR = 0;
            }
            if (colorR > 255) {
                colorR = 255;
            }
            if (colorG < 0) {
                colorG = 0;
            }
            if (colorG > 255) {
                colorG = 255;
            }
            if (colorB < 0) {
                colorB = 0;
            }
            if (colorB > 255) {
                colorB = 255;
            }
            this.textColor = new Color(colorR, colorG, colorB);
            this.rotation = Double.isNaN(rotation) ? 0.0f : (float)rotation;
            this.augmentation = augmentation <= 0 ? 1 : Math.min(augmentation, 29);
        }
    }
}

