/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.soap;

import inform.agent.scripts.soap.SoapAttachmentPart;
import inform.common.SmartScriptableObject;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.util.Iterator;
import org.mozilla.javascript.Scriptable;

public class SoapAttachmentParts
extends SmartScriptableObject {
    private final SOAPMessage message;
    private int countParts = 0;

    public SoapAttachmentParts(Scriptable scope, SOAPMessage message) {
        this.setParentScope(scope);
        this.message = message;
        Iterator iterator = message.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPart next = (AttachmentPart)iterator.next();
            SoapAttachmentParts.putProperty((Scriptable)this, this.countParts++, (Object)new SoapAttachmentPart((Scriptable)this, next));
        }
    }

    @Override
    public String getClassName() {
        return "AttachmentParts";
    }

    SoapAttachmentPart createAttachmentPart() throws SOAPException, IOException {
        AttachmentPart part = this.message.createAttachmentPart();
        this.message.addAttachmentPart(part);
        SoapAttachmentPart result = new SoapAttachmentPart((Scriptable)this, part);
        SoapAttachmentParts.putProperty((Scriptable)this, this.countParts++, (Object)result);
        this.message.saveChanges();
        return result;
    }

    void clearAttachmentParts() throws SOAPException {
        while (this.countParts > 0) {
            super.delete(--this.countParts);
        }
        this.message.removeAllAttachments();
        this.message.saveChanges();
    }
}

