/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.soap;

import inform.common.SmartScriptableObject;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.javascript.Scriptable;

public class SoapNamespaces
extends SmartScriptableObject {
    private final SOAPElement element;

    public SoapNamespaces(Scriptable scope, SOAPElement element) {
        this.setParentScope(scope);
        this.element = element;
        Iterator iterator = element.getNamespacePrefixes();
        while (iterator.hasNext()) {
            String n = (String)iterator.next();
            SoapNamespaces.putConstProperty(this, n, element.getNamespaceURI(n));
        }
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        try {
            this.element.addNamespaceDeclaration(name, (String)value);
        }
        catch (SOAPException ex) {
            Logger.getLogger(SoapNamespaces.class.getName()).log(Level.SEVERE, null, ex);
        }
        super.put(name, start, value);
    }

    @Override
    public void delete(String name) {
        this.element.removeNamespaceDeclaration(name);
        super.delete(name);
    }
}

