/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.spreadsheets.excel;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.TextLibrary;
import inform.agent.scripts.spreadsheets.excel.ExcelCellStyle;
import inform.agent.scripts.spreadsheets.excel.ExcelFont;
import inform.agent.scripts.spreadsheets.excel.ExcelWorkbookSheetCells;
import inform.agent.scripts.textutils.TextExtractor;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Predicate;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.RecordFormatException;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class ExcelWorkbook
extends SmartScriptableObject {
    private static final String MESSAGE_MISSINGFILE = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b '%s'. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u0438 \u043c\u0435\u0441\u0442\u043e\u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.";
    private static final String MESSAGE_EMPTYBINARY = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c Excel-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u0431\u0438\u043d\u0430\u0440\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430";
    private static final String MESSAGE_EMPTYFIELD = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c Excel-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445";
    private static final String MESSAGE_BADFIELDTYPE_READ = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c Excel-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 c \u0442\u0438\u043f\u043e\u043c '%s'";
    private static final String MESSAGE_UNKNOWNFILE = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430";
    private static final String MESSAGE_BADTYPE = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c Excel-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432 \u043e\u0431\u044a\u0435\u043a\u0442 \u0441 \u0442\u0438\u043f\u043e\u043c '%s'. \u041f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u043c, \u043f\u043e\u043b\u0435\u043c \u0442\u0430\u0431\u043b\u0438\u0446\u044b (\u0441 \u0442\u0438\u043f\u043e\u043c Blob \u0438\u043b\u0438 BlobFile) \u0438\u043b\u0438 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c \u0444\u0430\u0439\u043b\u0430.";
    private static final String MESSAGE_BADFIELDTYPE_WRITE = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c Excel-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432 \u043f\u043e\u043b\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 c \u0442\u0438\u043f\u043e\u043c '%s'";
    private static final String MESSAGE_BADCOLOR = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0446\u0432\u0435\u0442\u0430: '%s'";
    static final String MESSAGE_BADSTYLE = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u0441\u0442\u0438\u043b\u044f \u044f\u0447\u0435\u0439\u043a\u0438: '%s'";
    static final String MESSAGE_BADFONT = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u0444\u043e\u043d\u0430 \u044f\u0447\u0435\u0439\u043a\u0438: '%s'";
    static final String MESSAGE_EVALUATE_ERROR = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u0444\u043e\u0440\u043c\u0443\u043b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 Excel";
    Workbook workbook;

    private ExcelWorkbook(Scriptable scope) {
        this.setParentScope(scope);
    }

    public static ExcelWorkbook createExcelWorkbook(Scriptable scope) {
        ExcelWorkbook book = new ExcelWorkbook(scope);
        book.workbook = new XSSFWorkbook();
        return book;
    }

    public static ExcelWorkbook createExcelWorkbook(Scriptable scope, TextExtractor.DOCUMENT_FORMAT document) {
        ExcelWorkbook book = new ExcelWorkbook(scope);
        switch (document) {
            case DOCUMENT_XLSX: {
                book.workbook = new XSSFWorkbook();
                break;
            }
            case DOCUMENT_XLS: {
                book.workbook = new HSSFWorkbook();
                break;
            }
            default: {
                throw new InformException(MESSAGE_UNKNOWNFILE);
            }
        }
        return book;
    }

    public static ExcelWorkbook openExcelWorkbook(Scriptable scope, Object dataSource) throws Exception {
        if (dataSource instanceof String) {
            String filename;
            String strDataSource = (String)dataSource;
            int lastDotIndex = strDataSource.lastIndexOf(".");
            String string = filename = lastDotIndex != -1 && lastDotIndex < strDataSource.length() - 1 ? strDataSource.substring(lastDotIndex + 1) : null;
            if (filename == null) {
                throw new InformException(String.format(MESSAGE_MISSINGFILE, dataSource));
            }
            if (filename.equalsIgnoreCase("XLS")) {
                return ExcelWorkbook.openExcelWorkbook(scope, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLS, dataSource);
            }
            if (filename.equalsIgnoreCase("XLSX")) {
                return ExcelWorkbook.openExcelWorkbook(scope, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLSX, dataSource);
            }
            throw new InformException(MESSAGE_UNKNOWNFILE);
        }
        if (dataSource instanceof BinaryObject || dataSource instanceof DatasourceField) {
            TextLibrary textLibrary = new TextLibrary(scope);
            int codeFormat = textLibrary.determineFormat(dataSource);
            switch (codeFormat) {
                case 3: {
                    return ExcelWorkbook.openExcelWorkbook(scope, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLSX, dataSource);
                }
                case 6: {
                    return ExcelWorkbook.openExcelWorkbook(scope, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLS, dataSource);
                }
            }
            throw new InformException(MESSAGE_UNKNOWNFILE);
        }
        throw new InformException(String.format(MESSAGE_BADTYPE, dataSource == null ? "null" : dataSource.getClass().getName()));
    }

    public static ExcelWorkbook openExcelWorkbook(Scriptable scope, TextExtractor.DOCUMENT_FORMAT document, Object dataSource) throws Exception {
        ExcelWorkbook book;
        block16: {
            BlobFileField blobFile;
            BinaryObject binary;
            File file;
            block18: {
                block20: {
                    block19: {
                        block17: {
                            assert (document != null);
                            file = null;
                            binary = null;
                            blobFile = null;
                            if (!(dataSource instanceof String)) break block17;
                            String fileName = (String)dataSource;
                            file = Core.mountfs.resolve(new File(fileName));
                            if (!file.exists()) {
                                throw new InformException(String.format(MESSAGE_MISSINGFILE, fileName));
                            }
                            break block18;
                        }
                        if (!(dataSource instanceof BinaryObject)) break block19;
                        binary = (BinaryObject)dataSource;
                        if (binary.getSize() == 0) {
                            throw new InformException(MESSAGE_EMPTYBINARY);
                        }
                        break block18;
                    }
                    if (!(dataSource instanceof DatasourceField)) break block20;
                    DatasourceField field = (DatasourceField)dataSource;
                    if (field.getIsNull()) {
                        throw new InformException(MESSAGE_EMPTYFIELD);
                    }
                    switch (field.getDataType()) {
                        case BLOB: {
                            if (field.getDescriptor().getBlobRawType() != FieldDescriptor.BlobRawType.BINARY) {
                                throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, DataType.BLOB + "(" + field.getDescriptor().getBlobRawType() + ")"));
                            }
                            binary = field.getAsBinary();
                            assert (binary != null);
                            break block18;
                        }
                        case FILE: {
                            blobFile = (BlobFileField)field;
                            break;
                        }
                        default: {
                            throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, new Object[]{field.getDataType()}));
                        }
                    }
                    break block18;
                }
                throw new InformException(String.format(MESSAGE_BADTYPE, dataSource == null ? "null" : dataSource.getClass().getName()));
            }
            book = new ExcelWorkbook(scope);
            try {
                book.workbook = ExcelWorkbook.tryOpenWorkbook(document, file, binary, blobFile);
            }
            catch (Exception e) {
                Predicate<Exception> IsPOIByteArrayMaxOverrideException = exception -> exception instanceof RecordFormatException && exception.getMessage().contains("IOUtils.setByteArrayMaxOverride");
                if (document == TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLSX && IsPOIByteArrayMaxOverrideException.test(e)) {
                    int deltaByteArrayInitSize = 100000000;
                    int maxByteArrayInitSize = IOUtils.getMaxByteArrayInitSize();
                    for (int i = 1; i <= 20; ++i) {
                        IOUtils.setByteArrayMaxOverride((int)(maxByteArrayInitSize > 0 ? maxByteArrayInitSize : deltaByteArrayInitSize + i * deltaByteArrayInitSize));
                        try {
                            book.workbook = ExcelWorkbook.tryOpenWorkbook(document, file, binary, blobFile);
                        }
                        catch (Exception ex) {
                            Core.logger.warn("run tryOpenWorkbook()", ex);
                            if (!IsPOIByteArrayMaxOverrideException.test(ex)) break;
                        }
                        if (book.workbook != null) break;
                    }
                    IOUtils.setByteArrayMaxOverride((int)maxByteArrayInitSize);
                }
                if (book.workbook != null) break block16;
                throw e;
            }
        }
        return book;
    }

    private static Workbook tryOpenWorkbook(TextExtractor.DOCUMENT_FORMAT document, File file, BinaryObject binary, BlobFileField blobFile) throws Exception {
        assert (file != null || binary != null || blobFile != null);
        try (InputStream is = file != null ? new FileInputStream(file) : (binary != null ? new ByteArrayInputStream(binary.getInternalBuffer()) : (blobFile != null ? blobFile.openFileStream() : null));){
            assert (is != null);
            switch (document) {
                case DOCUMENT_XLSX: {
                    XSSFWorkbook xSSFWorkbook = new XSSFWorkbook(is);
                    return xSSFWorkbook;
                }
                case DOCUMENT_XLS: {
                    HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(is);
                    return hSSFWorkbook;
                }
            }
            throw new InformException(MESSAGE_UNKNOWNFILE);
        }
    }

    @Override
    public String getClassName() {
        return "ExcelWorkbook";
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        this.workbook.close();
    }

    @SmartScriptableObject.FunctionTag
    public ExcelWorkbookSheetCells createSheet(String sheetName) {
        return ExcelWorkbookSheetCells.createSheet(this, sheetName);
    }

    @SmartScriptableObject.FunctionTag
    public ExcelWorkbookSheetCells readSheet(Object sheetName) {
        return ExcelWorkbookSheetCells.readSheet(this, sheetName);
    }

    @SmartScriptableObject.FunctionTag
    public void removeSheet(Object sheetName) {
        int index = sheetName instanceof Number ? ((Number)sheetName).intValue() : this.indexOf(sheetName.toString());
        this.workbook.removeSheetAt(index);
    }

    @SmartScriptableObject.FunctionTag
    public String sheetName(int sheetIndex) {
        return this.workbook.getSheetName(sheetIndex);
    }

    @SmartScriptableObject.FunctionTag
    public void setSheetName(int sheetIndex, String sheetName) {
        this.workbook.setSheetName(sheetIndex, sheetName);
    }

    @SmartScriptableObject.FunctionTag
    public int indexOf(String sheetName) {
        return this.workbook.getSheetIndex(sheetName);
    }

    @SmartScriptableObject.FunctionTag
    public void setSheetIndex(String sheetName, int order) {
        this.workbook.setSheetOrder(sheetName, order);
    }

    @SmartScriptableObject.FunctionTag
    public void saveToFile(String fileName) throws IOException {
        assert (this.workbook != null);
        try (FileOutputStream os = new FileOutputStream(Core.mountfs.resolve(new File(fileName)));){
            this.workbook.write((OutputStream)os);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void saveToBlob(Object dataSource) throws Exception {
        if (dataSource instanceof BinaryObject) {
            this.saveToBinaryObject((BinaryObject)dataSource);
        } else if (dataSource instanceof DatasourceField) {
            this.saveToDatasourceField((DatasourceField)dataSource);
        } else {
            throw new InformException(String.format(MESSAGE_BADTYPE, dataSource == null ? "null" : dataSource.getClass().getName()));
        }
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject toBinary() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.workbook.write((OutputStream)out);
        return new BinaryObject(out.toByteArray());
    }

    @SmartScriptableObject.FunctionTag
    public ExcelFont createFont(Object cellFont) {
        if (cellFont == null || cellFont instanceof Undefined) {
            return new ExcelFont(this);
        }
        if (cellFont instanceof ExcelFont) {
            return new ExcelFont(this, (ExcelFont)cellFont);
        }
        if (cellFont instanceof Font) {
            return new ExcelFont(this, (Font)cellFont);
        }
        throw new InformException(String.format(MESSAGE_BADFONT, cellFont));
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle createCellStyle(Object cellStyle) {
        if (cellStyle == null || cellStyle instanceof Undefined) {
            return new ExcelCellStyle(this);
        }
        if (cellStyle instanceof ExcelCellStyle) {
            return new ExcelCellStyle(this, (ExcelCellStyle)cellStyle);
        }
        if (cellStyle instanceof CellStyle) {
            return new ExcelCellStyle(this, (CellStyle)cellStyle);
        }
        throw new InformException(String.format(MESSAGE_BADSTYLE, cellStyle));
    }

    @SmartScriptableObject.PropertyTag
    public int getCountSheets() {
        return this.workbook.getNumberOfSheets();
    }

    @SmartScriptableObject.FunctionTag
    public void evaluateCells() {
        try {
            this.workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
            this.workbook.setForceFormulaRecalculation(true);
        }
        catch (Exception e) {
            throw InformException.detail(e, MESSAGE_EVALUATE_ERROR);
        }
    }

    private void saveToBinaryObject(BinaryObject binary) throws IOException {
        assert (this.workbook != null);
        assert (binary != null);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.workbook.write((OutputStream)os);
            binary.clear();
            try (ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());){
                binary.loadFromStream(is);
            }
        }
    }

    private void saveToDatasourceField(DatasourceField field) throws Exception {
        assert (this.workbook != null);
        assert (field != null);
        field.clear();
        switch (field.getDataType()) {
            case BLOB: {
                if (field.getDescriptor().getBlobRawType() != FieldDescriptor.BlobRawType.BINARY) {
                    throw new InformException(String.format(MESSAGE_BADFIELDTYPE_WRITE, DataType.BLOB + "(" + field.getDescriptor().getBlobRawType() + ")"));
                }
                BinaryObject binary = new BinaryObject();
                this.saveToBinaryObject(binary);
                field.setAsBinary(binary);
                break;
            }
            case FILE: {
                BinaryObject binary = new BinaryObject();
                this.saveToBinaryObject(binary);
                field.setAsBinary(binary);
                break;
            }
            default: {
                throw new InformException(String.format(MESSAGE_BADFIELDTYPE_WRITE, new Object[]{field.getDataType()}));
            }
        }
    }

    public Color parseColor(Object value) {
        if (value instanceof Number) {
            int c = ((Number)value).intValue();
            if (this.workbook instanceof XSSFWorkbook) {
                return new XSSFColor(new byte[]{0, (byte)(c & 0xFF), (byte)(c >> 8 & 0xFF), (byte)(c >> 16 & 0xFF)});
            }
            if (this.workbook instanceof HSSFWorkbook) {
                HSSFPalette palette = ((HSSFWorkbook)this.workbook).getCustomPalette();
                byte[] rgb = new byte[]{(byte)(c & 0xFF), (byte)(c >> 8 & 0xFF), (byte)(c >> 16 & 0xFF)};
                return palette.findSimilarColor(rgb[0], rgb[1], rgb[2]);
            }
        }
        throw new InformException(String.format(MESSAGE_BADCOLOR, value));
    }
}

