/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.spreadsheets.excel;

import inform.adt.InformException;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.spreadsheets.excel.ExcelCellStyle;
import inform.agent.scripts.spreadsheets.excel.ExcelWorkbook;
import inform.common.SmartScriptableObject;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.mozilla.javascript.Undefined;

public class ExcelWorkbookSheetCells
extends SmartScriptableObject {
    private static final String MESSAGE_MISSINGSHEET = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043b\u0438\u0441\u0442 Excel \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '%s'";
    private static final String MESSAGE_BADCOLUMN = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u043a\u043e\u043b\u043e\u043d\u043a\u0438 \u043b\u0438\u0441\u0442\u0430 Excel: '%s'";
    private static final String MESSAGE_BADROW = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 \u043b\u0438\u0441\u0442\u0430 Excel: '%s'";
    private static final String MESSAGE_CREATESHEET_ERROR = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043b\u0438\u0441\u0442 Excel \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '%s'";
    private static final String MESSAGE_BADROWCOUNT = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0440\u043e\u043a : '%s'.";
    private static final String MESSAGE_BADCOLUMNCOUNT = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043e\u043b\u043e\u043d\u043e\u043a : '%s'.";
    private final ExcelWorkbook book;
    private Sheet sheet;
    private int firstUsedColumn;
    private int lastUsedColumn;
    private boolean detectedUsedColumns;
    private static final String MESSAGE_BADROWHEIGHT = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u0430 \u0432\u044b\u0441\u043e\u0442\u0430 \u0441\u0442\u0440\u043e\u043a\u0438 : '%s'.";
    private static final String MESSAGE_BADCOLUMNWIDTH = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u0430 \u0448\u0438\u0440\u0438\u043d\u0430 \u043a\u043e\u043b\u043e\u043d\u043a\u0438 : '%s'.";

    private ExcelWorkbookSheetCells(ExcelWorkbook book) {
        this.setParentScope(book);
        this.book = book;
    }

    @Override
    public String getClassName() {
        return "ExcelWorkbookSheetCells";
    }

    public static ExcelWorkbookSheetCells createSheet(ExcelWorkbook excelWorkbook, String sheetName) {
        ExcelWorkbookSheetCells workbookSheetCells = new ExcelWorkbookSheetCells(excelWorkbook);
        workbookSheetCells.sheet = excelWorkbook.workbook.createSheet(sheetName);
        if (workbookSheetCells.sheet == null) {
            throw new InformException(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043b\u0438\u0441\u0442 Excel \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '%s'", sheetName));
        }
        return workbookSheetCells;
    }

    public static ExcelWorkbookSheetCells readSheet(ExcelWorkbook excelWorkbook, Object sheetName) {
        ExcelWorkbookSheetCells workbookSheetCells = new ExcelWorkbookSheetCells(excelWorkbook);
        workbookSheetCells.sheet = sheetName instanceof Number ? excelWorkbook.workbook.getSheetAt(((Number)sheetName).intValue()) : excelWorkbook.workbook.getSheet(sheetName.toString());
        if (workbookSheetCells.sheet == null) {
            throw new InformException(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043b\u0438\u0441\u0442 Excel \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '%s'", sheetName));
        }
        return workbookSheetCells;
    }

    @SmartScriptableObject.PropertyTag
    public int getFirstUsedColumn() {
        if (!this.detectedUsedColumns) {
            this.detectUsedColumns();
        }
        return this.firstUsedColumn;
    }

    @SmartScriptableObject.PropertyTag
    public int getFirstUsedRow() {
        return this.sheet.getFirstRowNum() + 1;
    }

    @SmartScriptableObject.PropertyTag
    public int getLastUsedColumn() {
        if (!this.detectedUsedColumns) {
            this.detectUsedColumns();
        }
        return this.lastUsedColumn;
    }

    @SmartScriptableObject.PropertyTag
    public int getLastUsedRow() {
        return this.sheet.getLastRowNum() + 1;
    }

    @SmartScriptableObject.FunctionTag
    public Object cells(int rowIndex, Object columnIndex) {
        Cell cell;
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        Row row = this.sheet.getRow(rn);
        if (row != null && (cell = row.getCell(cn)) != null) {
            CellType type = cell.getCellType();
            switch (type) {
                case NUMERIC: {
                    return cell.getNumericCellValue();
                }
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case FORMULA: {
                    FormulaEvaluator evaluator = this.book.workbook.getCreationHelper().createFormulaEvaluator();
                    CellValue value = evaluator.evaluate(cell);
                    CellType type2 = value.getCellType();
                    switch (type2) {
                        case BOOLEAN: {
                            return value.getBooleanValue();
                        }
                        case NUMERIC: {
                            return value.getNumberValue();
                        }
                    }
                    return value.getStringValue();
                }
            }
            return cell.getStringCellValue();
        }
        return null;
    }

    @SmartScriptableObject.FunctionTag
    public void setCell(int rowIndex, Object columnIndex, Object value, Object cellStyle) {
        Cell cell;
        Row row;
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        boolean isNum = false;
        CellStyle style = this.parseCellStyle(cellStyle);
        if (style == null) {
            style = this.getCellStyle(rn, cn);
        }
        if ((row = this.sheet.getRow(rn)) == null) {
            row = this.sheet.createRow(rn);
        }
        if ((cell = row.getCell(cn)) == null) {
            cell = row.createCell(cn);
        }
        if (style != null) {
            cell.setCellStyle(style);
            if (style.getDataFormat() > 0) {
                isNum = true;
            }
        }
        if (isNum || cell.getCellType() == CellType.NUMERIC) {
            cell.setCellValue(ValueCaster.toDouble(value));
        } else if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty()) {
                cell.setBlank();
            } else {
                cell.setCellValue(str);
            }
        }
        this.detectedUsedColumns = false;
    }

    @SmartScriptableObject.FunctionTag
    public void setCellFormula(int rowIndex, Object columnIndex, String formula, Object cellStyle) {
        Row row;
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        CellStyle style = this.parseCellStyle(cellStyle);
        if (style == null) {
            style = this.getCellStyle(rn, cn);
        }
        if ((row = this.sheet.getRow(rn)) == null) {
            row = this.sheet.createRow(rn);
        }
        Cell cell = row.createCell(cn, CellType.FORMULA);
        cell.setCellFormula(formula);
        if (style != null) {
            cell.setCellStyle(style);
        }
        this.detectedUsedColumns = false;
    }

    @SmartScriptableObject.FunctionTag
    public void evaluateCell(int rowIndex, Object columnIndex) {
        try {
            int rn = this.parseRowIndex(rowIndex);
            int cn = this.parseColumnIndex(columnIndex);
            Row row = this.sheet.getRow(rn);
            if (row == null) {
                return;
            }
            Cell cell = row.getCell(cn);
            if (cell == null) {
                return;
            }
            this.book.workbook.getCreationHelper().createFormulaEvaluator().evaluateInCell(cell);
        }
        catch (Exception e) {
            throw InformException.detail(e, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u0444\u043e\u0440\u043c\u0443\u043b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 Excel");
        }
    }

    private CellStyle parseCellStyle(Object cellStyle) {
        if (cellStyle != null && !(cellStyle instanceof Undefined)) {
            if (cellStyle instanceof ExcelCellStyle) {
                return ((ExcelCellStyle)cellStyle).style;
            }
            throw new InformException(String.format("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u0441\u0442\u0438\u043b\u044f \u044f\u0447\u0435\u0439\u043a\u0438: '%s'", cellStyle));
        }
        return null;
    }

    private CellStyle getCellStyle(int poiRowIndex, int poiColumnIndex) {
        Row row = this.sheet.getRow(poiRowIndex);
        if (row != null) {
            Cell cell = row.getCell(poiColumnIndex);
            if (cell != null) {
                return cell.getCellStyle();
            }
            CellStyle columnStyle = this.sheet.getColumnStyle(poiColumnIndex);
            CellStyle rowStyle = row.getRowStyle();
            if (columnStyle == null) {
                return rowStyle;
            }
            if (rowStyle == null) {
                return columnStyle;
            }
            return columnStyle.getIndex() < rowStyle.getIndex() ? rowStyle : columnStyle;
        }
        return this.sheet.getColumnStyle(poiColumnIndex);
    }

    @SmartScriptableObject.FunctionTag
    public void clearCell(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        Row row = this.sheet.getRow(rn);
        if (row == null) {
            return;
        }
        Cell cell = row.getCell(cn);
        if (cell == null) {
            return;
        }
        row.removeCell(cell);
        if (row.getLastCellNum() < 0) {
            this.sheet.removeRow(row);
        }
        this.detectedUsedColumns = false;
    }

    @SmartScriptableObject.FunctionTag
    public void setCellStyle(int rowIndex, Object columnIndex, ExcelCellStyle value) {
        Cell cell;
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        Row row = this.sheet.getRow(rn);
        if (row == null) {
            if (value == null) {
                return;
            }
            row = this.sheet.createRow(rn);
        }
        if ((cell = row.getCell(cn)) == null) {
            if (value == null) {
                return;
            }
            cell = row.createCell(cn);
        }
        if (value == null) {
            Object cellValue = this.cells(rowIndex, columnIndex);
            row.removeCell(cell);
            this.setCell(rowIndex, columnIndex, cellValue, null);
        } else {
            cell.setCellStyle(value.style);
        }
        this.detectedUsedColumns = false;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle getCellStyle(int rowIndex, Object columnIndex) {
        Cell cell;
        int cn;
        int rn = this.parseRowIndex(rowIndex);
        CellStyle style = this.getCellStyle(rn, cn = this.parseColumnIndex(columnIndex));
        if (style != null) {
            return this.book.createCellStyle(style);
        }
        Row row = this.sheet.getRow(rn);
        if (row == null) {
            row = this.sheet.createRow(rn);
        }
        if ((cell = row.getCell(cn)) == null) {
            cell = row.createCell(cn);
        }
        return this.book.createCellStyle(cell.getCellStyle());
    }

    @SmartScriptableObject.FunctionTag
    public int getCellType(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        Row row = this.sheet.getRow(rn);
        if (row == null) {
            return 0;
        }
        Cell cell = row.getCell(cn);
        if (cell == null) {
            return 0;
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case BLANK: {
                return 1;
            }
            case NUMERIC: {
                return DateUtil.isCellDateFormatted((Cell)cell) ? 5 : 2;
            }
            case STRING: {
                return 3;
            }
            case BOOLEAN: {
                return 4;
            }
            case ERROR: {
                return 6;
            }
            case FORMULA: {
                CellType cellType2 = cell.getCachedFormulaResultType();
                switch (cellType2) {
                    case BLANK: {
                        return 1;
                    }
                    case NUMERIC: {
                        return DateUtil.isCellDateFormatted((Cell)cell) ? 5 : 2;
                    }
                    case STRING: {
                        return 3;
                    }
                    case BOOLEAN: {
                        return 4;
                    }
                    case ERROR: {
                        return 6;
                    }
                }
            }
        }
        return 0;
    }

    @SmartScriptableObject.FunctionTag
    public boolean isCellFormula(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        Row row = this.sheet.getRow(rn);
        if (row == null) {
            return false;
        }
        Cell cell = row.getCell(cn);
        if (cell == null) {
            return false;
        }
        return cell.getCellType() == CellType.FORMULA;
    }

    @SmartScriptableObject.FunctionTag
    public void insertRow(int rowIndex, Object rowCount) {
        int rn = this.parseRowIndex(rowIndex);
        int cnt = this.parseRowCount(rowCount);
        if (rn <= this.sheet.getLastRowNum()) {
            this.sheet.shiftRows(rn, this.sheet.getLastRowNum(), cnt, true, true);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void removeRow(int rowIndex, Object rowCount) {
        int rn = this.parseRowIndex(rowIndex);
        int cnt = this.parseRowCount(rowCount);
        int rn2 = rn + cnt;
        for (int i = rn; i < rn2; ++i) {
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            this.sheet.removeRow(row);
        }
        if (rn2 <= this.sheet.getLastRowNum()) {
            this.sheet.shiftRows(rn2, this.sheet.getLastRowNum(), -cnt, true, true);
        }
        this.detectedUsedColumns = false;
    }

    @SmartScriptableObject.FunctionTag
    public void clearRow(int rowIndex, Object rowCount) {
        int rn = this.parseRowIndex(rowIndex);
        int cnt = this.parseRowCount(rowCount);
        int rn2 = rn + cnt;
        for (int i = rn; i < rn2; ++i) {
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            this.sheet.removeRow(row);
        }
        this.detectedUsedColumns = false;
    }

    @SmartScriptableObject.FunctionTag
    public void copyRow(int srcRow, int destRow, Object rowCount) {
        int srcRowNum = this.parseRowIndex(srcRow);
        int destRowNum = this.parseRowIndex(destRow);
        int cnt = this.parseRowCount(rowCount);
        for (int i = 0; i < cnt; ++i) {
            Row src = this.sheet.getRow(srcRowNum + i);
            if (src == null) continue;
            Row dest = this.sheet.getRow(destRowNum + i);
            if (dest == null) {
                dest = this.sheet.createRow(destRowNum + i);
            }
            int lastCellNum = src.getLastCellNum();
            for (int j = 0; j < lastCellNum; ++j) {
                Cell srcCell = src.getCell(j);
                if (srcCell == null) continue;
                Cell destCell = dest.createCell(j);
                if (srcCell.getCellType() == CellType.FORMULA) {
                    String formulaString = srcCell.getCellFormula();
                    destCell.setCellFormula(formulaString);
                } else if (srcCell.getCellType() == CellType.NUMERIC) {
                    double numericValue = srcCell.getNumericCellValue();
                    destCell.setCellValue(numericValue);
                } else if (srcCell.getCellType() == CellType.BOOLEAN) {
                    boolean boolValue = srcCell.getBooleanCellValue();
                    destCell.setCellValue(boolValue);
                } else {
                    destCell.setCellValue(srcCell.getStringCellValue());
                }
                CellStyle cellStyle = srcCell.getCellStyle();
                destCell.setCellStyle(cellStyle);
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public void insertColumn(Object columnIndex, Object columnCount) {
        int cn = this.parseColumnIndex(columnIndex);
        int cnt = this.parseColumnCount(columnCount);
        Iterator ri = this.sheet.rowIterator();
        while (ri.hasNext()) {
            Row row = (Row)ri.next();
            this.insertColumnsInOneRow(row, cn, cnt);
        }
        this.detectedUsedColumns = false;
    }

    @SmartScriptableObject.FunctionTag
    public void removeColumn(Object columnIndex, Object columnCount) {
        int cn = this.parseColumnIndex(columnIndex);
        int cnt = this.parseColumnCount(columnCount);
        Iterator ri = this.sheet.rowIterator();
        while (ri.hasNext()) {
            Row row = (Row)ri.next();
            this.removeColumnsInOneRow(row, cn, cnt);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void clearColumn(Object columnIndex, Object columnCount) {
        int cn = this.parseColumnIndex(columnIndex);
        int cnt = this.parseColumnCount(columnCount);
        Iterator ri = this.sheet.rowIterator();
        while (ri.hasNext()) {
            Row row = (Row)ri.next();
            for (int i = cn; i < cn + cnt; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) continue;
                row.removeCell(cell);
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public void autosizeColumn(Object columnIndex) {
        int cn = this.parseColumnIndex(columnIndex);
        this.sheet.autoSizeColumn(cn, true);
    }

    @SmartScriptableObject.FunctionTag
    public void groupColumns(Object fromIndex, Object toIndex) {
        int from = this.parseColumnIndex(fromIndex);
        int to = this.parseColumnIndex(toIndex);
        this.sheet.groupColumn(from, to);
    }

    @SmartScriptableObject.FunctionTag
    public void ungroupColumns(Object fromIndex, Object toIndex) {
        int from = this.parseColumnIndex(fromIndex);
        int to = this.parseColumnIndex(toIndex);
        this.sheet.ungroupColumn(from, to);
    }

    @SmartScriptableObject.FunctionTag
    public void groupRows(int fromIndex, int toIndex) {
        int from = this.parseRowIndex(fromIndex);
        int to = this.parseRowIndex(toIndex);
        this.sheet.groupRow(from, to);
    }

    @SmartScriptableObject.FunctionTag
    public void ungroupRows(int fromIndex, int toIndex) {
        int from = this.parseRowIndex(fromIndex);
        int to = this.parseRowIndex(toIndex);
        this.sheet.ungroupRow(from, to);
    }

    @SmartScriptableObject.FunctionTag
    public void setColumnHidden(Object columnIndex, boolean value) {
        int cn = this.parseColumnIndex(columnIndex);
        this.sheet.setColumnHidden(cn, value);
    }

    @SmartScriptableObject.FunctionTag
    public void setRowHidden(int rowIndex, boolean value) {
        int rn = this.parseRowIndex(rowIndex);
        Row row = this.sheet.getRow(rn);
        if (row == null) {
            row = this.sheet.createRow(rn);
        }
        row.setZeroHeight(value);
    }

    @SmartScriptableObject.FunctionTag
    public void mergeCells(int rowIndex, Object columnIndex, Object rowsCount, Object columnsCount) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        int cntRows = this.parseRowCount(rowsCount);
        int cntColumns = this.parseColumnCount(columnsCount);
        this.sheet.addMergedRegion(new CellRangeAddress(rn, rn + cntRows - 1, cn, cn + cntColumns - 1));
    }

    @SmartScriptableObject.FunctionTag
    public void unmergeCells(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        List regions = this.sheet.getMergedRegions();
        for (int i = 0; i < regions.size(); ++i) {
            CellRangeAddress region = (CellRangeAddress)regions.get(i);
            if (!region.containsColumn(cn) || !region.containsRow(rn)) continue;
            this.sheet.removeMergedRegion(i);
        }
    }

    @SmartScriptableObject.FunctionTag
    public boolean isMergedCell(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        for (CellRangeAddress region : this.sheet.getMergedRegions()) {
            if (!region.containsColumn(cn) || !region.containsRow(rn)) continue;
            return true;
        }
        return false;
    }

    private void detectUsedColumns() {
        int firstUsedRow = this.sheet.getFirstRowNum();
        Row r0 = this.sheet.getRow(firstUsedRow);
        if (r0 != null) {
            this.firstUsedColumn = r0.getFirstCellNum();
            this.lastUsedColumn = r0.getLastCellNum();
            Iterator rowIterator = this.sheet.rowIterator();
            while (rowIterator.hasNext()) {
                short lastCellNum;
                Row row = (Row)rowIterator.next();
                short firstCellNum = row.getFirstCellNum();
                if (firstCellNum >= 0 && firstCellNum < this.firstUsedColumn) {
                    this.firstUsedColumn = firstCellNum;
                }
                if ((lastCellNum = row.getLastCellNum()) <= this.lastUsedColumn) continue;
                this.lastUsedColumn = lastCellNum;
            }
            if (this.lastUsedColumn == 0) {
                this.lastUsedColumn = 1;
            }
        } else {
            this.firstUsedColumn = 0;
            this.lastUsedColumn = 1;
        }
        ++this.firstUsedColumn;
        this.detectedUsedColumns = true;
    }

    private int parseRowIndex(int rowIndex) {
        if (rowIndex <= 0) {
            throw new InformException(String.format(MESSAGE_BADROW, rowIndex));
        }
        return rowIndex - 1;
    }

    private int parseColumnIndex(Object columnIndex) {
        if (columnIndex instanceof Number) {
            return ((Number)columnIndex).intValue() - 1;
        }
        if (columnIndex instanceof String) {
            return this.columnNameToIndex((String)columnIndex);
        }
        throw new InformException(String.format(MESSAGE_BADCOLUMN, columnIndex == null ? "null" : columnIndex.toString()));
    }

    private int columnNameToIndex(String name) {
        int result = 0;
        int digits = 26;
        for (char ch : name.toCharArray()) {
            result *= digits;
            if ('A' <= ch && ch <= 'Z') {
                result = result + ch - 65 + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                result = result + ch - 97 + 1;
                continue;
            }
            throw new InformException(String.format(MESSAGE_BADCOLUMN, name));
        }
        return result - 1;
    }

    private void insertColumnsInOneRow(Row row, int startingIndex, int shiftCount) {
        int endI = startingIndex + shiftCount;
        for (int i = row.getLastCellNum(); i >= startingIndex; --i) {
            Cell oldCell = row.getCell(i);
            if (oldCell != null) {
                Cell newCell = row.createCell(i + shiftCount, oldCell.getCellType());
                this.cloneCellValue(oldCell, newCell);
                newCell.setCellStyle(oldCell.getCellStyle());
                if (i >= endI) continue;
                row.removeCell(oldCell);
                continue;
            }
            Cell cell = row.getCell(i + shiftCount);
            if (cell == null) continue;
            row.removeCell(cell);
        }
    }

    private void removeColumnsInOneRow(Row row, int startingIndex, int shiftCount) {
        int endI = row.getLastCellNum() - shiftCount;
        for (int i = startingIndex; i <= row.getLastCellNum(); ++i) {
            Cell oldCell = row.getCell(i + shiftCount);
            if (oldCell != null) {
                Cell newCell = row.createCell(i, oldCell.getCellType());
                this.cloneCellValue(oldCell, newCell);
                newCell.setCellStyle(oldCell.getCellStyle());
                if (i <= endI) continue;
                row.removeCell(oldCell);
                continue;
            }
            Cell cell = row.getCell(i);
            if (cell == null) continue;
            row.removeCell(cell);
        }
    }

    private void cloneCellValue(Cell oldCell, Cell newCell) {
        switch (oldCell.getCellType()) {
            case STRING: {
                newCell.setCellValue(oldCell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                newCell.setCellFormula(oldCell.getCellFormula());
                break;
            }
            case ERROR: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
            }
        }
    }

    private int parseRowCount(Object value) {
        if (value == null || value instanceof Undefined) {
            return 1;
        }
        int cnt = ((Number)value).intValue();
        if (cnt < 1) {
            throw new InformException(String.format(MESSAGE_BADROWCOUNT, value));
        }
        return cnt;
    }

    private int parseColumnCount(Object value) {
        if (value == null || value instanceof Undefined) {
            return 1;
        }
        int cnt = ((Number)value).intValue();
        if (cnt < 1) {
            throw new InformException(String.format(MESSAGE_BADCOLUMNCOUNT, value));
        }
        return cnt;
    }

    private int parseRowHeight(Object value) {
        int cnt = ((Number)value).intValue();
        if (cnt < 0) {
            throw new InformException(String.format(MESSAGE_BADROWHEIGHT, value));
        }
        return cnt;
    }

    private int parseColumnWidth(Object value) {
        int cnt = ((Number)value).intValue();
        if (cnt < 0) {
            throw new InformException(String.format(MESSAGE_BADCOLUMNWIDTH, value));
        }
        return cnt;
    }

    @SmartScriptableObject.FunctionTag
    public int getColumnWidth(Object columnIndex) {
        int cn = this.parseColumnIndex(columnIndex);
        return this.sheet.getColumnWidth(cn);
    }

    @SmartScriptableObject.FunctionTag
    public void setColumnWidth(Object columnIndex, Object columnWidth) {
        int cn = this.parseColumnIndex(columnIndex);
        int size = this.parseColumnWidth(columnWidth);
        this.sheet.setColumnWidth(cn, size);
    }

    @SmartScriptableObject.PropertyTag
    public int getDefaultColumnWidth() {
        return this.sheet.getDefaultColumnWidth();
    }

    @SmartScriptableObject.FunctionTag
    public void setDefaultColumnWidth(Object columnWidth) {
        int size = this.parseColumnWidth(columnWidth);
        this.sheet.setDefaultColumnWidth(size);
    }

    @SmartScriptableObject.FunctionTag
    public int getRowHeight(int rowIndex) {
        int rn = this.parseRowIndex(rowIndex);
        XSSFRow row = (XSSFRow)this.sheet.getRow(rn);
        return row == null ? this.sheet.getDefaultRowHeight() : row.getHeight();
    }

    @SmartScriptableObject.FunctionTag
    public void setRowHeight(int rowIndex, Object rowHeight) {
        int rn = this.parseRowIndex(rowIndex);
        int size = this.parseRowHeight(rowHeight);
        XSSFRow row = (XSSFRow)this.sheet.getRow(rn);
        if (row == null) {
            row = (XSSFRow)this.sheet.createRow(rn);
        }
        row.setHeight((short)size);
    }

    @SmartScriptableObject.PropertyTag
    public int getDefaultRowHeight() {
        return this.sheet.getDefaultRowHeight();
    }

    @SmartScriptableObject.FunctionTag
    public void setDefaultRowHeight(Object rowHeight) {
        int size = this.parseRowHeight(rowHeight);
        this.sheet.setDefaultRowHeight((short)size);
    }
}

