/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.spreadsheets.ods;

import inform.adt.InformException;
import inform.agent.scripts.spreadsheets.ods.OdsCellStyle;
import inform.agent.scripts.spreadsheets.ods.OdsWorkbook;
import inform.common.SmartScriptableObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Undefined;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTableColumn;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.attribute.table.TableVisibilityAttribute;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.w3c.dom.Node;

public class OdsWorkbookSheetCells
extends SmartScriptableObject {
    private static final String MESSAGE_MISSINGSHEET = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043b\u0438\u0441\u0442 Ods \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '%s'";
    private static final String MESSAGE_BADCOLUMN = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u043a\u043e\u043b\u043e\u043d\u043a\u0438 \u043b\u0438\u0441\u0442\u0430 Ods: '%s'";
    private static final String MESSAGE_BADROW = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 \u043b\u0438\u0441\u0442\u0430 Ods: '%s'";
    private static final String MESSAGE_CREATESHEET_ERROR = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043b\u0438\u0441\u0442 Ods \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '%s'";
    private static final String MESSAGE_BADROWCOUNT = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0440\u043e\u043a : '%s'.";
    private static final String MESSAGE_BADCOLUMNCOUNT = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043e\u043b\u043e\u043d\u043e\u043a : '%s'.";
    private final OdsWorkbook book;
    private OdfTable table;
    private int firstUsedColumn;
    private int lastUsedColumn;
    private boolean detectedUsedColumns;

    private OdsWorkbookSheetCells(OdsWorkbook book) {
        this.setParentScope(book);
        this.book = book;
    }

    @Override
    public String getClassName() {
        return "WorkbookSheetCells";
    }

    public static OdsWorkbookSheetCells createSheet(OdsWorkbook odsWorkbook, String sheetName) {
        OdsWorkbookSheetCells workbookSheetCells = new OdsWorkbookSheetCells(odsWorkbook);
        workbookSheetCells.table = OdfTable.newTable((OdfDocument)workbookSheetCells.book.document);
        if (workbookSheetCells.table == null) {
            throw new InformException(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043b\u0438\u0441\u0442 Ods \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '%s'", sheetName));
        }
        workbookSheetCells.table.setTableName(sheetName);
        odsWorkbook.document.getTableList().add(workbookSheetCells.table);
        return workbookSheetCells;
    }

    public static OdsWorkbookSheetCells readSheet(OdsWorkbook odsWorkbook, Object sheetName) {
        OdsWorkbookSheetCells workbookSheetCells = new OdsWorkbookSheetCells(odsWorkbook);
        workbookSheetCells.table = sheetName instanceof Number ? (OdfTable)odsWorkbook.document.getTableList().get(((Number)sheetName).intValue()) : odsWorkbook.document.getTableByName(sheetName.toString());
        if (workbookSheetCells.table == null) {
            throw new InformException(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043b\u0438\u0441\u0442 Ods \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '%s'", sheetName));
        }
        return workbookSheetCells;
    }

    @SmartScriptableObject.PropertyTag
    public int getFirstUsedColumn() {
        if (!this.detectedUsedColumns) {
            this.detectUsedColumns();
        }
        return this.firstUsedColumn;
    }

    @SmartScriptableObject.PropertyTag
    public int getFirstUsedRow() {
        return ((OdfTableRow)this.table.getRowList().get(0)).getRowIndex() + 1;
    }

    @SmartScriptableObject.PropertyTag
    public int getLastUsedColumn() {
        if (!this.detectedUsedColumns) {
            this.detectUsedColumns();
        }
        return this.lastUsedColumn;
    }

    @SmartScriptableObject.PropertyTag
    public int getLastUsedRow() {
        return this.table.getRowCount();
    }

    @SmartScriptableObject.FunctionTag
    public Object cells(int rowIndex, Object columnIndex) {
        OdfTableCell cell;
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableRow row = this.table.getRowByIndex(rn);
        if (row != null && (cell = row.getCellByIndex(cn)) != null) {
            if (cell.getValueType() != null) {
                String type;
                switch (type = cell.getValueType()) {
                    case "float": {
                        return cell.getDoubleValue();
                    }
                    case "date": {
                        return cell.getDateValue();
                    }
                    case "boolean": {
                        return cell.getBooleanValue();
                    }
                }
                return cell.getStringValue();
            }
            if (cell.getFormula() != null) {
                TableTableCellElementBase element = cell.getOdfElement();
                String type = element.getOfficeValueTypeAttribute();
                if (type != null) {
                    switch (type) {
                        case "float": {
                            return element.getOfficeValueAttribute();
                        }
                        case "date": {
                            return element.getOfficeDateValueAttribute();
                        }
                        case "boolean": {
                            return element.getOfficeBooleanValueAttribute();
                        }
                    }
                    return element.getOfficeStringValueAttribute();
                }
                return cell.getFormula();
            }
        }
        return null;
    }

    @SmartScriptableObject.FunctionTag
    public void setCell(int rowIndex, Object columnIndex, Object value, Object cellStyle) throws Exception {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableRow row = this.table.getRowByIndex(rn);
        if (row == null) {
            row = (OdfTableRow)this.table.appendRows(rn);
        }
        OdfTableCell cell = row.getCellByIndex(cn);
        if (value instanceof Number) {
            cell.setDoubleValue(Double.valueOf(((Number)value).doubleValue()));
        } else if (value instanceof Calendar) {
            cell.setDateValue((Calendar)value);
        } else if (value instanceof Boolean) {
            cell.setBooleanValue((Boolean)value);
        } else {
            cell.setStringValue((String)value);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void setCellFormula(int rowIndex, Object columnIndex, String formula, Object cellStyle) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableRow row = this.table.getRowByIndex(rn);
        if (row == null) {
            row = this.table.appendRow();
        }
        OdfTableCell cell = row.getCellByIndex(cn);
        cell.setFormula(formula);
    }

    @SmartScriptableObject.FunctionTag
    public void evaluateCell(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableRow row = this.table.getRowByIndex(rn);
        if (row == null) {
            return;
        }
        OdfTableCell cell = row.getCellByIndex(cn);
        if (cell == null) {
            return;
        }
        cell.setFormula(cell.getFormula());
    }

    @SmartScriptableObject.FunctionTag
    public void clearCell(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableRow row = this.table.getRowByIndex(rn);
        if (row == null) {
            return;
        }
        OdfTableCell cell = row.getCellByIndex(cn);
        if (cell == null) {
            return;
        }
        ArrayList<CallSite> attributes = new ArrayList<CallSite>();
        for (int i = 0; i < cell.getOdfElement().getAttributes().getLength(); ++i) {
            Node node = cell.getOdfElement().getAttributes().item(i);
            attributes.add((CallSite)((Object)(node.getPrefix() + ":" + node.getLocalName())));
        }
        for (String string : attributes) {
            cell.getOdfElement().removeAttribute(string);
        }
        cell.removeTextContent();
    }

    @SmartScriptableObject.FunctionTag
    public void setCellStyle(int rowIndex, Object columnIndex, OdsCellStyle style) {
        OdfTableCell cell;
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableRow row = this.table.getRowByIndex(rn);
        if (row == null) {
            if (style == null) {
                return;
            }
            row = this.table.appendRow();
        }
        if ((cell = row.getCellByIndex(cn)) == null && style == null) {
            return;
        }
        StyleTableCellPropertiesElement cellElement = new StyleTableCellPropertiesElement(this.book.getDom());
        for (Map.Entry<String, String> entry : style.getPropertiesCellStyle().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            cellElement.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", key, value);
        }
        StyleTextPropertiesElement textElement = new StyleTextPropertiesElement(this.book.getDom());
        for (Map.Entry<String, String> entry : style.getFont().getPropertiesFont().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            textElement.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", key, value);
        }
        assert (cell != null);
        cell.getOdfElement().getOrCreateUnqiueAutomaticStyle().appendChild((Node)cellElement);
        cell.getOdfElement().getOrCreateUnqiueAutomaticStyle().appendChild((Node)textElement);
        this.detectedUsedColumns = false;
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle getCellStyle(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableRow row = this.table.getRowByIndex(rn);
        if (row == null) {
            row = this.table.appendRow();
        }
        OdfTableCell cell = row.getCellByIndex(cn);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < cell.getOdfElement().getOrCreateUnqiueAutomaticStyle().getLength(); ++i) {
            Node node = cell.getOdfElement().getOrCreateUnqiueAutomaticStyle().item(i);
            for (int j = 0; j < node.getAttributes().getLength(); ++j) {
                String nodeName = node.getAttributes().item(j).getNodeName();
                String nodeValue = node.getAttributes().item(j).getNodeValue();
                if (!node.getLocalName().equals("table-cell-properties")) continue;
                map.put(nodeName, nodeValue);
            }
        }
        return this.book.createCellStyle(map);
    }

    @SmartScriptableObject.FunctionTag
    public int getCellType(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableRow row = this.table.getRowByIndex(rn);
        if (row == null) {
            return 0;
        }
        OdfTableCell cell = row.getCellByIndex(cn);
        if (cell == null) {
            return 0;
        }
        String cellType = cell.getValueType();
        if (cellType != null) {
            switch (cellType) {
                case "float": {
                    return 2;
                }
                case "string": {
                    return 3;
                }
                case "boolean": {
                    return 4;
                }
                case "date": {
                    return 5;
                }
            }
            return 0;
        }
        return 0;
    }

    @SmartScriptableObject.FunctionTag
    public boolean isCellFormula(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableRow row = this.table.getRowByIndex(rn);
        if (row == null) {
            return false;
        }
        OdfTableCell cell = row.getCellByIndex(cn);
        if (cell == null) {
            return false;
        }
        return cell.getFormula() != null;
    }

    @SmartScriptableObject.FunctionTag
    public void insertRow(int rowIndex, Object rowCount) {
        int rn = this.parseRowIndex(rowIndex);
        int cnt = this.parseRowCount(rowCount);
        this.table.insertRowsBefore(rn, cnt);
    }

    @SmartScriptableObject.FunctionTag
    public void removeRow(int rowIndex, Object rowCount) {
        int rn = this.parseRowIndex(rowIndex);
        int cnt = this.parseRowCount(rowCount);
        this.table.removeRowsByIndex(rn, cnt);
    }

    @SmartScriptableObject.FunctionTag
    public void clearRow(int rowIndex, Object rowCount) {
        int rn = this.parseRowIndex(rowIndex);
        int cnt = this.parseRowCount(rowCount);
        int rn2 = rn + cnt;
        for (int i = rn; i < rn2; ++i) {
            OdfTableRow row = this.table.getRowByIndex(i);
            if (row == null) continue;
            TableTableRowElement rowElement = row.getOdfElement();
            int count = rowElement.getChildElementCount();
            for (int j = 0; j < count; ++j) {
                Node node = rowElement.getFirstChild();
                if (node == null) continue;
                TableTableCellElement element = new TableTableCellElement(this.book.getDom());
                rowElement.removeChild(node);
                rowElement.appendChild((Node)element);
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public void copyRow(int srcRow, int destRow, Object rowCount) {
        int srcRowNum = this.parseRowIndex(srcRow);
        int destRowNum = this.parseRowIndex(destRow);
        int cnt = this.parseRowCount(rowCount);
        for (int i = 0; i < cnt; ++i) {
            OdfTableRow src = this.table.getRowByIndex(srcRowNum + i);
            OdfTableRow dest = this.table.getRowByIndex(destRowNum + i);
            TableTableRowElement srcElement = src.getOdfElement();
            TableTableRowElement destElement = dest.getOdfElement();
            int count = srcElement.getChildElementCount();
            for (int j = 0; j < count; ++j) {
                Node destNode;
                Node srcNode = srcElement.getFirstChild();
                if (srcNode == null || (destNode = destElement.getFirstChild()) == null) continue;
                destElement.removeChild(destNode);
                destElement.appendChild(srcNode);
                srcElement.appendChild(srcNode.cloneNode(true));
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public void insertColumn(Object columnIndex, Object columnCount) {
        int cn = this.parseColumnIndex(columnIndex);
        int cnt = this.parseColumnCount(columnCount);
        this.table.insertColumnsBefore(cn, cnt);
    }

    @SmartScriptableObject.FunctionTag
    public void removeColumn(Object columnIndex, Object columnCount) {
        int cn = this.parseColumnIndex(columnIndex);
        int cnt = this.parseColumnCount(columnCount);
        this.table.removeColumnsByIndex(cn, cnt);
    }

    @SmartScriptableObject.FunctionTag
    public void clearColumn(Object columnIndex, Object columnCount) {
        int rn = this.parseColumnIndex(columnIndex);
        int cnt = this.parseColumnCount(columnCount);
        int rn2 = rn + cnt;
        for (int i = rn; i < rn2; ++i) {
            OdfTableColumn column = this.table.getColumnByIndex(i);
            if (column == null) continue;
            int count = column.getCellCount();
            ArrayList<CallSite> attributes = new ArrayList<CallSite>();
            for (int j = 0; j < count; ++j) {
                OdfTableCell cell = column.getCellByIndex(j);
                if (cell == null) continue;
                for (int k = 0; k < cell.getOdfElement().getAttributes().getLength(); ++k) {
                    Node node = cell.getOdfElement().getAttributes().item(k);
                    attributes.add((CallSite)((Object)(node.getPrefix() + ":" + node.getLocalName())));
                }
                for (String string : attributes) {
                    cell.getOdfElement().removeAttribute(string);
                }
                cell.removeTextContent();
                attributes.clear();
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public void setColumnHidden(Object columnHidden, boolean value) {
        for (int i = 0; i < 5; ++i) {
            OdfTableColumn expColumn = this.table.getColumnByIndex(i);
            TableTableColumnElement expElement = expColumn.getOdfElement();
            expElement.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(1));
        }
        int rn = this.parseColumnIndex(columnHidden);
        OdfTableColumn column = this.table.getColumnByIndex(rn);
        TableTableColumnElement element = column.getOdfElement();
        if (value) {
            element.setTableVisibilityAttribute(TableVisibilityAttribute.Value.COLLAPSE.toString());
        } else {
            element.removeAttribute("table:visibility");
        }
    }

    @SmartScriptableObject.FunctionTag
    public void setRowHidden(int rowIndex, boolean value) {
        for (int i = 0; i < 5; ++i) {
            OdfTableRow expRow = this.table.getRowByIndex(i);
            TableTableRowElement expElement = expRow.getOdfElement();
            expElement.setTableNumberRowsRepeatedAttribute(Integer.valueOf(1));
        }
        int rn = this.parseRowIndex(rowIndex);
        OdfTableRow row = this.table.getRowByIndex(rn);
        TableTableRowElement element = row.getOdfElement();
        if (value) {
            element.setTableVisibilityAttribute(TableVisibilityAttribute.Value.COLLAPSE.toString());
        } else {
            element.removeAttribute("table:visibility");
        }
    }

    @SmartScriptableObject.FunctionTag
    public void mergeCells(int rowIndex, Object columnIndex, Object rowsCount, Object columnsCount) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableCell cell = this.table.getCellByPosition(cn, rn);
        TableTableCellElement element = (TableTableCellElement)cell.getOdfElement();
        Integer columnsCountInt = ((Double)columnsCount).intValue();
        Integer rowsCountInt = (Integer)rowsCount;
        element.setTableNumberColumnsSpannedAttribute(columnsCountInt);
        element.setTableNumberRowsSpannedAttribute(rowsCountInt);
    }

    @SmartScriptableObject.FunctionTag
    public boolean isMergedCell(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableCell cell = this.table.getCellByPosition(cn, rn);
        TableTableCellElement element = (TableTableCellElement)cell.getOdfElement();
        return element.getTableNumberColumnsSpannedAttribute() != 1 || element.getTableNumberRowsSpannedAttribute() != 1;
    }

    @SmartScriptableObject.FunctionTag
    public void unmergeCells(int rowIndex, Object columnIndex) {
        int rn = this.parseRowIndex(rowIndex);
        int cn = this.parseColumnIndex(columnIndex);
        OdfTableCell cell = this.table.getCellByPosition(cn, rn);
        TableTableCellElement base = (TableTableCellElement)cell.getOdfElement();
        base.removeAttribute("table:number-columns-spanned");
        base.removeAttribute("table:number-rows-spanned");
    }

    private void detectUsedColumns() {
        int firstUsedRow = this.getFirstUsedRow();
        OdfTableRow r0 = this.table.getRowByIndex(firstUsedRow);
        this.firstUsedColumn = 0;
        if (r0 != null) {
            this.lastUsedColumn = r0.getCellCount();
            for (OdfTableRow row : this.table.getRowList()) {
                short lastCellNum;
                int firstCellNum = 0;
                if (firstCellNum < this.firstUsedColumn) {
                    this.firstUsedColumn = firstCellNum;
                }
                if ((lastCellNum = (short)row.getCellCount()) <= this.lastUsedColumn) continue;
                this.lastUsedColumn = lastCellNum;
            }
            if (this.lastUsedColumn == 0) {
                this.lastUsedColumn = 1;
            }
        } else {
            this.lastUsedColumn = 1;
        }
        ++this.firstUsedColumn;
        this.detectedUsedColumns = true;
    }

    private int parseRowIndex(int rowIndex) {
        if (rowIndex <= 0) {
            throw new InformException(String.format(MESSAGE_BADROW, rowIndex));
        }
        return rowIndex - 1;
    }

    private int parseColumnIndex(Object columnIndex) {
        if (columnIndex instanceof Number) {
            return ((Number)columnIndex).intValue() - 1;
        }
        if (columnIndex instanceof String) {
            return this.columnNameToIndex((String)columnIndex);
        }
        throw new InformException(String.format(MESSAGE_BADCOLUMN, columnIndex == null ? "null" : columnIndex.toString()));
    }

    private int parseRowCount(Object value) {
        if (value == null || value instanceof Undefined) {
            return 1;
        }
        int cnt = ((Number)value).intValue();
        if (cnt < 1) {
            throw new InformException(String.format(MESSAGE_BADROWCOUNT, value));
        }
        return cnt;
    }

    private int parseColumnCount(Object value) {
        if (value == null || value instanceof Undefined) {
            return 1;
        }
        int cnt = ((Number)value).intValue();
        if (cnt < 1) {
            throw new InformException(String.format(MESSAGE_BADCOLUMNCOUNT, value));
        }
        return cnt;
    }

    private int columnNameToIndex(String name) {
        int result = 0;
        int digits = 26;
        for (char ch : name.toCharArray()) {
            result *= digits;
            if ('A' <= ch && ch <= 'Z') {
                result = result + ch - 65 + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                result = result + ch - 97 + 1;
                continue;
            }
            throw new InformException(String.format(MESSAGE_BADCOLUMN, name));
        }
        return result - 1;
    }

    private Map<String, String> parseCellStyle(Object cellStyle) {
        if (cellStyle != null && !(cellStyle instanceof Undefined)) {
            if (cellStyle instanceof OdsCellStyle) {
                return ((OdsCellStyle)cellStyle).getPropertiesCellStyle();
            }
            throw new InformException(String.format("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u0441\u0442\u0438\u043b\u044f \u044f\u0447\u0435\u0439\u043a\u0438: '%s'", cellStyle));
        }
        return null;
    }
}

