/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.JoinType;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.sql.QueryNodeKind;
import java.io.IOException;
import java.util.ArrayList;

public class DirectoryQueryNode
extends QueryNode {
    private double directoryNodeId = 0.0;
    private int directoryFieldId = 0;

    DirectoryQueryNode(Query query, GenericQueryNode parentNode) {
        super(query, parentNode);
    }

    DirectoryQueryNode(Query query, GenericQueryNode parentNode, double tableId, int directoryFieldId) throws IOException {
        super(query, parentNode, tableId);
        this.directoryNodeId = tableId;
        this.directoryFieldId = directoryFieldId;
        this.joinType = JoinType.LEFT_OUTER;
        this.directoryLink = directoryFieldId;
    }

    public int getDirectoryFieldId() {
        return this.directoryFieldId;
    }

    @Override
    protected void enumFromTablesThis(ArrayList<QueryNode> joins, ArrayList<QueryNode> nonjoins) {
        this.generated = false;
        joins.add(this);
    }

    @Override
    protected void loadTag(int tag, TaggedReader reader) throws IOException, InformException {
        switch (tag) {
            case 8: {
                this.directoryNodeId = reader.getNodeID();
                break;
            }
            case 9: {
                this.directoryFieldId = reader.getInt();
                break;
            }
            default: {
                super.loadTag(tag, reader);
            }
        }
    }

    @Override
    public QueryNodeKind getKind() {
        if (this.getTableId() == 0.0 || this.directoryNodeId == 0.0 || this.directoryFieldId == 0) {
            return QueryNodeKind.ERROR;
        }
        return QueryNodeKind.DIRECTORY;
    }

    @Override
    public void writeGetTableRecordsRefsContent(TaggedWriter out) throws InformException {
    }
}

