/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.ServerSideHost;
import inform.agent.db.SqlGenerator;
import inform.agent.expr.ConditionBlockTerm;
import inform.agent.expr.Term;
import inform.agent.scripts.sql.ExpressionFilterRoot;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryKind;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.sql.QueryParameterList;
import inform.agent.scripts.sql.ReturnedFields;
import inform.agent.scripts.sql.RootQueryNode;
import inform.agent.scripts.sql.expr.FilterCondition;
import inform.agent.scripts.sql.expr.QueryFieldTerm;
import java.io.IOException;
import java.util.ArrayList;

public class ExpressionFilterQuery
extends Query {
    public static final String ALIAS = "FILTER";
    public static final String ALIAS_PREFIX = "FILTER.";
    public static final int DATAFILTER_ROWSET_ID = 1;
    private final Query baseQuery;
    private final SqlGenerator baseSearch;
    private int[] filterFields = null;

    public ExpressionFilterQuery(ServerSideHost ssHost, Query baseQuery) throws IOException {
        super(ssHost, baseQuery.getNullSortKind());
        this.baseQuery = baseQuery;
        this.baseSearch = null;
        this.initRootNode(baseQuery.root.getTableId(), baseQuery.root.returnedFields);
    }

    public ExpressionFilterQuery(ServerSideHost ssHost, SqlGenerator baseSearch) throws IOException {
        super(ssHost, baseSearch.getNullSortKind());
        this.baseQuery = null;
        this.baseSearch = baseSearch;
        this.initRootNode(baseSearch.getTableId(), baseSearch.getReturnedFields());
    }

    @Override
    public void load(TaggedReader in) throws IOException, InformException {
        this.root.where = new FilterCondition(this, false);
        this.root.where.load(in);
        for (Term t : this.root.where.terms()) {
            if (t instanceof QueryFieldTerm) {
                ((QueryFieldTerm)t).replaceDatasourceID(1);
                continue;
            }
            if (!(t instanceof ConditionBlockTerm)) continue;
            ((ConditionBlockTerm)t).replaceDatasourceID(1);
        }
        this.root.afterLoad();
        this.root.prepareExpressions();
    }

    @Override
    protected RootQueryNode createRootNode() {
        return new ExpressionFilterRoot(this);
    }

    private void initRootNode(double tableId, ReturnedFields returnedFields) throws IOException {
        this.kind = QueryKind.SIMPLE;
        ExpressionFilterRoot root = (ExpressionFilterRoot)this.root;
        root.internalSetEntryID(1);
        root.datasourceNodeId = tableId;
        root.tableNodeId = tableId;
        root.nodeType = 12;
        root.initMetadata();
        if (returnedFields != null && !returnedFields.empty()) {
            root.setReturnedFields(returnedFields);
        }
        this.registerNode(root);
    }

    private void generateJoin(QueryNode node, ArrayList<QueryNode> joins, StringBuilder sql) throws Exception {
        for (QueryNode join : joins) {
            if (join.generated || join.getParentEntryId() != node.getEntryId()) continue;
            join.generated = true;
            join.generateJoin(sql, null);
            this.generateJoin(join, joins, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDirectorySQL() throws Exception {
        QueryParameterList filterParameter = this.sqlParameters;
        this.sqlParameters = new QueryParameterList();
        try {
            ArrayList<QueryNode> joins = new ArrayList<QueryNode>();
            ArrayList<QueryNode> nonjoins = new ArrayList<QueryNode>();
            this.root.enumFromTables(joins, nonjoins);
            StringBuilder fromSql = new StringBuilder();
            this.generateJoin(this.root, joins, fromSql);
            String string = fromSql.toString();
            return string;
        }
        finally {
            if (filterParameter != null) {
                this.sqlParameters.addFrom(filterParameter);
            }
        }
    }

    public int requiredFilterFieldCount() {
        if (this.filterFields == null) {
            this.filterFields = ((ExpressionFilterRoot)this.root).getRequiredFilterFields();
        }
        return this.filterFields.length;
    }

    public int requiredFilterField(int index) {
        return this.filterFields[index];
    }

    public int[] requiredFilterFields() {
        return this.filterFields;
    }
}

