/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.GeneratedSql;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSetPostProcess;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.sql.ExtraField;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryParameter;
import inform.agent.scripts.sql.QueryParameterList;
import inform.agent.scripts.util.QueryPostProcess;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import org.mozilla.javascript.Context;

public class QueryGeneratedSql
extends GeneratedSql {
    private final QueryParameterList sqlParameters;
    private final Query query;

    public QueryGeneratedSql(Query query, String sqlText, QueryParameterList params) {
        super(sqlText);
        this.query = query;
        this.sqlParameters = params;
    }

    public Collection<ExtraField> getExtraFields() {
        return this.query.getExtraFields();
    }

    @Override
    public GeneratedSql.Sorting getSortingGeneration() {
        return this.query.getSortingGeneration();
    }

    @Override
    public boolean appendParametersTo(PreparedStatement statement) throws IOException, SQLException, TaggedReaderException {
        return QueryGeneratedSql.appendParametersTo(this.sqlParameters, statement);
    }

    public static boolean appendParametersTo(QueryParameterList sqlParameters, PreparedStatement statement) throws IOException, SQLException, TaggedReaderException {
        boolean result = true;
        if (sqlParameters == null) {
            return result;
        }
        int paramIndex = statement.getParamValuesCount();
        block7: for (QueryParameter p : sqlParameters.items()) {
            if (p.getIsNull()) {
                statement.setNull(++paramIndex, p.getType());
                continue;
            }
            switch (p.getType()) {
                case STRING: 
                case UNICODE: {
                    statement.setString(++paramIndex, p.getStringValue());
                    continue block7;
                }
                case DATE_TIME: {
                    double phenixDate = p.getNumberValue();
                    statement.setDateTime(++paramIndex, phenixDate);
                    continue block7;
                }
                case DOUBLE: {
                    statement.setDouble(++paramIndex, p.getNumberValue());
                    continue block7;
                }
                case INTEGER: {
                    statement.setInt(++paramIndex, (int)p.getNumberValue());
                    continue block7;
                }
                case BOOLEAN: {
                    statement.setBoolean(++paramIndex, p.getBooleanValue());
                    continue block7;
                }
            }
            result = false;
        }
        return result;
    }

    @Override
    public void logParameters(int index, StringBuilder log) {
        if (this.sqlParameters == null) {
            return;
        }
        int comma = 123;
        for (QueryParameter p : this.sqlParameters.items()) {
            log.append((char)comma).append(PreparedStatement.sqlDataType2char(p.getType())).append(index++).append('@');
            p.getLog(log);
            comma = 44;
        }
        if (comma != 123) {
            log.append('}');
        }
    }

    @Override
    public boolean hasPostProcess() {
        return this.query.hasOnGetData();
    }

    @Override
    public ResultSetPostProcess createPostProcess(SSContext ssContext, Context context, ServerSideHost ssHost, AbstractConnectionManager connectionManager, int nullSortKind) {
        if (!this.query.hasOnGetData()) {
            return null;
        }
        try {
            return new QueryPostProcess(ssContext, this.query, nullSortKind, context, ssHost, connectionManager);
        }
        catch (Exception e) {
            throw InformException.wrap(e);
        }
    }

    public QueryParameterList getSqlParameters() {
        return this.sqlParameters;
    }

    public TableDescriptor getTableDescriptor() {
        return this.query.getResultMetadata().tableDescriptor;
    }
}

